/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueManager {
    private static final TraceComponent tc = Tr.register(DefaultValueManager.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static Map<String, String> classMap = new HashMap<String, String>();
    private static final String SIGNATURE_CLASS = "com.ibm.websphere.wssecurity.wssapi.signature";
    private static final String DECRYPTION_CLASS = "com.ibm.websphere.wssecurity.wssapi.decryption";
    private static final String ENCRYPTION_CLASS = "com.ibm.websphere.wssecurity.wssapi.encryption";
    private static final String VERIFICATOIN_CLASS = "com.ibm.websphere.wssecurity.wssapi.verification";
    private static final String TOKEN_CLASS = "com.ibm.websphere.wssecurity.wssapi.token";
    private static final String WSS_CLASS = "com.ibm.websphere.wssecurity.wssapi";
    private static String DEFAULT_VALUE_FILE_NAME;
    private static String SIGNATURE;
    private static String CANONICALIZATIONMETHOD;
    private static String SIGNATUREMETHOD;
    private static String DIGESTMETHOD;
    private static String TRANSFORMMETHODS;
    private static String TRANSFORMMETHOD;
    private static String SIGNPARTS;
    private static String SIGNPART;
    private static String ENCRYPTION;
    private static String KEYENCRYPTED;
    private static String OPTIMIZED;
    private static String KEYENCRYPTIONMETHOD;
    private static String DATAENCRYPTIONMETHOD;
    private static String ENCRYPTIONPARTS;
    private static String ENCRYPTIONPART;
    private static String VERIFICATON;
    private static String ALLOWEDCANONICALIZATIONMETHODS;
    private static String ALLOWEDSIGNATUREMETHODS;
    private static String VERIFYPARTS;
    private static String VERIFYPART;
    private static String DECRYPTION;
    private static String ALLOWEDKEYENCRYPTIONMETHODS;
    private static String ALLOWEDDATAENCRYPTIONMETHODS;
    private static String DECRYPTIONPARTS;
    private static String DECRYPTIONPART;
    private static String TOKENREFERENCE;
    private static String TOKENMAPPINGS;
    private static String TOKENMAPPING;
    private static String VALUETYPE;
    private static String JAASLOGINCONFIGNAME;
    private String canonicalizationMethod;
    private String signatureMethod;
    private String digestMethod;
    private List<String> transformMethodsForSignature = new ArrayList<String>();
    private List<Integer> signParts = new ArrayList<Integer>();
    private int tokenReferenceForSignature;
    private Map<QName, TokenMapping> tokenMappingForSignature = new HashMap<QName, TokenMapping>();
    private boolean optimized = false;
    private boolean keyEncrypted;
    private String keyEncryptionMethod;
    private String dataEncryptionMethod;
    private List<Integer> encryptionParts = new ArrayList<Integer>();
    private int tokenReferenceForEncryption;
    private Map<QName, TokenMapping> tokenMappingForEncryption = new HashMap<QName, TokenMapping>();
    private List<String> allowedCanonicalizationMethods = new ArrayList<String>();
    private List<String> allowedSignatureMethods = new ArrayList<String>();
    private List<String> transformMethodsForVerification = new ArrayList<String>();
    private List<Integer> verifyParts = new ArrayList<Integer>();
    private Map<QName, TokenMapping> tokenMappingForVerification = new HashMap<QName, TokenMapping>();
    private boolean keyEncryptedForDecrption;
    private List<String> allowedKeyEncryptionMethods = new ArrayList<String>();
    private List<String> allowedDataEncryptionMethods = new ArrayList<String>();
    private List<Integer> decryptionParts = new ArrayList<Integer>();
    private Map<QName, TokenMapping> tokenMappingForDecryption = new HashMap<QName, TokenMapping>();
    private Map<QName, TokenMapping> tokenMapping = new HashMap<QName, TokenMapping>();
    private static final String GENERATE = "generate";
    private static final String CONSUME = "consume";
    private static final String TIMESTAMP = "timestamp";
    private static final String DURATION = "duration";
    private String duration;
    private static final String ALGORITHMS = "algorithms";
    private static final String SIGNATUREALGORITHM = "signatureAlgorithm";
    private static final String ENCRYPTIONALGORITHM = "encryptionAlgorithm";
    private static final String DEFAULTSIGNATUREALGORITHM = "defaultSignatureAlgorithm";
    private static final String DEFAULTENCRYPTIONALGORITHM = "defaultEncryptionAlgorithm";
    private static final String ALGORITHMNAME = "algorithmName";
    private static final String KEYFACTORYALGORITHM = "keyFactoryAlgorithm";
    private static final String KEYLENGTH = "keyLength";
    public static final String KEY_ALGORITHM = "algorithm";
    public static final String KEY_KEYLENGTH = "keyLength";
    private Map<String, Map> signatureAlgorithmMap = new HashMap<String, Map>();
    private Map<String, Map> encryptionAlgorithmMap = new HashMap<String, Map>();
    private String defaultSignatureAlgorithm;
    private String defaultEncryptionAlgorithm;
    private static DefaultValueManager instance;

    private DefaultValueManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DefaultValueManager()");
        }
        StAXOMBuilder stAXOMBuilder = null;
        ClassLoader classLoader = DefaultValueManager.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(DEFAULT_VALUE_FILE_NAME);
        try {
            stAXOMBuilder = new StAXOMBuilder(inputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            Tr.warning(tc, "WSEC7001W");
            return;
        }
        OMElement oMElement = stAXOMBuilder.getDocumentElement();
        this.getTimestampDefaultValue(oMElement);
        this.getSignatureDefaultValue(oMElement);
        this.getEncryptionDefaultValue(oMElement);
        this.getVerificationDefaultValue(oMElement);
        this.getDecryptionDefaultValue(oMElement);
        this.getAlgorithmDefaultValue(oMElement);
        this.getDefaultValue(oMElement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DefaultValueManager()");
        }
    }

    public static DefaultValueManager getInstance() {
        return instance;
    }

    private void getAlgorithmDefaultValue(OMElement oMElement) {
        OMElement oMElement2;
        OMElement oMElement3;
        OMElement oMElement4;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlgorithmDefaultValue(OMElement doc)");
        }
        OMElement oMElement5 = oMElement.getFirstChildWithName(new QName(ALGORITHMS));
        OMElement oMElement6 = oMElement5.getFirstChildWithName(new QName(DEFAULTSIGNATUREALGORITHM));
        OMElement oMElement7 = oMElement6.getFirstChildWithName(new QName(ALGORITHMNAME));
        this.defaultSignatureAlgorithm = this.getDataAsString(oMElement7.getText());
        OMElement oMElement8 = oMElement5.getFirstChildWithName(new QName(DEFAULTENCRYPTIONALGORITHM));
        OMElement oMElement9 = oMElement8.getFirstChildWithName(new QName(ALGORITHMNAME));
        this.defaultEncryptionAlgorithm = this.getDataAsString(oMElement9.getText());
        Iterator iterator = oMElement5.getChildrenWithName(new QName(SIGNATUREALGORITHM));
        while (iterator.hasNext()) {
            object2 = new HashMap();
            object = (OMElement)iterator.next();
            oMElement4 = object.getFirstChildWithName(new QName(ALGORITHMNAME));
            oMElement3 = object.getFirstChildWithName(new QName(KEYFACTORYALGORITHM));
            oMElement2 = object.getFirstChildWithName(new QName("keyLength"));
            object2.put(KEY_ALGORITHM, oMElement3.getText());
            object2.put("keyLength", new Integer(oMElement2.getText()));
            this.signatureAlgorithmMap.put(this.getDataAsString(oMElement4.getText()), (Map)object2);
        }
        object2 = oMElement5.getChildrenWithName(new QName(ENCRYPTIONALGORITHM));
        while (object2.hasNext()) {
            object = new HashMap();
            oMElement4 = (OMElement)object2.next();
            oMElement3 = oMElement4.getFirstChildWithName(new QName(ALGORITHMNAME));
            oMElement2 = oMElement4.getFirstChildWithName(new QName(KEYFACTORYALGORITHM));
            OMElement oMElement10 = oMElement4.getFirstChildWithName(new QName("keyLength"));
            object.put(KEY_ALGORITHM, oMElement2.getText());
            object.put("keyLength", new Integer(oMElement10.getText()));
            this.encryptionAlgorithmMap.put(this.getDataAsString(oMElement3.getText()), (Map)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlgorithmDefaultValue(OMElement doc)");
        }
    }

    private void getTimestampDefaultValue(OMElement oMElement) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTImestampDefaultValue(OMElement doc)");
        }
        OMElement oMElement2 = oMElement.getFirstChildWithName(new QName(TIMESTAMP));
        OMElement oMElement3 = oMElement2.getFirstChildWithName(new QName(DURATION));
        this.duration = oMElement3.getText();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimestampDefaultValue(OMElement doc): [duration:[" + this.duration + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestampDefaultValue(OMElement doc)");
        }
    }

    private void getDefaultValue(OMElement oMElement) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultValue(OMElement doc)");
        }
        OMElement oMElement2 = oMElement.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iterator = oMElement2.getChildrenWithName(new QName(TOKENMAPPING));
        while (iterator.hasNext()) {
            TokenMapping tokenMapping = new TokenMapping();
            OMElement oMElement3 = (OMElement)iterator.next();
            OMElement oMElement4 = oMElement3.getFirstChildWithName(new QName(VALUETYPE));
            tokenMapping.setValueType(this.getDataAsQName(oMElement4.getText()));
            Iterator iterator2 = oMElement3.getChildrenWithName(new QName(JAASLOGINCONFIGNAME));
            while (iterator2.hasNext()) {
                OMElement oMElement5 = (OMElement)iterator2.next();
                this.addTokenMapping(tokenMapping, oMElement5);
            }
            this.tokenMapping.put(tokenMapping.getValueType(), tokenMapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getDefaultValue(OMElement doc): [TokenMapping: mapping:[" + tokenMapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultValue(OMElement doc)");
        }
    }

    private void addTokenMapping(TokenMapping tokenMapping, OMElement oMElement) {
        String string = oMElement.getAttributeValue(new QName("type"));
        if (string.equals(GENERATE)) {
            tokenMapping.setJaasLoginConfigNameForGenerator(oMElement.getText());
        }
        if (string.equals(CONSUME)) {
            tokenMapping.setJaasLoginConfigNameForConsumer(oMElement.getText());
        }
    }

    private void getDecryptionDefaultValue(OMElement oMElement) {
        OMElement oMElement2;
        OMElement oMElement3;
        OMElement oMElement4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDecryptionDefaultValue(OMElement doc)");
        }
        OMElement oMElement5 = oMElement.getFirstChildWithName(new QName(DECRYPTION));
        OMElement oMElement6 = oMElement5.getFirstChildWithName(new QName(KEYENCRYPTED));
        this.keyEncryptedForDecrption = this.getDataAsBoolean(oMElement6.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [keyEncryptedForDecrption:[" + this.keyEncryptedForDecrption + "]");
        }
        OMElement oMElement7 = oMElement5.getFirstChildWithName(new QName(ALLOWEDKEYENCRYPTIONMETHODS));
        Iterator iterator = oMElement7.getChildrenWithName(new QName(KEYENCRYPTIONMETHOD));
        while (iterator.hasNext()) {
            oMElement4 = (OMElement)iterator.next();
            this.allowedKeyEncryptionMethods.add(this.getDataAsString(oMElement4.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [allowedKeyEncryptionMethods:[" + this.allowedKeyEncryptionMethods + "]");
        }
        oMElement4 = oMElement5.getFirstChildWithName(new QName(ALLOWEDDATAENCRYPTIONMETHODS));
        Iterator iterator2 = oMElement4.getChildrenWithName(new QName(DATAENCRYPTIONMETHOD));
        while (iterator2.hasNext()) {
            oMElement3 = (OMElement)iterator2.next();
            this.allowedDataEncryptionMethods.add(this.getDataAsString(oMElement3.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [allowedDataEncryptionMethods:[" + this.allowedDataEncryptionMethods + "]");
        }
        oMElement3 = oMElement5.getFirstChildWithName(new QName(DECRYPTIONPARTS));
        Iterator iterator3 = oMElement3.getChildrenWithName(new QName(DECRYPTIONPART));
        while (iterator3.hasNext()) {
            oMElement2 = (OMElement)iterator3.next();
            this.decryptionParts.add(this.getDataAsInt(oMElement2.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [decryptionParts:[" + this.decryptionParts + "]");
        }
        oMElement2 = oMElement5.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iterator4 = oMElement2.getChildrenWithName(new QName(TOKENMAPPING));
        while (iterator4.hasNext()) {
            TokenMapping tokenMapping = new TokenMapping();
            OMElement oMElement8 = (OMElement)iterator4.next();
            OMElement oMElement9 = oMElement8.getFirstChildWithName(new QName(VALUETYPE));
            tokenMapping.setValueType(this.getDataAsQName(oMElement9.getText()));
            OMElement oMElement10 = oMElement8.getFirstChildWithName(new QName(JAASLOGINCONFIGNAME));
            tokenMapping.setJaasLoginConfigNameForConsumer(oMElement10.getText());
            this.tokenMappingForDecryption.put(tokenMapping.getValueType(), tokenMapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [tokenMappingForDecryption:[" + tokenMapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDecryptionDefaultValue(OMElement doc)");
        }
    }

    private void getVerificationDefaultValue(OMElement oMElement) {
        OMElement oMElement2;
        OMElement oMElement3;
        OMElement oMElement4;
        OMElement oMElement5;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVerificationDefalutValue(OMElement doc)");
        }
        OMElement oMElement6 = oMElement.getFirstChildWithName(new QName(VERIFICATON));
        OMElement oMElement7 = oMElement6.getFirstChildWithName(new QName(ALLOWEDCANONICALIZATIONMETHODS));
        Iterator iterator = oMElement7.getChildrenWithName(new QName(CANONICALIZATIONMETHOD));
        while (iterator.hasNext()) {
            oMElement5 = (OMElement)iterator.next();
            this.allowedCanonicalizationMethods.add(this.getDataAsString(oMElement5.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [allowedCanonicalizationMethods:[" + this.allowedCanonicalizationMethods + "]");
        }
        oMElement5 = oMElement6.getFirstChildWithName(new QName(ALLOWEDSIGNATUREMETHODS));
        Iterator iterator2 = oMElement5.getChildrenWithName(new QName(SIGNATUREMETHOD));
        while (iterator2.hasNext()) {
            oMElement4 = (OMElement)iterator2.next();
            this.allowedSignatureMethods.add(this.getDataAsString(oMElement4.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [allowedSignatureMethods:[" + this.allowedSignatureMethods + "]");
        }
        oMElement4 = oMElement6.getFirstChildWithName(new QName(TRANSFORMMETHODS));
        Iterator iterator3 = oMElement4.getChildrenWithName(new QName(TRANSFORMMETHOD));
        while (iterator3.hasNext()) {
            oMElement3 = (OMElement)iterator3.next();
            this.transformMethodsForVerification.add(this.getDataAsString(oMElement3.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [transformMethodsForVerification:[" + this.transformMethodsForVerification + "]");
        }
        oMElement3 = oMElement6.getFirstChildWithName(new QName(VERIFYPARTS));
        Iterator iterator4 = oMElement3.getChildrenWithName(new QName(VERIFYPART));
        while (iterator4.hasNext()) {
            oMElement2 = (OMElement)iterator4.next();
            this.verifyParts.add(this.getDataAsInt(oMElement2.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [verifyParts:[" + this.verifyParts + "]");
        }
        oMElement2 = oMElement6.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iterator5 = oMElement2.getChildrenWithName(new QName(TOKENMAPPING));
        while (iterator5.hasNext()) {
            TokenMapping tokenMapping = new TokenMapping();
            OMElement oMElement8 = (OMElement)iterator5.next();
            OMElement oMElement9 = oMElement8.getFirstChildWithName(new QName(VALUETYPE));
            tokenMapping.setValueType(this.getDataAsQName(oMElement9.getText()));
            OMElement oMElement10 = oMElement8.getFirstChildWithName(new QName(JAASLOGINCONFIGNAME));
            tokenMapping.setJaasLoginConfigNameForConsumer(oMElement10.getText());
            this.tokenMappingForVerification.put(tokenMapping.getValueType(), tokenMapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [tokenMappingForVerification:[" + tokenMapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVerificationDefalutValue(OMElement doc)");
        }
    }

    private void getEncryptionDefaultValue(OMElement oMElement) {
        OMElement oMElement2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncryptionDefalutValue(OMElement doc)");
        }
        OMElement oMElement3 = oMElement.getFirstChildWithName(new QName(ENCRYPTION));
        OMElement oMElement4 = oMElement3.getFirstChildWithName(new QName(KEYENCRYPTED));
        this.keyEncrypted = this.getDataAsBoolean(oMElement4.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [keyEncrypted:[" + this.keyEncrypted + "]");
        }
        OMElement oMElement5 = oMElement3.getFirstChildWithName(new QName(KEYENCRYPTIONMETHOD));
        this.keyEncryptionMethod = this.getDataAsString(oMElement5.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [keyEncryptionMethod:[" + this.keyEncryptionMethod + "]");
        }
        OMElement oMElement6 = oMElement3.getFirstChildWithName(new QName(DATAENCRYPTIONMETHOD));
        this.dataEncryptionMethod = this.getDataAsString(oMElement6.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [dataEncryptionMethod:[" + this.dataEncryptionMethod + "]");
        }
        OMElement oMElement7 = oMElement3.getFirstChildWithName(new QName(ENCRYPTIONPARTS));
        Iterator iterator = oMElement7.getChildrenWithName(new QName(ENCRYPTIONPART));
        while (iterator.hasNext()) {
            oMElement2 = (OMElement)iterator.next();
            this.encryptionParts.add(this.getDataAsInt(oMElement2.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [encryptionParts:[" + this.encryptionParts + "]");
        }
        oMElement2 = oMElement3.getFirstChildWithName(new QName(TOKENREFERENCE));
        this.tokenReferenceForEncryption = this.getDataAsInt(oMElement2.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [tokenReferenceForEncryption:[" + this.tokenReferenceForEncryption + "]");
        }
        OMElement oMElement8 = oMElement3.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iterator2 = oMElement8.getChildrenWithName(new QName(TOKENMAPPING));
        while (iterator2.hasNext()) {
            TokenMapping tokenMapping = new TokenMapping();
            OMElement oMElement9 = (OMElement)iterator2.next();
            OMElement oMElement10 = oMElement9.getFirstChildWithName(new QName(VALUETYPE));
            tokenMapping.setValueType(this.getDataAsQName(oMElement10.getText()));
            OMElement oMElement11 = oMElement9.getFirstChildWithName(new QName(JAASLOGINCONFIGNAME));
            tokenMapping.setJaasLoginConfigNameForGenerator(oMElement11.getText());
            this.tokenMappingForEncryption.put(tokenMapping.getValueType(), tokenMapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [tokenMappingForEncryption:[" + tokenMapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncryptionDefalutValue(OMElement doc)");
        }
    }

    private boolean getDataAsBoolean(String string) {
        Boolean bl = new Boolean(string);
        return bl;
    }

    private void getSignatureDefaultValue(OMElement oMElement) {
        OMElement oMElement2;
        OMElement oMElement3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignatureDefalutValue(OMElement doc)");
        }
        OMElement oMElement4 = oMElement.getFirstChildWithName(new QName(SIGNATURE));
        OMElement oMElement5 = oMElement4.getFirstChildWithName(new QName(CANONICALIZATIONMETHOD));
        this.canonicalizationMethod = this.getDataAsString(oMElement5.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [canonicalizationMethod:[" + this.canonicalizationMethod + "]");
        }
        OMElement oMElement6 = oMElement4.getFirstChildWithName(new QName(SIGNATUREMETHOD));
        this.signatureMethod = this.getDataAsString(oMElement6.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [signatureMethod:[" + this.signatureMethod + "]");
        }
        OMElement oMElement7 = oMElement4.getFirstChildWithName(new QName(DIGESTMETHOD));
        this.digestMethod = this.getDataAsString(oMElement7.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [digestMethod:[" + this.digestMethod + "]");
        }
        OMElement oMElement8 = oMElement4.getFirstChildWithName(new QName(TRANSFORMMETHODS));
        Iterator iterator = oMElement8.getChildrenWithName(new QName(TRANSFORMMETHOD));
        while (iterator.hasNext()) {
            oMElement3 = (OMElement)iterator.next();
            this.transformMethodsForSignature.add(this.getDataAsString(oMElement3.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [transformMethodsForSignature:[" + this.transformMethodsForSignature + "]");
        }
        oMElement3 = oMElement4.getFirstChildWithName(new QName(SIGNPARTS));
        Iterator iterator2 = oMElement3.getChildrenWithName(new QName(SIGNPART));
        while (iterator2.hasNext()) {
            oMElement2 = (OMElement)iterator2.next();
            this.signParts.add(this.getDataAsInt(oMElement2.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [signParts:[" + this.signParts + "]");
        }
        oMElement2 = oMElement4.getFirstChildWithName(new QName(TOKENREFERENCE));
        this.tokenReferenceForSignature = this.getDataAsInt(oMElement2.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [tokenReferenceForSignature:[" + this.tokenReferenceForSignature + "]");
        }
        OMElement oMElement9 = oMElement4.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iterator3 = oMElement9.getChildrenWithName(new QName(TOKENMAPPING));
        while (iterator3.hasNext()) {
            TokenMapping tokenMapping = new TokenMapping();
            OMElement oMElement10 = (OMElement)iterator3.next();
            OMElement oMElement11 = oMElement10.getFirstChildWithName(new QName(VALUETYPE));
            tokenMapping.setValueType(this.getDataAsQName(oMElement11.getText()));
            OMElement oMElement12 = oMElement10.getFirstChildWithName(new QName(JAASLOGINCONFIGNAME));
            tokenMapping.setJaasLoginConfigNameForGenerator(oMElement12.getText());
            this.tokenMappingForSignature.put(tokenMapping.getValueType(), tokenMapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [tokenMappingForSignature:[" + tokenMapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignatureDefalutValue(OMElement doc)");
        }
    }

    private String getDataAsString(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataAsString(String elementData): [elementData:[" + string + "]");
        }
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        String string3 = classMap.get(string2);
        String string4 = string.substring(n + 1).trim();
        try {
            Class<?> clazz = Class.forName(string3 + "." + string2);
            Field field = clazz.getField(string4);
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDataAsString(String elementData): [elementData:[" + (String)field.get(clazz) + "]");
                }
                return (String)field.get(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{illegalArgumentException.getMessage()}));
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{illegalAccessException.getMessage()}));
            }
        }
        catch (SecurityException securityException) {
            Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{securityException.getMessage()}));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{noSuchFieldException.getMessage()}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{classNotFoundException.getMessage()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataAsString(String elementData)");
        }
        return null;
    }

    private QName getDataAsQName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataAsQName(String elementData): [elementData:[" + string + "]");
        }
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        String string3 = classMap.get(string2);
        String string4 = string.substring(n + 1).trim();
        try {
            Class<?> clazz = Class.forName(string3 + "." + string2);
            Field field = clazz.getField(string4);
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDataAsQName(String elementData): [elementData:[" + (QName)field.get(clazz) + "]");
                }
                return (QName)field.get(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{illegalArgumentException.getMessage()}));
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{illegalAccessException.getMessage()}));
            }
        }
        catch (SecurityException securityException) {
            Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{securityException.getMessage()}));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{noSuchFieldException.getMessage()}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{classNotFoundException.getMessage()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataAsString(String elementData) returns null");
        }
        return null;
    }

    private int getDataAsInt(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataAsInt(String elementData): [elementData:[" + string + "]");
        }
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        String string3 = classMap.get(string2);
        String string4 = string.substring(n + 1);
        try {
            Class<?> clazz = Class.forName(string3 + "." + string2);
            Field field = clazz.getField(string4);
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDataAsInt(String elementData): return [" + field.getInt(clazz) + "]");
                }
                return field.getInt(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{illegalArgumentException.getMessage()}));
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{illegalAccessException.getMessage()}));
            }
        }
        catch (SecurityException securityException) {
            Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{securityException.getMessage()}));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{noSuchFieldException.getMessage()}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{classNotFoundException.getMessage()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataAsInt(String elementData): return [-1]");
        }
        return -1;
    }

    public List<String> getAllowedCanonicalizationMethods() {
        return this.allowedCanonicalizationMethods;
    }

    public List<String> getAllowedDataEncryptionMethods() {
        return this.allowedDataEncryptionMethods;
    }

    public List<String> getAllowedKeyEncryptionMethods() {
        return this.allowedKeyEncryptionMethods;
    }

    public List<String> getAllowedSignatureMethods() {
        return this.allowedSignatureMethods;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public String getDataEncryptionMethod() {
        return this.dataEncryptionMethod;
    }

    public List<Integer> getDecryptionParts() {
        return this.decryptionParts;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public List<Integer> getEncryptionParts() {
        return this.encryptionParts;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public boolean isKeyEncrypted() {
        return this.keyEncrypted;
    }

    public boolean isKeyEncryptedForDecrption() {
        return this.keyEncryptedForDecrption;
    }

    public String getKeyEncryptionMethod() {
        return this.keyEncryptionMethod;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public List<Integer> getSignParts() {
        return this.signParts;
    }

    public List<String> getTransformMethodsForSignature() {
        return this.transformMethodsForSignature;
    }

    public List<String> getTransformMethodsForVerification() {
        return this.transformMethodsForVerification;
    }

    public List<Integer> getVerifyParts() {
        return this.verifyParts;
    }

    public int getTokenReferenceForSignature() {
        return this.tokenReferenceForSignature;
    }

    public int getTokenReferenceForEncryption() {
        return this.tokenReferenceForEncryption;
    }

    public Map<QName, TokenMapping> getTokenMappingForDecryption() {
        return this.tokenMappingForDecryption;
    }

    public Map<QName, TokenMapping> getTokenMappingForEncryption() {
        return this.tokenMappingForEncryption;
    }

    public Map<QName, TokenMapping> getTokenMappingForSignature() {
        return this.tokenMappingForSignature;
    }

    public Map<QName, TokenMapping> getTokenMappingForVerification() {
        return this.tokenMappingForVerification;
    }

    public Map<QName, TokenMapping> getTokenMapping() {
        return this.tokenMapping;
    }

    public String getDuration() {
        return this.duration;
    }

    public Map<String, Map> getSignatureAlgorithmMap() {
        return this.signatureAlgorithmMap;
    }

    public Map<String, Map> getEncryptionAlgorithmMap() {
        return this.encryptionAlgorithmMap;
    }

    public String getDefaultSignatureAlgorithm() {
        return this.defaultSignatureAlgorithm;
    }

    public String getDefaultEncryptionAlgorithm() {
        return this.defaultEncryptionAlgorithm;
    }

    static {
        classMap.put("WSSSignature", SIGNATURE_CLASS);
        classMap.put("WSSSignPart", SIGNATURE_CLASS);
        classMap.put("WSSDecryption", DECRYPTION_CLASS);
        classMap.put("WSSEncryption", ENCRYPTION_CLASS);
        classMap.put("WSSVerification", VERIFICATOIN_CLASS);
        classMap.put("WSSVerifyPart", VERIFICATOIN_CLASS);
        classMap.put("WSSConsumingContext", WSS_CLASS);
        classMap.put("X509Token", TOKEN_CLASS);
        classMap.put("X509PKCS7Token", TOKEN_CLASS);
        classMap.put("X509PKIPathToken", TOKEN_CLASS);
        classMap.put("LTPAToken", TOKEN_CLASS);
        classMap.put("LTPAPropagationToken", TOKEN_CLASS);
        classMap.put("UsernameToken", TOKEN_CLASS);
        classMap.put("SecurityContextToken", TOKEN_CLASS);
        classMap.put("SecurityToken", TOKEN_CLASS);
        DEFAULT_VALUE_FILE_NAME = "META-INF/wssapiDefaultValues.xml";
        SIGNATURE = "signature";
        CANONICALIZATIONMETHOD = "canonicalizationMethod";
        SIGNATUREMETHOD = "signatureMethod";
        DIGESTMETHOD = "digestMethod";
        TRANSFORMMETHODS = "transformMethods";
        TRANSFORMMETHOD = "transformMethod";
        SIGNPARTS = "signParts";
        SIGNPART = "signPart";
        ENCRYPTION = "encryption";
        KEYENCRYPTED = "keyEncrypted";
        OPTIMIZED = "optimized";
        KEYENCRYPTIONMETHOD = "keyEncryptionMethod";
        DATAENCRYPTIONMETHOD = "dataEncryptionMethod";
        ENCRYPTIONPARTS = "encryptionParts";
        ENCRYPTIONPART = "encryptionPart";
        VERIFICATON = "verification";
        ALLOWEDCANONICALIZATIONMETHODS = "allowedCanonicalizationMethods";
        ALLOWEDSIGNATUREMETHODS = "allowedSignatureMethods";
        VERIFYPARTS = "verifyParts";
        VERIFYPART = "verifyPart";
        DECRYPTION = "decryption";
        ALLOWEDKEYENCRYPTIONMETHODS = "allowedKeyEncryptionMethods";
        ALLOWEDDATAENCRYPTIONMETHODS = "allowedDataEncryptionMethods";
        DECRYPTIONPARTS = "decryptionParts";
        DECRYPTIONPART = "decryptionPart";
        TOKENREFERENCE = "tokenReference";
        TOKENMAPPINGS = "tokenMappings";
        TOKENMAPPING = "tokenMapping";
        VALUETYPE = "valueType";
        JAASLOGINCONFIGNAME = "jaasLoginConfigName";
        instance = new DefaultValueManager();
    }
}

