/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register(CommonContentGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CommonContentGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public Key getKey(OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        Object object2;
        Configuration configuration;
        Object object3;
        if (tc.isEntryEnabled()) {
            object3 = new StringBuffer("getKey(");
            ((StringBuffer)object3).append("OMDocument doc[").append(DOMUtils.getDisplayName(oMDocument)).append("], ");
            ((StringBuffer)object3).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object3).append("Map type, Map context)");
            Tr.entry(tc, ((StringBuffer)object3).toString());
        }
        object3 = (KeyInfoContentGeneratorConfig)map2.remove("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoContentGeneratorConfig [" + object3 + "].");
        }
        int n = 0;
        Object object4 = map2.get("com.ibm.ws.wssecurity.constants.soapVersion");
        if (object4 != null && object4 instanceof Integer) {
            n = (Integer)object4;
        }
        int n2 = 0;
        object4 = map2.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (object4 != null && object4 instanceof Integer) {
            n2 = (Integer)object4;
        }
        String string = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n2];
        String string2 = object3.getKeyInfoType();
        map2.put(Constants.WSSECURITY_KEYINFO_TYPE, string2);
        String string3 = (String)map.get(Constants.WSSECURITY_KEY_TYPE);
        map2.put(Constants.WSSECURITY_KEY_TYPE, string3);
        OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
        OMElement oMElement2 = null;
        boolean bl = ConfigUtil.isKeyInfoEmb(string2);
        boolean bl2 = ConfigUtil.isKeyInfoStrref(string2);
        if (bl2) {
            configuration = (WSSGeneratorConfig)map2.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            object2 = configuration.getTargetActor();
            boolean bl3 = Axis2Util.getMustUnderstand(map2);
            object = WSSGenerator.getHeader(oMDocument, false);
            oMElement2 = WSSGenerator.getSecurityHeader((OMElement)object, n, n2, (String)object2, bl3);
        } else {
            oMElement2 = bl ? CommonContentGenerator.insertEmbeddedElements(oMFactory, oMElement, n2, string) : oMElement;
        }
        configuration = object3.getTokenGenerator();
        if (configuration == null) {
            throw SoapSecurityException.format("security.wssecurity.WSEC6818E", configuration.toString());
        }
        object2 = CommonContentGenerator.invokeTokenGenerator(oMDocument, oMElement2, (TokenGeneratorConfig)configuration, map2);
        if (configuration.getProperties().get("RequiredImpliedDerivedKeys") != null && ((Boolean)configuration.getProperties().get("RequiredImpliedDerivedKeys")).booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Implied Derived Keys property is = TRUE");
            }
            map.put("RequiredImpliedDerivedKeys", (Boolean)configuration.getProperties().get("RequiredImpliedDerivedKeys"));
        }
        Key key = null;
        if ("SigningKey".equals(string3)) {
            try {
                key = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>((SecurityToken)object2){
                    final /* synthetic */ SecurityToken val$token;
                    {
                        this.val$token = securityToken;
                    }

                    @Override
                    public Key run() throws WSSException {
                        Key key = this.val$token.getKey(61);
                        return key;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Tr.processException((Throwable)privilegedActionException, clsName + ".login", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7073E", privilegedActionException.getCause());
            }
        }
        if ("EncryptingKey".equals(string3)) {
            try {
                key = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>((SecurityToken)object2){
                    final /* synthetic */ SecurityToken val$token;
                    {
                        this.val$token = securityToken;
                    }

                    @Override
                    public Key run() throws WSSException {
                        Key key = this.val$token.getKey(62);
                        return key;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Tr.processException((Throwable)privilegedActionException, clsName + ".login", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7073E", privilegedActionException.getCause());
            }
        }
        if (key == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Signing key or encrypting key is null.");
            }
            throw SoapSecurityException.format("security.wssecurity.WSEC7073E");
        }
        if (!bl) {
            CommonContentGenerator.insertKeyInfoChildElements(oMFactory, oMElement, n2, string, (SecurityToken)object2, string2, map);
        } else {
            CommonContentGenerator.insertIdForEmbeddedElement(oMElement2, (SecurityToken)object2, n2);
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getKey(");
            ((StringBuffer)object).append("Document, Element, Map, Map)");
            ((StringBuffer)object).append(" returns Key[").append(key).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return key;
    }

    private static final OMElement insertEmbeddedElements(OMFactory oMFactory, OMElement oMElement, int n, String string) throws SoapSecurityException {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("insertEmbeddedElements(");
            ((StringBuffer)charSequence).append("OMFactory factory, ");
            ((StringBuffer)charSequence).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("int wssVersion[").append(n).append("], ");
            ((StringBuffer)charSequence).append("String nsWsse[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = DOMUtils.getNamespacePrefix(oMElement, string);
        boolean bl = false;
        if (charSequence == null) {
            bl = true;
            charSequence = "wsse";
        }
        OMElement oMElement2 = oMFactory.createOMElement("SecurityTokenReference", string, (String)charSequence);
        if (bl) {
            oMElement2.declareNamespace(string, "wsse");
        }
        OMElement oMElement3 = oMFactory.createOMElement("Embedded", string, (String)charSequence);
        oMElement2.addChild(oMElement3);
        OMNode oMNode = oMElement.getFirstOMChild();
        if (oMNode == null) {
            oMElement.addChild(oMElement2);
        } else {
            oMNode.insertSiblingBefore(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("insertEmbeddedElements(");
            stringBuffer.append("OMFactory, OMElement, int, String)");
            stringBuffer.append(" returns OMElement[").append(DOMUtils.getDisplayName(oMElement3)).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return oMElement3;
    }

    private static final void insertIdForEmbeddedElement(OMElement oMElement, SecurityToken securityToken, int n) throws SoapSecurityException {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("insertIdForEmbeddedElement(");
            ((StringBuffer)charSequence).append("OMElement embelem[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("SecurityToken token[").append(securityToken).append("], ");
            ((StringBuffer)charSequence).append("int wssVersion[").append(n).append(")");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        if ((charSequence = securityToken.getId()) != null) {
            boolean bl = false;
            String string = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
            String string2 = null;
            OMContainer oMContainer = oMElement.getParent();
            if (oMContainer instanceof OMElement) {
                string2 = DOMUtils.getNamespacePrefix((OMElement)oMContainer, string);
            }
            if (string2 == null) {
                bl = true;
                string2 = "wsu";
            }
            if (bl) {
                oMElement.declareNamespace(string, string2);
            }
            oMElement.addAttribute("Id", (String)charSequence, oMElement.getOMFactory().createOMNamespace(string, string2));
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Id not found from token for Embedded element");
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("insertIdForEmbeddedElement(");
            stringBuffer.append("OMElement embelem, SecurityToken token, int wssVersion)");
            Tr.exit(tc, stringBuffer.toString());
        }
    }

    private static final SecurityToken invokeTokenGenerator(OMDocument oMDocument, OMElement oMElement, TokenGeneratorConfig tokenGeneratorConfig, Map<Object, Object> map) throws SoapSecurityException {
        TokenGeneratorComponent tokenGeneratorComponent;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("invokeTokenGenerator(");
            ((StringBuffer)object).append("OMDocument doc[").append(DOMUtils.getDisplayName(oMDocument)).append("], ");
            ((StringBuffer)object).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object).append("TokenGeneratorConfig tconfig, Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if ((tokenGeneratorComponent = ((PrivateGeneratorConfig.TokenGeneratorConfImpl)(object = (PrivateGeneratorConfig.TokenGeneratorConfImpl)tokenGeneratorConfig)).getInstance()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
        }
        SecurityToken securityToken = (SecurityToken)map.get(tokenGeneratorConfig);
        if (securityToken == null) {
            map.put("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey", tokenGeneratorConfig);
            tokenGeneratorComponent.invoke(oMDocument, oMElement, map);
            securityToken = (SecurityToken)map.remove(Constants.WSSECURITY_TOKEN_LOGININFO);
            map.put(tokenGeneratorConfig, securityToken);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("invokeTokenGenerator(");
            stringBuffer.append("Document doc, Element parent, TokenGeneratorConfig config, Map context)");
            stringBuffer.append(" returns SecurityToken[").append(securityToken).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return securityToken;
    }

    private static final void insertKeyInfoChildElements(OMFactory oMFactory, OMElement oMElement, int n, String string, SecurityToken securityToken, String string2, Map<Object, Object> map) throws SoapSecurityException {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("insertKeyInfoChildElements(");
            ((StringBuffer)charSequence).append("OMFactory factory, ");
            ((StringBuffer)charSequence).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("int wssVersion[").append(n).append("], ");
            ((StringBuffer)charSequence).append("String nsWsse[").append(string).append("], ");
            ((StringBuffer)charSequence).append("SecurityToken token[").append(securityToken).append("], ");
            ((StringBuffer)charSequence).append("KeyInfoContentGeneratorConfig config, Map type)");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        if (ConfigUtil.isKeyInfoStrref(string2)) {
            charSequence = DOMUtils.getNamespacePrefix(oMElement, string);
            boolean bl = false;
            if (charSequence == null) {
                bl = true;
                charSequence = "wsse";
            }
            OMElement oMElement2 = oMFactory.createOMElement("SecurityTokenReference", string, (String)charSequence);
            if (bl) {
                oMElement2.declareNamespace(string, (String)charSequence);
            }
            if (map.get("RequiredImpliedDerivedKeys") != null && ((Boolean)map.get("RequiredImpliedDerivedKeys")).booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Implied Derived Keys property is = TRUE");
                }
                String string3 = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
                bl = false;
                String string4 = null;
                if (oMElement != null) {
                    string4 = DOMUtils.getNamespacePrefix(oMElement, string3);
                }
                if (string4 == null) {
                    bl = true;
                    string4 = "wsc";
                }
                if (bl) {
                    oMElement2.declareNamespace(string3, string4);
                }
                String string5 = null;
                string5 = Base64.encode(((DKToken)securityToken).getNonce());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nonce from the DerivedKeyToken= " + string5);
                }
                oMElement2.addAttribute("Nonce", string5, oMElement2.getOMFactory().createOMNamespace(string3, string4));
                String string6 = new Long(((DKToken)securityToken).getLength()).toString();
                oMElement2.addAttribute("Length", string6, oMElement2.getOMFactory().createOMNamespace(string3, string4));
                String string7 = "#" + ((DKToken)securityToken).getrefTokenId();
                OMElement oMElement3 = oMFactory.createOMElement("Reference", string, (String)charSequence);
                oMElement3.addAttribute("URI", string7, null);
                QName qName = new QName("", com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT);
                DOMUtils.setQNameAttr(oMElement3, null, "ValueType", qName, n);
                oMElement2.addChild(oMElement3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "STR element = " + oMElement2);
                }
            } else {
                String string8 = securityToken.getReferenceURI();
                OMElement oMElement4 = oMFactory.createOMElement("Reference", string, (String)charSequence);
                oMElement4.addAttribute("URI", string8, null);
                QName qName = securityToken.getValueType();
                DOMUtils.setQNameAttr(oMElement4, null, "ValueType", qName, n);
                oMElement2.addChild(oMElement4);
            }
            oMElement.addChild(oMElement2);
        } else if (ConfigUtil.isKeyInfoKeyid(string2)) {
            charSequence = DOMUtils.getNamespacePrefix(oMElement, string);
            boolean bl = false;
            if (charSequence == null) {
                bl = true;
                charSequence = "wsse";
            }
            OMElement oMElement5 = oMFactory.createOMElement("SecurityTokenReference", string, (String)charSequence);
            if (bl) {
                oMElement5.declareNamespace(string, (String)charSequence);
            }
            OMElement oMElement6 = oMFactory.createOMElement("KeyIdentifier", string, (String)charSequence);
            QName qName = ((X509Token)securityToken).getKeyIdentifierEncodingType();
            DOMUtils.setQNameAttr(oMElement6, null, "EncodingType", qName, n);
            QName qName2 = ((X509Token)securityToken).getKeyIdentifierValueType();
            DOMUtils.setQNameAttr(oMElement6, null, "ValueType", qName2, n);
            oMElement5.addChild(oMElement6);
            String string9 = securityToken.getKeyIdentifier();
            OMText oMText = oMFactory.createOMText(string9);
            oMElement6.addChild(oMText);
            oMElement.addChild(oMElement5);
        } else if (ConfigUtil.isKeyInfoThumbprint(string2)) {
            charSequence = DOMUtils.getNamespacePrefix(oMElement, string);
            boolean bl = false;
            if (charSequence == null) {
                bl = true;
                charSequence = "wsse";
            }
            OMElement oMElement7 = oMFactory.createOMElement("SecurityTokenReference", string, (String)charSequence);
            if (bl) {
                oMElement7.declareNamespace(string, (String)charSequence);
            }
            OMElement oMElement8 = oMFactory.createOMElement("KeyIdentifier", string, (String)charSequence);
            QName qName = securityToken.getThumbprintEncodingType();
            DOMUtils.setQNameAttr(oMElement8, null, "EncodingType", qName, n);
            QName qName3 = securityToken.getThumbprintValueType();
            DOMUtils.setQNameAttr(oMElement8, null, "ValueType", qName3, n);
            oMElement7.addChild(oMElement8);
            String string10 = securityToken.getThumbprint();
            OMText oMText = oMFactory.createOMText(string10);
            oMElement8.addChild(oMText);
            oMElement.addChild(oMElement7);
        } else if (ConfigUtil.isKeyInfoKeyname(string2)) {
            charSequence = DOMUtils.getNamespacePrefix(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_DSIG);
            if (charSequence == null) {
                charSequence = "ds";
            }
            OMElement oMElement9 = oMFactory.createOMElement("KeyName", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, (String)charSequence);
            String string11 = securityToken.getKeyName();
            String string12 = KeyInfo.X509Data.decodeDName(string11);
            if (string12 != null) {
                string11 = string12;
            }
            OMText oMText = oMFactory.createOMText(string11);
            oMElement9.addChild(oMText);
            oMElement.addChild(oMElement9);
        } else if (!ConfigUtil.isKeyInfoEmb(string2)) {
            if (ConfigUtil.isKeyInfoX509issuer(string2)) {
                charSequence = DOMUtils.getNamespacePrefix(oMElement, string);
                boolean bl = false;
                if (charSequence == null) {
                    bl = true;
                    charSequence = "wsse";
                }
                OMElement oMElement10 = oMFactory.createOMElement("SecurityTokenReference", string, (String)charSequence);
                if (bl) {
                    oMElement10.declareNamespace(string, (String)charSequence);
                }
                String string13 = com.ibm.ws.wssecurity.common.Constants.NS_DSIG;
                String string14 = DOMUtils.getNamespacePrefix(oMElement, string13);
                bl = false;
                if (string14 == null) {
                    bl = true;
                    string14 = "ds";
                }
                if (bl) {
                    oMElement10.declareNamespace(string13, string14);
                }
                OMElement oMElement11 = oMFactory.createOMElement("X509Data", string13, string14);
                oMElement10.addChild(oMElement11);
                OMElement oMElement12 = oMFactory.createOMElement("X509IssuerSerial", string13, string14);
                oMElement11.addChild(oMElement12);
                OMElement oMElement13 = oMFactory.createOMElement("X509IssuerName", string13, string14);
                oMElement12.addChild(oMElement13);
                String string15 = ((X509Token)securityToken).getIssuerName();
                OMText oMText = oMFactory.createOMText(string15);
                oMElement13.addChild(oMText);
                OMElement oMElement14 = oMFactory.createOMElement("X509SerialNumber", string13, string14);
                oMElement12.addChild(oMElement14);
                String string16 = ((X509Token)securityToken).getIssuerSerial();
                OMText oMText2 = oMFactory.createOMText(string16);
                oMElement14.addChild(oMText2);
                oMElement.addChild(oMElement10);
            } else {
                charSequence = (String)map.get(Constants.WSSECURITY_KEY_TYPE);
                boolean bl = WSSecurityPlatformContextFactory.getInstance().isServer();
                StringBuffer stringBuffer = new StringBuffer("WARNING: ").append(clsName);
                stringBuffer.append(" found unknown key information type: ").append(string2).append(". ");
                stringBuffer.append(" Please make sure the key information used for");
                if ("SigningKey".equals(charSequence)) {
                    stringBuffer.append(" siganture");
                } else {
                    stringBuffer.append(" encryption");
                }
                stringBuffer.append(" in the");
                if (bl) {
                    stringBuffer.append(" response generator configuration.");
                } else {
                    stringBuffer.append(" request generator configuration.");
                }
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("insertKeyInfoChildElements(");
            ((StringBuffer)charSequence).append("OMFactory factory, OMElement parent, int wssVersion, String nsWsse, ");
            ((StringBuffer)charSequence).append("SecurityToken token, KeyInfoContentGeneratorConfig config, Map type)");
            Tr.exit(tc, ((StringBuffer)charSequence).toString());
        }
    }
}

