/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonContentConsumer
implements KeyInfoContentConsumerComponent {
    private static final TraceComponent tc = Tr.register(CommonContentConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CommonContentConsumer.class.getName();
    private static final QName ENCODINGTYPE_Q = new QName("", "EncodingType");
    private static final QName IDENTIFIERTYPE_Q = new QName("", "IdentifierType");
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public Key getKey(OMElement oMElement, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        Serializable serializable;
        boolean bl;
        Object object;
        String string;
        Object object2;
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("getKey(");
            ((StringBuffer)object2).append("Element target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object2).append("Map type, Map context)");
            Tr.entry(tc, ((StringBuffer)object2).toString());
        }
        object2 = (KeyInfoContentConsumerConfig)map2.remove("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoContentConsumerConfig [" + object2 + "].");
        }
        Map<Object, Object> map3 = object2.getProperties();
        String string2 = null;
        string2 = (String)map3.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
        if (string2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HW keystore name is in use = " + string2);
            }
            map2.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", string2);
        }
        KeyInfoResult keyInfoResult = new KeyInfoResult((KeyInfoContentConsumerConfig)object2);
        ResultPool.add(map2, keyInfoResult);
        ResolvedKeyInfo resolvedKeyInfo = CommonContentConsumer.resolveKeyInfo(oMElement, map2);
        if (resolvedKeyInfo == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
        }
        String string3 = resolvedKeyInfo._kitype;
        map2.put(Constants.WSSECURITY_KEYINFO_TYPE, string3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The type of a key information is [" + string3 + "].");
        }
        OMElement oMElement2 = null;
        if (ConfigUtil.isKeyInfoStrref(string3)) {
            string = resolvedKeyInfo._tokenReference;
            keyInfoResult.setIdInSubject(string);
            map2.put(Constants.WSSECURITY_KEY_REFERENCE, string);
            if (resolvedKeyInfo._impliedDKNonce != null) {
                map2.put("ImpliedDerivedKeys_Nonce_Prop", resolvedKeyInfo._impliedDKNonce);
                map2.put("ImpliedDerivedKeys_Length_Prop", resolvedKeyInfo._impliedDKLength);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reference URI to a token is [" + string + "].");
            }
        } else if (ConfigUtil.isKeyInfoKeyid(string3)) {
            string = resolvedKeyInfo._tokenId;
            keyInfoResult.setIdInSubject(string);
            object = resolvedKeyInfo._kidValueType;
            map2.put(Constants.WSSECURITY_KEY_ID, string);
            map2.put(Constants.WSSECURITY_KEY_VALUETYPE, object);
            map2.put(Constants.WSSECURITY_KEY_ENCODING, resolvedKeyInfo._kidEncodingType);
            map2.put(Constants.WSSECURITY_KEY_IDTYPE, resolvedKeyInfo._kidIdentifierType);
            bl = WSSecurityPlatformContextFactory.getInstance().isServer();
            if (bl && object != null && (((QName)object).equals(com.ibm.ws.wssecurity.common.Constants.X509_SKI) || ((QName)object).equals(com.ibm.ws.wssecurity.common.Constants.X509_SKI_OLD))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + object + " key idendifier is found.        It is cached in order to use it for response generator.");
                }
                if ((serializable = (MessageContext)map2.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
                }
                ((MessageContext)serializable).setProperty("com.ibm.ws.wssecurity.constants.consumedKeyidValuetype", object);
            }
        } else if (ConfigUtil.isKeyInfoThumbprint(string3)) {
            string = resolvedKeyInfo._tokenId;
            keyInfoResult.setIdInSubject(string);
            object = resolvedKeyInfo._kidValueType;
            map2.put(Constants.WSSECURITY_KEY_THUMBPRINT_REFERENCE, string);
            map2.put(Constants.WSSECURITY_KEY_VALUETYPE, object);
            map2.put(Constants.WSSECURITY_KEY_ENCODING, resolvedKeyInfo._kidEncodingType);
            map2.put(Constants.WSSECURITY_KEY_IDTYPE, resolvedKeyInfo._kidIdentifierType);
            bl = WSSecurityPlatformContextFactory.getInstance().isServer();
            if (bl && object != null && ((QName)object).equals(com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + object + " thumbprint reference is found.  It is cached in order to use it for response generator.");
                }
                if ((serializable = (MessageContext)map2.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
                }
                ((MessageContext)serializable).setProperty("com.ibm.ws.wssecurity.constants.consumedKeyidValuetype", object);
            }
        } else if (ConfigUtil.isKeyInfoKeyname(string3)) {
            string = resolvedKeyInfo._tokenName;
            keyInfoResult.setIdInSubject(string);
            map2.put(Constants.WSSECURITY_KEY_NAME, string);
        } else if (ConfigUtil.isKeyInfoEmb(string3)) {
            string = resolvedKeyInfo._tokenId;
            keyInfoResult.setIdInSubject(string);
            map2.put(Constants.WSSECURITY_KEY_EMBID, string);
            oMElement2 = resolvedKeyInfo._embeddedToken;
        } else if (ConfigUtil.isKeyInfoX509issuer(string3)) {
            string = resolvedKeyInfo._x509issuerName;
            object = resolvedKeyInfo._x509issuerSerial;
            keyInfoResult.setIdInSubject(string + ":" + (String)object);
            map2.put(Constants.WSSECURITY_KEY_ISSUERNAME, string);
            map2.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, object);
        } else {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey03", string3);
        }
        string = (String)map.get(Constants.WSSECURITY_KEY_TYPE);
        map2.put(Constants.WSSECURITY_KEY_TYPE, string);
        object = null;
        TokenConsumerConfig tokenConsumerConfig = object2.getTokenConsumer();
        if (tokenConsumerConfig != null) {
            object = CommonContentConsumer.invokeTokenConsumer(oMElement2, tokenConsumerConfig, map2);
        }
        map2.remove(Constants.WSSECURITY_KEYINFO_TYPE);
        serializable = null;
        Object object3 = object;
        if ("VerifyingKey".equals(string)) {
            try {
                serializable = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>((SecurityToken)object3){
                    final /* synthetic */ SecurityToken val$stoken;
                    {
                        this.val$stoken = securityToken;
                    }

                    @Override
                    public Key run() throws WSSException {
                        Key key = this.val$stoken.getKey(63);
                        return key;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Tr.processException((Throwable)privilegedActionException, clsName + ".getKey", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7074E", privilegedActionException.getCause());
            }
        }
        if ("DecryptingKey".equals(string)) {
            try {
                serializable = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>((SecurityToken)object3){
                    final /* synthetic */ SecurityToken val$stoken;
                    {
                        this.val$stoken = securityToken;
                    }

                    @Override
                    public Key run() throws WSSException {
                        Key key = this.val$stoken.getKey(64);
                        return key;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Tr.processException((Throwable)privilegedActionException, clsName + ".getKey", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7074E", privilegedActionException.getCause());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getKey(");
            stringBuffer.append("Element target, Map type, Map context)");
            stringBuffer.append(" returns Key[").append(serializable).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return serializable;
    }

    private static final ResolvedKeyInfo resolveKeyInfo(OMElement oMElement, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("resolveKeyInfo(");
            stringBuffer.append("Element elKinfo[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            stringBuffer.append("Map context)");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = 0;
        Object object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n];
        String string2 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
        ResolvedKeyInfo resolvedKeyInfo = null;
        Object object2 = DOMUtils.getFirstElement(oMElement);
        while (object2 != null) {
            String string3;
            String string4 = object2.getNamespace() == null ? null : object2.getNamespace().getNamespaceURI();
            String string5 = object2.getLocalName();
            if (string.equals(string4)) {
                if ("SecurityTokenReference".equals(string5)) {
                    string3 = null;
                    String string6 = null;
                    string3 = object2.getAttributeValue(new QName(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Nonce"));
                    string6 = object2.getAttributeValue(new QName(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Length"));
                    resolvedKeyInfo = CommonContentConsumer.resolveSecurityTokenReference((OMElement)object2, n, string, string2);
                    if (string3 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Implied derived keys are in use, nonce = " + string3);
                        }
                        resolvedKeyInfo._impliedDKNonce = string3;
                        resolvedKeyInfo._impliedDKLength = string6;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName((OMNode)object2), DOMUtils.getQualifiedName(oMElement)});
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.NS_DSIG.equals(string4)) {
                if ("KeyName".equals(string5)) {
                    string3 = DOMUtils.getStringValue((OMNode)object2);
                    if (string3 == null) {
                        throw SoapSecurityException.format("security.wssecurity.KeyNameContentConsumer.getKeyName01");
                    }
                    resolvedKeyInfo = new ResolvedKeyInfo("KEYNAME");
                    resolvedKeyInfo._tokenName = string3;
                } else if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName((OMNode)object2), DOMUtils.getQualifiedName(oMElement)});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName((OMNode)object2), DOMUtils.getQualifiedName(oMElement)});
            }
            object2 = DOMUtils.getNextElement((OMNode)object2);
        }
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("resolveKeyInfo(");
            ((StringBuffer)object2).append("Element elKinfo, Map context)");
            ((StringBuffer)object2).append(" returns ResolvedKeyInfo[").append(resolvedKeyInfo).append("]");
            Tr.exit(tc, ((StringBuffer)object2).toString());
        }
        return resolvedKeyInfo;
    }

    private static final ResolvedKeyInfo resolveSecurityTokenReference(OMElement oMElement, int n, String string, String string2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("resolveSecurityTokenReference(");
            ((StringBuffer)object).append("Element elStr[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object).append("int wssVersion[").append(n).append("], ");
            ((StringBuffer)object).append("String nsWsse[").append(string).append("], ");
            ((StringBuffer)object).append("String nsWsu[").append(string2).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        Object object2 = DOMUtils.getFirstElement(oMElement);
        while (object2 != null) {
            String string3;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            String string4 = object2.getNamespace() == null ? null : object2.getNamespace().getNamespaceURI();
            String string5 = object2.getLocalName();
            if (string.equals(string4)) {
                if ("Reference".equals(string5)) {
                    object7 = DOMUtils.getAttribute((OMElement)object2, "URI");
                    if (object7 == null) {
                        throw SoapSecurityException.format("security.wssecurity.STRReferenceContentConsumer.getReferenceURI02");
                    }
                    if (((String)object7).startsWith("#")) {
                        object7 = ((String)object7).substring(1);
                    }
                    object = new ResolvedKeyInfo("STRREF");
                    ((ResolvedKeyInfo)object)._tokenReference = (String)object7;
                } else if ("KeyIdentifier".equals(string5)) {
                    object7 = DOMUtils.getAttribute((OMElement)object2, "ValueType");
                    if (object7 == null) {
                        throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token16");
                    }
                    object6 = DOMUtils.getQName((OMElement)object2, (String)object7, n);
                    object5 = com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY;
                    object4 = object2.getAttributeValue(ENCODINGTYPE_Q);
                    if (object4 != null) {
                        object5 = DOMUtils.getQName((OMElement)object2, (String)object4, n);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, ConfigUtil.getMessage("security.wssecurity.KeyIdContentConsumer.getEncodingType02"));
                    }
                    object3 = com.ibm.ws.wssecurity.common.Constants.ITSHA1;
                    object4 = object2.getAttributeValue(IDENTIFIERTYPE_Q);
                    if (object4 != null) {
                        object3 = DOMUtils.getQName((OMElement)object2, (String)object4, n);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, ConfigUtil.getMessage("security.wssecurity.KeyIdContentConsumer.getIdentifierType01"));
                    }
                    string3 = DOMUtils.getStringValue((OMNode)object2);
                    if (string3 != null && string3.length() > 0) {
                        string3 = string3.trim();
                    }
                    if (com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1.equals(object6)) {
                        object3 = com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1;
                        object = new ResolvedKeyInfo("THUMBPRINT");
                    } else {
                        object = new ResolvedKeyInfo("KEYID");
                    }
                    ((ResolvedKeyInfo)object)._tokenId = string3;
                    ((ResolvedKeyInfo)object)._kidValueType = (QName)object6;
                    ((ResolvedKeyInfo)object)._kidEncodingType = (QName)object5;
                    ((ResolvedKeyInfo)object)._kidIdentifierType = (QName)object3;
                } else if ("Embedded".equals(string5)) {
                    object7 = DOMUtils.getFirstElement((OMNode)object2);
                    object6 = object2.getAttributeValue(new QName(string2, "Id"));
                    if (object6 == null) {
                        throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken02");
                    }
                    object = new ResolvedKeyInfo("EMB");
                    ((ResolvedKeyInfo)object)._embeddedToken = (OMElement)object7;
                    ((ResolvedKeyInfo)object)._tokenId = (String)object6;
                } else if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName((OMNode)object2), DOMUtils.getQualifiedName(oMElement)});
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.NS_DSIG.equals(string4)) {
                if ("X509Data".equals(string5)) {
                    object7 = DOMUtils.getOneChildElement((OMElement)object2, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "X509IssuerSerial");
                    if (object7 == null) {
                        throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
                    }
                    object6 = DOMUtils.getOneChildElement((OMElement)object7, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "X509IssuerName");
                    if (object6 == null) {
                        throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
                    }
                    object5 = DOMUtils.getOneChildElement((OMElement)object7, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "X509SerialNumber");
                    if (object5 == null) {
                        throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
                    }
                    object4 = DOMUtils.getStringValue((OMNode)object6);
                    object3 = KeyInfo.X509Data.encodeDName((String)object4);
                    if (object3 != null) {
                        object4 = object3;
                    }
                    if ((string3 = DOMUtils.getStringValue((OMNode)object5)) != null) {
                        try {
                            new BigInteger(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                BigInteger bigInteger = CertificateUtil.convertSerialNumber(string3);
                                string3 = bigInteger.toString();
                            }
                            catch (ParseException parseException) {
                                throw SoapSecurityException.format("security.wssecurity.X509LoginModule.s04", string3, (Throwable)parseException);
                            }
                        }
                    }
                    object = new ResolvedKeyInfo("X509ISSUER");
                    ((ResolvedKeyInfo)object)._x509issuerName = (String)object4;
                    ((ResolvedKeyInfo)object)._x509issuerSerial = string3;
                } else {
                    Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName((OMNode)object2), DOMUtils.getQualifiedName(oMElement)});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName((OMNode)object2), DOMUtils.getQualifiedName(oMElement)});
            }
            object2 = DOMUtils.getNextElement((OMNode)object2);
        }
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("resolveSecurityTokenReference(");
            ((StringBuffer)object2).append("Element elStr, int wssVersion, String nsWsse, String nsWsu)");
            ((StringBuffer)object2).append(" returns ResolvedKeyInfo[").append(object).append("]");
            Tr.exit(tc, ((StringBuffer)object2).toString());
        }
        return object;
    }

    private static final SecurityToken invokeTokenConsumer(OMElement oMElement, TokenConsumerConfig tokenConsumerConfig, Map<Object, Object> map) throws SoapSecurityException {
        TokenConsumerComponent tokenConsumerComponent;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("invokeTokenConsumer(");
            ((StringBuffer)object).append("Element target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object).append("TokenConsumerConfig config, Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if ((tokenConsumerComponent = ((PrivateConsumerConfig.TokenConsumerConfImpl)(object = (PrivateConsumerConfig.TokenConsumerConfImpl)tokenConsumerConfig)).getInstance()) == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
        }
        map.put("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey", tokenConsumerConfig);
        tokenConsumerComponent.invoke(oMElement, map);
        SecurityToken securityToken = (SecurityToken)map.remove(Constants.WSSECURITY_TOKEN_LOGININFO);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("invokeTokenConsumer(");
            stringBuffer.append("Element target, TokenConsumerConfig config, Map context)");
            stringBuffer.append(" returns SecurityToken[").append(securityToken).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return securityToken;
    }

    private static class ResolvedKeyInfo {
        private String _kitype;
        private String _tokenReference;
        private String _tokenId;
        private QName _kidValueType;
        private QName _kidEncodingType;
        private QName _kidIdentifierType;
        private String _tokenName;
        private OMElement _embeddedToken;
        private String _x509issuerName;
        private String _x509issuerSerial;
        private String _impliedDKNonce = null;
        private String _impliedDKLength = null;

        private ResolvedKeyInfo(String string) {
            this._kitype = string;
        }
    }
}

