/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.timer;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class BinaryHeap {
    private Comparable[] heapArray;
    private static final int DEFAULT_SIZE = 1024;
    private int heapSize;
    boolean memoryIsTight;
    private static final TraceComponent tc = Tr.register(BinaryHeap.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public BinaryHeap(Comparable comparable) {
        this.heapArray = new Comparable[1024];
        this.heapArray[0] = comparable;
        this.heapSize = 0;
        this.memoryIsTight = false;
    }

    private BinaryHeap(BinaryHeap binaryHeap) {
        this.heapArray = new Comparable[binaryHeap.heapSize + 1];
        System.arraycopy(binaryHeap.heapArray, 0, this.heapArray, 0, this.heapArray.length);
        this.heapSize = this.heapArray.length - 1;
        this.memoryIsTight = false;
    }

    public void insert(Comparable comparable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{comparable, this});
        }
        ++this.heapSize;
        int n = this.heapSize--;
        try {
            this.growIfNec();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.memoryIsTight = true;
            throw outOfMemoryError;
        }
        while (comparable.compareTo(this.heapArray[BinaryHeap.parent(n)]) < 0) {
            this.heapArray[n] = this.heapArray[BinaryHeap.parent(n)];
            n = BinaryHeap.parent(n);
        }
        this.heapArray[n] = comparable;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insert");
        }
    }

    public final Comparable minimum() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "minimum", this);
        }
        if (this.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "minimum", null);
            }
            return null;
        }
        if (tc.isEntryEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "minimum");
        }
        return this.heapArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Comparable deleteMin() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteMin", this);
        }
        Comparable[] comparableArray = this.heapArray;
        synchronized (this.heapArray) {
            Comparable comparable;
            if (this.isEmpty()) {
                comparable = null;
            } else {
                Comparable comparable2 = this.heapArray[this.heapSize];
                this.heapArray[this.heapSize--] = null;
                if (this.isEmpty()) {
                    comparable = comparable2;
                } else {
                    comparable = this.heapArray[1];
                    this.heapArray[1] = comparable2;
                    this.heapify(1);
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteMin", comparable);
            }
            return comparable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Comparable comparable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", new Object[]{comparable, this});
        }
        Comparable[] comparableArray = this.heapArray;
        synchronized (this.heapArray) {
            int n = this.findKey(comparable);
            if (n >= 0) {
                this.heapArray[n] = this.heapArray[0];
                this.percolateUp(n);
                this.deleteMin();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "delete");
            }
            return;
        }
    }

    private int findKey(Comparable comparable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findKey", new Object[]{comparable, this});
        }
        for (int i = 1; i <= this.heapSize; ++i) {
            if (!this.heapArray[i].equals(comparable)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findKey", new Integer(i));
            }
            return i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findKey", "-1");
        }
        return -1;
    }

    private void percolateUp(int n) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "percolateUp");
        }
        while (this.heapArray[n].compareTo(this.heapArray[BinaryHeap.parent(n)]) < 0) {
            int n2 = BinaryHeap.parent(n);
            Comparable comparable = this.heapArray[n2];
            this.heapArray[n2] = this.heapArray[n];
            this.heapArray[n] = comparable;
            int n3 = n;
            n = n2;
            this.heapify(n3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "percolateUp");
        }
    }

    private final void heapify(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "heapify", new Object[]{new Integer(n), this});
        }
        Comparable comparable = this.heapArray[n];
        while (BinaryHeap.left(n) <= this.heapSize) {
            int n2 = BinaryHeap.left(n);
            if (n2 < this.heapSize && this.heapArray[BinaryHeap.right(n)].compareTo(this.heapArray[n2]) < 0) {
                ++n2;
            }
            if (this.heapArray[n2].compareTo(comparable) >= 0) break;
            this.heapArray[n] = this.heapArray[n2];
            n = n2;
        }
        this.heapArray[n] = comparable;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "heapify");
        }
    }

    void buildHeap(Comparable[] comparableArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildHeap", new Object[]{comparableArray, this});
        }
        for (int i = comparableArray.length; i > 1; --i) {
            this.heapify(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildHeap");
        }
    }

    public Enumeration elements() {
        return new BinaryHeapEnumeration(this);
    }

    public final boolean isEmpty() {
        return this.heapSize == 0;
    }

    public final int size() {
        return this.heapSize;
    }

    private static final int parent(int n) {
        return n / 2;
    }

    private static final int left(int n) {
        return 2 * n;
    }

    private static final int right(int n) {
        return 2 * n + 1;
    }

    private void growIfNec() {
        if (this.heapSize + 1 == this.heapArray.length) {
            Comparable[] comparableArray = this.heapArray;
            int n = 0;
            n = this.memoryIsTight || this.heapSize > 10000 ? this.heapSize * 110 / 100 : this.heapSize * 2;
            this.heapArray = new Comparable[n];
            System.arraycopy(comparableArray, 0, this.heapArray, 0, comparableArray.length);
        }
    }

    private class BinaryHeapEnumeration
    implements Enumeration {
        private BinaryHeap theHeap;

        private BinaryHeapEnumeration(BinaryHeap binaryHeap2) {
            this.theHeap = new BinaryHeap(binaryHeap2);
        }

        public boolean hasMoreElements() {
            return !this.theHeap.isEmpty();
        }

        public Object nextElement() {
            if (this.theHeap.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.theHeap.deleteMin();
        }
    }
}

