/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.timer;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.ThreadPool;
import com.ibm.ws.wssecurity.util.timer._Alarm;

class AlarmThreadPool
extends ThreadPool {
    private static final TraceComponent tc = Tr.register(AlarmThreadPool.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static int minPoolSize = 1;
    private static int maxPoolSize = 4;
    private static int idleTimeout = 90000;

    AlarmThreadPool() {
        super("Alarm", minPoolSize, maxPoolSize);
        this.setKeepAliveTime(idleTimeout);
    }

    AlarmThreadPool(String string) {
        super(string, minPoolSize, maxPoolSize);
        this.setKeepAliveTime(idleTimeout);
    }

    public void fireAlarm(_Alarm _Alarm2) {
        Tr.entry(tc, "firing alarm", _Alarm2);
        try {
            this.execute(_Alarm2);
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "Encountered a failure in the fireAlarm method {0}", throwable);
        }
        Tr.exit(tc, "alarm fired");
    }
}

