/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.timer;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.Alarm;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManagerThread;
import com.ibm.ws.wssecurity.util.timer.BinaryHeap;
import com.ibm.ws.wssecurity.util.timer._Alarm;
import java.util.Vector;

public class AlarmManager {
    private static final TraceComponent tc = Tr.register(AlarmManager.class, null, null);
    public static final String ALARM_WORKBASED = "com.ibm.ejs.am.mode.workbased";
    static final BinaryHeap deferredAlarmQ = new BinaryHeap(new _Alarm());
    static final BinaryHeap nonDeferredAlarmQ = new BinaryHeap(new _Alarm());
    private static boolean initialized = false;
    private static boolean deferred = false;
    private static Vector deferredAlarmList = new Vector();
    private static int activeWork = 0;

    private AlarmManager() {
    }

    private static final synchronized void init() {
        if (initialized) {
            return;
        }
        Thread thread = new Thread((Runnable)new AlarmManagerThread(deferredAlarmQ, deferred, "Deferrable Alarm"), "Deferred Alarm Manager");
        thread.setDaemon(true);
        thread.start();
        Thread thread2 = new Thread((Runnable)new AlarmManagerThread(nonDeferredAlarmQ, false, "Non-deferrable Alarm"), "Non-Deferred Alarm Manager");
        thread2.setDaemon(true);
        thread2.start();
        initialized = true;
    }

    public static final Alarm create(long l, AlarmListener alarmListener, Object object) {
        return AlarmManager.createDeferrable(l, alarmListener, object);
    }

    public static final Alarm create(long l, AlarmListener alarmListener) {
        return AlarmManager.createDeferrable(l, alarmListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Alarm createNonDeferrable(long l, AlarmListener alarmListener, Object object) {
        AlarmManager.init();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonDeferrable", new Object[]{new Long(l), alarmListener, object});
        }
        if (alarmListener == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            l = 0L;
        }
        if ((l += System.currentTimeMillis()) < 0L) {
            l = Long.MAX_VALUE;
        }
        _Alarm _Alarm2 = new _Alarm(l, alarmListener, object, false);
        BinaryHeap binaryHeap = nonDeferredAlarmQ;
        synchronized (binaryHeap) {
            nonDeferredAlarmQ.insert(_Alarm2);
            if (_Alarm2 == nonDeferredAlarmQ.minimum()) {
                nonDeferredAlarmQ.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonDeferrable", _Alarm2);
        }
        return _Alarm2;
    }

    public static final Alarm createNonDeferrable(long l, AlarmListener alarmListener) {
        return AlarmManager.createNonDeferrable(l, alarmListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Alarm createDeferrable(long l, AlarmListener alarmListener, Object object) {
        AlarmManager.init();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDeferrable", new Object[]{new Long(l), alarmListener, object});
        }
        if (alarmListener == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            l = 0L;
        }
        _Alarm _Alarm2 = new _Alarm(l, alarmListener, object, true);
        if (!deferred || activeWork > 0) {
            BinaryHeap binaryHeap = deferredAlarmQ;
            synchronized (binaryHeap) {
                _Alarm2.expirationTime += System.currentTimeMillis();
                if (_Alarm2.expirationTime < 0L) {
                    _Alarm2.expirationTime = Long.MAX_VALUE;
                }
                deferredAlarmQ.insert(_Alarm2);
                if (_Alarm2 == deferredAlarmQ.minimum()) {
                    deferredAlarmQ.notify();
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Alarm has been deferred", _Alarm2);
        }
        Vector vector = deferredAlarmList;
        synchronized (vector) {
            deferredAlarmList.add(_Alarm2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDeferrable", _Alarm2);
        }
        return _Alarm2;
    }

    public static final Alarm createDeferrable(long l, AlarmListener alarmListener) {
        return AlarmManager.createDeferrable(l, alarmListener, null);
    }

    static final void cancel(Alarm alarm) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
        AlarmManager.disableAlarm(alarm);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean disableAlarm(Alarm alarm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableAlarm", alarm);
        }
        boolean bl = false;
        if (((_Alarm)alarm).deferrable) {
            BinaryHeap binaryHeap = deferredAlarmQ;
            synchronized (binaryHeap) {
                Vector vector = deferredAlarmList;
                synchronized (vector) {
                    if (!((_Alarm)alarm).fired) {
                        deferredAlarmQ.delete((_Alarm)alarm);
                        deferredAlarmList.remove((_Alarm)alarm);
                        bl = true;
                    }
                }
            }
        }
        BinaryHeap binaryHeap = nonDeferredAlarmQ;
        synchronized (binaryHeap) {
            if (!((_Alarm)alarm).fired) {
                nonDeferredAlarmQ.delete((_Alarm)alarm);
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableAlarm", bl);
        }
        return bl;
    }

    private static final void armDeferredAlarms() {
        AlarmManager.createNonDeferrable(1000L, new AlarmListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alarm(Object object) {
                _Alarm _Alarm2 = null;
                BinaryHeap binaryHeap = deferredAlarmQ;
                synchronized (binaryHeap) {
                    Vector vector = deferredAlarmList;
                    synchronized (vector) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Starting arm of " + deferredAlarmList.size() + " deferred alarms");
                        }
                        for (int i = 0; i < deferredAlarmList.size(); ++i) {
                            _Alarm2 = (_Alarm)deferredAlarmList.elementAt(i);
                            _Alarm2.expirationTime += System.currentTimeMillis();
                            if (_Alarm2.expirationTime < 0L) {
                                _Alarm2.expirationTime = Long.MAX_VALUE;
                            }
                            deferredAlarmQ.insert(_Alarm2);
                        }
                        deferredAlarmList.clear();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Completed arm of deferred alarms");
                        }
                        deferredAlarmQ.notify();
                    }
                }
            }
        });
    }

    public static synchronized void incActiveWork() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "activeWork = " + activeWork);
        }
        if (activeWork == 0) {
            AlarmManager.armDeferredAlarms();
        }
        ++activeWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decActiveWork() {
        BinaryHeap binaryHeap = deferredAlarmQ;
        synchronized (binaryHeap) {
            Class<AlarmManager> clazz = AlarmManager.class;
            synchronized (AlarmManager.class) {
                --activeWork;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "activeWork = " + activeWork);
                }
                if (activeWork == 0) {
                    deferredAlarmQ.notify();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
    }

    public static synchronized int getActiveWork() {
        return activeWork;
    }
}

