/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.dsig.PartList;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XPathTransformer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.XPathUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.JaxenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(XPathElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XPathElementSelector.class.getName();

    public void init(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        ArrayList arrayList;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + DOMUtils.getDisplayName(oMNode) + "], Map context)");
        }
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String string = (String)map.get("com.ibm.ws.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + string + "]");
        }
        if (string == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s01");
        }
        if (!Constants.DIALECT_XPATH.equals(string) && !Constants.DIALECT_FUNCTION.equals(string)) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string);
        }
        String string2 = (String)map.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keyword [" + string2 + "]");
        }
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object object = map.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean bl = "encryption_mode".equals((String)object);
        boolean bl2 = "decryption_mode".equals((String)object);
        boolean bl3 = "signature_mode".equals((String)object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + object + "]");
        }
        String string3 = (String)map.get("com.ibm.ws.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + string3 + "]");
        }
        Object[] objectArray = (Object[])map.get("com.ibm.ws.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + objectArray + "]");
        }
        Collection collection = (Collection)map.get("com.ibm.ws.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token generator configs [" + collection + "]");
        }
        IDResolver iDResolver = (IDResolver)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ID resolver [" + iDResolver + "]");
        }
        NonceManager nonceManager = (NonceManager)map.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        boolean bl4 = false;
        if (bl || bl2) {
            boolean bl5 = bl4 = string2 != null && string2.endsWith("node()");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption type is #Content [" + bl4 + "]");
            }
            if (bl4) {
                n = string2.lastIndexOf(47);
                string2 = string2.substring(0, n);
            }
        }
        object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        n = 0;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string4 = Constants.NAMESPACES[0][n];
        String string5 = Constants.NAMESPACES[1][n];
        OMDocument oMDocument = DOMUtil.getOwnerDocument(oMNode);
        if (string2.length() == 0) {
            com.ibm.ws.wssecurity.enc.PartList partList;
            arrayList = partList = new ArrayList(1);
            ((ArrayList)partList).add(oMDocument.getOMDocumentElement());
        } else {
            try {
                AXIOMXPath aXIOMXPath = new AXIOMXPath(string2);
                List list = aXIOMXPath.selectNodes(oMNode);
                int n2 = list.size();
                ArrayList<OMElement> arrayList2 = new ArrayList<OMElement>(n2);
                arrayList = arrayList2;
                for (int i = 0; i < n2; ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof OMElement)) continue;
                    arrayList2.add((OMElement)e);
                }
            }
            catch (JaxenException jaxenException) {
                if (!(bl || bl2 || bl3 || "timestamp".equals(string3) || "nonce".equals(string3))) {
                    try {
                        OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
                        OMElement oMElement = oMFactory.createOMElement("XPath", Constants.NS_DSIG, "ds");
                        OMText oMText = oMFactory.createOMText(string2);
                        oMElement.addChild(oMText);
                        XPathTransformer xPathTransformer = new XPathTransformer();
                        xPathTransformer.setParameter(oMElement);
                        SignatureContext signatureContext = new SignatureContext();
                        signatureContext.setIDResolver(iDResolver);
                        Vector vector = XPathUtil.fixTree(oMNode);
                        TransformContext transformContext = new TransformContext(signatureContext, oMNode);
                        xPathTransformer.transform(transformContext);
                        if (vector != null) {
                            XPathUtil.cleanTree(vector);
                        }
                        arrayList = new PartList(transformContext.getNodeset());
                    }
                    catch (TransformException transformException) {
                        Tr.processException(transformException, clsName + ".getElements", "%C");
                        throw SoapSecurityException.format("security.wssecurity.XPathElementSelector.s01", new String[]{string2, transformException.getMessage()}, (Throwable)transformException);
                    }
                }
                Tr.processException(jaxenException, clsName + ".getElements", "%C");
                throw SoapSecurityException.format("security.wssecurity.XPathElementSelector.s01", new String[]{string2, jaxenException.getMessage()}, (Throwable)jaxenException);
            }
        }
        if (string3 != null) {
            if (bl || bl3) {
                arrayList = IntegralDialectElementSelector.postprocess(oMDocument, string3, arrayList, objectArray, string4, string5, nonceManager, bl3, bl, string, string2);
            }
            if (bl && arrayList != null && ((ArrayList)arrayList).size() > 0) {
                throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", string2);
            }
        }
        if (bl || bl2) {
            arrayList = bl4 ? new com.ibm.ws.wssecurity.enc.PartList("http://www.w3.org/2001/04/xmlenc#Content", arrayList) : new com.ibm.ws.wssecurity.enc.PartList("http://www.w3.org/2001/04/xmlenc#Element", arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode, Map)");
        }
        return arrayList;
    }
}

