/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class WSSecurityFactoryBuilder {
    private static final TraceComponent tc = Tr.register(WSSecurityFactoryBuilder.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static Hashtable _factoryImpl = new Hashtable();
    private static Hashtable _factoryImplClassNames = new Hashtable();

    public static Object getInstance(String string) {
        if (_factoryImpl != null && _factoryImpl.containsKey(string)) {
            return _factoryImpl.get(string);
        }
        final String string2 = (String)WSSecurityFactoryBuilder.getImplClassName(string);
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return WSSecurityFactoryBuilder.loadImplFromClass(string2);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "factory key = " + string);
            Tr.debug(tc, "factory impl class = " + string2);
        }
        _factoryImpl.put(string, t);
        return t;
    }

    public static Object loadImplFromClass(String string) {
        ClassLoader classLoader = WSSecurityFactoryBuilder.class.getClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return clazz.newInstance();
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = Class.forName(string);
                return clazz.newInstance();
            }
            catch (Exception exception2) {
                if (tc.isDebugEnabled()) {
                    exception2.printStackTrace();
                }
                return null;
            }
        }
    }

    public static Object getImplClassName(String string) {
        block7: {
            Object object;
            InputStream inputStream;
            if (_factoryImplClassNames != null && !_factoryImplClassNames.isEmpty()) {
                return _factoryImplClassNames.get(string);
            }
            String string2 = "properties/platform.properties";
            if (PlatformContextUtil.isWebSphereThinClient()) {
                string2 = "com/ibm/ws/wssecurity/platform/websphere/properties/thinclient.properties";
            }
            if ((inputStream = WSSecurityFactoryBuilder.class.getClassLoader().getResourceAsStream(string2)) == null) {
                object = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                inputStream = object == null ? ClassLoader.getSystemResourceAsStream(string2) : ((ClassLoader)object).getResourceAsStream(string2);
            }
            if (inputStream != null) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((object = bufferedReader.readLine()) != null) {
                        if (!((String)object).startsWith("com.ibm") || ((String)object).indexOf(61) <= 0) continue;
                        int n = ((String)object).indexOf(61) + 1;
                        String string3 = ((String)object).substring(0, n - 1);
                        String string4 = ((String)object).substring(n);
                        if (string3 == null || string4 == null) continue;
                        _factoryImplClassNames.put(string3, string4);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "factory key = " + string3);
                        Tr.debug(tc, "factory impl class name = " + string4);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception while create WSSecurity factory.", exception);
                    exception.printStackTrace();
                }
            }
        }
        return _factoryImplClassNames.get(string);
    }
}

