/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPFunctionElementSelector
extends XPathElementSelector {
    private static final TraceComponent tc = Tr.register(WSPFunctionElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String WSP_BODY = "wsp:Body";
    private static final String WSP_HEADER = "wsp:Header";
    private static final String[] BODY_TEMPLATE = new String[]{"/*[namespace-uri()='", "' and local-name()='Envelope']/*[namespace-uri()='", "' and local-name()='Body']"};
    private static final String[] HEADER_TEMPLATE = new String[]{"/*[namespace-uri()='", "' and local-name()='Envelope']/*[namespace-uri()='", "' and local-name()='Header']/*[name()='", "']"};

    @Override
    public void init(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        super.init(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + DOMUtils.getDisplayName(oMNode) + "], Map context)");
        }
        String string = (String)map.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expression [" + string + "]");
        }
        int n = 0;
        Object object = map.get("com.ibm.ws.wssecurity.constants.soapVersion");
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string2 = Constants.NAMESPACES[2][n];
        if (string != null) {
            string = WSPFunctionElementSelector.convert2XPath(string2, string);
            map.put("com.ibm.ws.wssecurity.util.selector.keyword", string);
        }
        ArrayList<OMNode> arrayList = super.getElements(oMNode, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode node, Map)");
        }
        return arrayList;
    }

    protected static String convert2XPath(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convert2XPath(String nsSoap[" + string + "]," + "String exp[" + string2 + "])");
        }
        string2 = string2.trim();
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.startsWith(WSP_BODY)) {
            stringBuffer.append(BODY_TEMPLATE[0]).append(string);
            stringBuffer.append(BODY_TEMPLATE[1]).append(string);
            stringBuffer.append(BODY_TEMPLATE[2]);
            int n = string2.indexOf(41) + 1;
            if (n != string2.length()) {
                stringBuffer.append(string2.substring(n));
            }
        } else if (string2.startsWith(WSP_HEADER)) {
            stringBuffer.append(HEADER_TEMPLATE[0]).append(string);
            stringBuffer.append(HEADER_TEMPLATE[1]).append(string);
            stringBuffer.append(HEADER_TEMPLATE[2]);
            int n = string2.indexOf(40) + 1;
            int n2 = string2.indexOf(41);
            stringBuffer.append(string2.substring(n, n2));
            stringBuffer.append(HEADER_TEMPLATE[3]);
            if (n2 != string2.length() - 1) {
                stringBuffer.append(string2.substring(n2 + 1));
            }
        }
        String string3 = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convert2XPath(String, String) returns String[" + string3 + "]");
        }
        return string3;
    }
}

