/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

public class TokenHolder {
    private static final TraceComponent tc = Tr.register(TokenHolder.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TokenHolder.class.getName();

    public static String getTokenFromContext(String string, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenFromContext(Token id[" + string + "],  MessageContext messageContext");
        }
        String string2 = null;
        if (string.equals("INBOUND_SCTOKEN")) {
            if (messageContext != null) {
                OperationContext operationContext = messageContext.getOperationContext();
                if (operationContext == null) {
                    operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
                }
                if (operationContext != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found Operation Context. Look at the prev message contexts.");
                    }
                    HashMap hashMap = operationContext.getMessageContexts();
                    Set set = hashMap.entrySet();
                    for (Map.Entry entry : set) {
                        MessageContext messageContext2 = (MessageContext)entry.getValue();
                        string2 = (String)messageContext2.getProperty("INBOUND_SCTOKEN");
                        if (string2 == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found SCT UUID in the msg ctx with key: " + entry.getKey());
                        }
                        break;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NULL Operation Context.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT uuid in the inbound message context = " + string2);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unexpected property id (" + string + ") received. No action taken.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "This is the uuid from message context = " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenFromContext(Token id [ " + string + " ], MessageContext messageContext)");
        }
        return string2;
    }

    public static String getInstanceFromContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstanceFromContext(MessageContext messageContext");
        }
        String string = null;
        if (messageContext != null && (string = (String)messageContext.getProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage")) == null) {
            OperationContext operationContext = messageContext.getOperationContext();
            if (operationContext == null) {
                operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
            }
            if (operationContext != null) {
                HashMap hashMap = operationContext.getMessageContexts();
                Set set = hashMap.entrySet();
                for (Map.Entry entry : set) {
                    MessageContext messageContext2 = (MessageContext)entry.getValue();
                    string = (String)messageContext2.getProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage");
                    if (string == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found the instance in the msg ctx with key: " + entry.getKey());
                    }
                    messageContext.setProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage", string);
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstanceFromContext(MessageContext messageContext) returns = " + string);
        }
        return string;
    }

    public static HashMap getPropertyMapFromInboundMessageContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyMapFromInboundMessageContext(MessageContext messageContext");
        }
        HashMap hashMap = null;
        if (messageContext != null) {
            OperationContext operationContext = messageContext.getOperationContext();
            if (operationContext == null) {
                operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
            }
            if (operationContext != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking for WSS_RAMP property map in the inbound message context");
                }
                HashMap hashMap2 = operationContext.getMessageContexts();
                Set set = hashMap2.entrySet();
                for (Map.Entry entry : set) {
                    MessageContext messageContext2 = (MessageContext)entry.getValue();
                    hashMap = (HashMap)messageContext2.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (hashMap == null) continue;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Found the wss-ramp property map in the msg ctx with key: " + entry.getKey());
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyMapFromInboundMessageContext(MessageContext messageContext) returns = " + hashMap);
        }
        return hashMap;
    }

    public static HashMap getWssPropertyMapFromInboundMessageContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyMapFromInboundMessageContext(MessageContext messageContext");
        }
        HashMap hashMap = null;
        if (messageContext != null) {
            OperationContext operationContext = messageContext.getOperationContext();
            if (operationContext == null) {
                operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
            }
            if (operationContext != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking for WSS_PROPERTYMAP in the inbound message context");
                }
                HashMap hashMap2 = operationContext.getMessageContexts();
                Set set = hashMap2.entrySet();
                for (Map.Entry entry : set) {
                    MessageContext messageContext2 = (MessageContext)entry.getValue();
                    hashMap = (HashMap)messageContext2.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                    if (hashMap == null) continue;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Found the wss property map in the msg ctx with key: " + entry.getKey());
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyMapFromInboundMessageContext(MessageContext messageContext) returns = " + hashMap);
        }
        return hashMap;
    }

    public static Set getTokensFromContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokensFromContext(MessageContext messageContext)");
        }
        Object object = null;
        if (messageContext != null) {
            object = messageContext.getProperty("SCT_DIST_CACHE");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokensFromContext(MessageContext messageContext)");
        }
        if (object != null && object instanceof HashMap) {
            return ((HashMap)object).entrySet();
        }
        return null;
    }

    public static void setTokenToContext(SCT sCT, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenToContext(Token token, Map context)");
        }
        MessageContext messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        TokenHolder.setTokenToContext(sCT, messageContext);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenToContext(Token token, Map context)");
        }
    }

    private static void setTokenToContext(SCT sCT, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenToContext(Token token, MessageContext messageContext)");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token type :" + (sCT instanceof SCT ? "sct" : "non sct"));
        }
        HashMap<String, SCT> hashMap = null;
        hashMap = (HashMap<String, SCT>)messageContext.getProperty("SCT_DIST_CACHE");
        if (hashMap == null) {
            hashMap = new HashMap<String, SCT>();
        }
        if (sCT instanceof SCT) {
            hashMap.put(sCT.getUUID(), sCT);
        } else {
            hashMap.put(sCT.getId(), sCT);
        }
        messageContext.setProperty("SCT_DIST_CACHE", hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenToContext(Token token, MessageContext messageContext)");
        }
    }

    public static void setInboundTokenToContext(SCT sCT, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInboundTokenToContext(SecurityContextToken token, MessageContext messageContext)");
        }
        messageContext.setProperty("INBOUND_SCTOKEN", sCT.getUUID());
        OperationContext operationContext = messageContext.getOperationContext();
        if (operationContext == null) {
            operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
        }
        if (operationContext != null) {
            operationContext.setProperty("INBOUND_SCTOKEN", sCT.getUUID());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added token uuid = " + sCT.getUUID() + " to the operation context using INBOUND_SCTOKEN as key");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The operation context is NULL!!!");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added token uuid = " + sCT.getUUID() + " to the message context using INBOUND_SCTOKEN as key");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInboundTokenToContext(SecurityContextToken token, MessageContext messageContext)");
        }
    }

    public static String getInboundTokenFromContext(String string, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundTokenFromContext(String = " + string + ", MessageContext messageContext)");
        }
        String string2 = null;
        if ("INBOUND_SCTOKEN".equals(string)) {
            if (messageContext != null) {
                OperationContext operationContext = messageContext.getOperationContext();
                if (operationContext == null) {
                    operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
                }
                if (operationContext != null) {
                    HashMap hashMap = operationContext.getMessageContexts();
                    Set set = hashMap.entrySet();
                    for (Map.Entry entry : set) {
                        MessageContext messageContext2 = (MessageContext)entry.getValue();
                        string2 = (String)messageContext2.getProperty("INBOUND_SCTOKEN");
                        if (string2 == null) continue;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Found SCToken UUID " + string2 + " in the msg ctx with key: " + entry.getKey());
                        break;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found token uuid in the inbound message context = " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundTokenFromContext(String str, MessageContext messageContext) returns " + string2);
        }
        return string2;
    }
}

