/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(TimestampDialectElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    public static final String MOVE_MODE = "move";
    public static final String CHECK_MODE = "check";
    public static final int SECURITYFIRST = 0;
    public static final int SECURITYLAST = 1;
    public static final int SOAPHEADERFIRST = 2;
    public static final int SOAPHEADERLAST = 3;
    public static final int SECURITY_GENERATOR_DEFAULT = 0;
    public static final int SOAPHEADER_GENERATOR_DEFAULT = 3;
    public static final int SECURITY_CONSUMER_DEFAULT = 4;
    public static final int SOAPHEADER_CONSUMER_DEFAULT = 5;
    public static final String[] WASDIALECTS = new String[]{"SecurityFirst".intern(), "SecurityLast".intern(), "SOAPHeaderFirst".intern(), "SOAPHeaderLast".intern(), "SecurityConsumerDefault".intern(), "SOAPHeaderConsumerDefault".intern()};

    public void init(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + DOMUtils.getDisplayName(oMNode) + "], Map context)");
        }
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String string = (String)map.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expression [" + string + "]");
        }
        if (string == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object object2 = map.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean bl = MOVE_MODE.equals((String)object2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + object2 + "]");
        }
        object2 = map.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int n = 0;
        if (object2 != null && object2 instanceof Integer) {
            n = (Integer)object2;
        }
        object2 = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (object2 != null && object2 instanceof Integer) {
            n2 = (Integer)object2;
        }
        String string2 = Constants.NAMESPACES[1][n2];
        String string3 = null;
        if (map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey") == null) {
            object = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
            if (object != null) {
                string3 = object.getMyActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got consumer actor " + string3);
            }
        } else {
            object = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (object != null) {
                string3 = object.getTargetActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got generator actor " + string3);
            }
        }
        object = DOMUtil.getOwnerDocument(oMNode);
        OMElement oMElement = WSSGenerator.getHeader((OMDocument)object, false);
        OMElement oMElement2 = WSSGenerator.getSecurityHeader(oMElement, n, n2, string3, false);
        ArrayList<OMNode> arrayList = null;
        arrayList = bl ? TimestampDialectElementSelector.moveTimestamp(oMElement, oMElement2, string, string2, map) : TimestampDialectElementSelector.getElements(oMElement, oMElement2, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode, Map)");
        }
        return arrayList;
    }

    private static ArrayList<OMNode> moveTimestamp(OMElement oMElement, OMElement oMElement2, String string, String string2, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "moveTimestamp(OMElement header[" + DOMUtils.getDisplayName(oMElement) + "]," + "OMElement security[" + DOMUtils.getDisplayName(oMElement2) + "]," + "String keyword[" + string + "]," + "String nsWsu[" + string2 + "]," + "Map context)");
        }
        OMNode oMNode = null;
        Object[] objectArray = (Object[])map.get("com.ibm.ws.wssecurity.util.selector.element");
        if (objectArray != null && objectArray.length > 0) {
            oMNode = (OMNode)objectArray[0];
        }
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampDialectElementSelector.s01");
        }
        oMNode.detach();
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        if (WASDIALECTS[0].equals(string)) {
            OMNode oMNode2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Moving to the first of the Security element.");
            }
            if ((oMNode2 = oMElement2.getFirstOMChild()) == null) {
                oMElement2.addChild(oMNode);
            } else {
                oMNode2.insertSiblingBefore(oMNode);
            }
        } else if (WASDIALECTS[1].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Moving to the last of the Security element.");
            }
            oMElement2.addChild(oMNode);
        } else if (WASDIALECTS[2].equals(string)) {
            OMNode oMNode3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Moving to the first of the SOAP header element.");
            }
            if ((oMNode3 = oMElement.getFirstOMChild()) == null) {
                oMElement.addChild(oMNode);
            } else {
                oMNode3.insertSiblingBefore(oMNode);
            }
        } else if (WASDIALECTS[3].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Moving to the last of the Security element.");
            }
            oMElement.addChild(oMNode);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown keyword[" + string + "], so applying the default.");
                Tr.debug(tc, "Moving to the last of the Security element.");
            }
            oMElement2.addChild(oMNode);
        }
        objectArray[0] = oMNode;
        map.put("com.ibm.ws.wssecurity.util.selector.element", objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "moveTimestamp(OMElement, OMElement, String, String, Map) returns ArrayListList[" + arrayList + "]");
        }
        return arrayList;
    }

    private static ArrayList<OMNode> getElements(OMElement oMElement, OMElement oMElement2, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMElement header[" + DOMUtils.getDisplayName(oMElement) + "]," + "OMElement security[" + DOMUtils.getDisplayName(oMElement2) + "]," + "String keyword[" + string + "]," + "String nsWsu[" + string2 + "])");
        }
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        OMElement oMElement3 = null;
        if (WASDIALECTS[0].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the first child element in the Security element.");
            }
            oMElement3 = DOMUtils.getFirstElement(oMElement2);
        } else if (WASDIALECTS[1].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the last child element in the Security element.");
            }
            oMElement3 = DOMUtils.getLastElement(oMElement2);
        } else if (WASDIALECTS[2].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the first child element in the SOAP header element.");
            }
            oMElement3 = DOMUtils.getFirstElement(oMElement);
        } else if (WASDIALECTS[3].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the last child element in the SOAP header element.");
            }
            oMElement3 = DOMUtils.getLastElement(oMElement);
        } else if (WASDIALECTS[4].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the immediate child element in the Security element.");
            }
            oMElement3 = DOMUtils.getFirstElement(oMElement2, string2, "Timestamp");
        } else if (WASDIALECTS[5].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the immediate child element in the SOAP header element.");
            }
            oMElement3 = DOMUtils.getFirstElement(oMElement, string2, "Timestamp");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown keyword[" + string + "], so applying the default.");
                Tr.debug(tc, "Getting the last child element in the Security element.");
            }
            oMElement3 = DOMUtils.getLastElement(oMElement2);
        }
        arrayList.add(oMElement3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMElement, OMElement, String, String) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }
}

