/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNameHeaderSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(QNameHeaderSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";

    @Override
    public void init(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + oMNode + "]," + "Map context)");
        }
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String string = (String)map.get("com.ibm.ws.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + string + "]");
        }
        if (string == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s01");
        }
        if (!Constants.DIALECT_HEADER.equals(string)) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string);
        }
        Object object = map.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean bl = "encryption_mode".equals((String)object);
        boolean bl2 = "decryption_mode".equals((String)object);
        boolean bl3 = "signature_mode".equals((String)object);
        boolean bl4 = "verification_mode".equals((String)object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + object + "]");
        }
        String string2 = (String)map.get("com.ibm.ws.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + string2 + "]");
        }
        Object[] objectArray = (Object[])map.get("com.ibm.ws.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + objectArray + "]");
        }
        NonceManager nonceManager = (NonceManager)map.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        object = map.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int n2 = 0;
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object;
        }
        String string3 = Constants.NAMESPACES[2][n2];
        object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        n2 = 0;
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object;
        }
        String string4 = Constants.NAMESPACES[0][n2];
        String string5 = Constants.NAMESPACES[1][n2];
        String string6 = (String)map.get("com.ibm.ws.wssecurity.util.selector.actorOrRole");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Actor/role [" + string6 + "]");
        }
        String string7 = (String)map.get("com.ibm.ws.wssecurity.util.selector.headername");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Header name [" + string7 + "]");
        }
        String string8 = (String)map.get("com.ibm.ws.wssecurity.util.selector.headernamespace");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Header namespace [" + string8 + "]");
        }
        if (string8 == null) {
            throw SoapSecurityException.format("security.wssecurity.QNameHeaderSelector.s01");
        }
        boolean bl5 = false;
        for (n = 0; n < Constants.NS_WSADDRS.length; ++n) {
            if (!string8.equals(Constants.NS_WSADDRS[n])) continue;
            bl5 = true;
            break;
        }
        n = 0;
        String string9 = null;
        MessageContext messageContext = null;
        if (bl5) {
            messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
            if (messageContext == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
            }
            string9 = (String)messageContext.getProperty("WSAddressingVersion");
            if (string9 == null || string9.length() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No namespace defined for WS-Addressing on the message context.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Namespace for WS-Addressing [" + string9 + "].");
                }
                n = 1;
            }
        }
        OMDocument oMDocument = com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil.getOwnerDocument(oMNode);
        OMElement oMElement = oMDocument.getOMDocumentElement();
        ArrayList<OMNode> arrayList = null;
        OMElement oMElement2 = null;
        oMElement2 = oMElement instanceof SOAPEnvelope ? ((SOAPEnvelope)oMElement).getHeader() : DOMUtil.getOneChildElement(oMElement, string3, "Header");
        if (bl || bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing header for encryption with namespace [" + string8 + "] and name [" + string7 + "]");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing header for signature with namespace [" + string8 + "] and name [" + string7 + "]");
        }
        arrayList = new ArrayList<OMNode>();
        if (oMElement2 != null) {
            arrayList = DOMUtil.getHeadersForNamespace(oMElement2, string8, string7, string6, n2);
        }
        if (bl5 && arrayList != null && arrayList.size() != 0) {
            if (n != 0) {
                if (!string8.equals(string9)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WS-Addressing namespace was set to [" + string9 + "] and found namespace [" + string8 + "].");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getElements(OMNode node, Map context)");
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                }
            } else if (!QNameHeaderSelector.isGenerator(map)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No inbound WS-Addressing namespace is set, setting it to [" + string8 + "].");
                }
                messageContext.setProperty("WSAddressingVersion", string8);
            }
        }
        if (bl || bl2) {
            arrayList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", arrayList);
        }
        if (string2 != null) {
            if (bl || bl3) {
                arrayList = IntegralDialectElementSelector.postprocess(oMDocument, string2, arrayList, objectArray, string4, string5, nonceManager, bl3, bl, string, null);
            }
            if (bl && arrayList != null && arrayList.size() > 0) {
                throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", string8 + ":" + string7);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode node, Map context) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    private static final boolean isGenerator(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenerator(Map context)");
        }
        boolean bl = false;
        boolean bl2 = false;
        Object object = map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (object != null) {
            bl = true;
        }
        if ((object = map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey")) != null) {
            bl2 = true;
        }
        if (bl && bl2 || !bl && !bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not determine generator or consumer");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGenerator(Map context)");
            }
            throw SoapSecurityException.format("security.wssecurity.WSEC6734E");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGenerator(Map context) returns " + bl);
        }
        return bl;
    }

    private static final boolean isWsaHeader(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWsaHeader(String headerNamespace)");
        }
        boolean bl = false;
        if (string.equals(Constants.NS_WSADDRS[0]) || string.equals(Constants.NS_WSADDRS[1])) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWsaHeader(String headerNamespace) returns " + bl);
        }
        return bl;
    }
}

