/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PlatformContextUtil {
    private static final TraceComponent tc = Tr.register(PlatformContextUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static boolean isWebSphereServerProcess = true;
    private static boolean isWebSphereThinClient = false;
    private static boolean initialized = false;

    private static boolean initialize() {
        initialized = false;
        AdminService adminService = null;
        try {
            adminService = (AdminService)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return AdminServiceFactory.getAdminService();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (adminService != null) {
            isWebSphereServerProcess = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isWebSphereServerProcess = " + isWebSphereServerProcess);
            }
            return true;
        }
        isWebSphereServerProcess = false;
        isWebSphereThinClient = false;
        ClassLoader classLoader = PlatformContextUtil.class.getClassLoader();
        String string = "com.ibm.ws.wssecurity.platform.websphere.util.WasPasswordUtil";
        try {
            Class<?> clazz = classLoader.loadClass(string);
            isWebSphereThinClient = true;
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = Class.forName(string);
                isWebSphereThinClient = true;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isWebSphereThinClient:" + isWebSphereThinClient);
        }
        initialized = true;
        return true;
    }

    public static boolean isWebSphereServerProcess() {
        if (!initialized) {
            PlatformContextUtil.initialize();
        }
        return isWebSphereServerProcess;
    }

    public static boolean isWebSphereThinClient() {
        if (!initialized) {
            PlatformContextUtil.initialize();
        }
        return isWebSphereThinClient;
    }
}

