/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Duration;
import com.ibm.ws.wssecurity.util.Hex;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class NonceUtil {
    private static final TraceComponent tc = Tr.register(NonceUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = NonceUtil.class.getName();
    private static final long minForwardClockSkew = 90000L;
    private static final QName ENCODINGTYPE_Q = new QName("", "EncodingType");
    private static final QName VALUETYPE_Q = new QName("", "ValueType");
    private static final String HTTP_STR = "http://".intern();

    public static OMElement getTimestamp(OMElement oMElement, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestamp(OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsu[" + string + "])");
        }
        OMElement oMElement2 = null;
        oMElement2 = DOMUtils.equals(oMElement, string, "Timestamp") ? oMElement : DOMUtils.getLastElement(oMElement, string, "Timestamp");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestamp(OMElement, nsWsu) returns OMElement[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement getNonce(OMElement oMElement, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonce(OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsse[" + string + "])");
        }
        OMElement oMElement2 = null;
        oMElement2 = DOMUtils.equals(oMElement, string, "Nonce") ? oMElement : DOMUtils.getLastElement(oMElement, string, "Nonce");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonce(OMElement, String) returns OMElement[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement getChildTimestamp(OMElement oMElement, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestamp(OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsu[" + string + "])");
        }
        OMElement oMElement2 = DOMUtils.getOneChildElement(oMElement, string, "Timestamp");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestamp(OMElement, String) returns OMElement[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement getChildNonce(OMElement oMElement, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonce(OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsse[" + string + "])");
        }
        OMElement oMElement2 = DOMUtils.getOneChildElement(oMElement, string, "Nonce");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonce(OMElement parent, String nsWsse) returns OMElement[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement createTimestamp(OMFactory oMFactory, OMElement oMElement, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTimestamp(OMFactory factory[" + oMFactory + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsu[" + string + "]," + "String extType[" + string2 + "])");
        }
        String string3 = DOMUtils.getNamespacePrefix(oMElement, string);
        OMElement oMElement2 = null;
        if (string3 == null) {
            oMElement2 = oMFactory.createOMElement("Timestamp", string, "wsu");
            oMElement2.declareNamespace(string, "wsu");
        } else {
            oMElement2 = oMFactory.createOMElement("Timestamp", string, string3);
        }
        if ("wedsig".equals(string2) || "weenc".equals(string2)) {
            oMElement2.addAttribute("wasextention", string2, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTimestamp(OMFactory, OMElement, String, boolean) returns OMElement[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement addCreated(OMFactory oMFactory, OMElement oMElement, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCreated(OMFactory factory[" + oMFactory + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsu[" + string + "])");
        }
        boolean bl = false;
        String string2 = DOMUtils.getNamespacePrefix(oMElement, string);
        if (string2 == null) {
            bl = true;
            string2 = "wsu";
        }
        Date date = new Date();
        String string3 = UTC.format(date);
        OMElement oMElement2 = oMFactory.createOMElement("Created", string, string2);
        oMElement2.addChild(oMFactory.createOMText(string3));
        oMElement.addChild(oMElement2);
        if (bl) {
            oMElement2.declareNamespace(string, "wsu");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCreated(OMFactory, OMElement, String) returns OMElement[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement addExpires(OMFactory oMFactory, OMElement oMElement, Duration duration, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addExpires(OMFactory factory[" + oMFactory + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Duration duration[" + duration + "]," + "String nsWsu[" + string + "])");
        }
        boolean bl = false;
        String string2 = DOMUtils.getNamespacePrefix(oMElement, string);
        if (string2 == null) {
            bl = true;
            string2 = "wsu";
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        duration.addTo(calendar);
        String string3 = UTC.format(calendar.getTime());
        OMElement oMElement2 = oMFactory.createOMElement("Expires", string, string2);
        oMElement2.addChild(oMFactory.createOMText(string3));
        oMElement.addChild(oMElement2);
        if (bl) {
            oMElement2.declareNamespace(string, "wsu");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addExpires(OMFactory, OMElement, Duration, String) returns OMElement[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement addNonce(OMFactory oMFactory, OMElement oMElement, String string, NonceManager nonceManager, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonce(OMFactory factory[" + oMFactory + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsse[" + string + "]," + "NonceManager nmanager[" + nonceManager + "]," + "String extType[" + string2 + "])");
        }
        boolean bl = false;
        String string3 = DOMUtils.getNamespacePrefix(oMElement, string);
        if (string3 == null) {
            bl = true;
            string3 = "wsse";
        }
        OMElement oMElement2 = oMFactory.createOMElement("Nonce", string, string3);
        if (bl) {
            oMElement2.declareNamespace(string, "wsse");
        }
        if ("wedsig".equals(string2) || "weenc".equals(string2)) {
            oMElement2.addAttribute("wasextention", string2, null);
        }
        oMElement2.addChild(oMFactory.createOMText(NonceUtil.generateNonce(nonceManager)));
        oMElement.addChild(oMElement2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonce(OMFactory, OMElement, String, NonceManager, String) returns OMElement[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static String generateNonce(NonceManager nonceManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateNonce(NonceManager nmanager[" + nonceManager + "])");
        }
        byte[] byArray = nonceManager.generate();
        String string = Base64.encode(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateNonce(NonceManager) returns String[" + string + "]");
        }
        return string;
    }

    public static void checkNonce(OMElement oMElement, String string, NonceManager nonceManager) throws SoapSecurityException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNonce(OMElement element[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsse[" + string + "]," + "NonceManager nmanager[" + nonceManager + "])");
        }
        if (oMElement == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s06");
        }
        String string3 = oMElement.getLocalName();
        String string4 = string2 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getNamespaceURI();
        if (!string.equals(string2) || !"Nonce".equals(string3)) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(oMElement));
        }
        QName qName = Constants.BASE64_BINARY;
        String string5 = oMElement.getAttributeValue(ENCODINGTYPE_Q);
        if (string5 != null) {
            qName = DOMUtils.getQName(oMElement, string5);
        }
        string5 = DOMUtils.getStringValue(oMElement);
        byte[] byArray = null;
        if (Constants.BASE64_BINARY.equals(qName)) {
            byArray = Base64.decode(string5);
        } else if (Constants.HEX_BINARY.equals(qName)) {
            try {
                byArray = Hex.decode(string5);
            }
            catch (ParseException parseException) {
                Tr.processException(parseException, clsName + ".checkNonce", "371");
                throw SoapSecurityException.format("security.wssecurity.NonceUtil.s01", parseException);
            }
        }
        if (!nonceManager.validate(byArray)) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s02");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNonce(OMElement, String, NonceManager)");
        }
    }

    public static void checkTimestamp(OMNode oMNode, String string, int n, int n2, boolean bl) throws SoapSecurityException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTimestamp(OMNode node[" + DOMUtils.getDisplayName(oMNode) + "]," + "String nsWsu[" + string + "]," + "int maxAge[" + n + "]," + "int clockSkew[" + n2 + "]," + "boolean logError[" + bl + "])");
        }
        if (oMNode == null || oMNode.getType() != 1) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s07");
        }
        OMElement oMElement = (OMElement)oMNode;
        String string3 = oMElement.getLocalName();
        String string4 = string2 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getNamespaceURI();
        if (!string.equals(string2) || !"Timestamp".equals(string3)) {
            if (bl) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s03", new Object[]{DOMUtils.getQualifiedName(oMNode)});
            }
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(oMNode));
        }
        Date date = null;
        Date date2 = null;
        try {
            OMElement oMElement2;
            OMElement oMElement3 = DOMUtils.getFirstElement(oMElement, string, "Created");
            if (oMElement3 != null) {
                NonceUtil.checkType(oMElement3);
                date = UTC.parse(DOMUtils.getStringValue(oMElement3));
            }
            if ((oMElement2 = DOMUtils.getFirstElement(oMElement, string, "Expires")) != null) {
                NonceUtil.checkType(oMElement2);
                date2 = UTC.parse(DOMUtils.getStringValue(oMElement2));
            }
        }
        catch (ParseException parseException) {
            Tr.processException(parseException, clsName + ".checkTimestamp", "437");
            if (bl) {
                Tr.error(tc, "security.wssecurity.NonceUtil.s03", new Object[]{parseException});
            }
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s03", parseException);
        }
        long l = System.currentTimeMillis();
        Date date3 = new Date(l);
        if (date2 != null && date3.after(date2)) {
            String string5 = date != null ? date.toString() : "";
            String string6 = date2 != null ? date2.toString() : "";
            String string7 = date3.toString();
            if (bl) {
                Tr.error(tc, "security.wssecurity.NonceUtil.s04", new Object[]{string5, string6, string7});
            }
            throw SoapSecurityException.format(Constants.MESSAGE_EXPIRED, "security.wssecurity.NonceUtil.s04", new String[]{string5, string6, string7});
        }
        if (date != null) {
            Long l2 = new Long(l);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current time = " + l + " ms");
            }
            if (n < 0) {
                n = 300;
            }
            long l3 = n * 1000;
            long l4 = l - l3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Max age = " + l3 + " ms, (current - max age) = " + l4 + " ms");
            }
            if (n2 < 0) {
                n2 = 0;
            }
            long l5 = n2 * 1000;
            l4 -= l5;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clock skew = " + l5 + " ms, (current - clock skew) = " + l4 + " ms");
            }
            long l6 = date.getTime();
            Long l7 = new Long(l6);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created time (timestamp) = " + l6 + " ms");
            }
            if (l6 < l4) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Timestamp is not fresh, creation timestamp " + UTC.format(date) + " too old");
                }
                String string8 = "security.wssecurity.WSEC5205E";
                String string9 = "security.wssecurity.WSEC5206E";
                Tr.error(tc, string9, new Object[]{l2.toString(), l7.toString()});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, string8);
            }
            if (l5 < 90000L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Clock skew increased to 90000ms for forward timestamp check.");
                }
                l5 = 90000L;
            }
            long l8 = l + l5;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clock skew = " + l5 + " ms, (current + clock skew) = " + l8 + " ms");
            }
            if (l6 > l8) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Timestamp is not valid, creation timestamp " + UTC.format(date) + " too far in future");
                }
                String string10 = "security.wssecurity.WSEC5208E";
                String string11 = "security.wssecurity.WSEC5206E";
                Tr.error(tc, string11, new Object[]{l2.toString(), l7.toString()});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, string10);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Timestamp is fresh");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTimestamp(OMNode, String, int, int, boolean)");
        }
    }

    private static void checkType(OMElement oMElement) throws SoapSecurityException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkType(OMElement timestamp[" + DOMUtils.getDisplayName(oMElement) + "])");
        }
        if ((string = oMElement.getAttributeValue(VALUETYPE_Q)) != null && string.length() > 0) {
            if (string.startsWith(HTTP_STR)) {
                if (!string.equals(Constants.XSD_DATETIME)) {
                    throw SoapSecurityException.format("security.wssecurity.NonceUtil.s05", string, Constants.XSD_DATETIME);
                }
            } else {
                QName qName = DOMUtils.getQName(oMElement, string);
                if (!qName.equals(Constants.DATETIME)) {
                    throw SoapSecurityException.format("security.wssecurity.NonceUtil.s05", qName.toString(), Constants.DATETIME.toString());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkType(OMElement)");
        }
    }

    public static boolean isNonceFirst(OMElement oMElement, OMElement oMElement2, OMElement oMElement3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNonceFirst(OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "OMElement nonce[" + DOMUtils.getDisplayName(oMElement2) + "]," + "OMElement timestamp[" + DOMUtils.getDisplayName(oMElement3) + "])");
        }
        boolean bl = false;
        if (oMElement2 != null) {
            if (oMElement3 == null) {
                bl = true;
            } else {
                OMElement oMElement4 = DOMUtils.getFirstElement(oMElement);
                while (oMElement4 != null) {
                    if (oMElement4.equals(oMElement2)) {
                        bl = true;
                        break;
                    }
                    if (oMElement4.equals(oMElement3)) break;
                    oMElement4 = DOMUtils.getNextElement(oMElement4);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNonceFirst(OMElement, OMElement, OMElement) return boolean[" + bl + "]");
        }
        return bl;
    }

    public static Date checkNonceTimestamp(OMElement oMElement, String string, int n, int n2) throws SoapSecurityException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNonceTimestamp(OMElement element[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsu[" + string + "]," + "int maxAge[" + n + "]," + "int clockSkew[" + n2 + "])");
        }
        if (oMElement == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s08");
        }
        String string3 = oMElement.getLocalName();
        String string4 = string2 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getNamespaceURI();
        if (!string.equals(string2) || !"Created".equals(string3)) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(oMElement));
        }
        Date date = null;
        try {
            NonceUtil.checkType(oMElement);
            date = UTC.parse(DOMUtils.getStringValue(oMElement));
        }
        catch (ParseException parseException) {
            Tr.processException(parseException, clsName + ".checkNonceTimestamp", "626");
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s03", parseException);
        }
        long l = System.currentTimeMillis();
        Date date2 = new Date(l);
        Long l2 = new Long(l);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current time = " + l + " ms");
        }
        if (n < 0) {
            n = 300;
        }
        long l3 = n * 1000;
        long l4 = l - l3;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce max age = " + l3 + " ms, (current - Nonce max age) = " + l4 + " ms");
        }
        if (n2 < 0) {
            n2 = 0;
        }
        long l5 = n2 * 1000;
        l4 -= l5;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce clock skew = " + l5 + " ms, (current - Nonce clock skew) = " + l4 + " ms");
        }
        long l6 = date.getTime();
        Long l7 = new Long(l6);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce created time (timestamp) = " + l6 + " ms");
        }
        if (l6 < l4) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce timestamp is not fresh, creation timestamp " + UTC.format(date) + " too old");
            }
            String string5 = "security.wssecurity.WSEC5193E";
            String string6 = "security.wssecurity.WSEC5200E";
            Tr.error(tc, string6, new Object[]{l2.toString(), l7.toString()});
            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, string5);
        }
        if (l5 < 90000L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clock skew increased to 90000ms for forward timestamp check.");
            }
            l5 = 90000L;
        }
        long l8 = l + l5;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Clock skew = " + l5 + " ms, (current + clock skew) = " + l8 + " ms");
        }
        if (l6 > l8) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce timestamp is not valid, creation timestamp " + UTC.format(date) + " too far in advance");
            }
            String string7 = "security.wssecurity.WSEC5209E";
            String string8 = "security.wssecurity.WSEC5200E";
            Tr.error(tc, string8, new Object[]{l2.toString(), l7.toString()});
            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, string7);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce Timestamp is fresh");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNonceTimestamp(OMElement, String, int, int) returns Date[" + date + "]");
        }
        return date;
    }
}

