/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;

public class NamespaceUtil {
    private static final String comp = "security.wssecurity";
    private static final String clsName = NamespaceUtil.class.getName();

    public static int checkSoapVersion(OMNode oMNode, int n, String string) {
        if (oMNode.getType() != 1) {
            return -1;
        }
        OMElement oMElement = (OMElement)oMNode;
        return NamespaceUtil.checkVersion(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName(), oMElement.getLocalName(), 2, n, string);
    }

    public static int checkWsseVersion(OMNode oMNode, int n, String string) {
        if (oMNode.getType() != 1) {
            return -1;
        }
        OMElement oMElement = (OMElement)oMNode;
        return NamespaceUtil.checkVersion(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName(), oMElement.getLocalName(), 0, n, string);
    }

    public static int checkWsuVersion(OMNode oMNode, int n, String string) {
        if (oMNode.getType() != 1) {
            return -1;
        }
        OMElement oMElement = (OMElement)oMNode;
        return NamespaceUtil.checkVersion(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName(), oMElement.getLocalName(), 1, n, string);
    }

    public static int checkWsseVersion(QName qName, int n, String string) {
        return NamespaceUtil.checkVersion(qName.getNamespaceURI(), qName.getLocalPart(), 0, n, string);
    }

    public static int checkWsuVersion(QName qName, int n, String string) {
        return NamespaceUtil.checkVersion(qName.getNamespaceURI(), qName.getLocalPart(), 1, n, string);
    }

    private static int checkVersion(String string, String string2, int n, int n2, String string3) {
        if (string2 == null || string3 == null) {
            return -1;
        }
        if (!string2.equals(string3)) {
            return -1;
        }
        int n3 = NamespaceUtil.compareNS(string, n);
        if (n2 >= 0) {
            if (n3 == n2) {
                return n2;
            }
        } else if (n3 >= 0) {
            return n3;
        }
        return -1;
    }

    public static int isSoap(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals(Constants.NS_SOAP)) {
            return 0;
        }
        return string.equals(Constants.NS_SOAP12) ? 1 : -1;
    }

    public static int isWsse(String string) {
        if (string == null) {
            return -1;
        }
        return string.equals(Constants.NS_WSSE) ? 0 : -1;
    }

    public static int isWsu(String string) {
        if (string == null) {
            return -1;
        }
        return string.equals(Constants.NS_WSU) ? 0 : -1;
    }

    private static final int compareNS(String string, int n) {
        for (int i = 0; i < Constants.NAMESPACES[n].length; ++i) {
            if (string != Constants.NAMESPACES[n][i]) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList getWsseElementsByTagName(OMElement oMElement, String string) {
        return NamespaceUtil.getXElementsByTagName(oMElement, string, 0);
    }

    private static ArrayList getXElementsByTagName(OMElement oMElement, String string, int n) {
        ArrayList arrayList = null;
        for (int i = 0; i < Constants.NAMESPACES[n].length; ++i) {
            arrayList = DOMUtil.getElementsByTagNameNS(oMElement, Constants.NAMESPACES[n][i], string);
            if (arrayList == null || arrayList.size() <= 0) continue;
            return arrayList;
        }
        return arrayList;
    }

    public static ArrayList getWsuElementsByTagName(OMElement oMElement, String string) {
        return NamespaceUtil.getXElementsByTagName(oMElement, string, 1);
    }

    public static OMElement getFirstWsseElement(OMElement oMElement, String string) {
        OMElement oMElement2 = null;
        for (int i = 0; i < Constants.NAMESPACES[0].length; ++i) {
            oMElement2 = DOMUtils.getFirstElement(oMElement, Constants.NAMESPACES[0][i], string);
            if (oMElement2 == null) continue;
            return oMElement2;
        }
        return oMElement2;
    }

    public static OMElement getFirstWsuElement(OMElement oMElement, String string) {
        OMElement oMElement2 = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            oMElement2 = DOMUtils.getFirstElement(oMElement, Constants.NAMESPACES[1][i], string);
            if (oMElement2 == null) continue;
            return oMElement2;
        }
        return oMElement2;
    }

    public static SOAPHeaderBlock getWsseHeaderByName(SOAPEnvelope sOAPEnvelope, String string, String string2) {
        return NamespaceUtil.getHeaderByName(sOAPEnvelope, string, string2, 0);
    }

    public static SOAPHeaderBlock getWsuHeaderByName(SOAPEnvelope sOAPEnvelope, String string, String string2) {
        return NamespaceUtil.getHeaderByName(sOAPEnvelope, string, string2, 1);
    }

    private static SOAPHeaderBlock getHeaderByName(SOAPEnvelope sOAPEnvelope, String string, String string2, int n) {
        SOAPHeaderBlock sOAPHeaderBlock = null;
        for (int i = 0; i < Constants.NAMESPACES[n].length && (sOAPHeaderBlock = NamespaceUtil.getHeaderByName(sOAPEnvelope, string, Constants.NAMESPACES[n][i], string2)) == null; ++i) {
        }
        return sOAPHeaderBlock;
    }

    private static SOAPHeaderBlock getHeaderByName(SOAPEnvelope sOAPEnvelope, String string, String string2, String string3) {
        SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
        Iterator iterator = sOAPHeader.examineHeaderBlocks(string);
        SOAPHeaderBlock sOAPHeaderBlock = null;
        while (iterator.hasNext()) {
            SOAPHeaderBlock sOAPHeaderBlock2 = (SOAPHeaderBlock)iterator.next();
            if (!sOAPHeaderBlock2.getLocalName().equals(string3) || !sOAPHeaderBlock2.getNamespace().getName().equals(string2)) continue;
            sOAPHeaderBlock = sOAPHeaderBlock2;
            break;
        }
        return sOAPHeaderBlock;
    }

    public static String getWsuAttribute(OMElement oMElement, String string) {
        String string2 = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            string2 = oMElement.getAttributeValue(new QName(Constants.NAMESPACES[1][i], string));
            if (string2.length() == 0) continue;
            return string2;
        }
        return string2;
    }

    public static int checkVersion(QName qName, QName qName2) {
        String string;
        if (qName == null || qName2 == null) {
            return -1;
        }
        String string2 = qName.getLocalPart();
        if (string2 != (string = qName2.getLocalPart())) {
            return -1;
        }
        String string3 = qName.getNamespaceURI();
        String string4 = qName2.getNamespaceURI();
        if (string4 == Constants.NAMESPACES[0][0]) {
            return NamespaceUtil.compareNS(string3, 0);
        }
        if (string4 == Constants.NAMESPACES[1][0]) {
            return NamespaceUtil.compareNS(string3, 1);
        }
        return -1;
    }

    public static boolean equals(QName qName, QName qName2) {
        if (qName == null || qName2 == null) {
            return false;
        }
        if (qName.equals(qName2)) {
            return true;
        }
        return NamespaceUtil.checkVersion(qName, qName2) > 0;
    }
}

