/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Request;
import com.ibm.ws.wssecurity.common.RequestPool;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.time.TimestampRequest;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.wssapi.OMStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegralDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(IntegralDialectElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final QName URI_Q = new QName("", "URI");
    public static final String EXIST_STRTRANSFORM = "security.wssecurity.integraldialectelementselector.existstrtransform";
    public static final int BODY = 0;
    public static final int TIMESTAMP = 1;
    public static final int SECURITYTOKEN = 2;
    public static final int DSIGKEY = 3;
    public static final int ENCKEY = 4;
    public static final int MESSAGEID = 5;
    public static final int TO = 6;
    public static final int ACTION = 7;
    public static final int RELATESTO = 8;
    public static final int WSCONTEXT = 9;
    public static final int WSA_FROM = 10;
    public static final int WSA_REPLYTO = 11;
    public static final int WSA_FAULTTO = 12;
    public static final int WSA_ALL = 13;
    public static final String[] WASDIALECTS = new String[]{"body".intern(), "timestamp".intern(), "securitytoken".intern(), "dsigkey".intern(), "enckey".intern(), "messageid".intern(), "to".intern(), "action".intern(), "relatesto".intern(), "wscontext".intern(), "wsafrom".intern(), "wsareplyto".intern(), "wsafaultto".intern(), "wsaall".intern()};
    private static final String[] WSAELEMENTS = new String[]{"MessageID".intern(), "To".intern(), "Action".intern(), "RelatesTo".intern(), "From".intern(), "ReplyTo".intern(), "FaultTo".intern()};

    @Override
    public void init(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + DOMUtils.getDisplayName(oMNode) + "], Map context)");
        }
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String string = (String)map.get("com.ibm.ws.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + string + "]");
        }
        if (string == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s01");
        }
        if (!Constants.DIALECT_WAS.equals(string)) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string);
        }
        String string2 = (String)map.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keyword [" + string2 + "]");
        }
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object object = map.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean bl = "signature_mode".equals((String)object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + object + "]");
        }
        String string3 = (String)map.get("com.ibm.ws.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + string3 + "]");
        }
        Object[] objectArray = (Object[])map.get("com.ibm.ws.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + objectArray + "]");
        }
        Collection collection = (Collection)map.get("com.ibm.ws.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token generator configs [" + collection + "]");
        }
        boolean bl2 = ConfigUtil.isTrue((String)map.get(EXIST_STRTRANSFORM));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "STR-Transform exists [" + bl2 + "]");
        }
        IDResolver iDResolver = (IDResolver)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ID resolver [" + iDResolver + "]");
        }
        NonceManager nonceManager = (NonceManager)map.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        object = map.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int n = 0;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string4 = Constants.NAMESPACES[2][n];
        object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        n = 0;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string5 = Constants.NAMESPACES[0][n];
        String string6 = Constants.NAMESPACES[1][n];
        OMDocument oMDocument = DOMUtil.getOwnerDocument(oMNode);
        OMElement oMElement = oMDocument.getOMDocumentElement();
        ArrayList<Object> arrayList = null;
        if (WASDIALECTS[0].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[0] + "]");
            }
            arrayList = new ArrayList();
            OMElement oMElement2 = null;
            try {
                oMElement2 = DOMUtils.getOneChildElement(oMElement, string4, "Body");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception from SOAPEnvelope.getBody()" + exception);
                }
                Tr.processException((Throwable)exception, this.getClass().getName() + ".getElements", "%C", this);
                throw new SoapSecurityException(exception);
            }
            arrayList.add(oMElement2);
        } else if (WASDIALECTS[1].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[1] + "]");
            }
            arrayList = bl ? IntegralDialectElementSelector.getTimestampForSignature(map) : IntegralDialectElementSelector.getTimestampForVerification(oMDocument, string6, map);
        } else if (WASDIALECTS[2].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[2] + "]");
            }
            arrayList = null;
            SecurityTokenManagerImpl securityTokenManagerImpl = (SecurityTokenManagerImpl)map.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            arrayList = bl ? IntegralDialectElementSelector.getTokensForSignature(collection, securityTokenManagerImpl, map) : IntegralDialectElementSelector.getTokensForVerification(collection, securityTokenManagerImpl, map);
        } else if (WASDIALECTS[3].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[3] + "]");
            }
            arrayList = IntegralDialectElementSelector.getDsigKeyObjects(oMDocument, map, bl2, iDResolver, string5);
        } else if (WASDIALECTS[4].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[4] + "]");
            }
            arrayList = IntegralDialectElementSelector.getEncKeyObjects(oMDocument, map, bl2, iDResolver, string5);
        } else if (WASDIALECTS[5].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[5] + "]");
            }
            arrayList = this.getWSAElement(map, oMDocument, "MessageID");
        } else if (WASDIALECTS[6].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[6] + "]");
            }
            arrayList = this.getWSAElement(map, oMDocument, "To");
        } else if (WASDIALECTS[7].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[7] + "]");
            }
            arrayList = this.getWSAElement(map, oMDocument, "Action");
        } else if (WASDIALECTS[8].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[8] + "]");
            }
            arrayList = this.getWSAElement(map, oMDocument, "RelatesTo");
        } else if (WASDIALECTS[9].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[9] + "]");
            }
            arrayList = IntegralDialectElementSelector.getWSContextHeaderElement(oMDocument);
        } else if (WASDIALECTS[10].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[10] + "]");
            }
            arrayList = this.getWSAElement(map, oMDocument, "From");
        } else if (WASDIALECTS[11].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[11] + "]");
            }
            arrayList = this.getWSAElement(map, oMDocument, "ReplyTo");
        } else if (WASDIALECTS[12].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[12] + "]");
            }
            arrayList = this.getWSAElement(map, oMDocument, "FaultTo");
        } else if (WASDIALECTS[13].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[13] + "]");
            }
            arrayList = this.getWSAAllElements(map, oMDocument);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s03", string2);
        }
        if (string3 != null && bl) {
            arrayList = IntegralDialectElementSelector.postprocess(oMDocument, string3, arrayList, objectArray, string5, string6, nonceManager, bl, false, string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode, Map)");
        }
        return arrayList;
    }

    public static ArrayList<OMNode> postprocess(OMDocument oMDocument, String string, ArrayList<OMNode> arrayList, Object[] objectArray, String string2, String string3, NonceManager nonceManager, boolean bl, boolean bl2, String string4, String string5) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postprocess(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "String type[" + string + "]," + "ArrayList list," + "Object[] elements," + "String nsWsse[" + string2 + "]," + "String nsWsu[" + string3 + "]," + "NoceManager nmanager," + "boolean signature[" + bl + "]," + "boolean encryption[" + bl2 + "]," + "String dialect[" + string4 + "]," + "String keyword[" + string5 + "])");
        }
        PartList partList = new ArrayList();
        String string6 = bl2 ? "weenc" : "wedsig";
        for (int i = 0; i < arrayList.size(); ++i) {
            OMElement oMElement = null;
            OMElement oMElement2 = (OMElement)arrayList.get(i);
            if ("timestamp".equals(string)) {
                oMElement = NonceUtil.getTimestamp(oMElement2, string3);
                if (oMElement == null) {
                    OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
                    oMElement = NonceUtil.createTimestamp(oMFactory, oMElement2, string3, string6);
                    oMElement2.addChild(oMElement);
                    NonceUtil.addCreated(oMFactory, oMElement, string3);
                }
            } else if ("nonce".equals(string) && (oMElement = NonceUtil.getNonce(oMElement2, string2)) == null) {
                oMElement = NonceUtil.addNonce(oMDocument.getOMDocumentElement().getOMFactory(), oMElement2, string2, nonceManager, string6);
            }
            if (objectArray == null) continue;
            boolean bl3 = false;
            for (int j = 0; j < objectArray.length; ++j) {
                if (!DOMUtils.equals((OMNode)objectArray[j], oMElement2)) continue;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added the element [" + DOMUtils.getDisplayName(oMElement2) + "]");
            }
            ((ArrayList)partList).add(oMElement2);
        }
        if (bl2) {
            partList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", partList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postprocess(OMDocument, String, ArrayList, Object[],Duration, String, String, NoceManager,boolean, boolean, String, String) returns NodeList[" + partList + "]");
        }
        return partList;
    }

    private static ArrayList<OMNode> getTimestampForSignature(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestmapForSignature(Map context)");
        }
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        Request[] requestArray = RequestPool.get(map, TimestampRequest.class);
        if (requestArray != null && requestArray.length > 0) {
            for (int i = 0; i < requestArray.length; ++i) {
                RequestMessagePool.EncryptedObject encryptedObject;
                TimestampRequest timestampRequest = (TimestampRequest)requestArray[i];
                if (!timestampRequest.isSigned()) continue;
                OMElement oMElement = timestampRequest.getElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the element [" + DOMUtils.getDisplayName(oMElement) + "].");
                }
                if ((encryptedObject = RequestMessagePool.convertElement(map, oMElement, -1)) == null) {
                    arrayList.add(oMElement);
                    continue;
                }
                if (encryptedObject.getEncryptedData() != null) {
                    arrayList.add(encryptedObject.getEncryptedData());
                }
                if (encryptedObject.getHeaderInfo() == null) continue;
                arrayList.add(encryptedObject.getHeaderInfo());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestmapForSignature(Map)");
        }
        return arrayList;
    }

    private static ArrayList<OMNode> getTimestampForVerification(OMDocument oMDocument, String string, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestampForVerification(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "String nsWsu[" + string + "]," + "Map context)");
        }
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        ArrayList arrayList2 = null;
        OMElement oMElement = IntegralDialectElementSelector.getSecurityHeader(map, oMDocument);
        if (oMElement != null) {
            arrayList2 = DOMUtils.getElementsByTagNameNS(oMElement, string, "Timestamp");
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                OMElement oMElement2 = (OMElement)arrayList2.get(i);
                String string2 = oMElement2.getAttributeValue(Constants.WAS_EXTENTION_Q);
                if (string2 != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the timestamp element without WAS extention [" + oMElement2 + "]");
                }
                arrayList.add(oMElement2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestampForVerification(OMDocument, String nsWsu, Map) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    private static ArrayList<OMNode> getTokensForSignature(Collection<TokenGeneratorConfig> collection, SecurityTokenManagerImpl securityTokenManagerImpl, Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokensForSignature(Set configs,SecurityTokenManagerImpl securityTokenManager,Map context)");
        }
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        Collection<SecurityTokenWrapper> collection2 = securityTokenManagerImpl.getTokenWrappers();
        for (TokenGeneratorConfig tokenGeneratorConfig : collection) {
            if (!tokenGeneratorConfig.isStandAlone()) continue;
            for (SecurityTokenWrapper securityTokenWrapper : collection2) {
                if (tokenGeneratorConfig.hashCode() != securityTokenWrapper.getUsedTokenGeneratorHash() || securityTokenWrapper.isReferenced()) continue;
                OMStructure oMStructure = (OMStructure)securityTokenWrapper.getXML();
                OMElement oMElement = null;
                if (oMStructure != null) {
                    oMElement = oMStructure.getNode();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the token element [" + DOMUtils.getDisplayName(oMElement) + "]");
                }
                if (oMElement == null) continue;
                RequestMessagePool.EncryptedObject encryptedObject = RequestMessagePool.convertElement(map, oMElement, -1);
                if (encryptedObject == null) {
                    arrayList.add(oMElement);
                    continue;
                }
                if (encryptedObject.getEncryptedData() != null) {
                    arrayList.add(encryptedObject.getEncryptedData());
                }
                if (encryptedObject.getHeaderInfo() == null) continue;
                arrayList.add(encryptedObject.getHeaderInfo());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokensForSignature(Set, SecurityTokenManagerImpl, Map) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    private static ArrayList<OMNode> getTokensForVerification(Collection<TokenGeneratorConfig> collection, SecurityTokenManagerImpl securityTokenManagerImpl, Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokensForVerification(Set configs,SecurityTokenManagerImpl securityTokenManager,Map context)");
        }
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        if (collection != null) {
            Collection<SecurityTokenWrapper> collection2 = securityTokenManagerImpl.getTokenWrappers();
            for (TokenConsumerConfig tokenConsumerConfig : collection) {
                if (tokenConsumerConfig.isUsedForVerification() || tokenConsumerConfig.isUsedForDecryption()) continue;
                for (SecurityTokenWrapper securityTokenWrapper : collection2) {
                    if (tokenConsumerConfig.hashCode() != securityTokenWrapper.getUsedTokenConsumerHash() || securityTokenWrapper.isReferenced()) continue;
                    OMStructure oMStructure = (OMStructure)securityTokenWrapper.getXML();
                    OMElement oMElement = null;
                    if (oMStructure != null) {
                        oMElement = oMStructure.getNode();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added the token element [" + DOMUtils.getDisplayName(oMElement) + "]");
                    }
                    if (oMElement == null) continue;
                    arrayList.add(oMElement);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokensForVerification(Set, SecurityTokenManagerImpl, Map) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    public static ArrayList<OMNode> getHeaderElement(OMDocument oMDocument, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeaderElement(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "String ns[" + string + "]," + "String ln[" + string2 + "])");
        }
        ArrayList arrayList = null;
        OMElement oMElement = WSSGenerator.getHeader(oMDocument, false);
        if (oMElement != null) {
            arrayList = DOMUtils.getElementsByTagNameNS(oMElement, string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHeaderElement(OMDocument, String, String) returns NodeList[" + arrayList + "]");
        }
        return arrayList;
    }

    private static ArrayList<OMNode> getDsigKeyObjects(OMDocument oMDocument, Map<Object, Object> map, boolean bl, IDResolver iDResolver, String string) throws SoapSecurityException {
        ArrayList<OMNode> arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDsigKeyObjects(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Map context," + "boolean existSTRTransform[" + bl + "]," + "IDResolver idResolver," + "String nsWsse[" + string + "])");
        }
        ArrayList<OMNode> arrayList2 = new ArrayList<OMNode>();
        OMElement oMElement = IntegralDialectElementSelector.getSecurityHeader(map, oMDocument);
        if (oMElement != null && (arrayList = DOMUtils.getChildElements(oMElement, Constants.NS_DSIG, "Signature")) != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ArrayList<OMNode> arrayList3 = IntegralDialectElementSelector.getKeyObjects(oMDocument, (OMElement)arrayList.get(i), bl, iDResolver, string);
                if (arrayList3.size() <= 0) continue;
                for (int j = 0; j < arrayList3.size(); ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added the key objects in the Signature element [" + DOMUtils.getDisplayName(arrayList3.get(j)) + "]");
                    }
                    arrayList2.add((OMElement)arrayList3.get(j));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDsigKeyObjects(OMDocument, Map, boolean, IDResolver, String) returns ArrayList[" + arrayList2 + "]");
        }
        return arrayList2;
    }

    private static ArrayList<OMNode> getEncKeyObjects(OMDocument oMDocument, Map<Object, Object> map, boolean bl, IDResolver iDResolver, String string) throws SoapSecurityException {
        int n;
        ArrayList<OMNode> arrayList;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncKeyObjects(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Map context," + "boolean existSTRTransform[" + bl + "]," + "IDResolver idResolver," + "String nsWsse[" + string + "])");
        }
        ArrayList<OMNode> arrayList2 = new ArrayList<OMNode>();
        OMElement oMElement = IntegralDialectElementSelector.getSecurityHeader(map, oMDocument);
        ArrayList arrayList3 = null;
        if (oMElement != null && (arrayList3 = DOMUtils.getChildElements(oMElement, Constants.NS_ENC, "EncryptedKey")) != null && arrayList3.size() > 0) {
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                arrayList = IntegralDialectElementSelector.getKeyObjects(oMDocument, (OMElement)arrayList3.get(n2), bl, iDResolver, string);
                if (arrayList.size() <= 0) continue;
                for (n = 0; n < arrayList.size(); ++n) {
                    arrayList2.add((OMElement)arrayList.get(n));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the key objects in the EncryptedKey element [" + DOMUtils.getDisplayName(arrayList.get(n)) + "]");
                }
            }
        }
        if ((arrayList3 = DOMUtils.getElementsByTagNameNS(oMDocument.getOMDocumentElement(), Constants.NS_ENC, "EncryptedData")) != null && arrayList3.size() > 0) {
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                arrayList = IntegralDialectElementSelector.getKeyObjects(oMDocument, (OMElement)arrayList3.get(n2), bl, iDResolver, string);
                if (arrayList.size() <= 0) continue;
                for (n = 0; n < arrayList.size(); ++n) {
                    arrayList2.add((OMElement)arrayList.get(n));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the key objects in the EncryptedData element [" + DOMUtils.getDisplayName(arrayList.get(n)) + "]");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncKeyObjects(OMDocument, Map, boolean, IDResolver, String) returns ArrayList[" + arrayList2 + "]");
        }
        return arrayList2;
    }

    private static ArrayList<OMNode> getKeyObjects(OMDocument oMDocument, OMElement oMElement, boolean bl, IDResolver iDResolver, String string) throws SoapSecurityException {
        String string2;
        OMElement oMElement2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyObjects(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "boolean existSTRTransform[" + bl + "]," + "IDResolver idResolver," + "String nsWsse[" + string + "])");
        }
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        OMElement oMElement3 = DOMUtils.getZeroOrOneElement(oMElement, Constants.NS_DSIG, "KeyInfo");
        if (oMElement3 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added the element in the KeyInfo element [" + DOMUtils.getDisplayName(oMElement3) + "]");
            }
            arrayList.add(oMElement3);
        }
        if (!bl && (oMElement2 = DOMUtils.getFirstElement(oMElement3, string, "SecurityTokenReference")) != null && (oMElement2 = DOMUtils.getFirstElement(oMElement2, string, "Reference")) != null && (string2 = oMElement2.getAttributeValue(URI_Q)) != null) {
            if (string2.length() < 2 || string2.charAt(0) != '#') {
                throw new RuntimeException("Unsupported type of URI: " + string2);
            }
            oMElement2 = iDResolver.resolveID(oMDocument, string2.substring(1));
            if (oMElement2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the referenced element [" + DOMUtils.getDisplayName(oMElement2) + "]");
                }
                arrayList.add(oMElement2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyObjects(OMDocument, OMElement, boolean, IDResolver, String) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    static ArrayList<OMNode> getWSContextHeaderElement(OMDocument oMDocument) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSContextHeaderElement(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "])");
        }
        ArrayList<OMNode> arrayList = null;
        OMElement oMElement = WSSGenerator.getHeader(oMDocument, false);
        if (oMElement != null) {
            arrayList = DOMUtils.getChildElements(oMElement, Constants.NS_WSCTX_V1, "Context");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSContextHeaderElement(OMDocument) returns NodeList[" + arrayList + "]");
        }
        return arrayList;
    }

    private final ArrayList<OMNode> getWSAElement(Map<Object, Object> map, OMDocument oMDocument, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSAElement(Map context, OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "], String [" + string + "])");
        }
        ArrayList<OMNode> arrayList = null;
        boolean bl = IntegralDialectElementSelector.isGenerator(map);
        MessageContext messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        OMElement oMElement = WSSGenerator.getHeader(oMDocument, false);
        if (oMElement != null) {
            if (bl) {
                String string2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting the element for [" + string + "] for generator");
                }
                if ((string2 = (String)messageContext.getProperty("WSAddressingVersion")) == null || string2.length() == 0) {
                    string2 = Constants.NS_WSADDRS[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No outbound namespace defined for WS-Address, default [" + string2 + "] is used.");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Namespace for WS-Addressing outbound request [" + string2 + "].");
                }
                arrayList = DOMUtils.getChildElements(oMElement, string2, string);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting the element for [" + string + "] for consumer");
                }
                boolean bl2 = false;
                String string3 = null;
                for (int i = 0; i < Constants.NS_WSADDRS.length; ++i) {
                    arrayList = DOMUtils.getChildElements(oMElement, Constants.NS_WSADDRS[i], string);
                    if (arrayList == null || arrayList.size() == 0) continue;
                    string3 = Constants.NS_WSADDRS[i];
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    String string4 = (String)messageContext.getProperty("WSAddressingVersion");
                    if (string4 == null || string4.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No inbound WS-Addressing namespace is set, setting it to [" + string3 + "].");
                        }
                        messageContext.setProperty("WSAddressingVersion", string3);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Inbound WS-Addressing namespace was set to [" + string4 + "] and namespace found [" + string3 + "].");
                        }
                        if (!string4.equals(string3)) {
                            throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No SOAP header");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSAElement(Map, OMDocument, String) returns " + this.toString(arrayList));
        }
        return arrayList;
    }

    private final ArrayList<OMNode> getWSAAllElements(Map<Object, Object> map, OMDocument oMDocument) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSAAllElements(Map context, OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "])");
        }
        boolean bl = IntegralDialectElementSelector.isGenerator(map);
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        MessageContext messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        OMElement oMElement = WSSGenerator.getHeader(oMDocument, false);
        if (oMElement != null) {
            if (bl) {
                String string;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting all WSA elements for generator");
                }
                if ((string = (String)messageContext.getProperty("WSAddressingVersion")) == null || string.length() == 0) {
                    string = Constants.NS_WSADDRS[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No outbound namespace defined for WS-Address, default [" + string + "] is used.");
                    }
                }
                arrayList = this.getWSAAllElements(oMElement, string, WSAELEMENTS);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting all WSA elements for consumer");
                }
                boolean bl2 = false;
                String string = null;
                for (int i = 0; i < Constants.NS_WSADDRS.length; ++i) {
                    arrayList = this.getWSAAllElements(oMElement, Constants.NS_WSADDRS[i], WSAELEMENTS);
                    if (arrayList == null || arrayList.size() == 0) continue;
                    string = Constants.NS_WSADDRS[i];
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    String string2 = (String)messageContext.getProperty("WSAddressingVersion");
                    if (string2 == null || string2.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No inbound WS-Addressing namespace is set, setting it to [" + string + "].");
                        }
                        messageContext.setProperty("WSAddressingVersion", string);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Inbound WS-Addressing namespace was set to [" + string2 + "] and namespace found [" + string + "].");
                        }
                        if (!string2.equals(string)) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getWSAElement(Map context, Document doc, String elementName)");
                            }
                            throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No SOAP header");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSAAllElements(Map, OMDocument) returns " + this.toString(arrayList));
        }
        return arrayList;
    }

    private final ArrayList<OMNode> getWSAAllElements(OMContainer oMContainer, String string, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getWSAAllElements(OMContainer parent, String [" + string + "], String[] [" + this.toString(stringArray) + "])");
        }
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        for (OMNode oMNode = oMContainer.getFirstOMChild(); oMNode != null; oMNode = oMNode.getNextOMSibling()) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (oMNode.getType() != 1 || !DOMUtils.equals(oMNode, string, stringArray[i])) continue;
                arrayList.add((OMElement)oMNode);
            }
        }
        return arrayList;
    }

    protected static final OMElement getSecurityHeader(Map<Object, Object> map, OMDocument oMDocument) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityHeader(Map context, OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "])");
        }
        boolean bl = IntegralDialectElementSelector.isGenerator(map);
        String string = null;
        if (bl) {
            object = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (object != null) {
                string = object.getTargetActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got generator actor " + string);
            }
        } else {
            object = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
            if (object != null) {
                string = object.getMyActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got consumer actor " + string);
            }
        }
        object = map.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int n = 0;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object;
        }
        OMElement oMElement = WSSGenerator.getHeader(oMDocument, false);
        OMElement oMElement2 = WSSGenerator.getSecurityHeader(oMElement, n, n2, string, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityHeader(Map, OMDocument) returns " + oMElement2);
        }
        return oMElement2;
    }

    private final String toString(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i]).append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static final boolean isGenerator(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenerator(Map context)");
        }
        boolean bl = false;
        boolean bl2 = false;
        Object object = map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (object != null) {
            bl = true;
        }
        if ((object = map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey")) != null) {
            bl2 = true;
        }
        if (bl && bl2 || !bl && !bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not determine generator or consumer");
            }
            throw SoapSecurityException.format("security.wssecurity.WSEC6734E");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenerator(Map) returns " + bl);
        }
        return bl;
    }

    private final String toString(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return "<empty>";
        }
        StringBuffer stringBuffer = new StringBuffer("[ ");
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(DOMUtils.toString((OMNode)arrayList.get(i))).append(", ");
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

