/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants0;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class IdUtil
implements IDResolver {
    private static final TraceComponent tc = Tr.register(IdUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = IdUtil.class.getName();
    private static final String NS_XHTML = "http://www.w3.org/1999/xhtml";
    private static final String[][] KNOWN_IDATTRS = new String[][]{{Constants0.NS_WSSE, "*", "Id"}, {Constants0.NS_WSSE200207, "*", "Id"}, {Constants0.NS_WSSE200204, "*", "Id"}, {Constants0.NS_DSIG, "*", "Id"}, {Constants0.NS_ENC, "*", "Id"}, {"http://www.w3.org/1999/xhtml", "*", "id"}};
    private static final String[][] KNOWN_GLOBAL_IDATTRS = new String[][]{{Constants0.NS_WSU, "Id"}, {Constants0.NS_WSU200207, "Id"}};
    private static IdUtil instance = new IdUtil();
    protected String[][] known_idattrs = KNOWN_IDATTRS;
    protected String[][] known_global_idattrs = KNOWN_GLOBAL_IDATTRS;
    protected QName[] known_global_idattrs_qname = new QName[KNOWN_GLOBAL_IDATTRS.length];
    protected HashMap<String, QName> known_idattrs_map;
    private static long id = 0L;

    protected IdUtil() {
        int n;
        for (n = 0; n < KNOWN_GLOBAL_IDATTRS.length; ++n) {
            this.known_global_idattrs_qname[n] = new QName(KNOWN_GLOBAL_IDATTRS[n][0], KNOWN_GLOBAL_IDATTRS[n][1]);
        }
        this.known_idattrs_map = new HashMap(KNOWN_IDATTRS.length + 4);
        for (n = 0; n < KNOWN_IDATTRS.length; ++n) {
            this.known_idattrs_map.put(this.known_idattrs[n][0], new QName("", this.known_idattrs[n][2]));
        }
    }

    public static IdUtil getInstance() {
        return instance;
    }

    public QName getIdAttributeName(OMElement oMElement) {
        String string;
        QName qName;
        QName qName2 = null;
        for (int i = 0; i < this.known_global_idattrs.length; ++i) {
            qName = this.known_global_idattrs_qname[i];
            OMAttribute oMAttribute = oMElement.getAttribute(qName);
            if (oMAttribute == null) continue;
            qName2 = oMAttribute.getQName();
        }
        if (qName2 == null && (qName = this.known_idattrs_map.get(string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName())) != null) {
            if (oMElement.getAttributeValue(qName) != null) {
                qName2 = qName;
            } else {
                qName = null;
            }
        }
        return qName2;
    }

    private boolean matchId(OMElement oMElement, String string, boolean bl) {
        QName qName;
        boolean bl2 = false;
        bl2 = bl ? string.equals(NamespaceUtil.getWsuAttribute(oMElement, "Id")) : (qName = this.getIdAttributeName(oMElement)) != null && string.equals(oMElement.getAttributeValue(qName));
        return bl2;
    }

    public String makeUniqueId(String string) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "makeUniqueId(String base[" + string + "])");
        }
        String string2 = string + id++;
        if (bl) {
            Tr.exit(tc, "makeUniqueId(String base) returns String[" + string2 + "]");
        }
        return string2;
    }

    public void checkIdUniqueness(OMDocument oMDocument) throws SoapSecurityException {
        OMElement oMElement;
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "checkIdUniqueness(Document doc[" + DOMUtil.getDisplayName(oMDocument) + "])");
        }
        if (oMDocument != null && (oMElement = oMDocument.getOMDocumentElement()) != null) {
            HashSet hashSet = new HashSet();
            IdUtil.checkIdUniqueness(oMElement, hashSet);
        }
        if (bl) {
            Tr.exit(tc, "checkIdUniqueness(Document doc)");
        }
    }

    private static void checkIdUniqueness(OMNode oMNode, Set set) throws SoapSecurityException {
        if (oMNode.getType() == 1) {
            Object object;
            OMElement oMElement = (OMElement)oMNode;
            QName qName = IdUtil.getInstance().getIdAttributeName(oMElement);
            if (qName != null) {
                object = oMElement.getAttributeValue(qName);
                if (set.contains(object)) {
                    throw SoapSecurityException.format("security.wssecurity.IdUtil.s01", (String)object);
                }
                set.add(object);
            }
            for (object = oMElement.getFirstOMChild(); object != null; object = object.getNextOMSibling()) {
                if (object.getType() != 1 && object.getType() != 9) continue;
                IdUtil.checkIdUniqueness((OMNode)object, set);
            }
        }
    }

    public OMElement resolveID(OMDocument oMDocument, String string) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "resolveID(Document doc[" + DOMUtil.getDisplayName(oMDocument) + "]," + "String id[" + string + "])");
        }
        OMElement oMElement = this.resolveId0(oMDocument, string, false);
        if (bl) {
            Tr.exit(tc, "resolveID(Document doc,String id) returns Element[" + DOMUtil.getDisplayName(oMElement) + "]");
        }
        return oMElement;
    }

    public boolean findId(OMDocument oMDocument, String string) {
        boolean bl;
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "findId(Document doc[" + DOMUtil.getDisplayName(oMDocument) + "]," + "String id[" + string + "])");
        }
        boolean bl3 = bl = this.resolveId0(oMDocument, string, false) != null;
        if (bl2) {
            Tr.exit(tc, "findId(Document doc,String id) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public boolean findWsuId(OMDocument oMDocument, String string) {
        boolean bl;
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "findWsuId(Document doc[" + DOMUtil.getDisplayName(oMDocument) + "]," + "String id[" + string + "])");
        }
        boolean bl3 = bl = this.resolveId0(oMDocument, string, true) != null;
        if (bl2) {
            Tr.exit(tc, "findWsuId(Document doc,String id) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private OMElement resolveId0(OMDocument oMDocument, String string, boolean bl) {
        if (oMDocument == null) {
            return null;
        }
        return this.resolve(oMDocument.getOMDocumentElement(), string, bl);
    }

    protected OMElement resolveId(OMNode oMNode, String string) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "resolveId(Node node[" + DOMUtil.getDisplayName(oMNode) + "]," + "String id[" + string + "])");
        }
        OMElement oMElement = null;
        if (oMNode != null) {
            oMElement = this.resolve(oMNode, string, false);
        }
        if (bl) {
            Tr.exit(tc, "resolveId(Node node,String id) returns Element[" + DOMUtil.getDisplayName(oMElement) + "]");
        }
        return oMElement;
    }

    private OMElement resolve(OMNode oMNode, String string, boolean bl) {
        if (oMNode.getType() == 1 && this.matchId((OMElement)oMNode, string, bl)) {
            return (OMElement)oMNode;
        }
        if (oMNode.getType() == 1) {
            for (OMNode oMNode2 = ((OMElement)oMNode).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
                OMElement oMElement;
                if (oMNode2.getType() != 1 && oMNode2.getType() != 9 || (oMElement = this.resolve(oMNode2, string, bl)) == null) continue;
                return oMElement;
            }
        }
        return null;
    }

    public String getId(OMElement oMElement) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "getId(Element element[" + DOMUtil.getDisplayName(oMElement) + "])");
        }
        String string = null;
        QName qName = this.getIdAttributeName(oMElement);
        if (qName != null) {
            string = oMElement.getAttributeValue(qName);
        }
        if (bl) {
            Tr.exit(tc, "getId(Element element) returns String[" + string + "]");
        }
        return string;
    }
}

