/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class GetJAASConfigInfo {
    private static TraceComponent tc = Tr.register(GetJAASConfigInfo.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static boolean jaasConfigAvail = false;
    private static boolean conUseDefaultSCTJAASLoginCfg = false;
    private static boolean genUseDefaultSCTJAASLoginCfg = false;
    private static boolean conUseDefaultX509JAASLoginCfg = false;
    private static boolean genUseDefaultX509JAASLoginCfg = false;
    private static boolean conUseDefaultUNTJAASLoginCfg = false;
    private static boolean genUseDefaultUNTJAASLoginCfg = false;
    private static Map jaasConfigMap = null;

    public static void getJAASConfigInformation(String string, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJAASConfigInformation(String cfgName, Map context) : " + string);
        }
        if (!jaasConfigAvail) {
            GetJAASConfigInfo.readJAASConfigInformation();
        }
        if ("generate".equals(string)) {
            map.put("com.ibm.ws.wssecurity.sct.jaasLogin", genUseDefaultSCTJAASLoginCfg);
            map.put("com.ibm.ws.wssecurity.x509.jaasLogin", genUseDefaultX509JAASLoginCfg);
            map.put("com.ibm.ws.wssecurity.unt.jaasLogin", genUseDefaultUNTJAASLoginCfg);
        } else if ("consume".equals(string)) {
            map.put("com.ibm.ws.wssecurity.sct.jaasLogin", conUseDefaultSCTJAASLoginCfg);
            map.put("com.ibm.ws.wssecurity.x509.jaasLogin", conUseDefaultX509JAASLoginCfg);
            map.put("com.ibm.ws.wssecurity.unt.jaasLogin", conUseDefaultUNTJAASLoginCfg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJAASConfigInformation(String cfgName, Map context) : " + string);
        }
    }

    private static synchronized void readJAASConfigInformation() {
        block11: {
            Configuration configuration;
            block10: {
                if (jaasConfigAvail) {
                    return;
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "readJAASConfigInformation");
                }
                configuration = null;
                try {
                    configuration = (Configuration)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            return Configuration.getConfiguration();
                        }
                    });
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Succeeded to get JAAS configuration.");
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Caught Privileged Exception " + privilegedActionException.getMessage());
                }
            }
            try {
                if (configuration != null) {
                    genUseDefaultSCTJAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.generate.sct", "com.ibm.ws.wssecurity.wssapi.token.impl.SCTGenerateLoginModule", configuration);
                    conUseDefaultSCTJAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.consume.sct", "com.ibm.ws.wssecurity.wssapi.token.impl.SCTConsumeLoginModule", configuration);
                    genUseDefaultX509JAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.generate.x509", "com.ibm.ws.wssecurity.wssapi.token.impl.X509GenerateLoginModule", configuration);
                    conUseDefaultX509JAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.consume.x509", "com.ibm.ws.wssecurity.wssapi.token.impl.X509ConsumeLoginModule", configuration);
                    genUseDefaultUNTJAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.generate.unt", "com.ibm.ws.wssecurity.wssapi.token.impl.UNTGenerateLoginModule", configuration);
                    conUseDefaultUNTJAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.consume.unt", "com.ibm.ws.wssecurity.wssapi.token.impl.UNTConsumeLoginModule", configuration);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Caught Exception while getting JAAS config " + exception.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Generators: Default SCT login module is used = " + genUseDefaultSCTJAASLoginCfg + ", Default X509 Login module is used = " + genUseDefaultX509JAASLoginCfg + ", Default UNT Login module is used = " + genUseDefaultUNTJAASLoginCfg);
            Tr.debug(tc, "Consumers: Default SCT login module is used = " + conUseDefaultSCTJAASLoginCfg + ", Default X509 Login module is used = " + conUseDefaultX509JAASLoginCfg + ", Default UNT Login module is used = " + conUseDefaultUNTJAASLoginCfg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readJAASConfigInformation");
        }
        jaasConfigAvail = true;
    }

    private static boolean getJaasEntry(String string, String string2, Configuration configuration) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJaasEntry(" + string + ", " + string2 + ", config)");
        }
        boolean bl = false;
        AppConfigurationEntry[] appConfigurationEntryArray = configuration.getAppConfigurationEntry(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
            Tr.debug(tc, "Number of appConfigEntries : " + appConfigurationEntryArray.length);
        }
        if (appConfigurationEntryArray.length == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The Login Configuration is  : " + appConfigurationEntryArray[0].getLoginModuleName());
            }
            if (appConfigurationEntryArray[0].getLoginModuleName().equals(string2)) {
                jaasConfigMap.put(string, string);
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJaasEntry returns " + bl);
        }
        return bl;
    }

    public static String isJaasConfigOurs(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isJaasConfigOurs(" + string + ")");
        }
        String string2 = null;
        if (ConfigUtil.hasValue(string)) {
            if (!jaasConfigAvail) {
                GetJAASConfigInfo.readJAASConfigInformation();
            }
            string2 = (String)jaasConfigMap.get(string);
        }
        if (tc.isDebugEnabled()) {
            if (ConfigUtil.hasValue(string2)) {
                Tr.debug(tc, "JAAS config is ours");
            } else {
                Tr.debug(tc, "JAAS config is NOT ours");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isJaasConfigOurs returns (" + string2 + ")");
        }
        return string2;
    }

    static {
        jaasConfigMap = new HashMap();
    }
}

