/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ErrorHandlerImpl
implements ErrorHandler {
    int errorCount = 0;

    ErrorHandlerImpl() {
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("Warning: " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("Error: " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        ++this.errorCount;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Fatal Error: " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        ++this.errorCount;
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }
}

