/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Constants0;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.Serializer;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtil
extends com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil {
    private static final TraceComponent tc = Tr.register(DOMUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = DOMUtil.class.getName();
    private static final PrivilegedAction<Object> contextLoaderGetter = new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final HashSet<String> INDENT_NS = new HashSet();

    public static OMDocument parse(InputSource inputSource, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse(InputStream in,boolean validating[" + bl + "])");
        }
        OMDocument oMDocument = null;
        try {
            StAXOMBuilder stAXOMBuilder;
            XMLStreamReader xMLStreamReader;
            XMLInputFactory xMLInputFactory = StAXUtils.getXMLInputFactory();
            xMLInputFactory.setXMLResolver(new JarXMLResolver());
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream != null) {
                xMLStreamReader = xMLInputFactory.createXMLStreamReader(inputStream);
                stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
            } else {
                Reader reader = inputSource.getCharacterStream();
                xMLStreamReader = xMLInputFactory.createXMLStreamReader(reader);
                stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
            }
            while (!stAXOMBuilder.isCompleted()) {
                stAXOMBuilder.next();
            }
            xMLStreamReader.close();
            oMDocument = stAXOMBuilder.getDocument();
            xMLInputFactory.setXMLResolver(null);
            StAXUtils.releaseXMLInputFactory(xMLInputFactory);
        }
        catch (XMLStreamException xMLStreamException) {
            Tr.processException(xMLStreamException, clsName + ".parse", "118");
            Tr.error(tc, "security.wssecurity.DOMUtil.s04", new Object[]{xMLStreamException});
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.s04", xMLStreamException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse(InputStream in,boolean validating) returns OMDocument[" + DOMUtil.getDisplayName(oMDocument) + "]");
        }
        return oMDocument;
    }

    public static OMDocument getPrivateConfig(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateConfig(boolean sender[" + bl + "])");
        }
        String string = bl ? "config/ibm-wssecurity-sender-private.xml" : "config/ibm-wssecurity-receiver-private.xml";
        OMDocument oMDocument = DOMUtil.getPrivateConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateConfig(boolean sender) returns OMDocument[" + DOMUtil.getDisplayName(oMDocument) + "]");
        }
        return oMDocument;
    }

    protected static OMDocument getPrivateConfig(final String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateConfig(String file[" + string + "])");
        }
        OMDocument oMDocument = null;
        try {
            oMDocument = (OMDocument)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SoapSecurityException {
                    InputSource inputSource = DOMUtil.getResourceAsInputSource(string);
                    return DOMUtil.parse(inputSource, true);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            SoapSecurityException soapSecurityException = (SoapSecurityException)privilegedActionException.getException();
            Tr.processException(soapSecurityException, clsName + ".getPrivateCofig", "163");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{soapSecurityException});
            Throwable throwable = soapSecurityException.getCauseException();
            if (throwable != null) {
                throw new IllegalArgumentException(soapSecurityException.getMessage() + ": " + throwable.getMessage());
            }
            throw new IllegalArgumentException(soapSecurityException.getMessage());
        }
        catch (Throwable throwable) {
            Tr.processException(throwable, clsName + ".getPrivateConfig", "173");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{throwable});
            throw new IllegalArgumentException(throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateConfig(String file) returns OMDocument[" + DOMUtil.getDisplayName(oMDocument) + "]");
        }
        return oMDocument;
    }

    public static OMDocument getConfigValidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigValidation()");
        }
        OMDocument oMDocument = null;
        try {
            oMDocument = (OMDocument)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SoapSecurityException {
                    InputSource inputSource = DOMUtil.getResourceAsInputSource("config/ibm-wssecurity-config-validation.xml");
                    return DOMUtil.parse(inputSource, true);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            SoapSecurityException soapSecurityException = (SoapSecurityException)privilegedActionException.getException();
            Tr.processException(soapSecurityException, clsName + ".getPrivateCofig", "202");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{soapSecurityException});
            Throwable throwable = soapSecurityException.getCauseException();
            if (throwable != null) {
                throw new IllegalArgumentException(soapSecurityException.getMessage() + ": " + throwable.getMessage());
            }
            throw new IllegalArgumentException(soapSecurityException.getMessage());
        }
        catch (Throwable throwable) {
            Tr.processException(throwable, clsName + ".getPrivateConfig", "212");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{throwable});
            throw new IllegalArgumentException(throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigValidation() returns Document[" + DOMUtil.getDisplayName(oMDocument) + "]");
        }
        return oMDocument;
    }

    public static InputSource getResourceAsInputSource(String string) {
        ClassLoader classLoader;
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceAsInputSource(String path[" + string + "])");
        }
        if ((inputStream = (classLoader = DOMUtil.class.getClassLoader()).getResourceAsStream(string)) == null) {
            inputStream = classLoader.getResourceAsStream("/" + string);
        }
        if (inputStream == null) {
            classLoader = (ClassLoader)AccessController.doPrivileged(contextLoaderGetter);
            if (classLoader == null) {
                inputStream = ClassLoader.getSystemResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = ClassLoader.getSystemResourceAsStream("/" + string);
                }
            } else {
                inputStream = classLoader.getResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream("/" + string);
                }
            }
        }
        if (inputStream == null) {
            throw new RuntimeException(ConfigUtil.getMessage("security.wssecurity.DOMUtil.s03", new String[]{string}));
        }
        InputSource inputSource = new InputSource(inputStream);
        if (tc.isEntryEnabled()) {
            String string2 = inputSource == null ? "null" : "not null";
            Tr.exit(tc, "getResourceAsInputSource(String path) returns InputSource[" + string2 + "]");
        }
        return inputSource;
    }

    public static String toString(OMNode oMNode) {
        String string = DOMUtil.toString(oMNode, null);
        return string;
    }

    public static String toString(OMNode oMNode, String string) {
        String string2 = null;
        if (oMNode != null) {
            byte[] byArray = null;
            try {
                byArray = Serializer.serialize(oMNode);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Internal Error: " + iOException);
            }
            try {
                string2 = string == null ? new String(byArray) : new String(byArray, string);
            }
            catch (Exception exception) {
                string2 = new String(byArray);
            }
        }
        return string2;
    }

    public static OMDocument createDocument() throws SoapSecurityException {
        OMDocument oMDocument = null;
        oMDocument = OMAbstractFactory.getOMFactory().createOMDocument();
        return oMDocument;
    }

    public static OMElement getZeroOrOneElement(OMElement oMElement, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZeroOrOneElement(OMElement config[" + DOMUtil.getDisplayName(oMElement) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        OMElement oMElement2 = null;
        ArrayList arrayList = DOMUtil.getElementsByTagNameNS(oMElement, string, string2);
        if (arrayList.size() != 0) {
            if (arrayList.size() == 1) {
                oMElement2 = (OMElement)arrayList.get(0);
            } else {
                String string3 = (string != null ? "{" + string + "}" : "") + string2;
                throw SoapSecurityException.format("security.wssecurity.RequestReceiverConfig.sconf02", string3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZeroOrOneElement(OMElement config,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement getZeroOrOneElement(OMDocument oMDocument, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZeroOrOneElement(OMDocument config[" + DOMUtil.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        OMElement oMElement = DOMUtil.getZeroOrOneElement(oMDocument.getOMDocumentElement(), string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZeroOrOneElement(OMDocument config,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(oMElement) + "]");
        }
        return oMElement;
    }

    public static OMElement getOneElement(OMElement oMElement, String string, String string2) throws SoapSecurityException {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneElement(OMElement config[" + DOMUtil.getDisplayName(oMElement) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((arrayList = DOMUtil.getElementsByTagNameNS(oMElement, string, string2)).size() != 1) {
            String string3 = (string != null ? "{" + string + "}" : "") + string2;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf03", string3);
        }
        OMElement oMElement2 = (OMElement)arrayList.get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneElement(OMElement config,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement getOneElement(OMDocument oMDocument, String string, String string2) throws SoapSecurityException {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneElement(OMDocument config[" + DOMUtil.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((arrayList = DOMUtil.getElementsByTagNameNS(oMDocument.getOMDocumentElement(), string, string2)).size() != 1) {
            String string3 = (string != null ? "{" + string + "}" : "") + string2;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf03", string3);
        }
        OMElement oMElement = (OMElement)arrayList.get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneElement(OMDocument config,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(oMElement) + "]");
        }
        return oMElement;
    }

    public static ArrayList getHeadersForNamespace(OMElement oMElement, String string, String string2, String string3, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeadersForNamespace(OMElement parent[" + DOMUtil.getDisplayName(oMElement) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "]," + "String actorOrRole[" + string3 + "]," + "int version[" + n + "])");
        }
        boolean bl = false;
        if (string2 == null) {
            bl = true;
        }
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        for (OMNode oMNode = oMElement.getFirstOMChild(); oMNode != null; oMNode = oMNode.getNextOMSibling()) {
            if (oMNode.getType() != 1 || !DOMUtil.equals(oMNode, string, string2, string3, n, bl)) continue;
            arrayList.add(oMNode);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Found header with name [" + ((OMElement)oMNode).getLocalName() + " and namespace [" + string + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHeadersForNamespace(OMElement parent,String ns,String name,String actorOrRole,int version) returns NodeList[" + arrayList + "]");
        }
        return arrayList;
    }

    public static ArrayList<OMNode> getChildElements(OMElement oMElement, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildElements(OMElement parent[" + DOMUtil.getDisplayName(oMElement) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        for (OMNode oMNode = oMElement.getFirstOMChild(); oMNode != null; oMNode = oMNode.getNextOMSibling()) {
            if (oMNode.getType() != 1 || !DOMUtil.equals(oMNode, string, string2)) continue;
            arrayList.add((OMElement)oMNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildElements(OMElement parent,String ns,String name) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    public static OMElement getChildElement(OMElement oMElement, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildElement(OMElement parent[" + DOMUtil.getDisplayName(oMElement) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        OMElement oMElement2 = null;
        for (OMNode oMNode = oMElement.getFirstOMChild(); oMNode != null; oMNode = oMNode.getNextOMSibling()) {
            if (oMNode.getType() != 1 || !DOMUtil.equals(oMNode, string, string2)) continue;
            oMElement2 = (OMElement)oMNode;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildElement(OMElement parent,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement getAncestorElement(OMElement oMElement, String string, String string2) {
        OMElement oMElement2 = null;
        if (DOMUtil.equals(oMElement, string, string2)) {
            oMElement2 = oMElement;
        } else {
            OMContainer oMContainer = oMElement.getParent();
            while (oMContainer != null && oMElement != oMContainer) {
                if (oMContainer instanceof OMElement) {
                    oMElement2 = DOMUtil.getAncestorElement((OMElement)oMContainer, string, string2);
                    break;
                }
                oMContainer = ((OMElement)oMContainer).getParent();
            }
        }
        return oMElement2;
    }

    public static boolean equals(OMNode oMNode, String string, String string2, String string3, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(OMNode node[" + DOMUtil.getDisplayName(oMNode) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "]," + "String actorOrRole[" + string3 + "]," + "int soapVersion[" + n + "]," + "boolean namespaceOnly[" + bl + "])");
        }
        boolean bl2 = false;
        if (oMNode.getType() == 1) {
            OMElement oMElement = (OMElement)oMNode;
            if (bl) {
                bl2 = DOMUtil.equals(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getNamespaceURI(), string);
            } else {
                boolean bl3 = bl2 = DOMUtil.equals(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName(), string) && DOMUtil.equals(oMElement.getLocalName(), string2);
            }
            if (bl2) {
                String string4 = null;
                if (n == 1) {
                    string4 = oMElement.getAttributeValue(Constants.SOAP12_ROLE_Q);
                } else if (n == 0) {
                    string4 = oMElement.getAttributeValue(Constants.SOAP11_ACTOR_Q);
                }
                if (string3 == null || string3.length() == 0) {
                    if (string4 != null && string4.trim().length() != 0) {
                        bl2 = false;
                    }
                } else if (!string3.equals(string4)) {
                    bl2 = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(OMNode node,String ns,String name,String actorOrRole,int soapVersion,boolean namespaceOnly) returns boolean[" + bl2 + "]");
        }
        return bl2;
    }

    public static boolean equals(OMNode oMNode, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(OMNode node[" + DOMUtil.getDisplayName(oMNode) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        boolean bl = false;
        if (oMNode.getType() == 1) {
            OMElement oMElement = (OMElement)oMNode;
            boolean bl2 = bl = DOMUtil.equals(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName(), string) && DOMUtil.equals(oMElement.getLocalName(), string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(OMNode node,String ns,String name) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private static boolean equals(String string, String string2) {
        boolean bl = string == null && string2 == null || string != null && string.equals(string2);
        return bl;
    }

    public static boolean equals(OMNode oMNode, OMNode oMNode2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(OMNode node1[" + DOMUtil.getDisplayName(oMNode) + "]," + "OMNode node2[" + DOMUtil.getDisplayName(oMNode2) + "])");
        }
        boolean bl = false;
        if (oMNode == null && oMNode2 == null) {
            bl = true;
        } else if (oMNode == null || oMNode2 == null) {
            bl = false;
        } else if (oMNode.equals(oMNode2)) {
            bl = true;
        } else if (oMNode.getType() != oMNode2.getType()) {
            bl = false;
        } else {
            switch (oMNode.getType()) {
                case 1: {
                    bl = DOMUtil.equalsElement((OMElement)oMNode, (OMElement)oMNode2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    bl = DOMUtil.equalsTextValue((OMText)oMNode, (OMText)oMNode2);
                    break;
                }
                case 9: {
                    bl = DOMUtil.equalsNodeName(oMNode, oMNode2);
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(OMNode node1, OMNode node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    protected static boolean equalsElement(OMElement oMElement, OMElement oMElement2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsElement(OMElement node1[" + DOMUtil.getDisplayName(oMElement) + "]," + "OMElement node2[" + DOMUtil.getDisplayName(oMElement2) + "])");
        }
        boolean bl = false;
        if (oMElement == null && oMElement2 == null) {
            bl = true;
        } else if (DOMUtil.equals(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName(), oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getName()) && DOMUtil.equals(oMElement.getLocalName(), oMElement2.getLocalName())) {
            OMContainer oMContainer = oMElement.getParent();
            OMContainer oMContainer2 = oMElement2.getParent();
            if (oMContainer != null && oMContainer2 != null && oMContainer instanceof OMDocument && oMContainer2 instanceof OMDocument) {
                return true;
            }
            if (oMContainer instanceof OMDocument != oMContainer2 instanceof OMDocument) {
                return false;
            }
            OMElement oMElement3 = DOMUtil.getFirstElement((OMElement)oMContainer);
            OMElement oMElement4 = DOMUtil.getFirstElement((OMElement)oMContainer2);
            while (oMElement3 != null && oMElement4 != null) {
                if (oMElement3.equals(oMElement) && oMElement4.equals(oMElement2)) {
                    bl = DOMUtil.equals((OMElement)oMContainer, (OMElement)oMContainer2);
                    break;
                }
                oMElement3 = DOMUtil.getNextElement(oMElement3);
                oMElement4 = DOMUtil.getNextElement(oMElement4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsElement(OMElement node1, OMElement node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    protected static boolean equalsAttribute(OMAttribute oMAttribute, OMAttribute oMAttribute2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsAttribute(Attr node1[" + oMAttribute + "]," + "Attr node2[" + oMAttribute2 + "])");
        }
        boolean bl = false;
        if (oMAttribute == null && oMAttribute2 == null) {
            bl = true;
        } else if (DOMUtil.equals(oMAttribute.getAttributeValue(), oMAttribute2.getAttributeValue()) && DOMUtil.equals(oMAttribute.getLocalName(), oMAttribute2.getLocalName())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsAttribute(Attr node1,Attr node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    protected static boolean equalsNamespace(OMNamespace oMNamespace, OMNamespace oMNamespace2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsAttribute(Attr node1[" + oMNamespace + "]," + "Attr node2[" + oMNamespace2 + "])");
        }
        boolean bl = false;
        if (oMNamespace == null && oMNamespace2 == null) {
            bl = true;
        } else if (DOMUtil.equals(oMNamespace.getPrefix(), oMNamespace2.getPrefix()) && DOMUtil.equals(oMNamespace.getName(), oMNamespace2.getName())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsAttribute(Attr node1,Attr node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    protected static boolean equalsTextValue(OMText oMText, OMText oMText2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsTextValue(OMText node1[" + DOMUtil.getDisplayName(oMText) + "]," + "OMText node2[" + DOMUtil.getDisplayName(oMText2) + "])");
        }
        boolean bl = false;
        if (oMText == null && oMText2 == null) {
            bl = true;
        } else if (DOMUtil.equals(oMText.getText(), oMText2.getText())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsTextValue(OMText node1, OMText node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private static boolean equalsNodeName(OMNode oMNode, OMNode oMNode2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsNodeName(OMNode node1[" + DOMUtil.getDisplayName(oMNode) + "]," + "OMNode node2[" + DOMUtil.getDisplayName(oMNode2) + "])");
        }
        boolean bl = false;
        if (oMNode == null && oMNode2 == null) {
            bl = true;
        } else if (oMNode.getType() == 1 && oMNode2.getType() == 1) {
            OMElement oMElement = (OMElement)oMNode;
            OMElement oMElement2 = (OMElement)oMNode2;
            if (DOMUtil.equals(oMElement.getLocalName(), oMElement2.getLocalName()) && DOMUtil.equals(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName(), oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getName())) {
                bl = true;
            }
        } else if (oMNode.getType() == 4 && oMNode2.getType() == 4 && DOMUtil.equals(((OMText)oMNode).getText(), ((OMText)oMNode2).getText())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsNodeName(OMNode node1,OMNode node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static ArrayList<OMNode> getOneOrMoreChildElements(OMElement oMElement, String string, String string2) throws SoapSecurityException {
        ArrayList<OMNode> arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneOrMoreChildElements(OMElement parent[" + DOMUtil.getDisplayName(oMElement) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((arrayList = DOMUtil.getChildElements(oMElement, string, string2)).size() <= 0) {
            String string3 = (string != null ? "{" + string + "}" : "") + string2;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf09", string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneOrMoreChildElements(OMElement parent,String ns,String name) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    public static ArrayList<OMNode> getOneOrMoreElements(OMElement oMElement, String string, String string2) throws SoapSecurityException {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneOrMoreElements(OMElement parent[" + DOMUtil.getDisplayName(oMElement) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((arrayList = DOMUtil.getElementsByTagNameNS(oMElement, string, string2)).size() <= 0) {
            String string3 = (string != null ? "{" + string + "}" : "") + string2;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf09", string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneOrMoreElements(OMElement parent,String ns,String name) retuns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    public static String getAttribute(OMElement oMElement, String string) throws SoapSecurityException {
        String string2 = oMElement.getAttributeValue(new QName("", string));
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf10", oMElement.getLocalName(), string);
        }
        return string2;
    }

    public static OMElement getOneChildElement(OMElement oMElement, String string, String string2) throws SoapSecurityException {
        OMElement oMElement2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneChildElement(OMElement parent[" + DOMUtil.getDisplayName(oMElement) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((oMElement2 = DOMUtil.getChildElement(oMElement, string, string2)) == null) {
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf03", string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneChildElement(OMElement parent,String ns,String name) retuns OMElement[" + DOMUtil.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement getOneChildElement(OMElement oMElement, String string, String[] stringArray) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneChildElement(OMElement parent[" + DOMUtil.getDisplayName(oMElement) + "]," + "String ns[" + string + "]," + "String[] names[" + stringArray + "])");
        }
        OMElement oMElement2 = null;
        for (int i = 0; i < stringArray.length && (oMElement2 = DOMUtil.getChildElement(oMElement, string, stringArray[i])) == null; ++i) {
        }
        if (oMElement2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf11", stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneChildElement(OMElement parent,String ns,String[] names) retuns OMElement[" + DOMUtil.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMNode getNextSibling2(OMNode oMNode) {
        OMContainer oMContainer;
        OMNode oMNode2 = oMNode.getNextOMSibling();
        if (oMNode2 == null && ((oMContainer = oMNode.getParent()) == null || oMContainer instanceof OMDocument)) {
            return null;
        }
        return oMNode2;
    }

    public static OMNode getPreviousSibling2(OMNode oMNode) {
        OMContainer oMContainer;
        OMNode oMNode2 = oMNode.getPreviousOMSibling();
        if (oMNode2 == null && ((oMContainer = oMNode.getParent()) == null || oMContainer instanceof OMDocument)) {
            return null;
        }
        return oMNode2;
    }

    public static OMNode getFirstChild2(OMNode oMNode) {
        OMNode oMNode2 = null;
        if (oMNode != null && oMNode.getType() == 1) {
            oMNode2 = ((OMElement)oMNode).getFirstOMChild();
        }
        return oMNode2;
    }

    public static OMNode getLastChild2(OMNode oMNode) {
        OMNode oMNode2 = null;
        if (oMNode != null && oMNode.getType() == 1) {
            OMElement oMElement = (OMElement)oMNode;
            Iterator iterator = oMElement.getChildren();
            while (iterator.hasNext()) {
                oMNode2 = (OMNode)iterator.next();
            }
        }
        return oMNode2;
    }

    public static OMElement getFirstElement(OMNode oMNode) {
        OMNode oMNode2 = DOMUtil.getFirstChild2(oMNode);
        while (oMNode2 != null && oMNode2.getType() != 1) {
            oMNode2 = DOMUtil.getNextSibling2(oMNode2);
        }
        OMElement oMElement = (OMElement)oMNode2;
        return oMElement;
    }

    public static OMElement getFirstElement(OMNode oMNode, String string, String string2) {
        OMElement oMElement;
        OMNode oMNode2 = DOMUtil.getFirstChild2(oMNode);
        while (oMNode2 != null) {
            if (oMNode2.getType() == 1) {
                String string3;
                oMElement = (OMElement)oMNode2;
                String string4 = string3 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
                if ((string2.equals("*") || oMElement.getLocalName().equals(string2)) && (string == null && string3 == null || string != null && string.equals("*") || string != null && string.equals(string3))) break;
            }
            oMNode2 = DOMUtil.getNextSibling2(oMNode2);
        }
        oMElement = (OMElement)oMNode2;
        return oMElement;
    }

    public static OMElement getLastElement(OMNode oMNode) {
        OMNode oMNode2 = DOMUtil.getLastChild2(oMNode);
        while (oMNode2 != null && oMNode2.getType() != 1) {
            oMNode2 = DOMUtil.getPreviousSibling2(oMNode2);
        }
        OMElement oMElement = (OMElement)oMNode2;
        return oMElement;
    }

    public static OMElement getLastElement(OMNode oMNode, String string, String string2) {
        OMElement oMElement;
        OMNode oMNode2 = DOMUtil.getLastChild2(oMNode);
        while (oMNode2 != null) {
            if (oMNode2.getType() == 1) {
                String string3;
                oMElement = (OMElement)oMNode2;
                String string4 = string3 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
                if ((string2.equals("*") || oMElement.getLocalName().equals(string2)) && (string == null && string3 == null || string != null && string.equals("*") || string != null && string.equals(string3))) break;
            }
            oMNode2 = DOMUtil.getPreviousSibling2(oMNode2);
        }
        oMElement = (OMElement)oMNode2;
        return oMElement;
    }

    public static OMElement getNextElement(OMNode oMNode) {
        OMNode oMNode2 = oMNode;
        while ((oMNode2 = DOMUtil.getNextSibling2(oMNode2)) != null) {
            if (oMNode2 == oMNode) {
                oMNode2 = null;
                break;
            }
            if (oMNode2.getType() != 1) continue;
        }
        OMElement oMElement = (OMElement)oMNode2;
        return oMElement;
    }

    public static String getStringValue(OMNode oMNode) {
        String string = null;
        switch (oMNode.getType()) {
            case 1: 
            case 9: {
                OMNode oMNode2 = ((OMElement)oMNode).getFirstOMChild();
                if (oMNode2 == null) {
                    string = "";
                    break;
                }
                if (oMNode2 == DOMUtil.getLastChild2(oMNode) && (oMNode2.getType() == 4 || oMNode2.getType() == 12)) {
                    string = ((OMText)oMNode2).getText();
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer();
                DOMUtil.getStringValue0(oMNode, stringBuffer);
                string = new String(stringBuffer);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                string = ((OMText)oMNode).getText();
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unexpected node type: " + oMNode.getType());
            }
        }
        return string;
    }

    private static void getStringValue0(OMNode oMNode, StringBuffer stringBuffer) {
        switch (oMNode.getType()) {
            case 1: 
            case 9: {
                for (OMNode oMNode2 = ((OMElement)oMNode).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
                    DOMUtil.getStringValue0(oMNode2, stringBuffer);
                }
                break;
            }
            case 4: 
            case 12: {
                stringBuffer.append(((OMText)oMNode).getTextCharacters());
                break;
            }
        }
    }

    public static void removeIndentation(OMElement oMElement) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeIndentation(OMElement element[" + DOMUtil.getDisplayName(oMElement) + "])");
        }
        OMNode oMNode = oMElement.getFirstOMChild();
        while (oMNode != null) {
            if (oMNode.getType() == 1) {
                DOMUtil.removeIndentation((OMElement)oMNode);
                oMNode = oMNode.getNextOMSibling();
                continue;
            }
            if (oMNode.getType() == 4 || oMNode.getType() == 12) {
                OMNode oMNode2 = oMNode;
                if (DOMUtil.isAllSpace(oMNode)) {
                    oMNode = oMNode.getNextOMSibling();
                    oMNode2.detach();
                    continue;
                }
                if (DOMUtil.hasSpace(oMNode)) {
                    DOMUtil.trimSpaces(oMNode);
                    oMNode = oMNode.getNextOMSibling();
                    continue;
                }
                oMNode = oMNode.getNextOMSibling();
                continue;
            }
            oMNode = oMNode.getNextOMSibling();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeIndentation(OMElement element)");
        }
    }

    public static void indent(OMElement oMElement, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "indent(OMElement element[" + DOMUtil.getDisplayName(oMElement) + "]," + "int init[" + n + "]," + "int diff[" + n2 + "])");
        }
        int n3 = n + n2;
        if (INDENT_NS.contains(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName())) {
            OMFactory oMFactory = oMElement.getOMFactory();
            OMNode oMNode = null;
            for (OMNode oMNode2 = oMElement.getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
                if (oMNode2.getType() == 1) {
                    if (oMNode == null || oMNode.getType() != 4) {
                        oMNode2.insertSiblingBefore(DOMUtil.createTextNode(oMFactory, n3));
                    } else if (DOMUtil.isAllSpace(oMNode)) {
                        oMNode.insertSiblingBefore(DOMUtil.createTextNode(oMFactory, n3));
                        oMNode.detach();
                    }
                    DOMUtil.indent((OMElement)oMNode2, n3, n2);
                }
                oMNode = oMNode2;
            }
            if (oMNode == null || oMNode.getType() != 4) {
                oMElement.addChild(DOMUtil.createTextNode(oMFactory, n));
            } else if (DOMUtil.isAllSpace(oMNode)) {
                oMNode.insertSiblingBefore(DOMUtil.createTextNode(oMFactory, n));
                oMNode.detach();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "indent(OMElement element, int init, int diff)");
        }
    }

    protected static OMNode createTextNode(OMFactory oMFactory, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTextNode(OMFactory factory[" + oMFactory + "]," + "int spaces[" + n + "])");
        }
        StringBuffer stringBuffer = new StringBuffer(1 + n);
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        OMText oMText = oMFactory.createOMText(new String(stringBuffer));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTextNode(OMFactory factory, int spaces) returns OMNode[" + oMText + "]");
        }
        return oMText;
    }

    protected static boolean isAllSpace(OMNode oMNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllSpace(OMNode node[" + DOMUtil.getDisplayName(oMNode) + "])");
        }
        if (oMNode.getType() != 4) {
            return false;
        }
        boolean bl = true;
        String string = ((OMText)oMNode).getText();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            bl = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAllSpace(OMNode node) returns boolean[" + bl + "]");
        }
        return bl;
    }

    protected static boolean hasSpace(OMNode oMNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasSpace(OMNode node[" + DOMUtil.getDisplayName(oMNode) + "])");
        }
        if (oMNode.getType() != 4) {
            return false;
        }
        boolean bl = false;
        String string = ((OMText)oMNode).getText();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasSpace(OMNode node) returns boolean[" + bl + "]");
        }
        return bl;
    }

    protected static void trimSpaces(OMNode oMNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trimSpaces(OMNode node[" + DOMUtil.getDisplayName(oMNode) + "])");
        }
        if (oMNode.getType() != 4) {
            return;
        }
        boolean bl = false;
        String string = ((OMText)oMNode).getText();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                bl = false;
                continue;
            }
            if (!bl && (c == ' ' || c == '\t')) continue;
            bl = true;
            stringBuffer.append(c);
        }
        oMNode.insertSiblingBefore(oMNode.getOMFactory().createOMText(new String(stringBuffer)));
        oMNode.detach();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trimSpaces(OMNode node)");
        }
    }

    public static QName getQName(OMElement oMElement, String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQName(Element element[" + DOMUtil.getDisplayName(oMElement) + "]," + "String qNameStr[" + string + "])");
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(":");
        if (n == -1) {
            string2 = "";
            string3 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        OMContainer oMContainer = oMElement;
        String string4 = "";
        while (oMContainer instanceof OMElement) {
            object = oMContainer.getAllDeclaredNamespaces();
            while (object.hasNext()) {
                OMNamespace oMNamespace = (OMNamespace)object.next();
                if (!string2.equals(oMNamespace.getPrefix())) continue;
                string4 = oMNamespace.getName();
                break;
            }
            if (!string4.equals("")) break;
            oMContainer = oMContainer.getParent();
        }
        object = new QName(string4, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQName(Element element, String qNameStr) returns QName[" + object + "]");
        }
        return object;
    }

    public static void setQNameAttr(OMElement oMElement, String string, String string2, QName qName, int n) {
        String string3;
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameAttr(Element element[" + DOMUtil.getDisplayName(oMElement) + "]," + "String attrNameNS[" + string + "]," + "String attrName[" + string2 + "]," + "QName attrValue[" + qName + "]," + "int wssVersion[" + n + "])");
        }
        String string5 = DOMUtil.setQName0(oMElement, qName, n);
        int n2 = string2.indexOf(":");
        if (n2 == -1) {
            string4 = "";
            string3 = string2;
        } else {
            string4 = string2.substring(0, n2);
            string3 = string2.substring(n2 + 1);
        }
        oMElement.addAttribute(string3, string5, oMElement.getOMFactory().createOMNamespace(string, string4));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameAttr(Element element,String attrNameNS,String attrName,QName attrValue,int wssVersion)");
        }
    }

    private static String setQName0(OMElement oMElement, QName qName, int n) {
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        if (string == null || string.length() == 0 && n == 0) {
            return string2;
        }
        OMContainer oMContainer = oMElement;
        String string3 = null;
        HashSet<String> hashSet = new HashSet<String>();
        while (oMContainer instanceof OMElement) {
            Iterator iterator = oMContainer.getAllDeclaredNamespaces();
            while (iterator.hasNext()) {
                OMNamespace oMNamespace = (OMNamespace)iterator.next();
                String string4 = oMNamespace.getPrefix();
                String string5 = oMNamespace.getNamespaceURI();
                if (string5.equals(string) && string3 == null && !hashSet.contains(string4)) {
                    string3 = string4;
                }
                hashSet.add(string4);
            }
            oMContainer = oMContainer.getParent();
        }
        if (string3 == null) {
            while (hashSet.contains(string3 = "ns" + DOMUtil.makeRandomStr())) {
            }
            oMElement.declareNamespace(string, string3);
        }
        return string3.equals("") ? string2 : string3 + ":" + string2;
    }

    public static void setQNameAttr(OMElement oMElement, String string, String string2, QName qName) {
        String string3;
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameAttr(OMElement element[" + DOMUtil.getDisplayName(oMElement) + "]," + "String attrNameNS[" + string + "]," + "String attrName[" + string2 + "]," + "QName attrValue[" + qName + "])");
        }
        String string5 = DOMUtil.setQName0(oMElement, qName);
        int n = string2.indexOf(":");
        if (n == -1) {
            string4 = "";
            string3 = string2;
        } else {
            string4 = string2.substring(0, n);
            string3 = string2.substring(n + 1);
        }
        if (string == null) {
            oMElement.addAttribute(string3, string5, null);
        } else {
            oMElement.addAttribute(string3, string5, oMElement.getOMFactory().createOMNamespace(string, string4));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameAttr(OMElement element,String attrNameNS,String attrName,QName attrValue)");
        }
    }

    public static void setQNameText(OMElement oMElement, QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameText(OMElement element[" + DOMUtil.getDisplayName(oMElement) + "]," + "QName text[" + qName + "])");
        }
        String string = DOMUtil.setQName0(oMElement, qName);
        OMFactory oMFactory = oMElement.getOMFactory();
        oMElement.addChild(oMFactory.createOMText(string));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameText(OMElement element, QName text)");
        }
    }

    private static String setQName0(OMElement oMElement, QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        OMContainer oMContainer = oMElement;
        String string3 = null;
        HashSet<String> hashSet = new HashSet<String>();
        while (oMContainer instanceof OMElement) {
            Iterator iterator = oMContainer.getAllDeclaredNamespaces();
            while (iterator.hasNext()) {
                OMNamespace oMNamespace = (OMNamespace)iterator.next();
                String string4 = oMNamespace.getPrefix();
                String string5 = oMNamespace.getNamespaceURI();
                if (!string5.equals(string) || string3 != null || hashSet.contains(string4)) continue;
                hashSet.add(string4);
            }
            oMContainer = oMContainer.getParent();
        }
        if (string3 == null) {
            string3 = string != null && string.length() != 0 ? "ns" + string.hashCode() : "ns" + qName.hashCode();
            while (hashSet.contains(string3)) {
                string3 = "ns" + DOMUtil.makeRandomStr();
            }
            oMElement.declareNamespace(string, string3);
        }
        return string3.equals("") ? string2 : string3 + ":" + string2;
    }

    protected static String makeRandomStr() {
        return String.valueOf(Math.abs(new Random().nextLong()));
    }

    public static OMElement StringToElement(String string, String string2, String string3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StringToElement(String namespace[" + string + "]," + "String name[" + string2 + "]," + "String str[" + string3 + "])");
        }
        OMElement oMElement = null;
        OMDocument oMDocument = DOMUtil.createDocument();
        OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
        OMElement oMElement2 = null;
        oMElement2 = string == null || string.length() == 0 ? oMFactory.createOMElement(string2, "", "") : oMFactory.createOMElement(string2, string, "");
        OMText oMText = oMFactory.createOMText(string3);
        oMElement2.addChild(oMText);
        oMElement = oMElement2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StringToElement(String namespace,String name,String str) returns OMElement[" + oMElement + "]");
        }
        return oMElement;
    }

    public static boolean hasNamespaceDeclaration(OMElement oMElement, String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasNamespaceDeclaration(OMElement element[" + DOMUtil.getDisplayName(oMElement) + "]," + "String namespace[" + string + "])");
        }
        boolean bl2 = bl = DOMUtil.getNamespaceDeclaration(oMElement, string) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasNamespaceDeclaration(OMElement element,String namespace) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static String getNamespacePrefix(OMElement oMElement, String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespacePrefix(OMElement element[" + DOMUtil.getDisplayName(oMElement) + "]," + "String namespace[" + string + "])");
        }
        String string3 = null;
        String string4 = string2 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
        if (string2 != null && string2.equals(string)) {
            string3 = oMElement.getNamespace().getPrefix();
        } else {
            OMContainer oMContainer;
            OMNamespace oMNamespace = DOMUtil.getNamespaceDeclaration(oMElement, string);
            if (oMNamespace != null) {
                string3 = oMNamespace.getPrefix();
            }
            if (string3 == null && (oMContainer = oMElement.getParent()) != null && oMContainer instanceof OMElement) {
                string3 = DOMUtil.getNamespacePrefix((OMElement)oMContainer, string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespacePrefix(OMElement element,String namespace) returns String[" + string3 + "]");
        }
        return string3;
    }

    public static OMNamespace getNamespaceDeclaration(OMElement oMElement, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespaceDeclaration(OMElement element[" + DOMUtil.getDisplayName(oMElement) + "]," + "String namespace[" + string + "])");
        }
        Iterator iterator = oMElement.getAllDeclaredNamespaces();
        OMNamespace oMNamespace = null;
        while (iterator.hasNext()) {
            OMNamespace oMNamespace2 = (OMNamespace)iterator.next();
            String string2 = oMNamespace2.getName();
            if (!string.equals(string2)) continue;
            oMNamespace = oMNamespace2;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespaceDeclaration(OMElement element,String namespace) returns Attr[" + oMNamespace + "]");
        }
        return oMNamespace;
    }

    public static OMNamespace removeNamespaceDeclaration(OMElement oMElement, String string) {
        OMNamespace oMNamespace;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNamespaceDeclaration(OMElement element[" + DOMUtil.getDisplayName(oMElement) + "]," + "String namespace[" + string + "])");
        }
        if ((oMNamespace = DOMUtil.getNamespaceDeclaration(oMElement, string)) != null) {
            oMElement.declareNamespace(null, oMNamespace.getPrefix());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNamespaceDeclaration(OMElement element,String namespace) returns Attr[" + oMNamespace + "]");
        }
        return oMNamespace;
    }

    public static Collection<OMNamespace> getEffectiveNamespaceDeclarations(OMNode oMNode, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveNamespaceDeclarations(OMNode node[" + DOMUtil.getDisplayName(oMNode) + "]," + "boolean inclusive[" + bl + "])");
        }
        Collection collection = null;
        if (oMNode != null) {
            HashMap<String, OMNamespace> hashMap = new HashMap<String, OMNamespace>();
            DOMUtil.getEffectiveNamespaceDeclarations(oMNode, oMNode, bl, hashMap);
            OMNamespace oMNamespace = oMNode.getOMFactory().createOMNamespace("http://www.w3.org/XML/1998/namespace", "xml");
            hashMap.put(oMNamespace.getPrefix(), oMNamespace);
            collection = hashMap.values();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveNamespaceDeclarations(OMNode node,boolean inclusive) returns Collection[" + collection + "]");
        }
        return collection;
    }

    private static void getEffectiveNamespaceDeclarations(OMNode oMNode, OMNode oMNode2, boolean bl, Map<String, OMNamespace> map) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveNamespaceDeclarations(OMNode current[" + DOMUtil.getDisplayName(oMNode) + "]," + "OMNode start[" + DOMUtil.getDisplayName(oMNode2) + "]," + "boolean inclusive[" + bl + "]," + "Map name2Attr)");
        }
        if (com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil.hasParentNode(oMNode) && (object = oMNode.getParent()) instanceof OMElement) {
            DOMUtil.getEffectiveNamespaceDeclarations((OMElement)object, oMNode2, bl, map);
        }
        if ((oMNode != oMNode2 || bl) && oMNode.getType() == 1) {
            object = ((OMElement)oMNode).getAllDeclaredNamespaces();
            while (object.hasNext()) {
                OMNamespace oMNamespace = (OMNamespace)object.next();
                map.put(oMNamespace.getPrefix(), oMNamespace);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveNamespaceDeclarations(OMNode current,OMNode start,boolean inclusive,Map name2Attr)");
        }
    }

    public static Collection<OMAttribute> getEffectiveXMLPrefixedAttributes(OMNode oMNode, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveXMLPrefixedAttributes(OMNode node[" + DOMUtil.getDisplayName(oMNode) + "]," + "boolean inclusive[" + bl + "])");
        }
        Collection collection = null;
        if (oMNode != null) {
            HashMap<String, OMAttribute> hashMap = new HashMap<String, OMAttribute>();
            DOMUtil.getEffectiveAttributes(oMNode, oMNode, bl, new String[]{"xml"}, hashMap);
            collection = hashMap.values();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveXMLPrefixedAttributes(OMNode node,boolean inclusive) returns Collection[" + collection + "]");
        }
        return collection;
    }

    private static void getEffectiveAttributes(OMNode oMNode, OMNode oMNode2, boolean bl, String[] stringArray, Map<String, OMAttribute> map) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveAttributes(OMNode current[" + DOMUtil.getDisplayName(oMNode) + "]," + "OMNode start[" + DOMUtil.getDisplayName(oMNode2) + "]," + "String[] names," + "boolean inclusive[" + bl + "]," + "Map name2Attr)");
        }
        if (com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil.hasParentNode(oMNode) && (object = oMNode.getParent()) instanceof OMElement) {
            DOMUtil.getEffectiveAttributes((OMElement)object, oMNode2, bl, stringArray, map);
        }
        if ((oMNode != oMNode2 || bl) && oMNode.getType() == 1) {
            object = ((OMElement)oMNode).getAllAttributes();
            while (object.hasNext()) {
                OMAttribute oMAttribute = (OMAttribute)object.next();
                String string = oMAttribute.getNamespace().getPrefix();
                if (stringArray == null) continue;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    map.put(string, oMAttribute);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveAttributes(OMNode current,OMNode start,String[] names,boolean inclusive,Map name2Attr)");
        }
    }

    public static OMElement createDummyElement(OMElement oMElement, OMDocument oMDocument, OMNode oMNode, boolean bl) {
        Collection<OMNamespace> collection;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(OMElement element[" + DOMUtil.getDisplayName(oMElement) + "]," + "OMDocument factory[" + DOMUtil.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "OMNode node[" + DOMUtil.getDisplayName(oMNode) + "]," + "boolean inclusive[" + bl + "])");
        }
        String string = null;
        String string2 = "dummy";
        if (oMElement != null) {
            string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
            string2 = oMElement.getLocalName();
        }
        if (oMDocument == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement oMElement2 = oMDocument.getOMDocumentElement().getOMFactory().createOMElement(string2, string, null);
        if (oMNode != null && (collection = DOMUtil.getEffectiveNamespaceDeclarations(oMNode, bl)) != null && collection.size() > 0) {
            for (OMNamespace oMNamespace : collection) {
                oMElement2.declareNamespace(oMNamespace);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(OMElement element,OMDocument factory,OMNode node,boolean inclusive) returns OMElement[" + DOMUtil.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement createDummyElement(OMDocument oMDocument, OMNode oMNode, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(OMDocument factory[" + DOMUtil.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "OMNode node[" + DOMUtil.getDisplayName(oMNode) + "]," + "boolean inclusive[" + bl + "])");
        }
        OMElement oMElement = DOMUtil.createDummyElement(null, oMDocument, oMNode, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(OMDocument factory,OMNode node,boolean inclusive) returns OMElement[" + DOMUtil.getDisplayName(oMElement) + "]");
        }
        return oMElement;
    }

    public static OMElement createDummyElement(OMDocument oMDocument) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(OMDocument factory[" + DOMUtil.getDisplayName(oMDocument.getOMDocumentElement()) + "])");
        }
        OMElement oMElement = DOMUtil.createDummyElement(null, oMDocument, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(OMDocument factory) returns OMElement[" + oMElement + "]");
        }
        return oMElement;
    }

    public static String getQualifiedName(OMNode oMNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQualifiedName(OMNode node[" + DOMUtil.getDisplayName(oMNode) + "])");
        }
        String string = null;
        if (oMNode.getType() == 1) {
            OMElement oMElement = (OMElement)oMNode;
            String string2 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
            String string3 = oMElement.getLocalName();
            if (string2 == null) {
                string2 = "";
            } else if (!"".equals(string2)) {
                string2 = string2 + ":";
            }
            string = string2 + string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQualifiedName(OMNode node) returns String[" + string + "]");
        }
        return string;
    }

    public static String getDisplayName(OMNode oMNode) {
        return DOMUtil.getDisplayName(oMNode, true);
    }

    public static String getDisplayName(OMNode oMNode, boolean bl) {
        String string = null;
        if (oMNode != null) {
            String string2 = bl ? oMNode.getClass().getName() + " --- " : "";
            switch (oMNode.getType()) {
                case 1: {
                    OMElement oMElement = (OMElement)oMNode;
                    String string3 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
                    String string4 = oMElement.getLocalName();
                    string = string2 + "{" + string3 + "}" + string4;
                    break;
                }
                case 4: 
                case 12: {
                    OMText oMText = (OMText)oMNode;
                    String string5 = oMText.getText();
                    string = string2 + string5;
                    break;
                }
                default: {
                    string = string2;
                }
            }
        }
        return string;
    }

    public static String getDisplayName(OMDocument oMDocument) {
        String string = null;
        if (oMDocument != null) {
            string = oMDocument.getClass().getName();
        }
        return string;
    }

    static {
        INDENT_NS.add(Constants0.NS_WSSE);
        INDENT_NS.add(Constants0.NS_DSIG);
        INDENT_NS.add(Constants0.NS_ENC);
        INDENT_NS.add(Constants0.NS_WSSE200207);
        INDENT_NS.add(Constants0.NS_WSSE200204);
        INDENT_NS.add(Constants0.NS_WSU);
        INDENT_NS.add(Constants0.NS_WSU200207);
    }

    public static class JarXMLResolver
    implements XMLResolver {
        public Object resolveEntity(String string, String string2, String string3, String string4) {
            String string5;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resolveEntity(String publicId[" + string + "]," + "String systemId[" + string2 + "])");
            }
            InputStream inputStream = null;
            if (string2 != null) {
                try {
                    string5 = null;
                    int n = string2.lastIndexOf(47);
                    string5 = n < 0 ? "config/" + string2 : "config/" + string2.substring(n + 1);
                    inputStream = DOMUtil.class.getClassLoader().getResourceAsStream(string5);
                    if (inputStream == null) {
                        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(contextLoaderGetter);
                        inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string5) : classLoader.getResourceAsStream(string5);
                    }
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".resolveEntity", "265");
                    Tr.error(tc, "security.wssecurity.DOMUtil.s02", new Object[]{string, string2, exception});
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                string5 = inputStream == null ? "null" : "not null";
                Tr.entry(tc, "resolveEntity(String publicId,String systemId) returns InputStream[" + string5 + "]");
            }
            return inputStream;
        }
    }

    public static class JarEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) {
            String string3;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resolveEntity(String publicId[" + string + "]," + "String systemId[" + string2 + "])");
            }
            InputSource inputSource = null;
            if (string2 != null) {
                try {
                    string3 = null;
                    int n = string2.lastIndexOf(47);
                    string3 = n < 0 ? "config/" + string2 : "config/" + string2.substring(n + 1);
                    InputStream inputStream = DOMUtil.class.getClassLoader().getResourceAsStream(string3);
                    if (inputStream == null) {
                        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(contextLoaderGetter);
                        inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
                    }
                    if (inputStream != null) {
                        inputSource = new InputSource(inputStream);
                    }
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".resolveEntity", "265");
                    Tr.error(tc, "security.wssecurity.DOMUtil.s02", new Object[]{string, string2, exception});
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                string3 = inputSource == null ? "null" : "not null";
                Tr.entry(tc, "resolveEntity(String publicId,String systemId) returns InputStream[" + string3 + "]");
            }
            return inputSource;
        }
    }
}

