/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AlgorithmParameters;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

public final class ConfigValidation {
    private static String isFipsEnabled = null;
    private static boolean rsaoaepInitialized = false;
    private static boolean rsaoaepSupported = false;
    private static byte[] lock = new byte[0];
    protected final Set allowedEncAlgos = new HashSet();
    protected final Set allowedKeyEncAlgos = new HashSet();
    protected final Set allowedC14nAlgos = new HashSet();
    protected final Set allowedSignAlgos = new HashSet();
    protected final Set allowedDigestAlgos = new HashSet();
    private static final String comp = "security.wssecurity";
    private static final String clsName = ConfigValidation.class.getName();
    private static final TraceComponent tc = Tr.register(ConfigValidation.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public ConfigValidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigValidation()");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigValidation()");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        this.processAllowedAlgorithms(DOMUtil.getConfigValidation());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    private void addToSet(OMDocument oMDocument, String string, Set set) {
        ArrayList arrayList;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSet(" + oMDocument + ", " + string + ", " + set + ")");
        }
        if ((n = (arrayList = DOMUtil.getElementsByTagNameNS(oMDocument.getOMDocumentElement(), "http://www.ibm.com/xml/soapsec/config", string)).size()) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No allowed " + string + " elements found.");
            }
        } else {
            for (int i = 0; i < n; ++i) {
                OMElement oMElement = (OMElement)arrayList.get(i);
                try {
                    set.add(DOMUtil.getAttribute(oMElement, "algorithm"));
                    continue;
                }
                catch (SoapSecurityException soapSecurityException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "\"algorithm\" attribute not found in \"" + string + "\" element.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Allowed " + string + " set: ", new Object[]{set});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSet()");
        }
    }

    protected void processAllowedAlgorithms(OMDocument oMDocument) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processAllowedAlgorithms(" + oMDocument + ")");
        }
        if (oMDocument == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Allowed Algorithms Document is null, exiting.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processAllowedAlgorithms()");
            }
            return;
        }
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; getting FIPS algorithms");
            }
            this.addToSet(oMDocument, "fipsEncryptionMethod", this.allowedEncAlgos);
            this.addToSet(oMDocument, "fipsKeyEncryptionMethod", this.allowedKeyEncAlgos);
            this.addToSet(oMDocument, "fipsSignatureMethod", this.allowedSignAlgos);
            this.addToSet(oMDocument, "fipsDigestMethod", this.allowedDigestAlgos);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            this.addToSet(oMDocument, "encryptionMethod", this.allowedEncAlgos);
            this.addToSet(oMDocument, "keyEncryptionMethod", this.allowedKeyEncAlgos);
            this.addToSet(oMDocument, "signatureMethod", this.allowedSignAlgos);
            this.addToSet(oMDocument, "digestMethod", this.allowedDigestAlgos);
        }
        this.addToSet(oMDocument, "canonicalizationMethod", this.allowedC14nAlgos);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processAllowedAlgorithms()");
        }
    }

    protected boolean encryptionMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptionMethodValid(" + string + ")");
        }
        boolean bl = this.allowedEncAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptionMethodValid() returns " + bl);
        }
        return bl;
    }

    protected boolean keyEncryptionMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyEncryptionMethodValid(" + string + ")");
        }
        boolean bl = this.allowedKeyEncAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyEncryptionMethodValid() returns " + bl);
        }
        return bl;
    }

    protected boolean canonicalizationMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canonicalizationMethodValid(" + string + ")");
        }
        boolean bl = this.allowedC14nAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canonicalizationMethodValid() returns " + bl);
        }
        return bl;
    }

    protected boolean signatureMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signatureMethodValid(" + string + ")");
        }
        boolean bl = this.allowedSignAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signatureMethodValid() returns " + bl);
        }
        return bl;
    }

    protected boolean digestMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "digestMethodValid(" + string + ")");
        }
        boolean bl = this.allowedDigestAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "digestMethodValid() returns " + bl);
        }
        return bl;
    }

    public static boolean isFipsEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFipsEnabled");
        }
        if (isFipsEnabled == null) {
            isFipsEnabled = Security.getProperty("com.ibm.websphere.security.fips.enabled");
            if (isFipsEnabled != null && isFipsEnabled.equalsIgnoreCase("true")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Read java.security.Security property; FIPS mode is enabled");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Read java.security.Security property; FIPS mode is not enabled");
            }
        }
        if (isFipsEnabled != null && isFipsEnabled.equalsIgnoreCase("true")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFipsEnabled -> true");
            }
            return true;
        }
        isFipsEnabled = "false";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFipsEnabled -> false");
        }
        return false;
    }

    public static boolean isAlgoSupportedByRuntime(String string) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlgoSupportedByRuntime(String algo[" + string + "])");
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(string)) {
            bl = ConfigValidation.isRsaoaepSupported(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlgoSupportedByRuntime returns " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRsaoaepSupported(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRsaoaepSupported");
        }
        if (rsaoaepInitialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRsaoaepSupported returns " + rsaoaepSupported);
            }
            return rsaoaepSupported;
        }
        byte[] byArray = lock;
        synchronized (lock) {
            block16: {
                String string2 = "OAEP";
                StringTokenizer stringTokenizer = null;
                if ("true".equalsIgnoreCase(Security.getProperty("com.ibm.websphere.security.fips.enabled"))) {
                    stringTokenizer = new StringTokenizer(Security.getProperty("com.ibm.websphere.security.fips.jceProviders"), "|");
                }
                if (stringTokenizer == null || !stringTokenizer.hasMoreTokens()) {
                    try {
                        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string2);
                        AlgorithmParameterSpec algorithmParameterSpec = (AlgorithmParameterSpec)Class.forName("javax.crypto.spec.OAEPParameterSpec").getField("DEFAULT").get(null);
                        rsaoaepSupported = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully got instance of " + string2 + " cipher algorithm with default provider");
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Received exception " + exception.getMessage() + " while getting instance of " + string2 + " cipher algorithm with default provider");
                    }
                } else {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        try {
                            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string2, string3);
                            AlgorithmParameterSpec algorithmParameterSpec = (AlgorithmParameterSpec)Class.forName("javax.crypto.spec.OAEPParameterSpec").getField("DEFAULT").get(null);
                            rsaoaepSupported = true;
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "Successfully got instance of " + string2 + " cipher algorithm with provider " + string3);
                            break;
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Received exception " + exception.getMessage() + " while getting instance of " + string2 + " cipher algorithm with provider " + string3);
                        }
                    }
                }
            }
            if (!rsaoaepSupported) {
                Tr.warning(tc, "security.wssecurity.WSEC0157W", string);
            }
            rsaoaepInitialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRsaoaepSupported returns " + rsaoaepSupported);
            }
            return rsaoaepSupported;
        }
    }
}

