/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wssecurity.common.Constants0;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.Initializable;
import com.ibm.ws.wssecurity.platform.util.KeyStoreUtilFactory;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtil {
    private static final TraceComponent tc = Tr.register(ConfigUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = ConfigUtil.class.getName();
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};
    private static final String[] FALSE_VALUES = new String[]{"no", "off", "false", "0"};
    private static final PrivilegedAction<Object> thisClassLoaderGetter = new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            return this.getClass().getClassLoader();
        }
    };
    private static final String[] USAGE_VALUES = new String[]{"required", "optional", "rejected", "observed", "ignored"};
    private static final String[] KEYINFO_TYPES = new String[]{"STRREF", "EMB", "KEYID", "KEYNAME", "X509ISSUER", "THUMBPRINT"};
    private static final Set<String> C14N_TRANSFORMS = new HashSet<String>();
    private static final Set<String> DOMREQUIRED_TRANSFORMS;
    private static final Set<String> SECRETKEY_ALGORITHMS;

    public static boolean isTrue(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTrue(String flag[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < TRUE_VALUES.length; ++i) {
                if (!TRUE_VALUES[i].equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrue(String) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isFalse(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFalse(String flag[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < FALSE_VALUES.length; ++i) {
                if (!FALSE_VALUES[i].equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFalse returns [" + bl + "]");
        }
        return bl;
    }

    public static boolean hasValue(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean getIsTrueProperty(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTrueProperty(_map, " + string + ")");
        }
        String string2 = (String)map.get(string);
        boolean bl = false;
        if (ConfigUtil.hasValue(string2) && ConfigUtil.isTrue(string2)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTrueProperty returns [" + bl + "]");
        }
        return bl;
    }

    public static boolean getIsFalseProperty(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsFalseProperty(_map, " + string + ")");
        }
        String string2 = (String)map.get(string);
        boolean bl = true;
        if (ConfigUtil.hasValue(string2) && ConfigUtil.isFalse(string2)) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsFalseProperty returns [" + bl + "]");
        }
        return bl;
    }

    public static boolean isValidWSKeyStore(String string) {
        return KeyStoreUtilFactory.getInstance().isValidWSKeyStore(string);
    }

    public static boolean isHWKeyStore(String string) {
        return KeyStoreUtilFactory.getInstance().isHWKeyStore(string);
    }

    public static Provider getHWCryptoProviderInstance(String string) {
        return KeyStoreUtilFactory.getInstance().getHWCryptoProviderInstance(string);
    }

    public static void returnHWCryptoProviderInstance(String string, Provider provider) {
        KeyStoreUtilFactory.getInstance().returnHWCryptoProviderInstance(string, provider);
    }

    public static File fixPath(String string, String string2) {
        Comparable<StringBuffer> comparable;
        if (tc.isEntryEnabled()) {
            comparable = new StringBuffer("fixPath(");
            ((StringBuffer)comparable).append("String path[").append(string).append("], ");
            ((StringBuffer)comparable).append("String base[").append(string2).append("])");
            Tr.entry(tc, ((StringBuffer)comparable).toString());
        }
        if (!((File)(comparable = new File(string))).isAbsolute()) {
            comparable = string2 != null ? new File(string2, string) : new File(((File)comparable).getAbsolutePath());
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("fixPath(String, String)");
            stringBuffer.append(" returns File[").append(comparable).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return comparable;
    }

    public static KeyStore getKeyStore(String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStore(String keyStoreRef[" + string + "])");
        }
        if (string == null || string.length() == 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s08");
        }
        KeyStore keyStore = ConfigUtil.createKeyStore(null, null, null, string);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getKeyStore(String)");
            stringBuffer.append(" returns KeyStore[");
            stringBuffer.append(keyStore == null ? "null" : "not null");
            stringBuffer.append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return keyStore;
    }

    public static KeyStore getKeyStore(String string, String string2, char[] cArray) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getKeyStore(");
            ((StringBuffer)object).append("String type[").append(string).append("], ");
            ((StringBuffer)object).append("String path[").append(string2).append("], ");
            ((StringBuffer)object).append("char[] storepass[");
            ((StringBuffer)object).append(cArray == null ? "null" : "not null");
            ((StringBuffer)object).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if (cArray == null || cArray.length == 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s03", string2);
        }
        object = ConfigUtil.createKeyStore(string, string2, cArray, null);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getKeyStore(String, String, char[])");
            stringBuffer.append(" returns KeyStore[");
            stringBuffer.append(object == null ? "null" : "not null");
            stringBuffer.append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    private static KeyStore createKeyStore(final String string, final String string2, final char[] cArray, String string3) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("createKeyStore(");
            ((StringBuffer)object).append("String type[").append(string).append("], ");
            ((StringBuffer)object).append("String Path[").append(string2).append("], ");
            ((StringBuffer)object).append("char[] storepass[");
            ((StringBuffer)object).append(cArray == null ? "null" : "not null");
            ((StringBuffer)object).append("], ");
            ((StringBuffer)object).append("String keyStoreRef[").append(string3).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        if (string3 != null && string3.length() != 0) {
            object = KeyStoreUtilFactory.getInstance().getKeyStore(string3);
            if (object == null) {
                Tr.error(tc, "security.wssecurity.ConfigUtil.s29", new Object[]{string3});
                throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s29", string3);
            }
        } else {
            try {
                object = (KeyStore)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        KeyStore keyStore = null;
                        InputStream inputStream = null;
                        try {
                            keyStore = KeyStore.getInstance(string);
                            URL uRL = null;
                            File file = new File(string2);
                            if (file.exists() && file.length() == 0L) {
                                throw new IOException("Keystore file exists, but is empty: " + string2);
                            }
                            uRL = !file.exists() ? new URL(string2) : new URL("file:" + file.getCanonicalPath());
                            inputStream = uRL.openStream();
                            keyStore.load(inputStream, cArray);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Tr.processException(fileNotFoundException, clsName + ".createKeyStore", "277");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s04", new Object[]{string2});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s04", string2);
                        }
                        catch (IOException iOException) {
                            Tr.processException(iOException, clsName + ".createKeyStore", "286");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s05", new Object[]{string2, iOException});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s05", string2, (Throwable)iOException);
                        }
                        catch (CertificateException certificateException) {
                            Tr.processException(certificateException, clsName + ".createKeyStore", "295");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{string2, certificateException.getClass().getName(), certificateException.getMessage(), certificateException});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", string2, certificateException.getClass().getName(), certificateException.getMessage(), certificateException);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            Tr.processException(noSuchAlgorithmException, clsName + ".createKeyStore", "309");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{string2, noSuchAlgorithmException.getClass().getName(), noSuchAlgorithmException.getMessage(), noSuchAlgorithmException});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", string2, noSuchAlgorithmException.getClass().getName(), noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
                        }
                        catch (KeyStoreException keyStoreException) {
                            Tr.processException(keyStoreException, clsName + ".createKeyStore", "323");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{string2, keyStoreException.getClass().getName(), keyStoreException.getMessage(), keyStoreException});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", string2, keyStoreException.getClass().getName(), keyStoreException.getMessage(), keyStoreException);
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        return keyStore;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                Tr.processException(throwable, clsName + ".createKeyStore", "490");
                if (throwable instanceof SoapSecurityException) {
                    throw (SoapSecurityException)throwable;
                }
                throw new SoapSecurityException(throwable);
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".createKeyStore", "497");
                if (exception instanceof SoapSecurityException) {
                    throw (SoapSecurityException)exception;
                }
                throw new SoapSecurityException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("createKeyStore(");
            stringBuffer.append("String, String, char[], String)");
            stringBuffer.append(" returns KeyStore[");
            stringBuffer.append(object == null ? "null" : "not null");
            stringBuffer.append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    public static X509Certificate getX509Certificate(File file, CertificateFactory certificateFactory) throws SoapSecurityException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getX509Certificate(");
            ((StringBuffer)serializable).append("File path[").append(file).append("], ");
            ((StringBuffer)serializable).append("CertificateFactory certificateFactory[").append(certificateFactory).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = null;
        try {
            serializable = (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(file));
        }
        catch (IOException iOException) {
            Tr.processException(iOException, clsName + ".getX509Certificate", "531");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s23", new String[]{file.getAbsolutePath(), iOException.getMessage()});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s23", new String[]{file.getAbsolutePath(), iOException.getMessage()}, (Throwable)iOException);
        }
        catch (CertificateException certificateException) {
            Tr.processException(certificateException, clsName + ".getX509Certificate", "540");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s24", new String[]{file.getAbsolutePath(), certificateException.getMessage()});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s24", new String[]{file.getAbsolutePath(), certificateException.getMessage()}, (Throwable)certificateException);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getCertificate(");
            stringBuffer.append("File, CertificateFactory)");
            stringBuffer.append(" returns X509Certificate[");
            stringBuffer.append(serializable == null ? "null" : ((X509Certificate)serializable).getSubjectX500Principal().getName());
            stringBuffer.append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return serializable;
    }

    public static X509CRL getX509CRL(File file, CertificateFactory certificateFactory) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getX509CRL(");
            ((StringBuffer)object).append("File path[").append(file).append("], ");
            ((StringBuffer)object).append("CertificateFactory certificateFactory[").append(certificateFactory).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        try {
            object = (X509CRL)certificateFactory.generateCRL(new FileInputStream(file));
        }
        catch (IOException iOException) {
            Tr.processException(iOException, clsName + ".getX509CRL", "575");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s25", new Object[]{file.getAbsolutePath(), iOException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s25", file.getAbsolutePath(), (Throwable)iOException);
        }
        catch (CRLException cRLException) {
            Tr.processException(cRLException, clsName + ".getX509CRL", "584");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s26", new Object[]{file.getAbsolutePath(), cRLException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s26", file.getAbsolutePath(), (Throwable)cRLException);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getX509CRL(");
            stringBuffer.append("File, CertificateFactory)");
            stringBuffer.append(" returns X509CRL[");
            stringBuffer.append(object == null ? "null" : ((X509CRL)object).getIssuerX500Principal().getName());
            stringBuffer.append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    public static CertificateFactory createCertificateFactory(String string) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("createCertificateFactory(");
            ((StringBuffer)object).append("String provider[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        try {
            object = string == null || "".equals(string) ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", string);
        }
        catch (CertificateException certificateException) {
            Tr.processException(certificateException, clsName + ".createCertificateFactory", "622");
            Tr.error(tc, "security.wssecurity.CertificateFactory.getInstance", new String[]{"X.509", certificateException.getMessage()});
            throw SoapSecurityException.format("security.wssecurity.CertificateFactory.getInstance", new String[]{"X.509", certificateException.getMessage()}, (Throwable)certificateException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Tr.processException(noSuchProviderException, clsName + ".createCertificateFactory", "626");
            Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s22", new Object[]{string, noSuchProviderException.getMessage()});
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s22", new String[]{string, noSuchProviderException.getMessage()}, (Throwable)noSuchProviderException);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("createCertificateFactory(");
            stringBuffer.append("String)");
            stringBuffer.append(" returns CertificateFactory[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    public static OMDocument mergeDocuments(OMDocument[] oMDocumentArray) throws SoapSecurityException {
        int n;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("mergeDocuments(");
            ((StringBuffer)object).append("OMDocument[] docs { ");
            if (oMDocumentArray == null) {
                ((StringBuffer)object).append("null ");
            } else {
                n = oMDocumentArray.length;
                for (int i = 0; i < n; ++i) {
                    ((StringBuffer)object).append(DOMUtils.getDisplayName(oMDocumentArray[i])).append(", ");
                }
            }
            ((StringBuffer)object).append("}");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = DOMUtil.createDocument();
        OMElement oMElement = object.getOMFactory().createOMElement("root", "", "");
        object.addChild(oMElement);
        if (oMDocumentArray != null) {
            for (n = 0; n < oMDocumentArray.length; ++n) {
                OMElement oMElement2;
                if (oMDocumentArray[n] == null || (oMElement2 = oMDocumentArray[n].getOMDocumentElement()) == null) continue;
                oMElement.addChild(oMElement2);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("mergeDocuments(Document[])");
            stringBuffer.append(" returns Document[").append(DOMUtils.getDisplayName((OMDocument)object)).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    public static Object instantiate(String string, Class clazz, ClassLoader classLoader) throws SoapSecurityException {
        Serializable serializable;
        StringBuffer stringBuffer;
        if (tc.isEntryEnabled()) {
            stringBuffer = new StringBuffer("instantiate(");
            stringBuffer.append("String cls[").append(string).append("], ");
            stringBuffer.append("Class type[").append(clazz).append("], ");
            stringBuffer.append("ClassLoader acl[");
            stringBuffer.append(classLoader == null ? "null" : "not null");
            stringBuffer.append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        stringBuffer = null;
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = (ClassLoader)AccessController.doPrivileged(thisClassLoaderGetter);
        }
        if (tc.isDebugEnabled()) {
            if (classLoader2 != null) {
                Tr.debug(tc, "Classloader: " + classLoader2.getClass().getName());
                Tr.debug(tc, "Classloader dump: " + classLoader2.toString());
            } else {
                Tr.debug(tc, "Classloader: <null>");
            }
        }
        try {
            if (classLoader2 != null) {
                try {
                    serializable = classLoader2.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    serializable = Class.forName(string);
                }
            } else {
                serializable = Class.forName(string);
            }
            if (clazz != null && !clazz.isAssignableFrom((Class<?>)serializable)) {
                throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", string, clazz.getName());
            }
            stringBuffer = ((Class)serializable).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.processException(classNotFoundException, clsName + ".instantiate", "741");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s09", new Object[]{string});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s09", string);
        }
        catch (InstantiationException instantiationException) {
            Tr.processException(instantiationException, clsName + ".instantiate", "745");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{string});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s10", string);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.processException(illegalAccessException, clsName + ".instantiate", "749");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s11", new Object[]{string});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s11", string);
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("instantiate(");
            ((StringBuffer)serializable).append("String, Class, ClassLoader)");
            ((StringBuffer)serializable).append(" returns Object[").append((Object)stringBuffer).append("]");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
        return stringBuffer;
    }

    public static Initializable instantiate(String string, Class clazz, Map<Object, Object> map, ClassLoader classLoader) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("instantiate(");
            ((StringBuffer)object).append("String cls[").append(string).append("], ");
            ((StringBuffer)object).append("Class type[").append(clazz).append("], ");
            ((StringBuffer)object).append("Map map, ");
            ((StringBuffer)object).append("ClassLoader acl[");
            ((StringBuffer)object).append(classLoader == null ? "null" : "not null");
            ((StringBuffer)object).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = (Initializable)ConfigUtil.instantiate(string, clazz, classLoader);
        object.init(map);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("instantiate(");
            stringBuffer.append("String, Class, Map, ClassLoader)");
            stringBuffer.append(" returns Initializable[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    public static void getProperties(Map<Object, Object> map, OMElement oMElement) throws SoapSecurityException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getProperties(");
            ((StringBuffer)serializable).append("Map properties, ");
            ((StringBuffer)serializable).append("OMElement parent[");
            ((StringBuffer)serializable).append(DOMUtils.getDisplayName(oMElement));
            ((StringBuffer)serializable).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = DOMUtil.getChildElements(oMElement, Constants0.NS_CONFIG, "Property");
        OMElement oMElement2 = null;
        for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
            oMElement2 = (OMElement)((ArrayList)serializable).get(i);
            String string = DOMUtil.getAttribute(oMElement2, "name");
            String string2 = DOMUtil.getAttribute(oMElement2, "value");
            map.put(string, string2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added a property (Name [" + string + "], Value [" + string2 + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties(Map, Element)");
        }
    }

    public static Map<Object, Object> getProperties(OMElement oMElement) throws SoapSecurityException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getProperties(");
            ((StringBuffer)serializable).append("OMElement parent[");
            ((StringBuffer)serializable).append(DOMUtils.getDisplayName(oMElement));
            ((StringBuffer)serializable).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = DOMUtil.getChildElements(oMElement, Constants0.NS_CONFIG, "Property");
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        OMElement oMElement2 = null;
        for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
            oMElement2 = (OMElement)((ArrayList)serializable).get(i);
            String string = DOMUtil.getAttribute(oMElement2, "name");
            String string2 = DOMUtil.getAttribute(oMElement2, "value");
            hashMap.put(string, string2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added a property (Name [" + string + "], Value [" + string2 + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties(Element) returns Map[not null]");
        }
        return hashMap;
    }

    public static String getMessage(String string) {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getMessage(");
            ((StringBuffer)charSequence).append("String key[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = string;
        if (_MessageCatalog.instance != null) {
            try {
                charSequence = _MessageCatalog.instance.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception", new Object[]{missingResourceException});
                }
                Tr.processException(missingResourceException, ConfigUtil.class.getName() + ".getMessage", "871");
                charSequence = string;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getMessage(String)");
            stringBuffer.append("returns String [").append((String)charSequence).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return charSequence;
    }

    public static String getMessage(String string, String[] stringArray) {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getMessage(");
            ((StringBuffer)charSequence).append("String key[").append(string).append("], ");
            ((StringBuffer)charSequence).append("String[] args { ");
            if (stringArray == null) {
                ((StringBuffer)charSequence).append("null ");
            } else {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    ((StringBuffer)charSequence).append(stringArray[i]).append(", ");
                }
            }
            ((StringBuffer)charSequence).append(" })");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = ConfigUtil.getMessage(string);
        if (stringArray != null && stringArray.length > 0) {
            charSequence = MessageFormat.format((String)charSequence, stringArray);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getMessage(String, String[])");
            stringBuffer.append("returns String [").append((String)charSequence).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return charSequence;
    }

    public static int isIntegralWASDialect(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isIntegralWASDialect(");
            stringBuffer.append("String keyword[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < IntegralDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!string.equals(IntegralDialectElementSelector.WASDIALECTS[i])) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isIntegralWASDialect(String)");
            stringBuffer.append("returns int [").append(n).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return n;
    }

    public static int isConfidentialWASDialect(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isConfidentialWASDialect(");
            stringBuffer.append("String keyword[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < ConfidentialDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!string.equals(ConfidentialDialectElementSelector.WASDIALECTS[i])) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isConfidentialWASDialect(String)");
            stringBuffer.append("returns int [").append(n).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return n;
    }

    public static int isTimestampWASDialect(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isTimestampWASDialect(");
            stringBuffer.append("String keyword[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < TimestampDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!string.equals(TimestampDialectElementSelector.WASDIALECTS[i])) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isTimestampWASDialect(String)");
            stringBuffer.append("returns int [").append(n).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return n;
    }

    public static int isUsage(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsage(");
            stringBuffer.append("String usage[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < USAGE_VALUES.length; ++i) {
                if (!USAGE_VALUES[i].equalsIgnoreCase(string)) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsage(String)");
            stringBuffer.append("returns int [").append(n).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return n;
    }

    public static boolean isUsageRequired(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageRequired(");
            stringBuffer.append("String usage[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[0].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageRequired(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isUsageOptional(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageOptional(");
            stringBuffer.append("String usage[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[1].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageOptional(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isUsageRejected(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageRejected(");
            stringBuffer.append("String usage[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[2].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageRejected(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isUsageObserved(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageObserved(");
            stringBuffer.append("String usage[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[3].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageObserved(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isUsageIgnored(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageIgnored(");
            stringBuffer.append("String usage[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[4].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isUsageIgonored(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static int isKeyInfoType(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoType(");
            stringBuffer.append("String type[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < KEYINFO_TYPES.length; ++i) {
                if (!KEYINFO_TYPES[i].equalsIgnoreCase(string)) continue;
                n = i;
                break;
            }
            if (n == 3) {
                n = -1;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoType(String)");
            stringBuffer.append("returns int [").append(n).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return n;
    }

    public static boolean isKeyInfoStrref(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoStrref(");
            stringBuffer.append("String type[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[0].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoStrref(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isKeyInfoEmb(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoEmb(");
            stringBuffer.append("String type[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[1].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoEmb(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isKeyInfoKeyid(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoKeyid(");
            stringBuffer.append("String type[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[2].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoKeyid(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isKeyInfoKeyname(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoKeyname(");
            stringBuffer.append("String type[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[3].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoKeyname(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isKeyInfoX509issuer(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoX509issuer(");
            stringBuffer.append("String type[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[4].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoX509issuer(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isKeyInfoThumbprint(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoThumbprint(");
            stringBuffer.append("String type[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[5].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isKeyInfoThumbprint(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isC14nTransform(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isC14nTransform(");
            stringBuffer.append("String algorithm[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = C14N_TRANSFORMS.contains(string);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isC14nTransform(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isDOMRequiredTransform(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isDOMRequiredTransform(");
            stringBuffer.append("String algorithm[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = DOMREQUIRED_TRANSFORMS.contains(string);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isDOMRequiredTransform(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static boolean isSecretKeyAlgorithm(String string) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isSecretKeyAlgorithm(");
            stringBuffer.append("String algorithm[").append(string).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        if (string != null) {
            bl = SECRETKEY_ALGORITHMS.contains(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isSecretKeyAlgorithm(String)");
            stringBuffer.append("returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    public static int getMinimumPosition(List<ReferencePartConfig> list, List<SigningReferenceConfig> list2) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getMinimumPosition(");
            stringBuffer.append("List order[").append(list).append("], ");
            stringBuffer.append("List references[").append(list2).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = 10000;
        for (SigningReferenceConfig object : list2) {
            int n2 = ConfigUtil.getPosition(list, object.getReference());
            if (n2 >= n) continue;
            n = n2;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getMinimumPosition(List, List)");
            stringBuffer.append("returns int [").append(n).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return n;
    }

    public static int getPosition(List<ReferencePartConfig> list, ReferencePartConfig referencePartConfig) {
        Object object;
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getPosition(");
            stringBuffer.append("List order[").append(list).append("], ");
            stringBuffer.append("ReferencePartConfig reference[").append(referencePartConfig).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = 0;
        Iterator<ReferencePartConfig> iterator = list.iterator();
        while (iterator.hasNext() && !(object = iterator.next()).equals(referencePartConfig)) {
            if (!iterator.hasNext()) continue;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getPosition(List, ReferencePartConfig)");
            ((StringBuffer)object).append("returns int [").append(n).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return n;
    }

    public static void insertGenerator(List<Configuration> list, List<ReferencePartConfig> list2, int n, Configuration configuration) {
        Object object;
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("insertGenerator(");
            stringBuffer.append("List operationGenerators[").append(list).append("], ");
            stringBuffer.append("List order[").append(list2).append("], ");
            stringBuffer.append("int orderNumber[").append(n).append("], ");
            stringBuffer.append("Configuration config)");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n2 = 0;
        Iterator<Configuration> iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            object = iterator.next();
            int n3 = 0;
            if (object instanceof EncryptionGeneratorConfig) {
                n3 = ConfigUtil.getPosition(list2, ((EncryptionGeneratorConfig)object).getReference());
            } else if (object instanceof SignatureGeneratorConfig) {
                n3 = ConfigUtil.getMinimumPosition(list2, ((SignatureGeneratorConfig)object).getReferences());
            }
            if (n3 > n) {
                list.add(n2, configuration);
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            list.add(configuration);
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("insertGenerator(");
            ((StringBuffer)object).append("List, List, int, Configuration)");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
    }

    public static String trim(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.trim();
        }
        return string2;
    }

    public static String expandInstallLocation(String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("expandInstallLocation(");
            ((StringBuffer)object).append("String algorithm[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = VariableExpanderFactory.getVariableExpander();
        String string2 = object.expand(ConfigUtil.trim(string));
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("expandInstallLocation(String)");
            stringBuffer.append("returns String [").append(string2).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return string2;
    }

    public static WSSGeneratorConfig getGeneratorConfig(Map<Object, Object> map) {
        return (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
    }

    public static WSSConsumerConfig getConsumerConfig(Map<Object, Object> map) {
        return (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
    }

    public static boolean shouldUseStandardFaultCodes(Map<Object, Object> map) {
        WSSConsumerConfig wSSConsumerConfig;
        boolean bl;
        boolean bl2 = bl = false;
        if (map != null && (wSSConsumerConfig = ConfigUtil.getConsumerConfig(map)) != null) {
            bl2 = wSSConsumerConfig.getUseStandardFaultCodes();
        }
        return bl2;
    }

    static {
        C14N_TRANSFORMS.add("http://www.w3.org/2001/10/xml-exc-c14n#");
        C14N_TRANSFORMS.add("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        C14N_TRANSFORMS.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        C14N_TRANSFORMS.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DOMREQUIRED_TRANSFORMS = new HashSet<String>();
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2002/06/xmldsig-filter2");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/TR/1999/REC-xslt-19991116");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2002/07/decrypt#XML");
        SECRETKEY_ALGORITHMS = new HashSet<String>();
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-tripledes");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes128");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes192");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes256");
    }

    private static class _MessageCatalog {
        private static final TraceComponent tc1 = Tr.register(_MessageCatalog.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        private static ResourceBundle instance;

        private _MessageCatalog() {
        }

        private static void init() {
            block5: {
                if (tc1.isEntryEnabled()) {
                    Tr.entry(tc1, "init()");
                }
                try {
                    instance = ResourceBundle.getBundle("com.ibm.ws.wssecurity.resources.wssmessages");
                    if (tc1.isDebugEnabled()) {
                        Tr.debug(tc1, "Initialize resource bundle: com.ibm.ws.wssecurity.resources.wssmessages");
                    }
                }
                catch (Throwable throwable) {
                    instance = null;
                    Tr.processException(throwable, _MessageCatalog.class.getName(), "1532");
                    Tr.warning(tc1, "security.wssecurity.cannot.load.resource", new Object[]{throwable});
                    if (!tc1.isDebugEnabled()) break block5;
                    Tr.debug(tc1, "Failed to initialize resource bundle: com.ibm.ws.wssecurity.resources.wssmessages");
                }
            }
            if (tc1.isEntryEnabled()) {
                Tr.exit(tc1, "init()");
            }
        }

        static {
            _MessageCatalog.init();
        }
    }
}

