/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Parameters;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Properties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigConstants {
    public static final String TR_GROUP = "Web Services Security";
    public static final String TR_NLSPROPS = "com.ibm.ws.wssecurity.resources.wssmessages";
    public static final String WS_SECURITY_RESOURCE_NAME = "ws-security.xml";
    public static final String WS_SECURITY_DEFAULT_LOCATION = "${USER_INSTALL_ROOT}/properties/ws-security.xml";
    public static final String WS_SECURITY_LOCATION_PROPERTY = "wssecurity.defaultbindings.location";
    public static final String WS_INITIAL_SENDER_ID = "wssecurity.initial.sender.id";
    public static final String BASICAUTH_NONCE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce";
    public static final String BASICAUTH_NONCE_TIMESTAMP = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp";
    public static final String BASICAUTH_NONCE_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.NonceRequired";
    public static final String BASICAUTH_NONCE_TIMESTAMP_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestampRequired";
    public static final String BASICAUTH_NONCE_MAX_AGE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge";
    public static final String BASICAUTH_NONCE_CLOCK_SKEW = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew";
    public static final String BASICAUTH_NONCE_CACHE_USED = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.useCache";
    public static final String BASICAUTH_NONCE_CACHE_NAME = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName";
    public static final String BASICAUTH_NONCE_CACHE_SIZE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize";
    public static final String BASICAUTH_NONCE_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout";
    public static final String BASICAUTH_NONCE_LENGTH = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.length";
    public static final String CERTIFICATE_CACHE_USED = "com.ibm.ws.wssecurity.config.token.certificate.useCache";
    public static final String CERTIFICATE_CACHE_NAME = "com.ibm.ws.wssecurity.config.token.certificate.cacheName";
    public static final String CERTIFICATE_CACHE_SIZE = "com.ibm.ws.wssecurity.config.token.certificate.cacheSize";
    public static final String CERTIFICATE_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout";
    public static final String DISTRIBUTED_CONFIG_CACHE_USED = "com.ibm.ws.wssecurity.handler.useConfigCache";
    public static final String CONFIG_CACHENAME = "com.ibm.ws.wssecurity.handler.configCacheName";
    public static final String DISTRIBUTED_CONFIG_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.configCacheSize";
    public static final String DISTRIBUTED_CONFIG_CACHE_TIMETOLIVE = "com.ibm.ws.wssecurity.handler.configCacheTimeToLive";
    public static final String TOKEN_CACHE_USED = "com.ibm.ws.wssecurity.handler.token.useCache";
    public static final String TOKEN_CACHE_NAME = "com.ibm.ws.wssecurity.handler.token.cacheName";
    public static final String TOKEN_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.token.cacheSize";
    public static final String TOKEN_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.handler.token.cacheTimeout";
    public static final String TOKEN_CACHE_CUSHION = "com.ibm.ws.wssecurity.handler.token.cushion";
    public static final boolean DEFAULT_DISTRIBUTED_CONFIG_CACHE_USED = true;
    public static final String DEFAULT_CONFIG_CACHENAME = "WSSReqGeneratorConfigMap";
    public static final int DEFAULT_DISTRIBUTED_CONFIG_CACHE_SIZE = 128;
    public static final int DEFAULT_DISTRIBUTED_CONFIG_CACHE_TIMETOLIVE = 900;
    public static final String WSSREQGEN_CONFIG_KEY = "com.ibm.ws.wssecurity.handler.GenConfigCacheKey";
    public static final String WSSRESCON_CONFIG_KEY = "com.ibm.ws.wssecurity.handler.ConConfigCacheKey";
    public static final String OFFLOAD_ALL_CRYPTO = "com.ibm.ws.wssecurity.handler.OffloadAllCryptography";
    public static final String OFFLOAD_RSA_PUBKEY_CRYPTO = "com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography";
    public static final String HARDWARE_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.hardwareCacheSize";
    public static final int DEFAULT_HARDWARE_CACHE_SIZE = 1000;
    public static final String HARDWARE_CACHE_ENTRY_REFRESH = "com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours";
    public static final int DEFAULT_HARDWARE_CACHE_ENTRY_REFRESH = 8;
    public static final boolean DEFAULT_NONCE_CACHEUSED = true;
    public static final String DEFAULT_NONCE_CACHENAME = "NonceDistributionCacheMap";
    public static final int DEFAULT_NONCE_CACHESIZE = 1024;
    public static final int MIN_NONCE_CACHESIZE = 16;
    public static final int DEFAULT_NONCE_CACHETIMEOUT = 600;
    public static final int MIN_NONCE_CACHETIMEOUT = 300;
    public static final int DEFAULT_NONCE_LENGTH = 128;
    public static final int MIN_NONCE_LENGTH = 16;
    public static final int DEFAULT_NONCE_MAXAGE = 300;
    public static final int MIN_NONCE_MAXAGE = 300;
    public static final int DEFAULT_NONCE_CLOCKSKEW = 0;
    public static final int MIN_NONCE_CLOCKSKEW = 0;
    public static final boolean DEFAULT_NONCE_DISTRIBUTED = false;
    public static final boolean DEFAULT_CERT_CACHEUSED = true;
    public static final String DEFAULT_CERT_CACHENAME = "WSSCertCache";
    public static final int DEFAULT_CERT_CACHESIZE = 128;
    public static final int MIN_CERT_CACHESIZE = 16;
    public static final int DEFAULT_CERT_CACHETIMEOUT = 900;
    public static final int MIN_CERT_CACHETIMEOUT = 300;
    public static final boolean DEFAULT_TOKEN_CACHEUSED = true;
    public static final String DEFAULT_TOKEN_CACHENAME = "WSSTokenCache";
    public static final int DEFAULT_TOKEN_CACHESIZE = 128;
    public static final int MIN_TOKEN_CACHESIZE = 16;
    public static final int DEFAULT_TOKEN_CACHETIMEOUT = 900;
    public static final int MIN_TOKEN_CACHETIMEOUT = 300;
    public static final int DEFAULT_TOKEN_CUSHION = 600;
    public static final int MIN_TOKEN_CUSHION = 300;
    public static final int DEFAULT_TIMESTAMP_TIMEOUT = 600;
    public static final int MIN_TIMESTAMP_TIMEOUT = 300;
    public static final int DEFAULT_TIMESTAMP_MAXAGE = 300;
    public static final int MIN_TIMESTAMP_MAXAGE = 300;
    public static final int DEFAULT_TIMESTAMP_CLOCKSKEW = 180;
    public static final int MIN_TIMESTAMP_CLOCKSKEW = 0;
    public static final long MIN_SC_CACHE_CUSHION = 180000L;
    public static final long DEFAULT_SC_CACHE_CUSHION = 600000L;
    public static final long DEFAULT_SC_CACHE_EXTRA_TIME = 600000L;
    public static final long DEFAULT_SCT_CLOCKSKEW = 180000L;
    public static final long MAX_SCT_CLOCKSKEW = 600000L;
    public static final String WSSE_NS = "com.ibm.ws.wssecurity.config.WSSE.Namespace";
    public static final String DEFAULT_CONFIG_REF = "DEFAULT";
    public static final String LOCALTEST_MODE = "com.ibm.ws.wssecurity.config.localtest.on";
    private static final TraceComponent tc = Tr.register(ConfigConstants.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static String getMessage(String string) {
        return ConfigUtil.getMessage(string);
    }

    public static Map<Object, Object> getProperties(List list, VariableExpander variableExpander) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(List, VariableExpander):", new Object[]{list, variableExpander});
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        ConfigConstants.getProperties(hashMap, list, variableExpander);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(List, VariableExpander)");
        }
        return hashMap;
    }

    public static void getProperties(Map<Object, Object> map, List list, VariableExpander variableExpander) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(Map, List, VariableExpander):", new Object[]{map, list, variableExpander});
        }
        if (map != null && list != null && !list.isEmpty()) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string;
                Object object;
                Object e = list.get(i);
                if (e instanceof Properties) {
                    object = (Properties)e;
                    string = variableExpander.expand(((Properties)object).getValue());
                    map.put(((Properties)object).getName(), string);
                    continue;
                }
                if (e instanceof Parameters) {
                    object = (Parameters)e;
                    string = variableExpander.expand(((Parameters)object).getValue());
                    map.put(((Parameters)object).getName(), string);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.exit(tc, "Property type not recognized");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(Map, List, VariableExpander)");
        }
    }

    public static int validNonceCacheTimeout(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceCacheTimeout(int):", new Object[]{n});
        }
        if ((n2 = n) < 300) {
            Tr.warning(tc, "security.wssecurity.WSEC0116W", new Object[]{n2, 300});
            n2 = 300;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceCacheTimeout(int) returns " + n2);
        }
        return n2;
    }

    private static int validNonceMaxAge(int n, int n2) {
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceMaxAge(int, int):", new Object[]{n, n2});
        }
        if ((n3 = n) < 300 || n3 > n2) {
            Tr.warning(tc, "security.wssecurity.WSEC0118W", new Object[]{n3, 300, n2, 300});
            n3 = 300;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceMaxAge(int, int) returns " + n3);
        }
        return n3;
    }

    private static int validNonceClockSkew(int n, int n2) {
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceClockSkew(int, int):", new Object[]{n, n2});
        }
        if ((n3 = n) < 0 || n3 > n2) {
            Tr.warning(tc, "security.wssecurity.WSEC0119W", new Object[]{n3, 0, n2, 0});
            n3 = 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceClockSkew(int, int) returns " + n3);
        }
        return n3;
    }

    private static int validNonceCacheSize(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceCacheSize(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 16) {
            Tr.warning(tc, "security.wssecurity.WSEC0124W", new Object[]{n2, 16, 1024});
            n2 = 1024;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceCacheSize(int) returns " + n2);
        }
        return n2;
    }

    private static int validNonceLength(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceLength(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 16) {
            Tr.warning(tc, "security.wssecurity.WSEC0127W", new Object[]{n2, 16, 128});
            n2 = 128;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceLength(int) returns " + n2);
        }
        return n2;
    }

    public static int processNonceMaxAge(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceMaxAge(String, int):", new Object[]{string, new Integer(n)});
        }
        int n2 = 300;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n3 = Integer.parseInt(string);
                n2 = ConfigConstants.validNonceMaxAge(n3, n);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 300;
                Tr.processException(numberFormatException, ConfigConstants.class.getName() + ".processNonceMaxAge", "692");
                Tr.warning(tc, "security.wssecurity.WSEC0117W", new Object[]{string, 300});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceMaxAge(String, int) returns " + n2);
        }
        return n2;
    }

    public static int processNonceClockSkew(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceClockSkew(String, int):", new Object[]{string, new Integer(n)});
        }
        int n2 = 0;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n3 = Integer.parseInt(string);
                n2 = ConfigConstants.validNonceClockSkew(n3, n);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
                Tr.processException(numberFormatException, ConfigConstants.class.getName() + ".processNonceClockSkew", "720");
                Tr.warning(tc, "security.wssecurity.WSEC0120W", new Object[]{string, 0});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceClockSkew(String, int) returns " + n2);
        }
        return n2;
    }

    public static int processNonceCacheSize(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceCacheSize(String):", new Object[]{string});
        }
        int n = 1024;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n2 = Integer.parseInt(string);
                n = ConfigConstants.validNonceCacheSize(n2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 1024;
                Tr.processException(numberFormatException, ConfigConstants.class.getName() + ".processNonceCacheSize", "748");
                Tr.warning(tc, "security.wssecurity.WSEC6823W", new Object[]{string, 1024});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceCacheSize(String) returns " + n);
        }
        return n;
    }

    public static int processNonceLength(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceLength(String):", new Object[]{string});
        }
        int n = 128;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n2 = Integer.parseInt(string);
                n = ConfigConstants.validNonceLength(n2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 128;
                Tr.processException(numberFormatException, ConfigConstants.class.getName() + ".processNonceLength", "779");
                Tr.warning(tc, "security.wssecurity.WSEC6824W", new Object[]{string, 1024});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceLength(String) returns " + n);
        }
        return n;
    }

    public static int validCertCacheTimeout(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validCertCacheTimeout(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 300) {
            n2 = 300;
            Tr.warning(tc, "security.wssecurity.WSEC6825W", new Object[]{n2, 300});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validCertCacheTimeout(int) returns " + n2);
        }
        return n2;
    }

    public static int validCertCacheSize(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validCertCacheSize(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 16) {
            n2 = 128;
            Tr.warning(tc, "security.wssecurity.WSEC6826W", new Object[]{n2, 16, 128});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validCertCacheSize(int) returns " + n2);
        }
        return n2;
    }

    public static int processCertCacheSize(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processCertCacheSize(String):", new Object[]{string});
        }
        int n = 128;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n2 = Integer.parseInt(string);
                n = ConfigConstants.validCertCacheSize(n2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 128;
                Tr.processException(numberFormatException, ConfigConstants.class.getName() + ".processCertCacheSize", "856");
                Tr.warning(tc, "security.wssecurity.WSEC6827W", new Object[]{string, 128});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processCertCacheSize(String) returns " + n);
        }
        return n;
    }

    public static long processHardwareCacheEntryRefresh(String string) {
        long l;
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processHardwareCacheEntryRefresh(String):", new Object[]{string});
            }
            l = 0L;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n = Integer.parseInt(string);
                    if (n >= 0) {
                        l = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    l = 0L;
                    FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processHardwareCacheEntryRefresh", "1147");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the hardware cache refresh time" + string + ", cache entry refresh disabled.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processHardwareCacheEntryRefresh(String) returns " + l);
        }
        return l;
    }

    public static int processHardwareCacheSize(String string) {
        int n;
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processHardwareCacheSize(String):", new Object[]{string});
            }
            n = 1000;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 >= 0) {
                        n = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n = 1000;
                    Tr.processException(numberFormatException, ConfigConstants.class.getName() + ".processHardwareCacheSize", "%C");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the hardware cache size" + string + ", default value " + 1000 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processHardwareCacheSize(String) returns " + n);
        }
        return n;
    }

    public static int validTokenCacheTimeout(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTokenCacheTimeout(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 300) {
            n2 = 300;
            Tr.warning(tc, "security.wssecurity.WSEC6828W", new Object[]{n2, 300});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTokenCacheTimeout(int) returns " + n2);
        }
        return n2;
    }

    public static int validTokenCacheSize(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTokenCacheSize(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 16) {
            n2 = 128;
            Tr.warning(tc, "security.wssecurity.WSEC6829W", new Object[]{n2, 16, 128});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTokenCacheSize(int) returns " + n2);
        }
        return n2;
    }

    public static int processTokenCacheSize(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTokenCacheSize(String):", new Object[]{string});
        }
        int n = 128;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n2 = Integer.parseInt(string);
                n = ConfigConstants.validTokenCacheSize(n2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 128;
                Tr.processException(numberFormatException, ConfigConstants.class.getName() + ".processTokenCacheSize", "966");
                Tr.warning(tc, "security.wssecurity.WSEC6830W", new Object[]{string, 128});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTokenCacheSize(String) returns " + n);
        }
        return n;
    }

    public static long validTokenCushion(long l) {
        long l2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validTokenCushion(long cushion = " + l + ")");
        }
        if ((l2 = l) < 300000L) {
            l2 = 300000L;
            Tr.warning(tc, "security.wssecurity.WSEC6831W", new Object[]{l, l2});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validTokenCushion(long) returns " + l2);
        }
        return l2;
    }

    public static int validTimestampTimeout(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampTimeout(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 300) {
            Tr.warning(tc, "security.wssecurity.WSEC0139W", new Object[]{n2, 300});
            n2 = 300;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampTimeout(int) returns " + n2);
        }
        return n2;
    }

    private static int validTimestampMaxAge(int n, int n2) {
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampMaxAge(int, int):", new Object[]{new Integer(n), new Integer(n2)});
        }
        if ((n3 = n) < 300 || n3 > n2) {
            Tr.warning(tc, "security.wssecurity.WSEC0141W", new Object[]{n3, 300, n2, 300});
            n3 = 300;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampMaxAge(int, int) returns " + n3);
        }
        return n3;
    }

    private static int validTimestampClockSkew(int n, int n2) {
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampClockSkew(int, int):", new Object[]{new Integer(n), new Integer(n2)});
        }
        if ((n3 = n) < 0 || n3 > n2) {
            Tr.warning(tc, "security.wssecurity.WSEC0142W", new Object[]{n3, 0, n2, 0});
            n3 = 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampClockSkew(int, int) returns " + n3);
        }
        return n3;
    }

    public static int processTimestampMaxAge(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTimestampMaxAge(String, int):", new Object[]{string, new Integer(n)});
        }
        int n2 = 300;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n3 = Integer.parseInt(string);
                n2 = ConfigConstants.validTimestampMaxAge(n3, n);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 300;
                Tr.processException(numberFormatException, ConfigConstants.class.getName() + ".processTimestampMaxAge", "947");
                Tr.warning(tc, "security.wssecurity.WSEC0140W", new Object[]{string, 300});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTimestampMaxAge(String, int) returns " + n2);
        }
        return n2;
    }

    public static int processTimestampClockSkew(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTimestampClockSkew(String, int):", new Object[]{string, new Integer(n)});
        }
        int n2 = 180;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n3 = Integer.parseInt(string);
                n2 = ConfigConstants.validTimestampClockSkew(n3, n);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 180;
                Tr.processException(numberFormatException, ConfigConstants.class.getName() + ".processTimestampClockSkew", "975");
                Tr.warning(tc, "security.wssecurity.WSEC0143W", new Object[]{string, 180});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTimestampClockSkew(String, int) returns " + n2);
        }
        return n2;
    }

    public static String getWSSENS(MessageContext messageContext) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSENS(MessageContext)");
        }
        if ((string = (String)messageContext.getProperty("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace")) == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSSE namespace found in MessageContext, use default");
            }
            string = Constants.NS_WSSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSENS(MessageContext) returns " + string);
        }
        return string;
    }

    public static String getWSUNS(MessageContext messageContext) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSUNS(MessageContext)");
        }
        if ((string = (String)messageContext.getProperty("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace")) == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSU namespace found in MessageContext, use default");
            }
            string = Constants.NS_WSU;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSUNS(SOAPMessageContext) returns " + string);
        }
        return string;
    }
}

