/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfidentialDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(ConfidentialDialectElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    public static final int BODYCONTENT = 0;
    public static final int USERNAMETOKEN = 1;
    public static final int DIGESTVALUE = 2;
    public static final int SIGNATURE = 3;
    public static final int WSCONTEXTCONTENT = 4;
    public static final int TIMESTAMP = 5;
    public static final int SIGNATURECONFIRMATION = 6;
    public static final String[] WASDIALECTS = new String[]{"bodycontent".intern(), "usernametoken".intern(), "digestvalue".intern(), "signature".intern(), "wscontextcontent".intern(), "timestamp".intern(), "signatureconfirmation".intern()};

    @Override
    public void init(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(Node node[" + DOMUtils.getDisplayName(oMNode) + "], Map context)");
        }
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String string = (String)map.get("com.ibm.ws.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + string + "]");
        }
        if (string == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s01");
        }
        if (!Constants.DIALECT_WAS.equals(string)) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string);
        }
        String string2 = (String)map.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keyword [" + string2 + "]");
        }
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object object = map.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean bl = "encryption_mode".equals((String)object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + object + "]");
        }
        String string3 = (String)map.get("com.ibm.ws.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + string3 + "]");
        }
        Object[] objectArray = (Object[])map.get("com.ibm.ws.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + objectArray + "]");
        }
        Collection collection = (Collection)map.get("com.ibm.ws.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token configurations [" + collection + "]");
        }
        NonceManager nonceManager = (NonceManager)map.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        object = map.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int n = 0;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string4 = Constants.NAMESPACES[2][n];
        object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        n = 0;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string5 = Constants.NAMESPACES[0][n];
        String string6 = Constants.NAMESPACES[1][n];
        OMDocument oMDocument = com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil.getOwnerDocument(oMNode);
        OMElement oMElement = oMDocument.getOMDocumentElement();
        ArrayList arrayList = null;
        if (WASDIALECTS[0].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[0] + "]");
            }
            arrayList = new ArrayList<OMNode>();
            OMElement oMElement2 = null;
            try {
                oMElement2 = oMElement instanceof SOAPEnvelope ? ((SOAPEnvelope)oMElement).getBody() : DOMUtil.getOneChildElement(oMElement, string4, "Body");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception from SOAPEnvelope.getBody()" + exception);
                }
                Tr.processException((Throwable)exception, this.getClass().getName() + ".getElements", "194", this);
                throw new SoapSecurityException(exception);
            }
            ((ArrayList)arrayList).add((OMNode)oMElement2);
            arrayList = new PartList("http://www.w3.org/2001/04/xmlenc#Content", arrayList);
        } else if (WASDIALECTS[1].equals(string2)) {
            OMElement oMElement3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[1] + "]");
            }
            if ((oMElement3 = IntegralDialectElementSelector.getSecurityHeader(map, oMDocument)) != null) {
                arrayList = DOMUtils.getChildElements(oMElement3, string5, "UsernameToken");
            }
            arrayList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", arrayList);
        } else if (WASDIALECTS[2].equals(string2)) {
            OMElement oMElement4;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[2] + "]");
            }
            if ((oMElement4 = IntegralDialectElementSelector.getSecurityHeader(map, oMDocument)) != null) {
                arrayList = DOMUtils.getChildElements(oMElement4, Constants.NS_DSIG, "DigestValue");
            }
            arrayList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", arrayList);
        } else if (WASDIALECTS[3].equals(string2)) {
            OMElement oMElement5;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[3] + "]");
            }
            if ((oMElement5 = IntegralDialectElementSelector.getSecurityHeader(map, oMDocument)) != null) {
                arrayList = DOMUtils.getChildElements(oMElement5, Constants.NS_DSIG, "Signature");
            }
            arrayList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", arrayList);
        } else if (WASDIALECTS[5].equals(string2)) {
            OMElement oMElement6;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[5] + "]");
            }
            if ((oMElement6 = IntegralDialectElementSelector.getSecurityHeader(map, oMDocument)) != null) {
                arrayList = DOMUtils.getChildElements(oMElement6, Constants.NS_WSU, "Timestamp");
            }
            arrayList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", arrayList);
        } else if (WASDIALECTS[6].equals(string2)) {
            OMElement oMElement7;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[6] + "]");
            }
            if ((oMElement7 = IntegralDialectElementSelector.getSecurityHeader(map, oMDocument)) != null) {
                arrayList = DOMUtils.getChildElements(oMElement7, Constants.NS_WSSE11, "SignatureConfirmation");
            }
            arrayList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", arrayList);
        } else if (WASDIALECTS[4].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[4] + "]");
            }
            arrayList = IntegralDialectElementSelector.getWSContextHeaderElement(oMDocument);
            arrayList = new PartList("http://www.w3.org/2001/04/xmlenc#Content", arrayList);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s03", string2);
        }
        if (string3 != null && bl && (arrayList = IntegralDialectElementSelector.postprocess(oMDocument, string3, arrayList, objectArray, string5, string6, nonceManager, false, bl, string, string2)) != null && ((ArrayList)arrayList).size() > 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode, Map) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }
}

