/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.axiom.om.OMElement;

public class CertificateUtil {
    private static final TraceComponent tc = Tr.register(CertificateUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CertificateUtil.class.getName();
    public static final int ENCIPHERMENT = 0;
    public static final int SIGNATURE = 1;
    private static final String[] KEY_USAGE = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};

    public static boolean isUsedFor(Certificate certificate, int n) {
        boolean[] blArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsedFor(" + certificate + ", " + n + ")");
        }
        boolean bl = true;
        if (certificate != null && "X.509".equals(certificate.getType()) && (blArray = ((X509Certificate)certificate).getKeyUsage()) != null) {
            switch (n) {
                case 0: {
                    bl = blArray.length > 3 && blArray[2] && blArray[3];
                    break;
                }
                case 1: {
                    bl = blArray.length > 0 && blArray[0];
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown usage type: " + n);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsedFor(Certificate cert, int type) returns " + bl);
        }
        return bl;
    }

    public static String keyUsageToString(Certificate certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyUsageToString(" + certificate + ")");
        }
        String string = null;
        if (certificate != null && "X.509".equals(certificate.getType())) {
            string = CertificateUtil.keyUsageToString(((X509Certificate)certificate).getKeyUsage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyUsageToString(Certificate cert) returns " + string);
        }
        return string;
    }

    public static String keyUsageToString(boolean[] blArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyUsageToString(" + blArray + ")");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < KEY_USAGE.length && i < blArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(KEY_USAGE[i]);
            stringBuffer.append('=');
            stringBuffer.append(blArray[i]);
        }
        stringBuffer.append('}');
        String string = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyUsageToString(boolean[] usage) returns " + string);
        }
        return string;
    }

    public static X509DataUtil[] getX509Data(OMElement oMElement) throws XSignatureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509Data(" + oMElement + ")");
        }
        X509DataUtil[] x509DataUtilArray = null;
        try {
            KeyInfo keyInfo = CertificateUtil.getKeyInfo(oMElement);
            KeyInfo.X509Data[] x509DataArray = keyInfo.getX509Data();
            if (x509DataArray == null || x509DataArray.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            Key key = keyInfo.getKeyValue();
            x509DataUtilArray = new X509DataUtil[x509DataArray.length];
            for (int i = 0; i < x509DataArray.length; ++i) {
                x509DataUtilArray[i] = new X509DataUtil(x509DataArray[i], key);
            }
        }
        catch (SignatureStructureException signatureStructureException) {
            throw new XSignatureException(signatureStructureException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509Data(Element signature) returns " + x509DataUtilArray);
        }
        return x509DataUtilArray;
    }

    private static KeyInfo getKeyInfo(OMElement oMElement) throws SignatureStructureException, XSignatureException {
        OMElement oMElement2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfo(" + oMElement + ")");
        }
        if ((oMElement2 = KeyInfo.searchForKeyInfo(oMElement)) == null) {
            throw new SignatureStructureException("No KeyInfo element.");
        }
        KeyInfo keyInfo = new KeyInfo(oMElement2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfo(Element signature) returns " + keyInfo);
        }
        return keyInfo;
    }

    public static X509Certificate generateX509Certificate(byte[] byArray, Provider provider) throws CertificateException, NoSuchProviderException {
        return (X509Certificate)CertificateUtil.generateCertificate(byArray, "X.509", provider);
    }

    public static Certificate generateCertificate(byte[] byArray, String string, Provider provider) throws CertificateException, NoSuchProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateX509Certificate(byte[] binary[" + byArray + "]," + "String type[" + string + "]," + "Provider provider[" + provider + "])");
        }
        Certificate certificate = null;
        if (byArray != null && string != null) {
            CertificateFactory certificateFactory = provider == null ? CertificateFactory.getInstance(string) : CertificateFactory.getInstance(string, provider);
            certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateX509Certificate(byte[] binary,String type,Provider provider) returns Certificate[" + certificate + "]");
        }
        return certificate;
    }

    public static byte[] encodePkiPath(Provider provider, List list, KeyStore keyStore, String string) throws CertificateException, KeyStoreException {
        CertPath certPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodePkiPath(Provider provider[" + provider + "]," + "List certStores[" + list + "]," + "KeyStore kstore[" + keyStore + "]," + "String alias[" + string + "])");
        }
        byte[] byArray = null;
        if (keyStore != null && string != null && (certPath = CertificateUtil.getCertPath(keyStore, string, provider)) != null) {
            byArray = certPath.getEncoded("PkiPath");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodePkiPath(Provider provider,CertStores certStores,KeyStore kstore,String alias) returns byte[][" + byArray + "]");
        }
        return byArray;
    }

    public static byte[] encodePKCS7(Provider provider, List list, KeyStore keyStore, String string) throws CertStoreException, KeyStoreException, IOException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodePKCS7(Provider provider[" + provider + "]," + "List certStores[" + list + "]," + "KeyStore kstore[" + keyStore + "]," + "String alias[" + string + "])");
        }
        byte[] byArray = null;
        if (keyStore != null && string != null) {
            CRL[] cRLArray = CertificateUtil.extractCRLs(list);
            Content content = CertificateUtil.getSignedData(keyStore, string, cRLArray);
            byArray = CertificateUtil.getBinaryEncodedContent(content);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodePKCS7(Provider provider,List certStores,KeyStore kstore,String alias) returns byte[][" + byArray + "]");
        }
        return byArray;
    }

    private static CRL[] extractCRLs(List list) throws CertStoreException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractCRLs(List certStores[" + list + "])");
        }
        ArrayList<? extends CRL> arrayList = new ArrayList<CRL>();
        if (list != null && !list.isEmpty()) {
            for (CertStore certStore : list) {
                X509CRLSelector x509CRLSelector = new X509CRLSelector();
                Collection<? extends CRL> collection = null;
                collection = certStore.getCRLs(x509CRLSelector);
                if (collection == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, collection.size() + " CRLs found in the cert store[" + certStore + "].");
                }
                arrayList.addAll(collection);
            }
        }
        CRL[] cRLArray = new CRL[arrayList.size()];
        for (int i = 0; i < cRLArray.length; ++i) {
            cRLArray[i] = (CRL)arrayList.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractCRLs(List certStores) returns CRL[] " + cRLArray);
        }
        return cRLArray;
    }

    private static Content getSignedData(KeyStore keyStore, String string, CRL[] cRLArray) throws KeyStoreException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignedData(KeyStore ks[" + keyStore + "], " + "String alias[" + string + "], " + "CRL[] crls[" + cRLArray + "])");
        }
        SignedData signedData = null;
        Certificate[] certificateArray = keyStore.getCertificateChain(string);
        if (certificateArray != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, certificateArray.length + " certificates found");
            }
            signedData = new SignedData(certificateArray, cRLArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignedData(KeyStore ks, String alias, CRL[] crls,  returns SignedData[" + signedData + "]");
        }
        return signedData;
    }

    private static byte[] getBinaryEncodedContent(Content content) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBinaryEncodedContent(Content data[" + content + "])");
        }
        byte[] byArray = null;
        ContentInfo contentInfo = new ContentInfo(content);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        contentInfo.encode((OutputStream)byteArrayOutputStream);
        byArray = byteArrayOutputStream.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBinaryEncodedContent(Content data) retunrs byte[] " + byArray);
        }
        return byArray;
    }

    private static CertPath getCertPath(KeyStore keyStore, String string, Provider provider) throws KeyStoreException, CertificateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertPath(KeyStore ks[" + keyStore + "], " + "String alias[" + string + "], " + "Provider provider[" + provider + "])");
        }
        CertPath certPath = null;
        Certificate[] certificateArray = keyStore.getCertificateChain(string);
        final Vector<Certificate> vector = new Vector<Certificate>();
        if (certificateArray == null) {
            Tr.debug(tc, "Acquired certificate chain is null.");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, certificateArray.length + " certificates found");
            }
            for (int i = 0; i < certificateArray.length; ++i) {
                vector.add(certificateArray[i]);
            }
            final CertificateFactory certificateFactory = provider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            try {
                certPath = (CertPath)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws CertificateException {
                        CertPath certPath = certificateFactory.generateCertPath(vector);
                        return certPath;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof CertificateException) {
                    throw (CertificateException)throwable;
                }
                throw new CertificateException(throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertPath(KeyStore ks, String alias,Provider provider) returns CertPath[" + certPath + "]");
        }
        return certPath;
    }

    public static CertPath generateCertPath(byte[] byArray, String string, String string2, Provider provider) throws CertificateException, NoSuchProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateCertPath(byte[] binary[" + byArray + "]," + "String factoryType[" + string + "]," + "String encodingType[" + string2 + "]," + "Provider provider[" + provider + "])");
        }
        CertPath certPath = null;
        if (byArray != null && string != null && string2 != null) {
            CertificateFactory certificateFactory = provider == null ? CertificateFactory.getInstance(string) : CertificateFactory.getInstance(string, provider);
            certPath = certificateFactory.generateCertPath(new ByteArrayInputStream(byArray), string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateCertPath(byte[] binary,String factoryType,String encoingType,Provider provider) returns CertPath[" + certPath + "]");
        }
        return certPath;
    }

    public static Collection generateCRLs(byte[] byArray, String string, Provider provider) throws CertificateException, CRLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateCRLs(byte[] binary[" + byArray + "]," + "String factoryType[" + string + "]," + "Provider provider[" + provider + "])");
        }
        Collection<? extends CRL> collection = null;
        if (byArray != null && string != null) {
            CertificateFactory certificateFactory = provider == null ? CertificateFactory.getInstance(string) : CertificateFactory.getInstance(string, provider);
            collection = certificateFactory.generateCRLs(new ByteArrayInputStream(byArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateCRLs(byte[] binary,String factoryType,Provider provider) returns Collection[" + collection + "]");
        }
        return collection;
    }

    public static PKIXCertPathValidatorResult validateX509Certificate(X509Certificate x509Certificate, Provider provider, PKIXParameters pKIXParameters) throws CertPathBuilderException, CertPathValidatorException, CertStoreException, KeyStoreException, InvalidAlgorithmParameterException, IOException, NoSuchAlgorithmException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateX509Certificate(X509Certificate cert[" + x509Certificate + "], " + "Provider provider[" + provider + "]," + "PKIXParameters params[" + pKIXParameters + "])");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
        if (x509Certificate != null && pKIXParameters != null) {
            Serializable serializable;
            boolean bl = false;
            Set<TrustAnchor> set = pKIXParameters.getTrustAnchors();
            if (set != null && set.size() > 0) {
                for (TrustAnchor object : set) {
                    serializable = object.getTrustedCert();
                    if (!x509Certificate.equals(serializable)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                CertPathBuilder certPathBuilder = provider == null ? CertPathBuilder.getInstance("PKIX") : CertPathBuilder.getInstance("PKIX", provider);
                X509CertSelector x509CertSelector = (X509CertSelector)pKIXParameters.getTargetCertConstraints();
                x509CertSelector.setSubject(x509Certificate.getSubjectX500Principal().getEncoded());
                pKIXParameters.setTargetCertConstraints(x509CertSelector);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CertPathProvider = " + (provider == null ? "default" : provider.getName()));
                    Tr.debug(tc, "CertPath Builder = " + certPathBuilder.getClass().getName());
                    Tr.debug(tc, "CertPath Selector = " + x509CertSelector.getClass().getName());
                    Tr.debug(tc, "SubjectDN = " + x509Certificate.getSubjectX500Principal().getName());
                }
                serializable = new HashSet();
                serializable.add(x509Certificate);
                CertStore certStore = provider == null ? CertStore.getInstance("Collection", new CollectionCertStoreParameters((Collection<?>)((Object)serializable))) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters((Collection<?>)((Object)serializable)), provider);
                pKIXParameters.addCertStore(certStore);
                List<CertStore> list = pKIXParameters.getCertStores();
                X509CRLSelector x509CRLSelector = new X509CRLSelector();
                boolean bl2 = false;
                if (list != null) {
                    for (CertStore certStore2 : list) {
                        Iterator<? extends CRL> iterator;
                        Collection<? extends CRL> collection = certStore2.getCRLs(x509CRLSelector);
                        if (collection == null || !(iterator = collection.iterator()).hasNext()) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) {
                    pKIXParameters.setRevocationEnabled(true);
                    Tr.debug(tc, " RevocationEnabled.");
                } else {
                    pKIXParameters.setRevocationEnabled(false);
                    Tr.debug(tc, " Revocation Not Enabled.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Building the cert path...");
                }
                certPathBuilderResult = certPathBuilder.build(pKIXParameters);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CertPathBuilderResult=" + certPathBuilderResult);
                }
                if (certPathBuilderResult != null) {
                    pKIXCertPathValidatorResult = CertificateUtil.validateCertPath(certPathBuilderResult.getCertPath(), pKIXParameters);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateX509Certificate(X509Certificate cert, Provider provider,PKIXParameters params) returns PKIXCertPathValidatorResult[" + pKIXCertPathValidatorResult + "]");
        }
        return pKIXCertPathValidatorResult;
    }

    public static PKIXCertPathValidatorResult validateCertPath(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateCertPath(CertPath path[" + certPath + "]," + "PKIXParameters params[" + pKIXParameters + "])");
        }
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
        if (certPath != null && pKIXParameters == null) {
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXParameters);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateCertPath(CertPath path,PKIXParameters params) returns PKIXCertPathValidatorResult[" + pKIXCertPathValidatorResult + "]");
        }
        return pKIXCertPathValidatorResult;
    }

    public static BigInteger convertSerialNumber(String string) throws ParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertSerialNumber(String data[" + string + "])");
        }
        BigInteger bigInteger = null;
        if (string != null) {
            long l = 0L;
            for (int i = 0; i < string.length(); ++i) {
                l <<= 4;
                char c = string.charAt(i);
                if ('0' <= c && c <= '9') {
                    l += (long)(c - 48);
                    continue;
                }
                if ('a' <= c && c <= 'f') {
                    l += (long)(c + 10 - 97);
                    continue;
                }
                if ('A' <= c && c <= 'F') {
                    l += (long)(c + 10 - 65);
                    continue;
                }
                throw new ParseException("Illegal character: " + c, i);
            }
            bigInteger = BigInteger.valueOf(l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertSerialNumber(String data) returns BigInteger[" + bigInteger + "]");
        }
        return bigInteger;
    }

    public static class X509DataUtil {
        KeyInfo.X509Data x5data;
        CertStore docStore = null;
        Key publicKey;

        public X509DataUtil(KeyInfo.X509Data x509Data, Key key) {
            this.x5data = x509Data;
            this.publicKey = key;
        }

        private CertStore createCertStore() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCertStore()");
            }
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            X509Certificate[] x509CertificateArray = this.x5data.getCertificates();
            if (x509CertificateArray != null) {
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    vector.addElement(x509CertificateArray[i]);
                }
            }
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(vector));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createCertStore() returns " + certStore);
            }
            return certStore;
        }

        public Key validate(PKIXBuilderParameters pKIXBuilderParameters) throws XSignatureException {
            return this.validateAndGetCert(pKIXBuilderParameters).getPublicKey();
        }

        public X509Certificate validateAndGetCert(PKIXBuilderParameters pKIXBuilderParameters) throws XSignatureException {
            CertPath certPath;
            CertPathValidator certPathValidator;
            Object object;
            List<CertStore> list;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateAndGetCert(" + pKIXBuilderParameters + ")");
            }
            ArrayList<CertStore> arrayList = new ArrayList<CertStore>(((list = pKIXBuilderParameters.getCertStores()) == null ? 0 : list.size()) + 1);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
            try {
                arrayList.add(this.createCertStore());
                pKIXBuilderParameters.setCertStores(arrayList);
                object = CertPathBuilder.getInstance("PKIX");
                certPathValidator = CertPathValidator.getInstance("PKIX");
                certPath = ((CertPathBuilder)object).build(pKIXBuilderParameters).getCertPath();
                certPathValidator.validate(certPath, pKIXBuilderParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(invalidAlgorithmParameterException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(noSuchAlgorithmException);
            }
            catch (CertPathBuilderException certPathBuilderException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(certPathBuilderException);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(certPathValidatorException);
            }
            object = certPath.getCertificates();
            CertPathValidator certPathValidator2 = certPathValidator = object.isEmpty() ? null : (X509Certificate)object.get(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateAndGetCert(PKIXBuilderParameters params) returns " + certPathValidator);
            }
            return certPathValidator;
        }

        public X509CertSelector createSelector() throws IOException {
            X509Certificate[] x509CertificateArray;
            Object[] objectArray;
            Object[] objectArray2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSelector()");
            }
            X509CertSelector x509CertSelector = new X509CertSelector();
            String[] stringArray = this.x5data.getIssuerNames();
            if (stringArray != null && stringArray.length > 0) {
                objectArray2 = this.x5data.getSerialNumbers();
                x509CertSelector.setIssuer(stringArray[0]);
                x509CertSelector.setSerialNumber((BigInteger)objectArray2[0]);
            }
            if ((objectArray2 = this.x5data.getSubjectNames()) != null && objectArray2.length > 0) {
                x509CertSelector.setSubject((String)objectArray2[0]);
            } else {
                objectArray = this.x5data.getCertificates();
                if (objectArray != null && objectArray.length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CertPath Selector = " + x509CertSelector.getClass().getName());
                        Tr.debug(tc, "SubjectDN = " + ((X509Certificate)objectArray[0]).getSubjectX500Principal().getName());
                    }
                    x509CertSelector.setSubject(((X509Certificate)objectArray[0]).getSubjectX500Principal().getEncoded());
                }
            }
            objectArray = this.x5data.getSKIs();
            if (objectArray != null && objectArray.length > 0) {
                x509CertSelector.setSubjectKeyIdentifier((byte[])objectArray[0]);
            }
            if ((x509CertificateArray = this.x5data.getCertificates()) != null && x509CertificateArray.length == 1) {
                x509CertSelector.setCertificate(x509CertificateArray[0]);
            }
            if (this.publicKey != null) {
                x509CertSelector.setSubjectPublicKey(this.publicKey.getEncoded());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSelector() returns " + x509CertSelector);
            }
            return x509CertSelector;
        }
    }
}

