/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2Util {
    private static final TraceComponent tc = Tr.register(Axis2Util.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = Axis2Util.class.getName();
    public static final String SC_FAULT_CODE = "com.ibm.ws.wssecurity.sc.FaultCode";

    public static boolean isServiceProvider(Object object) throws SoapSecurityException {
        AxisService axisService = null;
        Object var2_2 = null;
        if (object instanceof MessageContext) {
            MessageContext messageContext = (MessageContext)object;
            axisService = messageContext.getAxisService();
            if (axisService == null) {
                EndpointReference endpointReference = messageContext.getTo();
                String string = endpointReference != null ? endpointReference.getAddress() : "";
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisService", new Object[]{string});
                throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getAxisService", new String[]{string});
            }
        } else if (object instanceof AxisService) {
            axisService = (AxisService)object;
        } else {
            Tr.error(tc, "security.wssecurity.WSEC6841E", new Object[]{"AxisService is NULL."});
            throw new SoapSecurityException("AxisService is NULL. Service for endpoint address not found.");
        }
        if (axisService != null) {
            if (axisService.isClientSide()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAxisService().isClientSide() = true");
                }
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAxisService().isClientSide() = false");
            }
            return true;
        }
        Tr.error(tc, "security.wssecurity.WSEC6841E", new Object[]{"AxisService is NULL."});
        throw new SoapSecurityException("AxisService is NULL. Service for endpoint address not found.");
    }

    public static AxisOperation getOperationFromWSAAction(MessageContext messageContext, String[] stringArray) throws SoapSecurityException {
        SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
        if (sOAPEnvelope != null) {
            for (String string : stringArray) {
                AxisOperation axisOperation;
                QName qName = new QName(string, "Action");
                Iterator iterator = sOAPEnvelope.getHeader().getChildrenWithName(qName);
                if (!iterator.hasNext()) continue;
                OMElement oMElement = (OMElement)iterator.next();
                String string2 = oMElement.getText().trim();
                if (messageContext.getAxisService() == null || (axisOperation = messageContext.getAxisService().getOperationByAction(string2)) == null) continue;
                String string3 = messageContext.getSoapAction();
                if (string3 != null && string3.length() != 0 && !string3.equals(string2)) {
                    throw new SoapSecurityException("SOAPAction and WSAction are not equal");
                }
                return axisOperation;
            }
        }
        return null;
    }

    public static PolicySetConfiguration getPolicySetConfig(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetConfig(MessageContext messageContext)");
        }
        AxisOperation axisOperation = messageContext.getAxisOperation();
        Parameter parameter = null;
        Object object = null;
        if (axisOperation != null) {
            parameter = axisOperation.getParameter("WASAxis2PolicySet");
        }
        if (parameter != null) {
            object = parameter.getValue();
        }
        PolicySetConfiguration policySetConfiguration = null;
        if (object != null && object instanceof PolicySetConfiguration) {
            policySetConfiguration = (PolicySetConfiguration)object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Valid PolicySet from the operation context");
            }
        } else {
            AxisService axisService = messageContext.getAxisService();
            if (axisService != null) {
                parameter = axisService.getParameter("WASAxis2PolicySet");
            }
            if (parameter != null) {
                object = parameter.getValue();
            }
            if (object != null && object instanceof PolicySetConfiguration) {
                policySetConfiguration = (PolicySetConfiguration)object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid PolicySet from the service context");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetConfig(MessageContext messageContext) returns :" + policySetConfiguration);
        }
        return policySetConfiguration;
    }

    public static void setMustUnderstand(MessageContext messageContext, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMustUnderstand=" + bl);
        }
        if (messageContext != null) {
            messageContext.setProperty(Constants.MUST_UNDERSTAND, new Boolean(bl));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMustUnderstand");
        }
    }

    public static boolean getMustUnderstand(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(messageContext)");
        }
        boolean bl = true;
        Boolean bl2 = null;
        bl2 = (Boolean)Axis2Util.getProperty(messageContext, Constants.MUST_UNDERSTAND);
        if (bl2 != null) {
            bl = bl2;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No cached value found.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + bl);
        }
        return bl;
    }

    public static boolean getMustUnderstand(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(context)");
        }
        boolean bl = true;
        if (map != null) {
            MessageContext messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
            bl = Axis2Util.getMustUnderstand(messageContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + bl);
        }
        return bl;
    }

    public static Object getProperty(MessageContext messageContext, String string) {
        return Axis2Util.getProperty(messageContext, string, true);
    }

    public static Object getProperty(MessageContext messageContext, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty(messageContext," + string + ")");
        }
        Object object = null;
        if (messageContext != null) {
            if (bl) {
                object = messageContext.getProperty(string);
            }
            if (object == null) {
                OperationContext operationContext = messageContext.getOperationContext();
                if (operationContext == null) {
                    operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
                }
                if (operationContext != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for cached " + string + " attribute in message context collection");
                    }
                    HashMap hashMap = operationContext.getMessageContexts();
                    Set set = hashMap.entrySet();
                    for (Map.Entry entry : set) {
                        MessageContext messageContext2 = (MessageContext)entry.getValue();
                        object = messageContext2.getProperty(string);
                        if (object == null) continue;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Cached value found in msg ctx with key: " + entry.getKey());
                        break;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            if (object instanceof String) {
                Tr.exit(tc, "getProperty(messageContext," + string + ") returns " + (String)object);
            } else {
                Tr.exit(tc, "getProperty(messageContext,property)");
            }
        }
        return object;
    }

    public static QName setFailedAuthFaultCode(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFailedAuthFaultCode");
        }
        QName qName = null;
        if (map != null && ConfigUtil.shouldUseStandardFaultCodes(map)) {
            map.put(SC_FAULT_CODE, Constants.FAILED_AUTHENTICATION);
            qName = Constants.FAILED_AUTHENTICATION;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFailedAuthFaultCode returns " + qName);
        }
        return qName;
    }

    public static QName setFailedAuthFaultCodeIfNone(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFailedAuthFaultCodeIfNone");
        }
        QName qName = null;
        if (map != null && ConfigUtil.shouldUseStandardFaultCodes(map) && (qName = (QName)map.get(SC_FAULT_CODE)) == null) {
            map.put(SC_FAULT_CODE, Constants.FAILED_AUTHENTICATION);
            qName = Constants.FAILED_AUTHENTICATION;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFailedAuthFaultCodeIfNone returns " + qName);
        }
        return qName;
    }

    public static QName setFaultCode(Map<Object, Object> map, QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFaultCode");
        }
        QName qName2 = null;
        if (map != null && ConfigUtil.shouldUseStandardFaultCodes(map)) {
            map.put(SC_FAULT_CODE, qName);
            qName2 = qName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFaultCode returns " + qName2);
        }
        return qName2;
    }
}

