/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.cache.STSTokenCache;
import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.net.URI;
import java.util.Properties;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;

public class SCTValidate
implements RequestHandler {
    private static final TraceComponent tc = Tr.register(SCTValidate.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public IRequestSecurityTokenResponse handleRequest(IRequestSecurityToken iRequestSecurityToken, String string, IConstants iConstants) throws InvalidRequestException {
        Object object;
        String string2 = "handleRequest()";
        SCTValidate.trEntry(string2);
        IElement iElement = iRequestSecurityToken.getValidateTarget();
        if (iElement == null) {
            String string3 = "Missing ValidateTarget element.";
            SCTValidate.trDebug(string3);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s16", null));
            SCTValidate.trExit(string2);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string3), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        String string4 = SCTValidate.extractUUIDFromValidateTarget(iElement);
        if (string4 == null) {
            String string5 = "UUID was not successfully extracted from validate request. Validate failed.";
            SCTValidate.trDebug(string5);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s17", null));
            SCTValidate.trExit(string2);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string5), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        boolean bl = false;
        STSTokenCache sTSTokenCache = SCTHelper.getCache();
        SCT sCT = (SCT)sTSTokenCache.getToken(string4);
        if (sCT == null) {
            object = "SCT with the UUID " + string4 + " does not exist. Validate failed.";
            SCTValidate.trDebug((String)object);
        } else {
            for (String string3 : object = sCT.getInstances()) {
                if (!sCT.isValid(string3, 0L)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                SCTValidate.trDebug("All keys associated with the specified SCT have expired. Validate failed.");
            }
        }
        object = bl ? iConstants.getValidStatusCode() : iConstants.getInvalidStatusCode();
        IElement iElement2 = SCTValidate.generateStatus((URI)object, null, iConstants);
        IRequestSecurityTokenResponse iRequestSecurityTokenResponse = SCTHelper.createRSTR(iRequestSecurityToken.getContext());
        iRequestSecurityTokenResponse.setStatus(iElement2);
        SCTValidate.trExit(string2);
        return iRequestSecurityTokenResponse;
    }

    public void initialize(Properties properties) {
    }

    private static String extractUUIDFromValidateTarget(IElement iElement) {
        String string = SCTHelper.extractTextFrom(iElement, new String[]{"SecurityContextToken", "Identifier"});
        return string;
    }

    private static IElement generateStatus(URI uRI, String string, IConstants iConstants) {
        String string2 = "generateStatus()";
        SCTValidate.trEntry(string2);
        if (uRI == null || uRI.equals("")) {
            SCTValidate.trDebug("Code is null or empty: this parameter is required.");
            SCTValidate.trExit(string2);
            return null;
        }
        IElement iElement = SCTHelper.createIElement("Status", "wst", iConstants.getWSTrustNamespace());
        IElement iElement2 = SCTHelper.createIElement("Code", "wst", iConstants.getWSTrustNamespace());
        SCTHelper.addTextTo(iElement2, uRI.toString());
        SCTHelper.addChildTo(iElement, iElement2);
        if (string != null && !string.equals("")) {
            IElement iElement3 = SCTHelper.createIElement("Reason", "wst", iConstants.getWSTrustNamespace());
            SCTHelper.addTextTo(iElement3, string);
            SCTHelper.addChildTo(iElement, iElement3);
        }
        SCTValidate.trExit(string2);
        return iElement;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

