/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.cache.STSTokenCache;
import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandlerException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.UnableToRenewException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.UninitializedHandlerException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTIssue;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Properties;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.ILifetime;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;

public class SCTRenew
extends SCTIssue
implements RequestHandler {
    private int lifetimeMSec;
    private boolean initialized;
    private static URI NS_WSC_URI = null;
    private static final String CLASS_NAME = SCTRenew.class.getName();
    private static final TraceComponent tc = Tr.register(SCTRenew.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public SCTRenew() {
        block3: {
            this.initialized = false;
            if (NS_WSC_URI == null) {
                try {
                    NS_WSC_URI = new URI("http://schemas.xmlsoap.org/ws/2005/02/sc");
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Failed initialization of SC URI namespace: http://schemas.xmlsoap.org/ws/2005/02/sc");
                    Tr.debug(tc, "Error is: " + uRISyntaxException.getMessage());
                }
            }
        }
    }

    public IRequestSecurityTokenResponse handleRequest(IRequestSecurityToken iRequestSecurityToken, String string, IConstants iConstants) throws RequestHandlerException {
        Object object;
        String string2;
        Date date;
        String string3 = "handleRequest()";
        SCTRenew.trEntry(string3);
        if (!this.initialized) {
            String string4 = CLASS_NAME + " has not been initialized. " + "Initialize the handler before handling requests.";
            SCTRenew.trDebug(string4);
            Tr.error(tc, SCTHelper.getMessage("security.wssecurity.sct.s12", null));
            SCTRenew.trExit(string3);
            throw (UninitializedHandlerException)SCTHelper.populateIFault(new UninitializedHandlerException(string4), "wst", iConstants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E");
        }
        IElement iElement = iRequestSecurityToken.getRenewTarget();
        if (iElement == null) {
            String string5 = "Missing RenewTarget element.";
            SCTRenew.trDebug(string5);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s13", null));
            SCTRenew.trExit(string3);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string5), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        String string6 = SCTRenew.extractUUIDFromRenewTarget(iElement);
        if (string6 == null) {
            String string7 = "UUID was not successfully extracted from renew request. Renew failed.";
            SCTRenew.trDebug(string7);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s14", null));
            SCTRenew.trExit(string3);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string7), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        STSTokenCache sTSTokenCache = SCTHelper.getCache();
        SCT sCT = (SCT)sTSTokenCache.getToken(string6);
        if (sCT == null) {
            String string8 = "SCT with the UUID " + string6 + " does not exist. Renew failed.";
            SCTRenew.trDebug(string8);
            SCTRenew.trExit(string3);
            throw (UnableToRenewException)SCTHelper.populateIFault(new UnableToRenewException(string8), NS_WSC_URI == null ? null : "wsc", NS_WSC_URI == null ? null : NS_WSC_URI, "UnableToRenew", "security.wssecurity.WSEC6865E");
        }
        if (!sCT.isRenewable() || sCT.isCancelled()) {
            String string9 = "SCT with the UUID " + string6 + " is not renewable. Renew failed.";
            SCTRenew.trDebug(string9);
            SCTRenew.trExit(string3);
            throw (UnableToRenewException)SCTHelper.populateIFault(new UnableToRenewException(string9), NS_WSC_URI == null ? null : "wsc", NS_WSC_URI == null ? null : NS_WSC_URI, "UnableToRenew", "security.wssecurity.WSEC6865E");
        }
        String[] stringArray = sCT.getInstances();
        Date date2 = new Date();
        Date date3 = new Date(0L);
        String string10 = null;
        for (String string4 : stringArray) {
            date = sCT.getExpiration(string4);
            if (!date.after(date3)) continue;
            date3 = date;
            string10 = string4;
        }
        if (date3.before(date2) && !sCT.isRenewableAfterExpiration()) {
            String string5 = "SCT with UUID " + string6 + " has expired, and is not renewable after expiration. " + "Renew failed.";
            SCTRenew.trDebug(string5);
            SCTRenew.trExit(string3);
            throw (UnableToRenewException)SCTHelper.populateIFault(new UnableToRenewException(string5), NS_WSC_URI == null ? null : "wsc", NS_WSC_URI == null ? null : NS_WSC_URI, "UnableToRenew", "security.wssecurity.WSEC6865E");
        }
        IElement iElement2 = iRequestSecurityToken.getEntropy();
        byte[] byArray = this.extractBinarySecret(iElement2);
        String string7 = SCTHelper.extractAttributeFrom(iElement2, new String[]{"BinarySecret"}, "Type");
        ILifetime iLifetime = iRequestSecurityToken.getLifetime();
        date = null;
        Date date4 = null;
        if (iLifetime != null) {
            date = iLifetime.getCreated();
            date4 = iLifetime.getExpires();
        }
        if (date == null) {
            date = new Date();
        }
        Date date5 = new Date(date.getTime() + (long)this.lifetimeMSec);
        if (date4 == null) {
            date4 = date5;
        }
        if (date4.getTime() - date.getTime() > (long)this.lifetimeMSec) {
            SCTRenew.trDebug("Requested lifetime is greater than the configured maximum lifetime. Using the configured maximum lifetime.");
            date4 = date5;
        }
        byte[] byArray2 = null;
        if (byArray == null) {
            SCTRenew.trDebug("RequestSecurityToken is missing Entropy/BinarySecret. Using old keys.");
            byArray2 = sCT.getServerSecret(string10);
            byArray = sCT.getClientSecret(string10);
        } else {
            string2 = sCT.getAlgorithm();
            object = sCT.getProvider();
            int n = sCT.getKeySize();
            if (string2 == null || object == null) {
                String string8 = "Either algorithm or provider in the cached SCT is null. Both must be non-null. Renew failed.";
                SCTRenew.trDebug(string8);
                Tr.error(tc, SCTHelper.getMessage("security.wssecurity.sct.s15", null));
                SCTRenew.trExit(string3);
                throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string8), "wst", iConstants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E");
            }
            byArray2 = SCTHelper.generateSecret(string2, (String)object, n);
        }
        string2 = SCTHelper.generateUUID();
        object = new SCT.KeyHistoryEntry(string2, byArray, byArray2, date, date4, SCT.SCTState.RENEWED);
        sCT.setKeyHistoryEntry((SCT.KeyHistoryEntry)object);
        String string9 = SCTHelper.generateUUID();
        sTSTokenCache.updateToken(string6, sCT, date4 == null ? -1L : date4.getTime() - date2.getTime() + (long)this.renewalWindowMSec);
        IElement iElement3 = this.generateRequestedSecurityToken(sCT, string9, string2, iConstants);
        IElement iElement4 = this.generateRequestedAttachedReference(string9, iConstants);
        IElement iElement5 = this.generateEntropy(byArray2, string7, iConstants);
        ILifetime iLifetime2 = this.generateLifetime(date, date4);
        IElement iElement6 = this.generateRenewing(sCT.isRenewable(), sCT.isRenewableAfterExpiration(), iConstants);
        IRequestSecurityTokenResponse iRequestSecurityTokenResponse = SCTHelper.createRSTR(iRequestSecurityToken.getContext());
        iRequestSecurityTokenResponse.setRequestedSecurityToken(iElement3);
        iRequestSecurityTokenResponse.setRequestedAttachedReference(iElement4);
        iRequestSecurityTokenResponse.setEntropy(iElement5);
        iRequestSecurityTokenResponse.setLifetime(iLifetime2);
        iRequestSecurityTokenResponse.setRenewing(iElement6);
        SCTRenew.trExit(string3);
        return iRequestSecurityTokenResponse;
    }

    public void initialize(Properties properties) {
        String string = "initialize()";
        SCTRenew.trEntry(string);
        SCTRenew.trDebug("Calling super.initialize()...");
        super.initialize(properties);
        String string2 = properties.getProperty("lifetimeMinutes");
        this.lifetimeMSec = Integer.valueOf(string2) * 60000;
        this.initialized = true;
        SCTRenew.trExit(string);
    }

    private static String extractUUIDFromRenewTarget(IElement iElement) {
        String string = SCTHelper.extractTextFrom(iElement, new String[]{"SecurityContextToken", "Identifier"});
        return string;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

