/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.cache.STSTokenCache;
import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandlerException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.UninitializedHandlerException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Properties;
import org.eclipse.higgins.sts.IAppliesTo;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IEndpointReference;
import org.eclipse.higgins.sts.ILifetime;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;

public class SCTIssue
implements RequestHandler {
    private int lifetimeMSec;
    protected int renewalWindowMSec;
    private boolean renewableAfterExpiration;
    private String provider;
    private String algorithm;
    private int keySize;
    private boolean initialized = false;
    private URI wscURI = null;
    protected static final int MINUTE_MSEC_CONVERSION_FACTOR = 60000;
    private static final String CLASS_NAME = SCTIssue.class.getName();
    private static final TraceComponent tc = Tr.register(SCTIssue.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public IRequestSecurityTokenResponse handleRequest(IRequestSecurityToken iRequestSecurityToken, String string, IConstants iConstants) throws RequestHandlerException {
        boolean bl;
        Integer n;
        String string2 = "handleRequest()";
        SCTIssue.trEntry(string2);
        if (!this.initialized) {
            String string3 = CLASS_NAME + " has not been initialized. " + "Initialize the handler before handling requests.";
            SCTIssue.trDebug(string3);
            Tr.error(tc, SCTHelper.getMessage("security.wssecurity.sct.s06", null));
            SCTIssue.trExit(string2);
            throw (UninitializedHandlerException)SCTHelper.populateIFault(new UninitializedHandlerException(string3), "wst", iConstants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E");
        }
        IAppliesTo iAppliesTo = iRequestSecurityToken.getAppliesTo();
        if (iAppliesTo == null) {
            String string4 = "AppliesTo element should not be null.";
            SCTIssue.trDebug(string4);
            SCTIssue.trExit(string2);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string4), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        IEndpointReference iEndpointReference = iAppliesTo.getEndpointReference();
        if (iEndpointReference == null) {
            String string5 = "AppliesTo endpoint reference should not be null.";
            SCTIssue.trDebug(string5);
            SCTIssue.trExit(string2);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string5), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        IElement iElement = iRequestSecurityToken.getEntropy();
        byte[] byArray = this.extractBinarySecret(iElement);
        String string6 = SCTHelper.extractAttributeFrom(iElement, new String[]{"BinarySecret"}, "Type");
        if (byArray == null) {
            String string7 = "RequestSecurityToken is missing Entropy/BinarySecret";
            SCTIssue.trDebug(string7);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s07", null));
            SCTIssue.trExit(string2);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string7), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        ILifetime iLifetime = iRequestSecurityToken.getLifetime();
        Date date = null;
        Date date2 = null;
        if (iLifetime != null) {
            date = iLifetime.getCreated();
            date2 = iLifetime.getExpires();
        }
        if (date == null) {
            date = new Date();
        }
        Date date3 = new Date(date.getTime() + (long)this.lifetimeMSec);
        if (date2 == null) {
            date2 = date3;
        }
        if (date2.getTime() - date.getTime() > (long)this.lifetimeMSec) {
            SCTIssue.trDebug("Requested lifetime is greater than the configured maximum lifetime. Using the configured maximum lifetime.");
            date2 = date3;
        }
        if ((n = iRequestSecurityToken.getKeySize()) == null) {
            n = this.keySize;
        }
        IElement iElement2 = iRequestSecurityToken.getRenewing();
        String string8 = SCTHelper.extractAttributeFrom(iElement2, new String[0], "Allow");
        String string9 = SCTHelper.extractAttributeFrom(iElement2, new String[0], "OK");
        boolean bl2 = string8 == null ? true : Boolean.valueOf(string8);
        boolean bl3 = bl = string9 == null ? this.renewableAfterExpiration : Boolean.valueOf(string9);
        if (!this.renewableAfterExpiration && bl) {
            SCTIssue.trDebug("Current configuration prohibits renewing of this token after expiration.");
            bl = false;
        }
        SCT sCT = this.createSCT(byArray, n, date, date2, bl2, bl, iEndpointReference);
        String string10 = SCTHelper.generateUUID();
        String string11 = sCT.getInstances()[0];
        IElement iElement3 = this.generateRequestedSecurityToken(sCT, string10, string11, iConstants);
        IEndpointReference iEndpointReference2 = this.generateAppliesTo(iEndpointReference.getAddress());
        IElement iElement4 = this.generateRequestedAttachedReference(string10, iConstants);
        IElement iElement5 = this.generateRequestedUnattachedReference(sCT.getUUID(), iConstants);
        IElement iElement6 = this.generateEntropy(sCT.getServerSecret(string11), string6, iConstants);
        IElement iElement7 = this.generateRequestedProofToken(iConstants);
        ILifetime iLifetime2 = this.generateLifetime(sCT.getCreation(string11), sCT.getExpiration(string11));
        IElement iElement8 = this.generateRenewing(bl2, bl, iConstants);
        IRequestSecurityTokenResponse iRequestSecurityTokenResponse = SCTHelper.createRSTR(iRequestSecurityToken.getContext());
        iRequestSecurityTokenResponse.setRequestedSecurityToken(iElement3);
        iRequestSecurityTokenResponse.setAppliesTo(iEndpointReference2);
        iRequestSecurityTokenResponse.setRequestedAttachedReference(iElement4);
        iRequestSecurityTokenResponse.setRequestedUnattachedReference(iElement5);
        iRequestSecurityTokenResponse.setEntropy(iElement6);
        iRequestSecurityTokenResponse.setRequestedProofToken(iElement7);
        iRequestSecurityTokenResponse.setLifetime(iLifetime2);
        iRequestSecurityTokenResponse.setRenewing(iElement8);
        iRequestSecurityTokenResponse.setKeySize(n);
        boolean bl4 = this.cacheSCT(sCT);
        if (!bl4) {
            String string12 = "SCT was not cached successfully.";
            SCTIssue.trDebug(string12);
            Tr.error(tc, SCTHelper.getMessage("security.wssecurity.sct.s08", null));
            SCTIssue.trExit(string2);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string12), "wst", iConstants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E");
        }
        SCTIssue.trExit(string2);
        return iRequestSecurityTokenResponse;
    }

    public void initialize(Properties properties) {
        String string = "initialize";
        SCTIssue.trEntry(string);
        String string2 = properties.getProperty("lifetimeMinutes");
        String string3 = properties.getProperty("renewalWindowMinutes");
        String string4 = properties.getProperty("renewableAfterExpiration");
        this.lifetimeMSec = Integer.valueOf(string2) * 60000;
        this.renewalWindowMSec = Integer.valueOf(string3) * 60000;
        this.renewableAfterExpiration = Boolean.valueOf(string4);
        this.provider = properties.getProperty("provider", "IBMJCE");
        this.algorithm = properties.getProperty("algorithm", "AES");
        this.keySize = Integer.valueOf(properties.getProperty("keySize", "128"));
        SCTIssue.trDebug("Configured value - lifetimeMSec: " + this.lifetimeMSec);
        SCTIssue.trDebug("Configured value - renewalWindowMSec: " + this.renewalWindowMSec);
        SCTIssue.trDebug("Configured value - renewableAfterExpiration: " + this.renewableAfterExpiration);
        SCTIssue.trDebug("Configured value - provider: " + this.provider);
        SCTIssue.trDebug("Configured value - algorithm: " + this.algorithm);
        SCTIssue.trDebug("Configured value - keySize: " + this.keySize);
        try {
            this.wscURI = new URI("http://schemas.xmlsoap.org/ws/2005/02/sc");
        }
        catch (URISyntaxException uRISyntaxException) {
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s09", new String[]{uRISyntaxException.toString()}));
        }
        this.initialized = true;
        SCTIssue.trExit(string);
    }

    protected byte[] extractBinarySecret(IElement iElement) {
        String string;
        byte[] byArray = null;
        if (iElement != null && (string = SCTHelper.extractTextFrom(iElement, new String[]{"BinarySecret"})) != null) {
            byArray = SCTHelper.decode(string);
        }
        return byArray;
    }

    protected IElement generateRequestedSecurityToken(SCT sCT, String string, String string2, IConstants iConstants) {
        IElement iElement = null;
        if (sCT != null) {
            iElement = SCTHelper.createIElement("RequestedSecurityToken", "wst", iConstants.getWSTrustNamespace());
            IElement iElement2 = SCTHelper.createIElement("SecurityContextToken", "wsc", this.wscURI);
            SCTHelper.addAttributeTo(iElement2, "Id", "wsu", iConstants.getWSSecurityUtilityNamespace(), string);
            IElement iElement3 = SCTHelper.createIElement("Identifier", "wsc", this.wscURI);
            SCTHelper.addTextTo(iElement3, sCT.getUUID());
            SCTHelper.addChildTo(iElement2, iElement3);
            SCTHelper.addChildTo(iElement, iElement2);
            if (string2 != null) {
                IElement iElement4 = SCTHelper.createIElement("Instance", "wsc", this.wscURI);
                SCTHelper.addTextTo(iElement4, string2);
                SCTHelper.addChildTo(iElement2, iElement4);
            }
        }
        return iElement;
    }

    protected IEndpointReference generateAppliesTo(URI uRI) {
        return SCTHelper.createIEndpointReference(uRI);
    }

    protected IElement generateRequestedAttachedReference(String string, IConstants iConstants) {
        IElement iElement = SCTHelper.createIElement("RequestedAttachedReference", "wst", iConstants.getWSTrustNamespace());
        IElement iElement2 = SCTHelper.createIElement("SecurityTokenReference", "wsse", iConstants.getWSSecurityNamespace());
        IElement iElement3 = SCTHelper.createIElement("Reference", "wsse", iConstants.getWSSecurityNamespace());
        SCTHelper.addAttributeTo(iElement3, "URI", null, null, "#" + string);
        SCTHelper.addAttributeTo(iElement3, "ValueType", null, null, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
        SCTHelper.addChildTo(iElement, iElement2);
        SCTHelper.addChildTo(iElement2, iElement3);
        return iElement;
    }

    protected IElement generateRequestedUnattachedReference(String string, IConstants iConstants) {
        IElement iElement = null;
        if (string != null) {
            iElement = SCTHelper.createIElement("RequestedUnattachedReference", "wst", iConstants.getWSTrustNamespace());
            IElement iElement2 = SCTHelper.createIElement("SecurityTokenReference", "wsse", iConstants.getWSSecurityNamespace());
            IElement iElement3 = SCTHelper.createIElement("Reference", "wsse", iConstants.getWSSecurityNamespace());
            SCTHelper.addAttributeTo(iElement3, "URI", null, null, string);
            SCTHelper.addAttributeTo(iElement3, "ValueType", null, null, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            SCTHelper.addChildTo(iElement, iElement2);
            SCTHelper.addChildTo(iElement2, iElement3);
        }
        return iElement;
    }

    protected IElement generateEntropy(byte[] byArray, String string, IConstants iConstants) {
        String string2;
        IElement iElement = null;
        if (byArray != null && (string2 = SCTHelper.encode(byArray)) != null) {
            iElement = SCTHelper.createIElement("Entropy", "wst", iConstants.getWSTrustNamespace());
            IElement iElement2 = SCTHelper.createIElement("BinarySecret", "wst", iConstants.getWSTrustNamespace());
            if (string != null && !string.equals("")) {
                SCTHelper.addAttributeTo(iElement2, "Type", null, null, string);
            }
            SCTHelper.addTextTo(iElement2, string2);
            SCTHelper.addChildTo(iElement, iElement2);
        }
        return iElement;
    }

    protected IElement generateRequestedProofToken(IConstants iConstants) {
        IElement iElement = SCTHelper.createIElement("RequestedProofToken", "wst", iConstants.getWSTrustNamespace());
        IElement iElement2 = SCTHelper.createIElement("ComputedKey", "wst", iConstants.getWSTrustNamespace());
        SCTHelper.addTextTo(iElement2, iConstants.getPSHA1ComputedKey().toString());
        SCTHelper.addChildTo(iElement, iElement2);
        return iElement;
    }

    protected ILifetime generateLifetime(Date date, Date date2) {
        return SCTHelper.createILifetime(date, date2);
    }

    protected IElement generateRenewing(boolean bl, boolean bl2, IConstants iConstants) {
        IElement iElement = SCTHelper.createIElement("Renewing", "wst", iConstants.getWSTrustNamespace());
        SCTHelper.addAttributeTo(iElement, "Allow", null, null, new Boolean(bl).toString());
        SCTHelper.addAttributeTo(iElement, "OK", null, null, new Boolean(bl2).toString());
        return iElement;
    }

    private SCT createSCT(byte[] byArray, int n, Date date, Date date2, boolean bl, boolean bl2, IEndpointReference iEndpointReference) {
        byte[] byArray2 = SCTHelper.generateSecret(this.algorithm, this.provider, n);
        String string = SCTHelper.generateUUID();
        SCT.KeyHistoryEntry keyHistoryEntry = new SCT.KeyHistoryEntry(string, byArray, byArray2, date, date2, SCT.SCTState.ISSUED);
        String string2 = SCTHelper.generateUUID();
        while (SCTHelper.isCached(string2)) {
            string2 = SCTHelper.generateUUID();
        }
        SCT sCT = new SCT(string2, new SCT.KeyHistoryEntry[]{keyHistoryEntry});
        sCT.setRenewable(bl);
        sCT.setRenewableAfterExpiration(bl2);
        sCT.setAlgorithm(this.algorithm);
        sCT.setProvider(this.provider);
        sCT.setKeySize(n);
        sCT.setAppliesTo(iEndpointReference.getAddress().toString());
        return sCT;
    }

    private boolean cacheSCT(SCT sCT) throws UninitializedHandlerException {
        String[] stringArray;
        String string = "cacheSCT()";
        SCTIssue.trEntry(string);
        if (!this.initialized) {
            String string2 = CLASS_NAME + " has not been initialized. " + "Initialize the handler before handling requests.";
            SCTIssue.trDebug(string2);
            SCTIssue.trExit(string);
            throw new UninitializedHandlerException(string2);
        }
        STSTokenCache sTSTokenCache = SCTHelper.getCache();
        String string3 = sCT.getIdentifier();
        if (string3 != null && sTSTokenCache != null && !sTSTokenCache.containsToken(string3) && (stringArray = sCT.getInstances()).length > 0) {
            String string4 = stringArray[0];
            Date date = sCT.getExpiration(string4);
            Date date2 = new Date();
            return sTSTokenCache.cacheToken(string3, sCT, date == null ? -1L : date.getTime() - date2.getTime() + (long)this.renewalWindowMSec);
        }
        SCTIssue.trExit(string);
        return false;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

