/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.cache.STSTokenCache;
import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.cache.STSTokenCacheFactory;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.axis2.util.Base64;
import org.apache.axis2.util.UUIDGenerator;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IEndpointReference;
import org.eclipse.higgins.sts.IFault;
import org.eclipse.higgins.sts.ILifetime;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.UnsupportedContainedObjectClassException;
import org.eclipse.higgins.sts.impl.Element;
import org.eclipse.higgins.sts.impl.EndpointReference;
import org.eclipse.higgins.sts.impl.Lifetime;
import org.eclipse.higgins.sts.impl.RequestSecurityTokenResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCTHelper {
    private static STSTokenCacheFactory tcFactory;
    private static Properties sctConfigProperties;
    private static final OMFactory omFactory;
    private static final String CLASS_NAME;
    private static final String UUIDGeneratorPrefix = "urn:";
    private static final TraceComponent tc;

    public static IRequestSecurityTokenResponse createRSTR(URI uRI) {
        IRequestSecurityTokenResponse iRequestSecurityTokenResponse = null;
        if (uRI != null) {
            iRequestSecurityTokenResponse = SCTHelper.createRSTR(uRI.toString());
        }
        return iRequestSecurityTokenResponse;
    }

    public static IRequestSecurityTokenResponse createRSTR(String string) {
        RequestSecurityTokenResponse requestSecurityTokenResponse = new RequestSecurityTokenResponse();
        if (string != null) {
            requestSecurityTokenResponse.setContext(string);
        }
        return requestSecurityTokenResponse;
    }

    public static String printDate(Date date) {
        return UTC.format(date);
    }

    public static Date parseDate(String string) {
        Date date = null;
        try {
            date = UTC.parse(string);
        }
        catch (ParseException parseException) {
            SCTHelper.trDebug("Problem parsing the date: " + parseException.getLocalizedMessage());
            return null;
        }
        return date;
    }

    public static void setTokenCacheFactory(STSTokenCacheFactory sTSTokenCacheFactory) {
        tcFactory = sTSTokenCacheFactory;
    }

    public static STSTokenCache getCache() {
        if (tcFactory == null) {
            return null;
        }
        return tcFactory.getInstance("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
    }

    public static Properties getSCTConfigProperties() {
        SCTHelper.trEntry("getSCTConfigProperties");
        SCTHelper.trExit("getSCTConfigProperties returns ");
        return sctConfigProperties;
    }

    public static void setSCTConfigProperties(Properties properties) {
        SCTHelper.trEntry("setSCTConfigProperties(props)");
        sctConfigProperties = properties;
        SCTHelper.trExit("setSCTConfigProperties(props)");
    }

    public static boolean isCached(String string) {
        STSTokenCache sTSTokenCache = SCTHelper.getCache();
        boolean bl = false;
        if (sTSTokenCache != null) {
            bl = sTSTokenCache.containsToken(string);
        }
        return bl;
    }

    public static IElement createIElement(String string, String string2, URI uRI) {
        OMNamespace oMNamespace = null;
        if (string2 != null && uRI != null) {
            oMNamespace = omFactory.createOMNamespace(uRI.toString(), string2);
        }
        Element element = new Element();
        try {
            element.set(omFactory.createOMElement(string, oMNamespace));
        }
        catch (UnsupportedContainedObjectClassException unsupportedContainedObjectClassException) {
            SCTHelper.trDebug("Error occurred while trying to create IElement: " + unsupportedContainedObjectClassException.getLocalizedMessage());
            element = null;
        }
        return element;
    }

    public static IEndpointReference createIEndpointReference(URI uRI) {
        EndpointReference endpointReference = null;
        if (uRI != null) {
            endpointReference = new EndpointReference();
            endpointReference.setAddress(uRI);
        }
        return endpointReference;
    }

    public static ILifetime createILifetime(Date date, Date date2) {
        if (date == null && date2 == null) {
            return null;
        }
        Lifetime lifetime = new Lifetime();
        if (date != null) {
            lifetime.setCreated(date);
        }
        if (date2 != null) {
            lifetime.setExpires(date2);
        }
        return lifetime;
    }

    public static void addChildTo(IElement iElement, IElement iElement2) {
        String string = "addChildTo()";
        SCTHelper.trEntry(string);
        OMElement oMElement = null;
        OMElement oMElement2 = null;
        try {
            oMElement = (OMElement)iElement.getAs(OMElement.class);
            oMElement2 = (OMElement)iElement2.getAs(OMElement.class);
            if (oMElement != null && oMElement2 != null) {
                oMElement.addChild(oMElement2);
            } else {
                SCTHelper.trDebug("Either the parent or the child is null.");
            }
        }
        catch (UnsupportedContainedObjectClassException unsupportedContainedObjectClassException) {
            SCTHelper.trDebug("A problem occurred when getting an instance of the elements: " + unsupportedContainedObjectClassException.getLocalizedMessage());
            SCTHelper.trExit(string);
            return;
        }
        SCTHelper.trExit(string);
    }

    public static void addTextTo(IElement iElement, String string) {
        String string2 = "addTextTo()";
        SCTHelper.trEntry(string2);
        OMElement oMElement = null;
        try {
            oMElement = (OMElement)iElement.getAs(OMElement.class);
            if (oMElement != null && string != null) {
                oMElement.addChild(SCTHelper.createOMText(string));
            } else {
                SCTHelper.trDebug("Either the parent or the text is null.");
            }
        }
        catch (UnsupportedContainedObjectClassException unsupportedContainedObjectClassException) {
            SCTHelper.trDebug("A problem occurred when getting an instance of the element: " + unsupportedContainedObjectClassException.getLocalizedMessage());
            SCTHelper.trExit(string2);
            return;
        }
        SCTHelper.trExit(string2);
    }

    public static void addAttributeTo(IElement iElement, String string, String string2, URI uRI, String string3) {
        String string4 = "addAttributeTo()";
        SCTHelper.trEntry(string4);
        OMElement oMElement = null;
        try {
            oMElement = (OMElement)iElement.getAs(OMElement.class);
            if (oMElement != null) {
                oMElement.addAttribute(SCTHelper.createOMAttribute(string, string2, uRI, string3));
            } else {
                SCTHelper.trDebug("The parent is null.");
            }
        }
        catch (UnsupportedContainedObjectClassException unsupportedContainedObjectClassException) {
            SCTHelper.trDebug("A problem occurred when getting an instance of the element: " + unsupportedContainedObjectClassException.getLocalizedMessage());
            SCTHelper.trExit(string4);
            return;
        }
        SCTHelper.trExit(string4);
    }

    public static OMElement extractElementFromSet(Set<OMElement> set, String string) {
        Iterator<OMElement> iterator = set.iterator();
        OMElement oMElement = null;
        while (iterator.hasNext()) {
            OMElement oMElement2 = iterator.next();
            if (!oMElement2.getLocalName().equals(string)) continue;
            oMElement = oMElement2;
            break;
        }
        return oMElement;
    }

    public static String extractTextFrom(IElement iElement, String[] stringArray) {
        String string = "extractTextFrom()";
        SCTHelper.trEntry(string);
        String string2 = null;
        if (iElement != null) {
            OMElement oMElement = null;
            try {
                oMElement = (OMElement)iElement.getAs(OMElement.class);
            }
            catch (UnsupportedContainedObjectClassException unsupportedContainedObjectClassException) {
                SCTHelper.trDebug("A problem occurred when getting an instance of the element: " + unsupportedContainedObjectClassException.getLocalizedMessage());
                SCTHelper.trExit(string);
                return null;
            }
            for (String string3 : stringArray) {
                OMElement oMElement2 = SCTHelper.findChildElement(oMElement, string3);
                if (oMElement2 == null) {
                    return null;
                }
                oMElement = oMElement2;
            }
            string2 = oMElement.getText();
        }
        SCTHelper.trExit(string);
        return string2;
    }

    public static String extractAttributeFrom(IElement iElement, String[] stringArray, String string) {
        String string2 = "extractAttributeFrom()";
        SCTHelper.trEntry(string2);
        String string3 = null;
        if (iElement != null && string != null) {
            OMElement oMElement = null;
            try {
                oMElement = (OMElement)iElement.getAs(OMElement.class);
            }
            catch (UnsupportedContainedObjectClassException unsupportedContainedObjectClassException) {
                SCTHelper.trDebug("A problem occurred when getting an instance of the element: " + unsupportedContainedObjectClassException.getLocalizedMessage());
                SCTHelper.trExit(string2);
                return null;
            }
            if (oMElement == null) {
                SCTHelper.trDebug("The parent is null.");
                SCTHelper.trExit(string2);
                return null;
            }
            for (String string4 : stringArray) {
                OMElement oMElement2 = SCTHelper.findChildElement(oMElement, string4);
                if (string4 == null) {
                    return null;
                }
                oMElement = oMElement2;
            }
            string3 = oMElement.getAttributeValue(new QName(string));
        }
        SCTHelper.trExit(string2);
        return string3;
    }

    public static byte[] copyOf(byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    public static byte[] decode(String string) {
        return Base64.decode(string);
    }

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray);
    }

    public static String generateUUID() {
        String string = UUIDGenerator.getUUID();
        if (string.startsWith(UUIDGeneratorPrefix)) {
            string = string.substring(UUIDGeneratorPrefix.length());
        }
        return string;
    }

    public static byte[] generateSecret(String string, String string2, int n) {
        String string3 = CLASS_NAME + ".generateServerSecret(" + "algorithm=" + string + "," + "provider=" + string2 + "," + "keySize=" + n + ")";
        SCTHelper.trEntry(string3);
        byte[] byArray = null;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string, string2);
            keyGenerator.init(n);
            SecretKey secretKey = keyGenerator.generateKey();
            byArray = secretKey.getEncoded();
        }
        catch (Exception exception) {
            SCTHelper.trDebug("Error occurred while generating secret: " + exception.getLocalizedMessage());
            SCTHelper.trExit(string3);
            return null;
        }
        SCTHelper.trExit(string3);
        return byArray;
    }

    public static String getMessage(String string, String[] stringArray) {
        return SoapSecurityException.format(string, stringArray).getMessage();
    }

    public static IFault populateIFault(IFault iFault, String string, URI uRI, String string2, String string3) {
        if (iFault != null) {
            iFault.setCodePrefix(string);
            iFault.setCodeNamespace(uRI);
            iFault.setCodeLocalPart(string2);
            iFault.setReason(string3);
        }
        return iFault;
    }

    private static OMElement findChildElement(OMElement oMElement, String string) {
        OMElement oMElement2 = null;
        if (oMElement != null) {
            Iterator iterator = oMElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement oMElement3 = (OMElement)iterator.next();
                if (!oMElement3.getLocalName().equals(string)) continue;
                oMElement2 = oMElement3;
                break;
            }
        }
        return oMElement2;
    }

    private static OMText createOMText(String string) {
        return omFactory.createOMText(string);
    }

    private static OMAttribute createOMAttribute(String string, String string2, URI uRI, String string3) {
        OMNamespace oMNamespace = null;
        if (string2 != null && uRI != null) {
            oMNamespace = omFactory.createOMNamespace(uRI.toString(), string2);
        }
        OMAttribute oMAttribute = omFactory.createOMAttribute(string, oMNamespace, string3);
        return oMAttribute;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }

    static {
        sctConfigProperties = null;
        omFactory = OMAbstractFactory.getOMFactory();
        CLASS_NAME = SCTHelper.class.getName();
        tc = Tr.register(SCTHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    }
}

