/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.cache.STSTokenCacheFactory;
import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTCancel;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTGetToken;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTIssue;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTPutToken;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTRenew;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTValidate;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IFault;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.ISTSRequest;
import org.eclipse.higgins.sts.ISTSResponse;
import org.eclipse.higgins.sts.server.ISecurityTokenServiceExtension;

public class SCTHandler
implements ISecurityTokenServiceExtension {
    private HashMap<String, RequestHandler> handlerMap = new HashMap();
    private STSTokenCacheFactory tcFactory;
    private static final TraceComponent tc = Tr.register(SCTHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public void invoke(ISTSRequest iSTSRequest, ISTSResponse iSTSResponse, IConstants iConstants) {
        String string = "invoke()";
        SCTHandler.trEntry(string);
        Iterator iterator = SCTHandler.extractRSTs(iSTSRequest);
        while (iterator.hasNext()) {
            String string2;
            IRequestSecurityToken iRequestSecurityToken = (IRequestSecurityToken)iterator.next();
            URI uRI = iRequestSecurityToken.getRequestType();
            if (uRI == null) {
                string2 = "RequestType is missing from RequestSecurityToken.";
                SCTHandler.trDebug(string2);
                iSTSResponse.setFault(SCTHelper.populateIFault(new InvalidRequestException(string2), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E"));
                SCTHandler.trExit(string);
                return;
            }
            string2 = uRI.toString();
            RequestHandler requestHandler = this.handlerMap.get(string2);
            IRequestSecurityTokenResponse iRequestSecurityTokenResponse = null;
            if (requestHandler != null) {
                try {
                    iRequestSecurityTokenResponse = requestHandler.handleRequest(iRequestSecurityToken, string2, iConstants);
                }
                catch (Exception exception) {
                    SCTHandler.trDebug("Exception caught by SCTHandler while attempting to process request: " + exception.getLocalizedMessage());
                    if (IFault.class.isAssignableFrom(exception.getClass())) {
                        iSTSResponse.setFault((IFault)((Object)exception));
                    }
                    SCTHandler.trExit(string);
                    return;
                }
                if (iRequestSecurityTokenResponse == null) continue;
                SCTHandler.addToSTSResponse(iSTSResponse, iRequestSecurityTokenResponse);
                continue;
            }
            String string3 = SCTHelper.getMessage("security.wssecurity.sct.s01", new String[]{string2});
            Tr.error(tc, string3);
            SCTHandler.trDebug("This handler does not recognize the specified request type: " + string2);
            iSTSResponse.setFault(SCTHelper.populateIFault(new InvalidRequestException(string3), "wst", iConstants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E"));
            SCTHandler.trExit(string);
            return;
        }
        SCTHandler.trExit(string);
    }

    public void initialize() {
    }

    public void destroy() {
    }

    public void configure(Map map) {
        RequestHandler requestHandler;
        Object object;
        Object object2;
        Object object32;
        String string = "configure()";
        SCTHandler.trEntry(string);
        Properties properties = new Properties();
        for (Object object32 : map.keySet()) {
            properties.setProperty((String)object32, (String)map.get(object32));
        }
        SCTHelper.setSCTConfigProperties(properties);
        object32 = properties.getProperty("tokenCacheFactory");
        try {
            object2 = Class.forName(object32);
            object = ((Class)object2).getConstructor(new Class[0]);
            this.tcFactory = (STSTokenCacheFactory)((Constructor)object).newInstance(new Object[0]);
            this.tcFactory.createInstance("http://schemas.xmlsoap.org/ws/2005/02/sc/sct", SCT.class, properties);
            SCTHelper.setTokenCacheFactory(this.tcFactory);
        }
        catch (Exception exception) {
            SCTHandler.trDebug("Exception occurred while trying to get an instance of " + object32 + ": " + exception.getLocalizedMessage());
            this.tcFactory = (STSTokenCacheFactory)WSSecurityFactoryBuilder.getInstance("com.ibm.ws.wssecurity.platform.TokenCacheFactory");
            if (this.tcFactory == null) {
                SCTHandler.trDebug("Default token cache implementation failed to load.");
            }
            this.tcFactory.createInstance("http://schemas.xmlsoap.org/ws/2005/02/sc/sct", properties);
            SCTHelper.setTokenCacheFactory(this.tcFactory);
        }
        this.handlerMap.clear();
        object2 = properties.getProperty("RequestType_issue");
        object = properties.getProperty("RequestType_cancel");
        String string2 = properties.getProperty("RequestType_renew");
        String string3 = properties.getProperty("RequestType_validate");
        String string4 = "There is no configuration property for ";
        String string5 = " request type rst.";
        if (object2 != null) {
            requestHandler = new SCTIssue();
            this.handlerMap.put((String)object2, requestHandler);
            ((SCTIssue)requestHandler).initialize(properties);
        } else {
            SCTHandler.trDebug(string4 + "issue" + string5);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s02", null));
        }
        if (object != null) {
            requestHandler = new SCTCancel();
            this.handlerMap.put((String)object, requestHandler);
            ((SCTCancel)requestHandler).initialize(properties);
        } else {
            SCTHandler.trDebug(string4 + "cancel" + string5);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s03", null));
        }
        if (string2 != null) {
            requestHandler = new SCTRenew();
            this.handlerMap.put(string2, requestHandler);
            ((SCTRenew)requestHandler).initialize(properties);
        } else {
            SCTHandler.trDebug(string4 + "renew" + string5);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s04", null));
        }
        if (string3 != null) {
            requestHandler = new SCTValidate();
            this.handlerMap.put(string3, requestHandler);
            ((SCTValidate)requestHandler).initialize(properties);
        } else {
            SCTHandler.trDebug(string4 + "validate" + string5);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s05", null));
        }
        requestHandler = new SCTGetToken();
        SCTPutToken sCTPutToken = new SCTPutToken();
        this.handlerMap.put("http://w3.ibm.com/ws/2005/02/trust/getToken", requestHandler);
        this.handlerMap.put("http://w3.ibm.com/ws/2005/02/trust/putToken", sCTPutToken);
        ((SCTGetToken)requestHandler).initialize(properties);
        sCTPutToken.initialize(properties);
        SCTHandler.trExit(string);
    }

    public boolean canHandle(ISTSRequest iSTSRequest, IConstants iConstants) {
        String string = "canHandle";
        SCTHandler.trEntry(string);
        Iterator iterator = SCTHandler.extractRSTs(iSTSRequest);
        while (iterator.hasNext()) {
            IRequestSecurityToken iRequestSecurityToken = (IRequestSecurityToken)iterator.next();
            URI uRI = iRequestSecurityToken.getRequestType();
            if (uRI != null) {
                String string2 = uRI.toString();
                SCTHandler.trDebug("requestType: " + string2);
                RequestHandler requestHandler = this.handlerMap.get(string2);
                SCTHandler.trDebug("handler: " + requestHandler);
                if (requestHandler != null) continue;
            }
            SCTHandler.trDebug("Returning false");
            SCTHandler.trExit(string);
            return false;
        }
        SCTHandler.trDebug("Returning true");
        SCTHandler.trExit(string);
        return true;
    }

    private static Iterator extractRSTs(ISTSRequest iSTSRequest) {
        List list = iSTSRequest.getRequestSecurityTokenCollection();
        return list.iterator();
    }

    private static ISTSResponse addToSTSResponse(ISTSResponse iSTSResponse, IRequestSecurityTokenResponse iRequestSecurityTokenResponse) {
        List list = iSTSResponse.getRequestSecurityTokenResponseCollection();
        list.add(iRequestSecurityTokenResponse);
        return iSTSResponse;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

