/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.cache.STSTokenCache;
import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.util.Properties;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;

public class SCTCancel
implements RequestHandler {
    private static final TraceComponent tc = Tr.register(SCTCancel.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public IRequestSecurityTokenResponse handleRequest(IRequestSecurityToken iRequestSecurityToken, String string, IConstants iConstants) throws InvalidRequestException {
        String string2 = "handleRequest()";
        SCTCancel.trEntry(string2);
        IElement iElement = iRequestSecurityToken.getCancelTarget();
        if (iElement == null) {
            String string3 = "Missing CancelTarget element.";
            SCTCancel.trDebug(string3);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s10", null));
            SCTCancel.trExit(string2);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string3), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        String string4 = SCTCancel.extractUUIDFromCancelTarget(iElement);
        if (string4 == null) {
            String string5 = "UUID was not successfully extracted from cancel request. Cancel failed.";
            SCTCancel.trDebug(string5);
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s11", null));
            SCTCancel.trExit(string2);
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(string5), "wst", iConstants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        IElement iElement2 = SCTCancel.generateRequestedTokenCancelled(iConstants);
        IRequestSecurityTokenResponse iRequestSecurityTokenResponse = SCTHelper.createRSTR(iRequestSecurityToken.getContext());
        iRequestSecurityTokenResponse.setRequestedTokenCancelled(iElement2);
        SCTCancel.cancelSCT(string4);
        SCTCancel.trExit(string2);
        return iRequestSecurityTokenResponse;
    }

    public void initialize(Properties properties) {
    }

    private static IElement generateRequestedTokenCancelled(IConstants iConstants) {
        return SCTHelper.createIElement("RequestedTokenCancelled", "wst", iConstants.getWSTrustNamespace());
    }

    private static String extractUUIDFromCancelTarget(IElement iElement) {
        String string = SCTHelper.extractTextFrom(iElement, new String[]{"SecurityContextToken", "Identifier"});
        return string;
    }

    private static void cancelSCT(String string) {
        STSTokenCache sTSTokenCache = SCTHelper.getCache();
        SCT sCT = (SCT)sTSTokenCache.removeToken(string);
        if (sCT != null) {
            sCT.setCancelState();
        }
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

