/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.net.InetAddress;
import java.net.URL;

public class STSUriUtil {
    private static final TraceComponent tc = Tr.register(STSUriUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static int URICompare(String string, String string2) {
        STSUriUtil.trEntry("URICompare(attachedResourceURI[" + string + "], testResourceURI[" + string2 + "])");
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        String[] stringArray = null;
        String[] stringArray2 = null;
        n2 = STSUriUtil.StringCompare(string, string2);
        if (n2 > 0) {
            stringArray = STSUriUtil.NormalizeURI(string);
            stringArray2 = STSUriUtil.NormalizeURI(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    n = STSUriUtil.StringCompare(stringArray[i], stringArray2[j]);
                    if (n >= n2) continue;
                    n2 = n;
                }
            }
            if (n2 == Integer.MAX_VALUE) {
                n2 = -1;
            }
        }
        STSUriUtil.trExit("URICompare(...) returns distance[" + n2 + "]");
        return n2;
    }

    public static int ResourceCompare(String string, String string2) {
        STSUriUtil.trEntry("ResourceCompare(attachedResource[" + string + "], testResource[" + string2 + "]");
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        String[] stringArray = null;
        String[] stringArray2 = null;
        n = STSUriUtil.StringCompare(string, string2);
        if (n == Integer.MAX_VALUE) {
            String string3;
            String string4 = STSUriUtil.getPrefix(string);
            if (!STSUriUtil.equals(string4, string3 = STSUriUtil.getPrefix(string2))) {
                n = Integer.MAX_VALUE;
            } else {
                String string5;
                String string6 = STSUriUtil.getService(string);
                if (!STSUriUtil.equals(string6, string5 = STSUriUtil.getService(string2))) {
                    n = Integer.MAX_VALUE;
                } else {
                    String string7;
                    String string8 = STSUriUtil.getResourceProtocol(string);
                    if (!STSUriUtil.equalsIgnoreCase(string8, string7 = STSUriUtil.getResourceProtocol(string2))) {
                        n = Integer.MAX_VALUE;
                    } else {
                        stringArray = STSUriUtil.NormalizeResource(string);
                        stringArray2 = STSUriUtil.NormalizeResource(string2);
                        for (int i = 0; i < stringArray.length; ++i) {
                            for (int j = 0; j < stringArray2.length; ++j) {
                                n2 = STSUriUtil.StringCompare(stringArray[i], stringArray2[j]);
                                if (n2 >= n) continue;
                                n = n2;
                            }
                        }
                    }
                }
            }
            if (n == Integer.MAX_VALUE) {
                n = -1;
            }
        }
        if (tc.isDebugEnabled()) {
            if (n == 0) {
                Tr.debug(tc, "TRUST POLICY SET MATCH FOUND!");
            } else if (n != -1) {
                Tr.debug(tc, "Inherited trust policy set found.  Keep looking for better match.");
            } else {
                Tr.debug(tc, "Policy set does not apply.  Keep looking.");
            }
        }
        STSUriUtil.trExit("ResourceCompare(...) returns distance[" + n + "]");
        return n;
    }

    private static String[] NormalizeURI(String string) {
        STSUriUtil.trEntry("NormalizeURI(anURL[" + string + "])");
        boolean bl = false;
        URL uRL = null;
        URL uRL2 = null;
        String string2 = null;
        String string3 = null;
        int n = 80;
        String string4 = null;
        String string5 = null;
        String[] stringArray = null;
        InetAddress[] inetAddressArray = null;
        if (string.length() == 0) {
            stringArray = new String[]{string};
        } else {
            String string6;
            if (string.regionMatches(true, 0, "http://", 0, "http://".length()) || string.regionMatches(true, 0, "https://", 0, "https://".length())) {
                string5 = string;
                bl = true;
            } else {
                string5 = "http://" + string;
            }
            try {
                uRL2 = new URL(string5);
                n = uRL2.getPort();
                if (n == -1 && (n = uRL2.getDefaultPort()) == -1) {
                    n = 80;
                }
                if ((string2 = uRL2.getHost()).equalsIgnoreCase("localhost") || string2.equals("127.0.0.1") || string2.equalsIgnoreCase("localhost.localdomain")) {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    string6 = inetAddress.getHostName();
                    inetAddressArray = InetAddress.getAllByName(string6);
                } else {
                    inetAddressArray = InetAddress.getAllByName(string2);
                }
                stringArray = new String[inetAddressArray.length];
                for (int i = 0; i < inetAddressArray.length; ++i) {
                    string4 = inetAddressArray[i].getHostAddress();
                    uRL = new URL(uRL2.getProtocol(), string4, n, uRL2.getFile());
                    if (bl) {
                        stringArray[i] = uRL.toString();
                        continue;
                    }
                    if (bl) continue;
                    stringArray[i] = uRL.toString().substring("http://".length());
                }
            }
            catch (Exception exception) {
                STSUriUtil.trDebug("Unable to normalize URL: " + exception.getMessage());
            }
            if (stringArray == null || stringArray[0] == null) {
                String string7 = null;
                string6 = null;
                try {
                    string3 = STSUriUtil.getURLProtocol(string);
                    if (string3 != null) {
                        string7 = string3.toLowerCase();
                    }
                    if ((string2 = STSUriUtil.getIPAddress(string)) != null) {
                        string6 = string2.toLowerCase();
                    }
                    STSUriUtil.trDebug("protocol[" + string3 + "], lcProtocol[" + string7 + "], hostName[" + string2 + "], lcHostName[" + string6 + "]");
                    if (string6 != null && string7 != null) {
                        String string8 = null;
                        string8 = string3.equals(string7) ? string : STSUriUtil.replaceSubstring(string, string3, string7);
                        String string9 = null;
                        string9 = string2.equals(string6) ? string : STSUriUtil.replaceSubstring(string8, string2, string6);
                        stringArray = new String[]{string9};
                    }
                }
                catch (Exception exception) {
                    STSUriUtil.trDebug("Unable to lowercase protocol and IP Address in URL: " + exception.getMessage());
                }
            }
            if (stringArray == null || stringArray[0] == null) {
                stringArray = new String[]{string};
            }
        }
        STSUriUtil.trExit("NormalizeURI(...) returns normalizedURIs");
        return stringArray;
    }

    private static String[] NormalizeResource(String string) {
        int n;
        STSUriUtil.trEntry("NormalizeResource(resource[" + string + "])");
        int n2 = 0;
        String[] stringArray = null;
        String[] stringArray2 = null;
        n2 = string.indexOf(":/") + 2;
        stringArray = STSUriUtil.NormalizeURI(string.substring(n2));
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n] = string.substring(0, n2) + stringArray[n];
            }
        } else {
            stringArray2 = new String[]{string};
        }
        if (tc.isDebugEnabled()) {
            if (stringArray2 == null) {
                Tr.debug(tc, "normalizedResource == null");
            } else {
                for (n = 0; n < stringArray2.length; ++n) {
                    Tr.debug(tc, "normalizedResource[" + n + "] is [" + stringArray2[n] + "]");
                }
            }
        }
        STSUriUtil.trExit("NormalizeResource(...) returns normalizedResource");
        return stringArray2;
    }

    public static int StringCompare(String string, String string2) {
        STSUriUtil.trEntry("StringCompare(attachedResource[" + string + "], testResource[" + string2 + "]");
        int n = 0;
        n = string2.startsWith(string) ? string2.length() - string.length() : Integer.MAX_VALUE;
        STSUriUtil.trExit("StringCompare(...) returns distance[" + n + "]");
        return n;
    }

    public static boolean equals(String string, String string2) {
        STSUriUtil.trEntry("equals(string1[" + string + "], string2[" + string2 + "])");
        boolean bl = false;
        bl = string == null || string2 == null ? false : string.equals(string2);
        STSUriUtil.trExit("equals(...) returns rc[" + bl + "]");
        return bl;
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        STSUriUtil.trEntry("equalsIgnoreCase(string1[" + string + "], string2[" + string2 + "])");
        boolean bl = false;
        bl = string == null || string2 == null ? false : string.equalsIgnoreCase(string2);
        STSUriUtil.trExit("equalsIgnoreCase(...) returns rc[" + bl + "]");
        return bl;
    }

    public static String getPrefix(String string) {
        String string2 = STSUriUtil.getSubstring(string, null, ":/");
        return string2;
    }

    public static String getResourceProtocol(String string) {
        String string2 = STSUriUtil.getSubstring(string, ":/", "://");
        return string2;
    }

    public static String getURLProtocol(String string) {
        String string2 = STSUriUtil.getSubstring(string, null, "://");
        return string2;
    }

    public static String getIPAddress(String string) {
        String string2 = STSUriUtil.getSubstring(string, "://", ":");
        if (string2 == null) {
            string2 = STSUriUtil.getSubstring(string, "://", "/");
        }
        return string2;
    }

    public static String getPort(String string, String string2) {
        String string3 = null;
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(':');
            string3 = STSUriUtil.getSubstring(string, stringBuffer.toString(), "/");
        }
        return string3;
    }

    public static String getService(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = null;
        string2 = STSUriUtil.getIPAddress(string);
        if (string2 != null) {
            stringBuffer = new StringBuffer(string2);
            string3 = STSUriUtil.getPort(string, string2);
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append(':');
                stringBuffer.append(string3);
            }
            string4 = STSUriUtil.getSubstring(string, stringBuffer.toString(), null);
        }
        return string4;
    }

    public static String getSubstring(String string, String string2, String string3) {
        int n = -1;
        int n2 = -1;
        String string4 = null;
        if (string2 == null) {
            n = 0;
        } else {
            n = string.indexOf(string2);
            if (n != -1) {
                n += string2.length();
            }
        }
        if (n != -1) {
            n2 = string3 == null ? string.length() : string.indexOf(string3, n);
        }
        string4 = n == -1 || n2 == -1 ? null : string.substring(n, n2);
        return string4;
    }

    public static String replaceSubstring(String string, String string2, String string3) {
        StringBuffer stringBuffer = null;
        int n = -1;
        int n2 = -1;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (string != null && string2 != null && string3 != null && (n = string.indexOf(string2)) != -1) {
            n2 = n + string2.length();
            string4 = string.substring(0, n);
            string5 = string.substring(n2, string.length());
            stringBuffer = new StringBuffer(string4);
            if (stringBuffer != null) {
                stringBuffer.append(string3);
                stringBuffer.append(string5);
                string6 = stringBuffer.toString();
            }
        }
        return string6;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

