/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.CacheableToken;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.net.URI;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.impl.Constants;
import org.eclipse.higgins.sts.impl.RequestSecurityToken;
import org.eclipse.higgins.sts.impl.STSRequest;
import org.eclipse.higgins.sts.impl.STSResponse;
import org.eclipse.higgins.sts.server.impl.SecurityTokenService;

public abstract class STSTokenUtil {
    private static final TraceComponent tc = Tr.register(STSTokenUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static final Boolean putToken(CacheableToken cacheableToken, String string) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putToken(CacheableToken token, String TokenTypeURI=" + string + ")");
        }
        Boolean bl = false;
        try {
            STSRequest sTSRequest = new STSRequest();
            RequestSecurityToken requestSecurityToken = new RequestSecurityToken();
            requestSecurityToken.setRequestType(new URI("http://w3.ibm.com/ws/2005/02/trust/putToken"));
            requestSecurityToken.setTokenType(new URI(string));
            requestSecurityToken.setData(cacheableToken);
            List list = sTSRequest.getRequestSecurityTokenCollection();
            list.add(requestSecurityToken);
            SecurityTokenService securityTokenService = STSConfigUtil.getSecurityTokenServiceSingletonInstance();
            STSResponse sTSResponse = new STSResponse();
            securityTokenService.invoke(sTSRequest, sTSResponse, new Constants());
            if (sTSResponse != null) {
                List list2 = sTSResponse.getRequestSecurityTokenResponseCollection();
                if (list2.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "empty vector returned from SecurityTokenService");
                    }
                } else {
                    IRequestSecurityTokenResponse iRequestSecurityTokenResponse = (IRequestSecurityTokenResponse)list2.get(0);
                    bl = (Boolean)iRequestSecurityTokenResponse.getData();
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in putToken");
            }
            exception.printStackTrace();
            throw new AxisFault(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putToken(CacheableToken token, String TokenTypeURI=" + string + ")");
        }
        return bl;
    }

    public static final CacheableToken getToken(String string, String string2) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getToken(String UUID=" + string + ", String TokenTypeURI=" + string2 + ")");
        }
        CacheableToken cacheableToken = null;
        try {
            STSRequest sTSRequest = new STSRequest();
            RequestSecurityToken requestSecurityToken = new RequestSecurityToken();
            requestSecurityToken.setRequestType(new URI("http://w3.ibm.com/ws/2005/02/trust/getToken"));
            requestSecurityToken.setTokenType(new URI(string2));
            requestSecurityToken.setData(string);
            List list = sTSRequest.getRequestSecurityTokenCollection();
            list.add(requestSecurityToken);
            SecurityTokenService securityTokenService = STSConfigUtil.getSecurityTokenServiceSingletonInstance();
            STSResponse sTSResponse = new STSResponse();
            securityTokenService.invoke(sTSRequest, sTSResponse, new Constants());
            if (sTSResponse != null) {
                List list2 = sTSResponse.getRequestSecurityTokenResponseCollection();
                if (list2.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "empty vector returned from SecurityTokenService");
                    }
                } else {
                    IRequestSecurityTokenResponse iRequestSecurityTokenResponse = (IRequestSecurityTokenResponse)list2.get(0);
                    cacheableToken = (CacheableToken)iRequestSecurityTokenResponse.getData();
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in getToken");
            }
            exception.printStackTrace();
            throw new AxisFault(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getToken(String UUID=" + string + ", String TokenTypeURI=" + string2 + ")");
        }
        return cacheableToken;
    }
}

