/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.trust.server.sts.STSCallbackHandler;
import com.ibm.ws.wssecurity.trust.server.sts.Util.Constants;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSUriUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.apache.axis2.context.MessageContext;
import org.eclipse.higgins.sts.IAddressingInformation;
import org.eclipse.higgins.sts.IAppliesTo;
import org.eclipse.higgins.sts.IEndpointReference;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.ISTSRequest;

public class STSSecurityUtil {
    private static final TraceComponent tc = Tr.register(STSSecurityUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = STSSecurityUtil.class.getName();
    private URI to = null;
    private URI appliesTo = null;
    private URI issuer = null;
    private STSTargetMap targetMap;
    private Subject subject;
    private Set<SecurityToken> securityTokenSet = null;

    public void invoke(ISTSRequest iSTSRequest, MessageContext messageContext) throws SoapSecurityException {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + iSTSRequest + ", " + messageContext + ")");
        }
        IAddressingInformation iAddressingInformation = iSTSRequest.getAddressingInformation();
        this.to = iAddressingInformation.getTo();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stsTo: " + this.to);
        }
        if ((list = iSTSRequest.getRequestSecurityTokenCollection()).isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization failed in invokeSecurityLayer()");
            }
            SoapSecurityException soapSecurityException = SoapSecurityException.format(Constants.TRUST_FAULT_FAILED_AUTHENTICATION, "security.wssecurity.WSEC6851E");
            throw soapSecurityException;
        }
        IRequestSecurityToken iRequestSecurityToken = (IRequestSecurityToken)list.get(0);
        IAppliesTo iAppliesTo = iRequestSecurityToken.getAppliesTo();
        if (iAppliesTo == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization failed in invokeSecurityLayer()");
            }
            SoapSecurityException soapSecurityException = SoapSecurityException.format(Constants.TRUST_FAULT_FAILED_AUTHENTICATION, "security.wssecurity.WSEC6851E");
            throw soapSecurityException;
        }
        IEndpointReference iEndpointReference = iAppliesTo.getEndpointReference();
        if (iEndpointReference == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization failed in invokeSecurityLayer()");
            }
            SoapSecurityException soapSecurityException = SoapSecurityException.format(Constants.TRUST_FAULT_FAILED_AUTHENTICATION, "security.wssecurity.WSEC6851E");
            throw soapSecurityException;
        }
        this.appliesTo = iEndpointReference.getAddress();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appliesTo: " + this.appliesTo);
        }
        IEndpointReference iEndpointReference2 = iRequestSecurityToken.getIssuer();
        this.issuer = null;
        if (iEndpointReference2 != null) {
            this.issuer = iEndpointReference2.getAddress();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "issuer: " + this.issuer);
        }
        this.targetMap = STSConfigUtil.getSTSTargetMap();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "targetMap: " + this.targetMap);
        }
        this.subject = (Subject)messageContext.getProperties().get(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TOKEN_WSSSUBJECT);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "subject: " + this.subject);
        }
        this.securityTokenSet = null;
        if (this.subject != null) {
            this.securityTokenSet = this.subject.getPrivateCredentials(SecurityToken.class);
        }
        this.processTargetMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(request, inMessage)");
        }
    }

    private void processTargetMap() throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTargetMap()");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            object = this.targetMap.getTarget();
            Iterator<Target> iterator = object.iterator();
            while (iterator.hasNext()) {
                List<Object> list;
                Target target;
                block28: {
                    DefaultIssuerRule defaultIssuerRule;
                    block27: {
                        target = iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  - processing target (" + target + ")");
                        }
                        String string = target.getAppliesTo();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  comparing target.getAppliesTo (" + string + ") to soap envelope's AppliesTo (" + this.appliesTo + ")");
                        }
                        if (STSUriUtil.URICompare(string, this.appliesTo.toString()) != 0) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  they are equivalent");
                        }
                        bl3 = true;
                        defaultIssuerRule = target.getDefaultIssuerRule();
                        if (defaultIssuerRule != null) break block27;
                        if (!tc.isDebugEnabled()) break block28;
                        Tr.debug(tc, "NO JAAS config found for Issuer==null");
                        break block28;
                    }
                    list = defaultIssuerRule.getTokenTypeRule();
                    for (Object object2 : list) {
                        if (!this.identityRuleExists((TokenTypeRule)object2, null)) continue;
                        bl2 = true;
                        bl = this.processTokenTypeRule((TokenTypeRule)object2, null);
                        if (!bl) continue;
                        break;
                    }
                }
                if (!bl) {
                    list = target.getIssuerRule();
                    block4: for (Object object2 : list) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  - processing rule (" + object2 + ")");
                        }
                        String string = ((IssuerRule)object2).getIssuerURI();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "issuer: " + string + ".");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "comparing issuer and this.issuer");
                        }
                        if (string != null && string.equals(this.issuer)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "issuer equals this.issuer");
                            }
                            List<TokenTypeRule> list2 = ((IssuerRule)object2).getTokenTypeRule();
                            for (TokenTypeRule tokenTypeRule : list2) {
                                if (!this.identityRuleExists(tokenTypeRule, this.issuer)) continue;
                                bl2 = true;
                                bl = this.processTokenTypeRule(tokenTypeRule, this.issuer);
                                if (!bl) continue;
                                break block4;
                            }
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "  issuer does NOT equal this.issuer");
                    }
                    if (!bl2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  tokenTypeRuleList is empty, therefore there are no JAASConfig settings");
                            Tr.debug(tc, "  comparing " + this.appliesTo.toString() + " and " + this.to.toString());
                        }
                        boolean bl4 = bl = 0 == STSUriUtil.URICompare(this.appliesTo.toString(), this.to.toString());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  URICompare returned: " + bl);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Target element was found: breaking from targets iteration.");
                }
                break;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to process tokentype rules");
            }
            Tr.processException((Throwable)exception, clsName + ".processTargetMap", "254", this);
        }
        if (!bl3) {
            boolean bl5 = bl = 0 == STSUriUtil.URICompare(this.appliesTo.toString(), this.to.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  target was not found: no rules exist for specified target.");
                Tr.debug(tc, "  comparing " + this.appliesTo.toString() + " and " + this.toString());
                Tr.debug(tc, "  URICompare returned: " + bl);
            }
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization failed in invokeSecurityLayer()");
            }
            object = SoapSecurityException.format(Constants.TRUST_FAULT_FAILED_AUTHENTICATION, "security.wssecurity.WSEC6851E");
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTargetMap()");
        }
    }

    private boolean identityRuleExists(TokenTypeRule tokenTypeRule, URI uRI) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "identityRuleExists(TokenTypeRule tokenTypeRule[" + tokenTypeRule + "], URI issuer[" + uRI + "])");
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = this.processToken(tokenTypeRule, uRI, null);
            if (!bl) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to process token");
            }
            Tr.processException((Throwable)exception, clsName + ".identityRuleExists", "297", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "identityRuleExists(TokenTypeRule tokenTypeRule, URI issuer) returns boolean[" + bl2 + "]");
        }
        return bl2;
    }

    private boolean processTokenTypeRule(TokenTypeRule tokenTypeRule, URI uRI) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTokenTypeRule(TokenTypeRule tokenTypeRule[" + tokenTypeRule + "], URI issuer[" + uRI + "])");
        }
        boolean bl = false;
        try {
            String string = tokenTypeRule.getRequiredTokenTypeURI();
            for (SecurityToken securityToken : this.securityTokenSet) {
                QName qName = securityToken.getValueType();
                String string2 = null;
                if (qName != null) {
                    string2 = qName.getLocalPart();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  comparing " + string + " and " + string2);
                }
                if (!string.equals(string2)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  they are equal");
                }
                if (!(bl = this.processToken(tokenTypeRule, uRI, securityToken))) continue;
                break;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to process token*");
            }
            Tr.processException((Throwable)exception, clsName + ".processTokenTypeRule", "337", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTokenTypeRule(TokenTypeRule tokenTypeRule, URI issuer) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private boolean processToken(TokenTypeRule tokenTypeRule, URI uRI, SecurityToken securityToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processToken(TokenTypeRule tokenTypeRule[" + tokenTypeRule + "], URI issuer[" + uRI + "], SecurityToken token[" + securityToken + "]");
        }
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "calling tokenTypeRule.getCallbackHandler()");
        }
        try {
            String string = tokenTypeRule.getRequiredTokenTypeURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tokenType: " + string);
            }
            URI uRI2 = null;
            if (string != null) {
                uRI2 = new URI(string);
            }
            String string2 = tokenTypeRule.getCallbackHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "callbackHandlerString: " + string2);
            }
            Class<?> clazz = Class.forName(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "callbackHandlerClass: " + clazz);
            }
            CallbackHandler callbackHandler = (CallbackHandler)clazz.newInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " calling STSCallbackHandler.class.isAssignableFrom(callbackHandlerClass)");
            }
            if (STSCallbackHandler.class.isAssignableFrom(clazz)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  STSCallbackHandler.class.isAssignableFrom(callbackHandlerClass) returned true");
                }
                ((STSCallbackHandler)callbackHandler).setAppliesTo(this.appliesTo);
                ((STSCallbackHandler)callbackHandler).setIssuer(uRI);
                ((STSCallbackHandler)callbackHandler).setTokenType(uRI2);
                ((STSCallbackHandler)callbackHandler).setToken(securityToken);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  STSCallbackHandler.class.isAssignableFrom(callbackHandlerClass) returned false");
            }
            String string3 = tokenTypeRule.getJAASConfigName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  jaasConfigName: " + string3);
            }
            bl = this.processJAASConfig(string3, callbackHandler);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to process JAAS config");
            }
            Tr.processException((Throwable)exception, clsName + ".CheckToken", "402", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processToken(TokenTypeRule tokenTypeRule, URI issuer, SecurityToken token) returns boolean[" + bl + "] ");
        }
        return bl;
    }

    private boolean processJAASConfig(String string, CallbackHandler callbackHandler) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processJAASConfig(String jaasConfigName[" + string + "], CallbackHandler callbackHandler[" + callbackHandler + "])");
        }
        LoginContext loginContext = null;
        boolean bl = false;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "callbackHandler.getClass().getName(): " + callbackHandler.getClass().getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating LoginContext");
            }
            loginContext = new LoginContext(string, this.subject, callbackHandler);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeeded to construct the login context.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invoking LoginModules");
            }
            loginContext.login();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "STSSecurityLayer JAAS login succeeded.");
            }
            bl = true;
        }
        catch (LoginException loginException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "STSSecurityLayer JAAS login failed.");
            }
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_AUTHENTICATION, ".X509TokenConsumer.s02", (Throwable)loginException);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "logging out of context");
            }
            loginContext.logout();
        }
        catch (LoginException loginException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "STSSecurityLayer JAAS logout failed.");
            }
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_AUTHENTICATION, ".X509TokenConsumer.s02", (Throwable)loginException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processJAASConfig(String jaasConfigName, CallbackHandler callbackHandler) returns boolean[" + bl + "]");
        }
        return bl;
    }
}

