/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSResourceEvaluator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManager;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;

public class STSPolicySetUtil {
    private static byte[] lock;
    private static TraceComponent tc;
    private static long defaultTimeout;
    private static long timeoutMinutes;
    private static HashMap<String, String> actionURIToActionMap;
    private static HashMap<String, PolicySetConfiguration> cache;
    private static final String FFDC_ID_1 = "FFDC-1";

    public static boolean isTrustRequest(MessageContext messageContext, String string) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTrustRequest(MessageContext msgContext, String action)" + string);
        }
        boolean bl = false;
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "action is not included in message");
            }
        } else {
            AxisService axisService = messageContext.getAxisService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "msgContext.getAxisService(): " + axisService);
            }
            if (axisService == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get AxisService");
                }
            } else {
                AxisOperation axisOperation = axisService.getOperationByAction(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "axisService.getOperationByAction(" + string + "): " + axisOperation);
                }
                if (axisOperation == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unable to get AxisOperation");
                    }
                } else {
                    QName qName = axisOperation.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "axisOperation.getName(): " + qName);
                    }
                    if (qName == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unable to get AxisOperation Name");
                        }
                    } else {
                        if ("STSInOutOperation".equals(qName.getLocalPart())) {
                            bl = true;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "operationName.getLocalPart().equals(STSInOutOperation) == " + bl);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrustRequest(MessageContext msgContext, String action) returns boolean[" + bl + "]");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure() throws SoapSecurityException {
        String string = "configure";
        STSPolicySetUtil.trEntry(string);
        STSConfigGroup sTSConfigGroup = STSConfigUtil.getSTSConfigurationMap();
        timeoutMinutes = defaultTimeout;
        actionURIToActionMap.clear();
        Object object = lock;
        synchronized (lock) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            cache.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            object = STSConfigUtil.getProperties(sTSConfigGroup, new String[]{"TrustServiceProperties"});
            if (object != null) {
                object5 = object.iterator();
                while (object5.hasNext()) {
                    object4 = (STSProperty)object5.next();
                    object3 = ((STSProperty)object4).getName();
                    STSPolicySetUtil.trDebug("  Found property " + (String)object3);
                    if (!((String)object3).equals("policySetCacheTimeoutMinutes")) continue;
                    timeoutMinutes = Integer.parseInt(((STSProperty)object4).getValue());
                    STSPolicySetUtil.trDebug("Successfully configured policy set timeout cache to " + timeoutMinutes + " minutes.");
                }
            }
            object5 = STSConfigUtil.getProperties(sTSConfigGroup, new String[]{"PolicySet", "Schemas"});
            object4 = new HashSet();
            if (object5 != null) {
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = ((STSProperty)object3.next()).getValue();
                    ((HashSet)object4).add(object2);
                    STSPolicySetUtil.trDebug("Search schema: " + (String)object2);
                }
            } else {
                STSPolicySetUtil.trDebug("Could not extract properties from PolicySet/Schemas configuration group.");
            }
            object3 = STSConfigUtil.getConfiguration(sTSConfigGroup, new String[]{"MessageReceiver"});
            if (object3 != null) {
                object2 = ((STSConfigGroup)object3).getSTSConfigGroup();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string2 = ((STSConfigGroup)iterator.next()).getName();
                    if (!((HashSet)object4).contains(string2)) continue;
                    STSPolicySetUtil.trDebug("Searching through MessageReceiver|" + string2 + "|Action configuration group for action properties.");
                    List<STSProperty> list = STSConfigUtil.getProperties((STSConfigGroup)object3, new String[]{string2, "Action"});
                    if (list != null) {
                        for (STSProperty sTSProperty : list) {
                            String string3 = sTSProperty.getValue();
                            String string4 = sTSProperty.getName();
                            actionURIToActionMap.put(string3, string4);
                            STSPolicySetUtil.trDebug("Learned mapping from " + string3 + " to " + string4);
                        }
                        continue;
                    }
                    STSPolicySetUtil.trDebug("Could not extract action properties.");
                }
            } else {
                STSPolicySetUtil.trDebug("Could not extract MessageReceiver configuration group.");
            }
            STSPolicySetUtil.trExit(string);
            return;
        }
    }

    public static String mapTrustAction(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapTrustAction(String:" + string + ")");
        }
        String string2 = null;
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "actionURI == null");
            }
        } else {
            string2 = actionURIToActionMap.get(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapTrustAction returns String:action: " + string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PolicySetConfiguration getTrustPolicySetConfiguration(MessageContext messageContext, String string, ClassLoader classLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustPolicySetConfiguration(MessageContext msgContext, action[String:" + string + "] Classloader classLoader)");
        }
        String string2 = null;
        PolicySetConfiguration policySetConfiguration = null;
        try {
            EndpointReference endpointReference = null;
            endpointReference = messageContext.getTo();
            if (endpointReference != null) {
                string2 = endpointReference.getAddress();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endpoint = " + string2);
            }
            String string3 = new String("Trust." + string + ":/" + string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "reference = " + string3);
            }
            Object object = lock;
            // MONITORENTER : lock
            policySetConfiguration = cache.get(string3);
            // MONITOREXIT : object
            if (policySetConfiguration == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reference [String:" + string3 + "] not found in cache");
                    Tr.debug(tc, "calling PolicySetUtil.getInstance(classLoader.getSystemClassLoader()");
                }
                object = PolicySetUtil.getInstance(classLoader.getSystemClassLoader());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[PolicySetUtil:util] == " + object);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling util.getSystemAttachments(new String(system/trust))");
                }
                PolicySetAttachments policySetAttachments = ((PolicySetUtil)object).getSystemAttachments(new String("system/trust"));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[PolicySetAttachments:psa] == " + policySetAttachments);
                }
                if ((policySetConfiguration = policySetAttachments.getPolicySet(string3, new STSResourceEvaluator(), classLoader.getSystemClassLoader(), classLoader.getSystemClassLoader())) != null) {
                    byte[] byArray = lock;
                    // MONITORENTER : lock
                    cache.put(string3, policySetConfiguration);
                    // MONITOREXIT : byArray
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating an alarm to remove policy set " + string3 + " in " + timeoutMinutes + " minutes");
                    }
                    AlarmManager.createDeferrable(timeoutMinutes * 60L * 1000L, new AlarmListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void alarm(Object object) {
                            String string = (String)object;
                            byte[] byArray = lock;
                            synchronized (byArray) {
                                cache.remove(string);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Policy set " + string + " removed from the cache.");
                            }
                        }
                    }, string3);
                }
            }
            if (policySetConfiguration == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "[PolicySetConfiguration:psc] == " + policySetConfiguration);
            }
        }
        catch (Exception exception) {
            Tr.processException(exception, "security.wssecurity.WSSecurityConsumerHandler.s04", "368");
            throw new SoapSecurityException("security.wssecurity.WSSecurityConsumerHandler.s04");
        }
        if (!tc.isEntryEnabled()) return policySetConfiguration;
        Tr.exit(tc, "getTrustPolicySetConfiguration() returns psc");
        return policySetConfiguration;
    }

    public static String getActionFromMessage(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActionFromMessage(MessageContext");
        }
        SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
        String string = null;
        if (sOAPEnvelope == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to get Envelope from the request messageContext");
            }
        } else {
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            if (sOAPHeader == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get Header from the request envelope");
                }
            } else {
                OMElement oMElement;
                String string2 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                ArrayList arrayList = sOAPHeader.getHeaderBlocksWithNSURI(string2);
                if (arrayList.isEmpty()) {
                    string2 = "http://www.w3.org/2005/08/addressing";
                    arrayList = sOAPHeader.getHeaderBlocksWithNSURI(string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking for " + string2 + ", " + "Action");
                }
                if (null != (oMElement = sOAPHeader.getFirstChildWithName(new QName(string2, "Action")))) {
                    string = oMElement.getText();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Action: " + oMElement.getText());
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Action: <not found>");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActionFromMessage(MessageContext msgContext) returns = " + string);
        }
        return string;
    }

    private static void initialize() {
        tc = Tr.register(STSPolicySetUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        lock = new byte[0];
        timeoutMinutes = defaultTimeout = 120L;
        actionURIToActionMap = new HashMap();
        cache = new HashMap();
        try {
            STSPolicySetUtil.configure();
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException(soapSecurityException, "STSPolicySetUtil.initialize", FFDC_ID_1);
            Tr.error(tc, "security.wssecurity.config.s01");
        }
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }

    static {
        STSPolicySetUtil.initialize();
    }
}

