/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.platform.trust.server.sts.STSConfigurationMapLoader;
import com.ibm.ws.wssecurity.platform.trust.server.sts.STSExtensionMapLoader;
import com.ibm.ws.wssecurity.platform.trust.server.sts.STSTargetMapLoader;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSPolicySetUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Configuration;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Property;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.AssignedTokenType;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.higgins.sts.impl.AppliesToMapping;
import org.eclipse.higgins.sts.impl.ExtensionMappingKey;
import org.eclipse.higgins.sts.server.impl.SecurityTokenService;
import org.eclipse.higgins.sts.server.impl.SecurityTokenServiceFactory;
import org.eclipse.higgins.sts.utilities.ObjectFactoryHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSConfigUtil {
    private static final String comp = "security.wssecurity";
    private static boolean bInitialized = false;
    private static HashMap actionStringsMap = new HashMap();
    private static final String CLASS_NAME = STSConfigUtil.class.getName();
    private static final TraceComponent tc;
    private static final STSConfigUtil singleton;
    private static SecurityTokenService securityTokenService;
    private static STSExtensionMap stsPluginMap;
    private static STSTargetMap stsTargetMap;
    private static STSConfigGroup stsConfigMap;

    public boolean loadSTSConfiguration() throws SoapSecurityException {
        String string = "loadSTSConfiguration";
        STSConfigUtil.trEntry(string);
        boolean bl = false;
        try {
            if (bInitialized) {
                String string2 = SecurityTokenServiceFactory.class.getName();
                SecurityTokenService securityTokenService = (SecurityTokenService)ObjectFactoryHelper.getNewInstanceFromFactory(string2);
                if (securityTokenService == null) {
                    STSConfigUtil.trDebug("Initialization of security token service failed");
                    throw new SoapSecurityException("Initialization of security token service failed");
                }
                STSConfigUtil.initializeSecurityTokenService(securityTokenService);
                STSConfigUtil.setSecurityTokenServiceSingletonInstance(securityTokenService);
            } else {
                STSConfigUtil.getSecurityTokenServiceSingletonInstance();
            }
            STSPolicySetUtil.configure();
            bl = true;
        }
        catch (Exception exception) {
            STSConfigUtil.trDebug("Initialization of security token service failed: " + exception.getLocalizedMessage());
            FFDCFilter.processException(exception, CLASS_NAME + ".loadSTSConfiguration", "85");
            bl = false;
        }
        STSConfigUtil.trExit(string);
        return bl;
    }

    public static STSConfigUtil getSingletonInstance() {
        return singleton;
    }

    /*
     * WARNING - void declaration
     */
    public static void initializeSecurityTokenService(SecurityTokenService securityTokenService) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator<AssignedTokenType> iterator;
        List<AssignedTokenType> list;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        String string = "initializeSecurityTokenService(ISecurityTokenService SecurityTokenService)";
        STSConfigUtil.trEntry(string);
        STSExtensionMap sTSExtensionMap = STSConfigUtil.loadSTSExtensionMap();
        STSTargetMap sTSTargetMap = STSConfigUtil.loadSTSTargetMap();
        STSConfigGroup sTSConfigGroup = STSConfigUtil.loadSTSConfigurationMap();
        HashMap<Object, AppliesToMapping> hashMap = new HashMap<Object, AppliesToMapping>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        HashMap<Object, List<AssignedTokenType>> hashMap3 = new HashMap<Object, List<AssignedTokenType>>();
        HashMap<Object, Serializable> hashMap4 = new HashMap<Object, Serializable>();
        Vector<ExtensionMappingKey> vector = new Vector<ExtensionMappingKey>();
        HashMap<List<AssignedTokenType>, String> hashMap5 = new HashMap<List<AssignedTokenType>, String>();
        if (sTSConfigGroup == null) {
            STSConfigUtil.trDebug("stsconfig.xml was not successfully parsed.");
            throw SoapSecurityException.format("security.wssecurity.config.s01");
        }
        STSConfigUtil.populateActionStringsMap(sTSConfigGroup);
        Object object10 = STSConfigUtil.getConfiguration(sTSConfigGroup, new String[]{"STSMapping", "Default"});
        if (object10 == null) {
            STSConfigUtil.trDebug("Path STSMapping|Default not found in generic STS configuration file.");
        } else {
            STSConfigUtil.trDebug("Building default EMKs...");
            object9 = ((STSConfigGroup)object10).getSTSConfigGroup();
            object8 = object9.iterator();
            while (object8.hasNext()) {
                void object52;
                object7 = object8.next();
                object6 = ((STSConfigGroup)object7).getSTSProperty();
                list = object6.iterator();
                iterator = null;
                Object var18_28 = null;
                object4 = null;
                URI uRI = null;
                while (list.hasNext()) {
                    object3 = list.next();
                    object2 = ((STSProperty)object3).getName();
                    object = ((STSProperty)object3).getType();
                    if (object == null || !((String)object).equals("EMK")) {
                        STSConfigUtil.trDebug("Expecting Type=\"EMK\". Actual type=" + (String)object);
                        continue;
                    }
                    if (((String)object2).equals("Action")) {
                        STSConfigUtil.trDebug("Found Action: " + ((STSProperty)object3).getValue());
                        iterator = STSConfigUtil.extractURIFromValue((STSProperty)object3, sTSConfigGroup);
                        continue;
                    }
                    if (((String)object2).equals("TokenType")) {
                        STSConfigUtil.trDebug("Found TokenType: " + ((STSProperty)object3).getValue());
                        URI uRI2 = STSConfigUtil.extractURIFromValue((STSProperty)object3, sTSConfigGroup);
                        continue;
                    }
                    if (((String)object2).equals("RequestType")) {
                        STSConfigUtil.trDebug("Found RequestType: " + ((STSProperty)object3).getValue());
                        object4 = STSConfigUtil.extractURIFromValue((STSProperty)object3, sTSConfigGroup);
                        continue;
                    }
                    if (((String)object2).equals("Issuer")) {
                        STSConfigUtil.trDebug("Found Issuer: " + ((STSProperty)object3).getValue());
                        uRI = STSConfigUtil.extractURIFromValue((STSProperty)object3, sTSConfigGroup);
                        continue;
                    }
                    STSConfigUtil.trDebug("Key name not recognized: " + (String)object2);
                }
                if (iterator == null && object52 == null && object4 == null && uRI == null) {
                    STSConfigUtil.trDebug("Specified key is not valid. At least one of Action, TokenType, RequestType or Issuer must be present.");
                    continue;
                }
                vector.add(new ExtensionMappingKey((URI)((Object)iterator), (URI)object52, (URI)object4, uRI));
                STSConfigUtil.trDebug("Default EMK added - {action: " + iterator + " tokenType: " + object52 + " requestType: " + object4 + " issuer: " + uRI + "}.");
            }
        }
        object9 = STSConfigUtil.getConfiguration(sTSConfigGroup, new String[]{"MessageReceiver", "http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestType"});
        if (object9 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Path MessageReceiver|http://schemas.xmlsoap.org/ws/2005/02/trust|RequestType was not found in generic STS configuration file.");
            }
        } else {
            STSConfigUtil.trDebug("Extracting default request types...");
            object8 = ((STSConfigGroup)object9).getSTSProperty();
            object7 = object8.iterator();
            while (object7.hasNext()) {
                object6 = (STSProperty)object7.next();
                list = "RequestType_" + ((STSProperty)object6).getName();
                iterator = ((STSProperty)object6).getValue();
                STSConfigUtil.trDebug("  Found request type: " + (String)((Object)list) + " = " + (String)((Object)iterator));
                hashMap5.put(list, (String)((Object)iterator));
            }
        }
        if (sTSExtensionMap == null) {
            STSConfigUtil.trDebug("stsplugins.xml was not successfully parsed.");
            throw SoapSecurityException.format("security.wssecurity.config.s02");
        }
        object10 = (ArrayList)sTSExtensionMap.getExtension();
        for (int i = 0; i < ((ArrayList)object10).size(); ++i) {
            Object object5;
            Object object11;
            Object object12;
            Object object13;
            int n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  - processing extension (" + i + ")");
            }
            object8 = (Extension)((ArrayList)object10).get(i);
            object7 = ((Extension)object8).getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenTypeURI:  " + (String)object7);
            }
            object6 = ((Extension)object8).getLocalName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigName:  " + (String)object6);
            }
            list = ((Extension)object8).getHandlerFactory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HandlerFactory:  " + (String)((Object)list));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mapConfiguration2FactoryClassName.put(" + (String)object6 + ", " + (String)((Object)list) + ")");
            }
            hashMap3.put(object6, list);
            iterator = ((Extension)object8).getConfiguration();
            ArrayList arrayList = (ArrayList)((Configuration)((Object)iterator)).getProperty();
            object4 = new Properties();
            for (n = 0; n < arrayList.size(); ++n) {
                object3 = (Property)arrayList.get(n);
                object2 = ((Property)object3).getName();
                object = ((Property)object3).getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  - found property (" + i + ") (" + (String)object2 + ", " + (String)object + ")");
                }
                ((Properties)object4).setProperty((String)object2, (String)object);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mapConfiguration2Properties.put(" + (String)object6 + ", STSProperties" + ")");
            }
            hashMap4.put(object6, (Serializable)object4);
            n = 1;
            if (sTSConfigGroup == null) {
                STSConfigUtil.trDebug("stsconfig.xml is not available.");
            } else {
                object3 = STSConfigUtil.getConfiguration(sTSConfigGroup, new String[]{"STSMapping", object6});
                if (object3 == null) {
                    STSConfigUtil.trDebug("Path STSMapping|" + (String)object6 + " not found in generic STS configuration file.");
                } else {
                    STSConfigUtil.trDebug("Building new EMKs for " + (String)object6 + "...");
                    n = 0;
                    object2 = ((STSConfigGroup)object3).getSTSConfigGroup();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Object object14;
                        object13 = (STSConfigGroup)object.next();
                        object12 = ((STSConfigGroup)object13).getSTSProperty();
                        object11 = object12.iterator();
                        object5 = null;
                        URI uRI = null;
                        URI uRI3 = null;
                        URI uRI4 = null;
                        while (object11.hasNext()) {
                            object14 = (STSProperty)object11.next();
                            String string2 = ((STSProperty)object14).getName();
                            String string3 = ((STSProperty)object14).getType();
                            if (string3 == null || !string3.equals("EMK")) {
                                STSConfigUtil.trDebug("Expecting Type=\"EMK\". Actual type=" + string3);
                                continue;
                            }
                            if (string2.equals("Action")) {
                                STSConfigUtil.trDebug("Found Action: " + ((STSProperty)object14).getValue());
                                object5 = STSConfigUtil.resolveURI(STSConfigUtil.extractURIFromValue((STSProperty)object14, sTSConfigGroup), (Extension)object8);
                                continue;
                            }
                            if (string2.equals("TokenType")) {
                                STSConfigUtil.trDebug("Found TokenType: " + ((STSProperty)object14).getValue());
                                uRI = STSConfigUtil.resolveURI(STSConfigUtil.extractURIFromValue((STSProperty)object14, sTSConfigGroup), (Extension)object8);
                                continue;
                            }
                            if (string2.equals("RequestType")) {
                                STSConfigUtil.trDebug("Found RequestType: " + ((STSProperty)object14).getValue());
                                uRI3 = STSConfigUtil.resolveURI(STSConfigUtil.extractURIFromValue((STSProperty)object14, sTSConfigGroup), (Extension)object8);
                                continue;
                            }
                            if (string2.equals("Issuer")) {
                                STSConfigUtil.trDebug("Found Issuer: " + ((STSProperty)object14).getValue());
                                uRI4 = STSConfigUtil.resolveURI(STSConfigUtil.extractURIFromValue((STSProperty)object14, sTSConfigGroup), (Extension)object8);
                                continue;
                            }
                            STSConfigUtil.trDebug("Key name not recognized: " + string2);
                        }
                        if (object5 == null && uRI == null && uRI3 == null && uRI4 == null) {
                            STSConfigUtil.trDebug("Specified key is not valid. At least one of Action, TokenType, RequestType or Issuer must be present.");
                            continue;
                        }
                        object14 = new ExtensionMappingKey((URI)object5, uRI, uRI3, uRI4);
                        hashMap2.put(object14, object6);
                        STSConfigUtil.trDebug("New EMK added - {action: " + object5 + " tokenType: " + uRI + " requestType: " + uRI3 + " issuer: " + uRI4 + "}.");
                    }
                }
            }
            if (n != 0) {
                if (vector.isEmpty()) {
                    STSConfigUtil.trDebug("Default mappings are not available. No mappings for this token type will be created.");
                } else {
                    STSConfigUtil.trDebug("Default mappings are available. These will be used to create mappings for this token type.");
                    object3 = vector.iterator();
                    while (object3.hasNext()) {
                        object2 = (ExtensionMappingKey)object3.next();
                        object = STSConfigUtil.resolveURI(((ExtensionMappingKey)object2).getAction(), (Extension)object8);
                        object13 = STSConfigUtil.resolveURI(((ExtensionMappingKey)object2).getTokenType(), (Extension)object8);
                        object12 = STSConfigUtil.resolveURI(((ExtensionMappingKey)object2).getRequestType(), (Extension)object8);
                        object11 = STSConfigUtil.resolveURI(((ExtensionMappingKey)object2).getIssuer(), (Extension)object8);
                        if (object == null && object13 == null && object12 == null && object11 == null) {
                            STSConfigUtil.trDebug("Specified key is not valid. At least one of Action, TokenType, RequestType or Issuer must be present.");
                            continue;
                        }
                        object5 = new ExtensionMappingKey((URI)object, (URI)object13, (URI)object12, (URI)object11);
                        hashMap2.put(object5, object6);
                        STSConfigUtil.trDebug("New EMK added - {action: " + object + " tokenType: " + object13 + " requestType: " + object12 + " issuer: " + object11 + "}.");
                    }
                }
            }
            if ((object3 = STSConfigUtil.getConfiguration(sTSConfigGroup, new String[]{"MessageReceiver", object7, "RequestType"})) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Path MessageReceiver|" + (String)object7 + "|" + "RequestType" + " was not found in generic STS configuration file.");
                    Tr.debug(tc, "Using default request type URIs...");
                }
                if (hashMap5.isEmpty()) {
                    STSConfigUtil.trDebug("Default request types are not available. No request type URIs will be passed to the plugin configuration.");
                    continue;
                }
                object2 = hashMap5.keySet();
                object = object2.iterator();
                while (object.hasNext()) {
                    object13 = new String((String)object.next());
                    object12 = new String((String)hashMap5.get(object13));
                    STSConfigUtil.trDebug("  Adding: [" + (String)object13 + " : " + (String)object12 + "] to the plugin configuration.");
                    ((Properties)object4).put(object13, object12);
                }
                continue;
            }
            STSConfigUtil.trDebug("Extracting specific request types...");
            object2 = ((STSConfigGroup)object3).getSTSProperty();
            object = object2.iterator();
            while (object.hasNext()) {
                object13 = (STSProperty)object.next();
                object12 = "RequestType_" + ((STSProperty)object13).getName();
                object11 = ((STSProperty)object13).getValue();
                STSConfigUtil.trDebug("  Adding: [" + (String)object12 + " : " + (String)object11 + "] to the plugin configuration.");
                ((Properties)object4).put(object12, object11);
            }
        }
        URI uRI = null;
        object8 = null;
        object7 = null;
        try {
            uRI = new URI("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            object8 = new URI("http://w3.ibm.com/ws/2005/02/trust/getToken");
            object7 = new URI("http://w3.ibm.com/ws/2005/02/trust/putToken");
        }
        catch (URISyntaxException uRISyntaxException) {
            FFDCFilter.processException(uRISyntaxException, CLASS_NAME, "331");
            STSConfigUtil.trDebug("Syntax problem for getToken/putToken URIs. " + uRISyntaxException.getLocalizedMessage());
            throw SoapSecurityException.format("security.wssecurity.config.s04", uRISyntaxException);
        }
        hashMap2.put(new ExtensionMappingKey(null, uRI, (URI)object8, null), "Security Context Token");
        hashMap2.put(new ExtensionMappingKey(null, uRI, (URI)object7, null), "Security Context Token");
        if (sTSTargetMap == null) {
            STSConfigUtil.trDebug("ststargets.xml was not successfully parsed.");
            throw SoapSecurityException.format("security.wssecurity.config.s03");
        }
        object10 = (ArrayList)sTSTargetMap.getTarget();
        for (int i = 0; i < ((ArrayList)object10).size(); ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  - processing target (" + i + ")");
            }
            object8 = (Target)((ArrayList)object10).get(i);
            object7 = ((Target)object8).getAppliesTo();
            object6 = null;
            try {
                object6 = new URI((String)object7);
            }
            catch (URISyntaxException uRISyntaxException) {
                STSConfigUtil.trDebug("Syntax problem with URIs. This element will not be added to the STS mapping. " + uRISyntaxException.getLocalizedMessage());
                throw SoapSecurityException.format("security.wssecurity.config.s03", uRISyntaxException);
            }
            list = ((Target)object8).getAssignedTokenType();
            for (AssignedTokenType assignedTokenType : list) {
                object4 = assignedTokenType.getTokenTypeURI();
                String string4 = assignedTokenType.getIssuerURI();
                STSConfigUtil.trDebug("For endpoint " + (String)object7 + ":");
                STSConfigUtil.trDebug("  TokenTypeURI: " + (String)object4);
                STSConfigUtil.trDebug("  IssuerURI: " + string4);
                object3 = null;
                object2 = null;
                try {
                    if (object4 == null) {
                        STSConfigUtil.trDebug("TokenTypeURI is a required attribute and was found to be null. This element will not be added to the STS mapping.");
                        continue;
                    }
                    object3 = new URI((String)object4);
                    if (string4 != null) {
                        object2 = new URI(string4);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    STSConfigUtil.trDebug("Syntax problem with URIs. This element will not be added to the STS mapping. " + uRISyntaxException.getLocalizedMessage());
                    throw SoapSecurityException.format("security.wssecurity.config.s03", uRISyntaxException);
                }
                STSConfigUtil.trDebug("Adding mapping from " + (String)object7 + " to (" + (String)object4 + ", " + string4 + ") to mapAppliesTo2ATM.");
                hashMap.put(object6, new AppliesToMapping((URI)object3, (URI)object2));
            }
        }
        URI uRI4 = null;
        try {
            uRI4 = new URI(sTSTargetMap.getDefaultTokenTypeURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            FFDCFilter.processException(uRISyntaxException, CLASS_NAME, "456");
            STSConfigUtil.trDebug("Problem with default token type URI syntax. " + uRISyntaxException.getLocalizedMessage());
            throw SoapSecurityException.format("security.wssecurity.config.s03", uRISyntaxException);
        }
        try {
            hashMap.put(new URI("*"), new AppliesToMapping(uRI4, null));
        }
        catch (URISyntaxException uRISyntaxException) {
            STSConfigUtil.trDebug("Syntax problem with \"*\". This element will not be added to the STS mapping. " + uRISyntaxException.getLocalizedMessage());
            throw SoapSecurityException.format("security.wssecurity.config.s03", uRISyntaxException);
        }
        try {
            securityTokenService.configure(hashMap, hashMap2, hashMap3, hashMap4);
        }
        catch (Exception exception) {
            STSConfigUtil.trDebug("Exception caught while configuring STS" + exception.getLocalizedMessage());
            throw new SoapSecurityException(exception);
        }
        STSConfigUtil.trExit(string);
    }

    public static void setSecurityTokenServiceSingletonInstance(SecurityTokenService securityTokenService) {
        STSConfigUtil.securityTokenService = securityTokenService;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Set new instance of SecurityTokenService");
        }
    }

    public static SecurityTokenService getSecurityTokenServiceSingletonInstance() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityTokenServiceSingletonInstance()");
        }
        SecurityTokenService securityTokenService = null;
        if (STSConfigUtil.securityTokenService == null) {
            String string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting new instance of SecurityTokenService");
            }
            if (null == (securityTokenService = (SecurityTokenService)ObjectFactoryHelper.getNewInstanceFromFactory(string = SecurityTokenServiceFactory.class.getName()))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to load class:" + string);
                }
                throw SoapSecurityException.format("security.wssecurity.config.s07");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loaded: " + string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "about to call initializeSecurityTokenService()");
            }
            STSConfigUtil.initializeSecurityTokenService(securityTokenService);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "finished calling initializeSecurityTokenService()");
            }
            bInitialized = true;
            STSConfigUtil.setSecurityTokenServiceSingletonInstance(securityTokenService);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityTokenServiceSingletonInstance()");
        }
        return STSConfigUtil.securityTokenService;
    }

    private static STSConfigGroup loadSTSConfigurationMap() throws SoapSecurityException {
        stsConfigMap = null;
        STSConfigurationMapLoader sTSConfigurationMapLoader = (STSConfigurationMapLoader)WSSecurityFactoryBuilder.getInstance("com.ibm.ws.wssecurity.platform.stsConfigurationMapLoader");
        if (sTSConfigurationMapLoader != null && (stsConfigMap = sTSConfigurationMapLoader.loadSTSConfigurationMap()) != null) {
            STSConfigUtil.trDebug("Generic STS configuration successfully loaded.");
        }
        if (stsConfigMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadSTSConfigurationMap, stsconfig.xml was not successfully parsed.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s01");
        }
        return stsConfigMap;
    }

    private static STSExtensionMap loadSTSExtensionMap() throws SoapSecurityException {
        stsPluginMap = null;
        STSExtensionMapLoader sTSExtensionMapLoader = (STSExtensionMapLoader)WSSecurityFactoryBuilder.getInstance("com.ibm.ws.wssecurity.platform.stsExtensionMapLoader");
        if (sTSExtensionMapLoader != null && (stsPluginMap = sTSExtensionMapLoader.loadSTSExtensionMap()) != null) {
            STSConfigUtil.trDebug("Extensions configuration successfully loaded.");
        }
        if (stsPluginMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadSTSExtensionMap, stsplugins.xml was not successfully parsed.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s02");
        }
        return stsPluginMap;
    }

    private static STSTargetMap loadSTSTargetMap() throws SoapSecurityException {
        stsTargetMap = null;
        STSTargetMapLoader sTSTargetMapLoader = (STSTargetMapLoader)WSSecurityFactoryBuilder.getInstance("com.ibm.ws.wssecurity.platform.stsTargetMapLoader");
        if (sTSTargetMapLoader != null && (stsTargetMap = sTSTargetMapLoader.loadSTSTargetMap()) != null) {
            STSConfigUtil.trDebug("Targets configuration successfully loaded.");
        }
        if (stsTargetMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadSTSTargetMap, ststargets.xml was not successfully parsed.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s03");
        }
        return stsTargetMap;
    }

    public static STSConfigGroup getSTSConfigurationMap() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSTSConfigurationMap");
        }
        if (stsConfigMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSTSConfigurationMap, stsConfigMap is null and need to load it");
            }
            stsConfigMap = STSConfigUtil.loadSTSConfigurationMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSTSConfigurationMap");
        }
        return stsConfigMap;
    }

    public static STSExtensionMap getSTSExtensionMap() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSTSExtensionMap");
        }
        if (stsPluginMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSTSExtensionMap, stsPluginMap is null and need to load it");
            }
            stsPluginMap = STSConfigUtil.loadSTSExtensionMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSTSExtensionMap");
        }
        return stsPluginMap;
    }

    public static STSTargetMap getSTSTargetMap() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSTSTargetMap");
        }
        if (stsTargetMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSTSTargetMap, stsTargetMap is null and need to load it");
            }
            stsTargetMap = STSConfigUtil.loadSTSTargetMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSTSTargetMap");
        }
        return stsTargetMap;
    }

    public static STSConfigGroup getConfiguration(STSConfigGroup sTSConfigGroup, String[] stringArray) {
        if (sTSConfigGroup == null) {
            STSConfigUtil.trDebug("Root element is null.");
            return null;
        }
        for (String string : stringArray) {
            List<STSConfigGroup> list = sTSConfigGroup.getSTSConfigGroup();
            Iterator<STSConfigGroup> iterator = list.iterator();
            sTSConfigGroup = null;
            while (iterator.hasNext()) {
                STSConfigGroup sTSConfigGroup2 = iterator.next();
                if (!sTSConfigGroup2.getName().equals(string)) continue;
                sTSConfigGroup = sTSConfigGroup2;
                break;
            }
            if (sTSConfigGroup != null) continue;
            STSConfigUtil.trDebug(string + " was not found in the configuration path.");
            return null;
        }
        return sTSConfigGroup;
    }

    public static List<STSProperty> getProperties(STSConfigGroup sTSConfigGroup, String[] stringArray) {
        STSConfigGroup sTSConfigGroup2 = STSConfigUtil.getConfiguration(sTSConfigGroup, stringArray);
        if (sTSConfigGroup2 == null) {
            STSConfigUtil.trDebug("getProperties could not find the specified STSConfigGroup.");
            return null;
        }
        return sTSConfigGroup2.getSTSProperty();
    }

    public static String mapActionRST2ActionRSTR(String string) {
        return (String)actionStringsMap.get(string);
    }

    private static URI extractURIFromValue(STSProperty sTSProperty, STSConfigGroup sTSConfigGroup) {
        String string = "extractURIFromValue";
        STSConfigUtil.trEntry(string);
        if (sTSProperty == null) {
            STSConfigUtil.trDebug("the STSProperty passed in is null.");
            STSConfigUtil.trExit(string);
            return null;
        }
        URI uRI = null;
        String string2 = null;
        String string3 = sTSProperty.getValue();
        if (string3.startsWith("#")) {
            string3 = string3.substring("#".length());
            String[] stringArray = string3.split("\\|");
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            List<STSProperty> list = STSConfigUtil.getProperties(sTSConfigGroup, stringArray2);
            if (list == null) {
                STSConfigUtil.trDebug("Path " + string3 + " was not found in the configuration.");
            } else {
                String string4 = stringArray[stringArray.length - 1];
                int n = string4.indexOf(",");
                String string5 = null;
                String string6 = null;
                if (n == -1) {
                    string5 = string4;
                } else {
                    string5 = string4.substring(0, n);
                    string6 = string4.substring(n + 1);
                }
                STSConfigUtil.trDebug("nameKey: " + string5 + " typeKey: " + string6);
                for (STSProperty sTSProperty2 : list) {
                    String string7 = sTSProperty2.getName();
                    String string8 = sTSProperty2.getType();
                    String string9 = sTSProperty2.getValue();
                    if (string6 == null) {
                        if (!string7.equals(string5)) continue;
                        STSConfigUtil.trDebug("Found a match: {name: " + string7 + " type: " + string8 + " value: " + string9 + "}");
                        string2 = string9;
                    } else {
                        if (!string7.equals(string5) || string8 == null || !string8.equals(string6)) continue;
                        STSConfigUtil.trDebug("Found a match: {name: " + string7 + " type: " + string8 + " value: " + string9 + "}");
                        string2 = string9;
                    }
                    break;
                }
            }
        } else {
            string2 = string3;
        }
        if (string2 == null) {
            STSConfigUtil.trDebug("Could not extract the URI from value " + string3);
        } else {
            try {
                uRI = new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                FFDCFilter.processException(uRISyntaxException, CLASS_NAME, "569");
                STSConfigUtil.trDebug("Value does not correspond to a valid URI. " + uRISyntaxException.getLocalizedMessage());
            }
        }
        STSConfigUtil.trExit(string);
        return uRI;
    }

    private static URI resolveURI(URI uRI, Extension extension) {
        String string = "resolveURI";
        STSConfigUtil.trEntry(string);
        if (uRI == null) {
            STSConfigUtil.trDebug("Input URI is null.");
            STSConfigUtil.trExit(string);
            return null;
        }
        String string2 = uRI.toString();
        if (!string2.startsWith("$")) {
            STSConfigUtil.trDebug("Input URI does not need to be resolved. " + uRI);
            STSConfigUtil.trExit(string);
            return uRI;
        }
        URI uRI2 = null;
        String string3 = "get" + string2.substring("$".length());
        String string4 = null;
        try {
            Method method = extension.getClass().getMethod(string3, new Class[0]);
            string4 = (String)method.invoke((Object)extension, (Object[])null);
            uRI2 = new URI(string4);
            STSConfigUtil.trDebug("Resolved URI: " + uRI2);
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException(securityException, CLASS_NAME, "625");
            STSConfigUtil.trDebug("Specified URI " + string2 + " was not successfully resolved. " + securityException.getLocalizedMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException(noSuchMethodException, CLASS_NAME, "628");
            STSConfigUtil.trDebug("Specified URI " + string2 + " was not successfully resolved. No accessor method called " + string3 + " in " + Extension.class.getName() + ". " + noSuchMethodException.getLocalizedMessage());
        }
        catch (URISyntaxException uRISyntaxException) {
            FFDCFilter.processException(uRISyntaxException, CLASS_NAME, "633");
            STSConfigUtil.trDebug("Resolved URI " + string4 + " is not a valid URI. " + uRISyntaxException.getLocalizedMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASS_NAME, "636");
            STSConfigUtil.trDebug("Specified URI " + string2 + " was not successfully resolved. " + exception.getLocalizedMessage());
        }
        STSConfigUtil.trExit(string);
        return uRI2;
    }

    private static void populateActionStringsMap(STSConfigGroup sTSConfigGroup) {
        String string = "populateActionStringsMap";
        STSConfigUtil.trEntry(string);
        STSConfigUtil.trDebug("Clearing actionStringsMap.");
        actionStringsMap.clear();
        List<STSProperty> list = STSConfigUtil.getProperties(sTSConfigGroup, new String[]{"PolicySet", "Schemas"});
        if (list != null) {
            Iterator<STSProperty> iterator = list.iterator();
            while (iterator.hasNext()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                STSProperty sTSProperty = iterator.next();
                String string2 = sTSProperty.getValue();
                STSConfigUtil.trDebug("  Found schema: " + string2);
                List<STSProperty> list2 = STSConfigUtil.getProperties(sTSConfigGroup, new String[]{"MessageReceiver", string2, "Action"});
                if (list2 != null) {
                    String string3;
                    String string4;
                    String string5;
                    for (STSProperty sTSProperty2 : list2) {
                        string5 = sTSProperty2.getName();
                        string4 = sTSProperty2.getType();
                        string3 = sTSProperty2.getValue();
                        if (string5 == null || string4 == null || string3 == null) {
                            STSConfigUtil.trDebug("      Action property should have a name, type and value. Skipping.");
                            continue;
                        }
                        if (!string4.equals("RST")) continue;
                        STSConfigUtil.trDebug("    Found action - " + string5 + " " + string4 + " " + string3);
                        hashMap.put(string5, string3);
                    }
                    for (STSProperty sTSProperty2 : list2) {
                        string5 = sTSProperty2.getName();
                        string4 = sTSProperty2.getType();
                        string3 = sTSProperty2.getValue();
                        if (string5 == null || string4 == null || string3 == null) {
                            STSConfigUtil.trDebug("      Action property should have a name, type and value. Skipping.");
                            continue;
                        }
                        if (!string4.equals("RSTR")) continue;
                        STSConfigUtil.trDebug("    Found action - " + string5 + " " + string4 + " " + string3);
                        String string6 = (String)hashMap.get(string5);
                        if (string6 != null) {
                            STSConfigUtil.trDebug("Creating entry: " + string6 + " -> " + string3);
                            actionStringsMap.put(string6, string3);
                            continue;
                        }
                        STSConfigUtil.trDebug("      RSTR does not have matching RST. Skipping.");
                    }
                    continue;
                }
                STSConfigUtil.trDebug("Actions were not found for schema " + string2 + ". Skipping.");
            }
        } else {
            STSConfigUtil.trDebug("Schemas were not found in stsconfig.xml. Could not populate actionStringsMap.");
        }
        STSConfigUtil.trExit(string);
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }

    static {
        securityTokenService = null;
        stsPluginMap = null;
        stsTargetMap = null;
        stsConfigMap = null;
        tc = Tr.register(STSConfigUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        singleton = new STSConfigUtil();
    }
}

