/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.MessageReceiver;

import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.server.sts.Util.Constants;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSSecurityUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.eclipse.higgins.sts.IAddressingInformation;
import org.eclipse.higgins.sts.IAppliesTo;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IEndpointReference;
import org.eclipse.higgins.sts.IFault;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.ISTSRequest;
import org.eclipse.higgins.sts.impl.AddressingInformation;
import org.eclipse.higgins.sts.impl.AppliesTo;
import org.eclipse.higgins.sts.impl.EndpointReference;
import org.eclipse.higgins.sts.impl.Lifetime;
import org.eclipse.higgins.sts.impl.RequestSecurityToken;
import org.eclipse.higgins.sts.impl.STSRequest;
import org.eclipse.higgins.sts.impl.STSResponse;
import org.eclipse.higgins.sts.server.impl.SecurityTokenService;
import org.eclipse.higgins.sts.utilities.XMLHelper;

public class STSMessageReceiver
extends AbstractInOutSyncMessageReceiver {
    private static final TraceComponent tc = Tr.register(STSMessageReceiver.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";

    protected AbstractMessageReceiver.ThreadContextDescriptor setThreadContext(MessageContext messageContext) {
        return null;
    }

    protected void restoreThreadContext(AbstractMessageReceiver.ThreadContextDescriptor threadContextDescriptor) {
    }

    public final void invokeBusinessLogic(MessageContext messageContext, MessageContext messageContext2) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage)");
        }
        try {
            OMElement oMElement;
            boolean bl = false;
            SOAPFactory sOAPFactory = null;
            sOAPFactory = messageContext.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
            SOAPEnvelope sOAPEnvelope = sOAPFactory.getDefaultEnvelope();
            ISTSRequest iSTSRequest = this.createSTSRequestFromMessageContext(messageContext);
            STSSecurityUtil sTSSecurityUtil = new STSSecurityUtil();
            sTSSecurityUtil.invoke(iSTSRequest, messageContext);
            SecurityTokenService securityTokenService = STSConfigUtil.getSecurityTokenServiceSingletonInstance();
            STSResponse sTSResponse = new STSResponse();
            securityTokenService.invoke(iSTSRequest, sTSResponse, new org.eclipse.higgins.sts.impl.Constants());
            if (sTSResponse == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "STS response is null");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
            }
            IFault iFault = sTSResponse.getFault();
            if (iFault != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "STS returned fault: " + iFault);
                }
                Tr.processException(new Throwable(iFault.toString()), this.getClass().getName(), FFDC_ID_1);
                URI uRI = iFault.getCodeNamespace();
                String string = uRI == null ? null : uRI.toString();
                String string2 = iFault.getCodePrefix();
                String string3 = iFault.getCodeLocalPart();
                SoapSecurityException soapSecurityException = null;
                if (string3 == null) {
                    soapSecurityException = SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
                } else {
                    QName qName = new QName(string, string3, string2 == null ? "" : string2);
                    soapSecurityException = SoapSecurityException.format(qName, iFault.getReason());
                }
                throw soapSecurityException;
            }
            List list = sTSResponse.getRequestSecurityTokenResponseCollection();
            if (list.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "empty vector returned from SecurityTokenService");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
            }
            IRequestSecurityTokenResponse iRequestSecurityTokenResponse = (IRequestSecurityTokenResponse)list.get(0);
            if (iRequestSecurityTokenResponse == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "STS returned a requestSecurityTokenResponse == null");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "STS returned a requestSecurityTokenResponse: " + iRequestSecurityTokenResponse);
            }
            this.createSoapEnvelopeFromRSTR(sOAPEnvelope, sOAPFactory, iRequestSecurityTokenResponse);
            SOAPEnvelope sOAPEnvelope2 = messageContext.getEnvelope();
            if (sOAPEnvelope2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get Envelope from the request messageContext");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            SOAPHeader sOAPHeader = sOAPEnvelope2.getHeader();
            if (sOAPHeader == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get Header from the request envelope");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            String string = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
            ArrayList arrayList = sOAPHeader.getHeaderBlocksWithNSURI(string);
            if (arrayList.isEmpty()) {
                string = "http://www.w3.org/2005/08/addressing";
                arrayList = sOAPHeader.getHeaderBlocksWithNSURI(string);
            }
            String string4 = "";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for " + string + ", " + "Action");
            }
            if (null != (oMElement = sOAPHeader.getFirstChildWithName(new QName(string, "Action")))) {
                string4 = oMElement.getText();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Action: " + oMElement.getText());
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Action: <not found>");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            String string5 = STSConfigUtil.mapActionRST2ActionRSTR(string4);
            if (string5 != null) {
                STSMessageReceiver.trDebug("Found mapping for action RST " + string4 + ": " + string5);
                SOAPHeader sOAPHeader2 = sOAPEnvelope.getHeader();
                if (sOAPHeader == null) {
                    STSMessageReceiver.trDebug("unable to get Header from the response envelope");
                } else {
                    OMElement oMElement2 = sOAPFactory.createOMElement("Action", string, "wsa");
                    oMElement2.setText(string5);
                    sOAPHeader2.addChild(oMElement2);
                }
                STSMessageReceiver.trDebug("outHeader: " + sOAPHeader2);
            } else {
                STSMessageReceiver.trDebug("No mapping found for action RST " + string4);
            }
            messageContext2.setProperty("Sandesha2UnreliableMessage", "true");
            messageContext2.setEnvelope(sOAPEnvelope);
        }
        catch (Exception exception) {
            String string = null;
            QName qName = null;
            if (exception instanceof SoapSecurityException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in invokeBusinessLogic: " + exception);
                }
                string = exception.getMessage();
                qName = ((SoapSecurityException)exception).getFaultCode();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in invokeBusinessLogic: " + exception);
                }
                Tr.processException(exception, this.getClass().getName() + ".invokeBusinessLogic", FFDC_ID_2);
                string = SoapSecurityException.getMessage("security.wssecurity.WSEC6852E");
                qName = Constants.TRUST_FAULT_REQUEST_FAILED;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "faultCode: " + qName);
            }
            if (qName == null) {
                qName = Constants.TRUST_FAULT_REQUEST_FAILED;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Message: " + string);
            }
            if (string == null) {
                string = SoapSecurityException.getMessage("security.wssecurity.WSEC6852E");
            }
            AxisFault axisFault = new AxisFault(string, qName);
            OMFactory oMFactory = OMAbstractFactory.getOMFactory();
            OMElement oMElement = oMFactory.createOMElement("Exception", null);
            oMElement.setText(string);
            axisFault.setDetail(oMElement);
            throw axisFault;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage)");
        }
    }

    private void createSoapEnvelopeFromRSTR(SOAPEnvelope sOAPEnvelope, SOAPFactory sOAPFactory, IRequestSecurityTokenResponse iRequestSecurityTokenResponse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSoapEnvelopeFromRSTR (SOAPEnvelope envelope, SOAPFactory fac, org.eclipse.higgins.sts.RequestSecurityTokenResponse RSTR)");
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            Object object13;
            Object object14;
            Object object15;
            Object object16;
            IEndpointReference iEndpointReference;
            OMElement oMElement = sOAPFactory.createOMElement("RequestSecurityTokenResponse", sOAPEnvelope.getDefaultNamespace());
            org.eclipse.higgins.sts.impl.Constants constants = new org.eclipse.higgins.sts.impl.Constants();
            OMElement oMElement2 = null;
            IElement iElement = null;
            iElement = iRequestSecurityTokenResponse.getRequestedSecurityToken();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                oMElement = sOAPFactory.createOMElement("RequestSecurityTokenResponse", oMElement2.getNamespace());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedSecurityToken: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else {
                oMElement = sOAPFactory.createOMElement("RequestSecurityTokenResponse", sOAPEnvelope.getDefaultNamespace());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedSecurityToken not found");
                }
            }
            String string = iRequestSecurityTokenResponse.getContext();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ContextURI: " + string);
            }
            if (null != string) {
                oMElement.addAttribute("Context", string, null);
            }
            if (null != (iEndpointReference = iRequestSecurityTokenResponse.getAppliesTo())) {
                oMElement2 = sOAPFactory.createOMElement("AppliesTo", constants.getWSSecurityPolicyNamespace().toString(), "wsp");
                object16 = sOAPFactory.createOMElement("EndpointReference", constants.getWSAddressingNamespace().toString(), "wsa");
                object15 = sOAPFactory.createOMElement("Address", constants.getWSAddressingNamespace().toString(), "wsa");
                object14 = sOAPFactory.createOMText(iEndpointReference.getAddress().toString());
                object15.addChild((OMNode)object14);
                object16.addChild((OMNode)object15);
                oMElement2.addChild((OMNode)object16);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AppliesTo: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AppliesTo not found");
            }
            iElement = iRequestSecurityTokenResponse.getRequestedProofToken();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedProofToken: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestedProofToken not found");
            }
            iElement = iRequestSecurityTokenResponse.getEntropy();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Entropy: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Entropy not found");
            }
            object16 = iRequestSecurityTokenResponse.getLifetime();
            if (null != object16) {
                oMElement2 = sOAPFactory.createOMElement("Lifetime", constants.getWSTrustNamespace().toString(), "wst");
                object15 = sOAPFactory.createOMElement("Created", constants.getWSSecurityUtilityNamespace().toString(), "wsu");
                object14 = sOAPFactory.createOMElement("Expires", constants.getWSSecurityUtilityNamespace().toString(), "wsu");
                object13 = sOAPFactory.createOMText(UTC.format(object16.getCreated()));
                object12 = sOAPFactory.createOMText(UTC.format(object16.getExpires()));
                object15.addChild((OMNode)object13);
                object14.addChild((OMNode)object12);
                oMElement2.addChild((OMNode)object15);
                oMElement2.addChild((OMNode)object14);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Lifetime: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lifetime not found");
            }
            object15 = iRequestSecurityTokenResponse.getTokenType();
            if (null != object15) {
                oMElement2 = sOAPFactory.createOMElement("TokenType", constants.getWSTrustNamespace().toString(), "wst");
                object14 = sOAPFactory.createOMText(((URI)object15).toString());
                oMElement2.addChild((OMNode)object14);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TokenType: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenType not found");
            }
            object14 = iRequestSecurityTokenResponse.getRequestType();
            if (null != object14) {
                oMElement2 = sOAPFactory.createOMElement("RequestType", constants.getWSTrustNamespace().toString(), "wst");
                object13 = sOAPFactory.createOMText(((URI)object14).toString());
                oMElement2.addChild((OMNode)object13);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestType: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestType not found");
            }
            iElement = iRequestSecurityTokenResponse.getRequestedAttachedReference();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedAttachedReference: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestedAttachedReference not found");
            }
            iElement = iRequestSecurityTokenResponse.getRequestedUnattachedReference();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedUnattachedReference: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestedUnattachedReference not found");
            }
            iElement = iRequestSecurityTokenResponse.getStatus();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Status not found");
            }
            iElement = iRequestSecurityTokenResponse.getAllowPostdating();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AllowPostdating: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AllowPostdating not found");
            }
            iElement = iRequestSecurityTokenResponse.getRenewing();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Renewing: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Renewing not found");
            }
            object13 = iRequestSecurityTokenResponse.getComputedKey();
            if (null != object13) {
                oMElement2 = sOAPFactory.createOMElement("ComputedKey", constants.getWSTrustNamespace().toString(), "wst");
                object12 = sOAPFactory.createOMText(((URI)object13).toString());
                oMElement2.addChild((OMNode)object12);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ComputedKey: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ComputedKey not found");
            }
            iElement = iRequestSecurityTokenResponse.getOnBehalfOf();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OnBehalfOf: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OnBehalfOf not found");
            }
            object12 = iRequestSecurityTokenResponse.getIssuer();
            if (null != object12) {
                oMElement2 = sOAPFactory.createOMElement("Issuer", constants.getWSTrustNamespace().toString(), "wst");
                object11 = sOAPFactory.createOMElement("EndpointReference", constants.getWSAddressingNamespace().toString(), "wsa");
                object10 = sOAPFactory.createOMElement("Address", constants.getWSAddressingNamespace().toString(), "wsa");
                object9 = sOAPFactory.createOMText(object12.getAddress().toString());
                object10.addChild((OMNode)object9);
                object11.addChild((OMNode)object10);
                oMElement2.addChild((OMNode)object11);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Issuer: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Issuer not found");
            }
            object11 = iRequestSecurityTokenResponse.getAuthenticationType();
            if (null != object11) {
                oMElement2 = sOAPFactory.createOMElement("AuthenticationType", constants.getWSTrustNamespace().toString(), "wst");
                object10 = sOAPFactory.createOMText(((URI)object11).toString());
                oMElement2.addChild((OMNode)object10);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AuthenticationType: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuthenticationType not found");
            }
            iElement = iRequestSecurityTokenResponse.getAuthenticator();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authenticator: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticator not found");
            }
            object10 = iRequestSecurityTokenResponse.getKeyType();
            if (null != object10) {
                oMElement2 = sOAPFactory.createOMElement("KeyType", constants.getWSTrustNamespace().toString(), "wst");
                object9 = sOAPFactory.createOMText(((URI)object10).toString());
                oMElement2.addChild((OMNode)object9);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyType: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyType not found");
            }
            object9 = iRequestSecurityTokenResponse.getKeySize();
            if (null != object9) {
                oMElement2 = sOAPFactory.createOMElement("KeySize", constants.getWSTrustNamespace().toString(), "wst");
                object8 = sOAPFactory.createOMText(((Integer)object9).toString());
                oMElement2.addChild((OMNode)object8);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeySize: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeySize not found");
            }
            object8 = iRequestSecurityTokenResponse.getSignatureAlgorithm();
            if (null != object8) {
                oMElement2 = sOAPFactory.createOMElement("SignatureAlgorithm", constants.getWSTrustNamespace().toString(), "wst");
                object7 = sOAPFactory.createOMText(((URI)object8).toString());
                oMElement2.addChild((OMNode)object7);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SignatureAlgorithm: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SignatureAlgorithm not found");
            }
            iElement = iRequestSecurityTokenResponse.getEncryption();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Encryption: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption not found");
            }
            object7 = iRequestSecurityTokenResponse.getEncryptionAlgorithm();
            if (null != object7) {
                oMElement2 = sOAPFactory.createOMElement("EncryptionAlgorithm", constants.getWSTrustNamespace().toString(), "wst");
                object6 = sOAPFactory.createOMText(((URI)object7).toString());
                oMElement2.addChild((OMNode)object6);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EncryptionAlgorithm: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EncryptionAlgorithm not found");
            }
            object6 = iRequestSecurityTokenResponse.getCanonicalizationAlgorithm();
            if (null != object6) {
                oMElement2 = sOAPFactory.createOMElement("CanonicalizationAlgorithm", constants.getWSTrustNamespace().toString(), "wst");
                object5 = sOAPFactory.createOMText(((URI)object6).toString());
                oMElement2.addChild((OMNode)object5);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CanonicalizationAlgorithm: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CanonicalizationAlgorithm not found");
            }
            iElement = iRequestSecurityTokenResponse.getProofEncryption();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ProofEncryption: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ProofEncryption not found");
            }
            iElement = iRequestSecurityTokenResponse.getUseKey();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UseKey: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UseKey not found");
            }
            object5 = iRequestSecurityTokenResponse.getSignWith();
            if (null != object5) {
                oMElement2 = sOAPFactory.createOMElement("SignWith", constants.getWSTrustNamespace().toString(), "wst");
                object4 = sOAPFactory.createOMText(((URI)object5).toString());
                oMElement2.addChild((OMNode)object4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SignWith: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SignWith not found");
            }
            object4 = iRequestSecurityTokenResponse.getEncryptWith();
            if (null != object4) {
                oMElement2 = sOAPFactory.createOMElement("EncryptWith", constants.getWSTrustNamespace().toString(), "wst");
                object3 = sOAPFactory.createOMText(((URI)object4).toString());
                oMElement2.addChild((OMNode)object3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EncryptWith: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EncryptWith not found");
            }
            iElement = iRequestSecurityTokenResponse.getDelegateTo();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DelegateTo: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DelegateTo not found");
            }
            object3 = iRequestSecurityTokenResponse.getForwardable();
            if (null != object3) {
                oMElement2 = sOAPFactory.createOMElement("Forwardable", constants.getWSTrustNamespace().toString(), "wst");
                object2 = sOAPFactory.createOMText(((Boolean)object3).toString());
                oMElement2.addChild((OMNode)object2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Forwardable: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Forwardable not found");
            }
            object2 = iRequestSecurityTokenResponse.getDelegatable();
            if (null != object2) {
                oMElement2 = sOAPFactory.createOMElement("Delegatable", constants.getWSTrustNamespace().toString(), "wst");
                object = sOAPFactory.createOMText(((Boolean)object2).toString());
                oMElement2.addChild((OMNode)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Delegatable: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Delegatable not found");
            }
            iElement = iRequestSecurityTokenResponse.getPolicy();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Policy: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Policy not found");
            }
            iElement = iRequestSecurityTokenResponse.getPolicyReference();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicyReference: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PolicyReference not found");
            }
            iElement = iRequestSecurityTokenResponse.getRequestedTokenCancelled();
            if (null != iElement) {
                oMElement2 = (OMElement)iElement.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedTokenCancelled: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestedTokenCancelled not found");
            }
            object = iRequestSecurityTokenResponse.getAnyOtherElements();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                oMElement2 = (OMElement)((IElement)iterator.next()).getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AnyOther: " + XMLHelper.toString(oMElement2));
                }
                oMElement.addChild(oMElement2);
            }
            sOAPEnvelope.getBody().addChild(oMElement);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "envelope:  [" + XMLHelper.toString(sOAPEnvelope) + "]");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in createSOAPEnvelopeFromRequestSecurityTokenResponse" + exception);
            }
            Tr.processException(exception, this.getClass().getName(), FFDC_ID_5);
            throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSoapEnvelopeFromRSTR (SOAPEnvelope envelope, SOAPFactory fac, org.eclipse.higgins.sts.RequestSecurityTokenResponse RSTR)");
        }
    }

    private ISTSRequest createSTSRequestFromMessageContext(MessageContext messageContext) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSTSRequestFromMessageContext(MessageContext messageContext)");
        }
        STSRequest sTSRequest = new STSRequest();
        try {
            Object object;
            OMElement oMElement;
            OMElement oMElement2;
            OMElement oMElement3;
            SOAPEnvelope sOAPEnvelope;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "looking for headers...");
            }
            if ((sOAPEnvelope = messageContext.getEnvelope()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get Envelope from the request messageContext");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            if (sOAPHeader == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get Header from the request envelope");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            if (sOAPBody == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get Body from the request envelope");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            AddressingInformation addressingInformation = new AddressingInformation();
            String string = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
            ArrayList arrayList = sOAPHeader.getHeaderBlocksWithNSURI(string);
            if (arrayList.isEmpty()) {
                string = "http://www.w3.org/2005/08/addressing";
                arrayList = sOAPHeader.getHeaderBlocksWithNSURI(string);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                oMElement3 = (OMElement)arrayList.get(i);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, oMElement3.getLocalName() + ": " + oMElement3.getText());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for " + string + ", " + "Action");
            }
            if (null != (oMElement2 = sOAPHeader.getFirstChildWithName(new QName(string, "Action")))) {
                addressingInformation.setAction(new URI(oMElement2.getText()));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Action: " + oMElement2.getText());
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Action: <not found>");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for " + string + ", " + "To");
            }
            if (null != (oMElement3 = sOAPHeader.getFirstChildWithName(new QName(string, "To")))) {
                addressingInformation.setTo(new URI(oMElement3.getText()));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "To: " + oMElement3.getText());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "To: <not found>");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for " + string + ", " + "From");
            }
            if (null != (oMElement = sOAPHeader.getFirstChildWithName(new QName(string, "From")))) {
                object = new EndpointReference();
                object.setAddress(new URI(oMElement.getText()));
                addressingInformation.setFrom((IEndpointReference)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "From: " + oMElement.getText());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "From: <not found>");
            }
            sTSRequest.setAddressingInformation(addressingInformation);
            object = this.createRSTFromSoapEnvelope(sOAPEnvelope, messageContext, addressingInformation);
            List list = sTSRequest.getRequestSecurityTokenCollection();
            list.add(object);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in createSTSRequestFromMessageContext :" + exception);
            }
            Tr.processException(exception, this.getClass().getName() + ".createSTSRequestFromMessageContext", FFDC_ID_3);
            throw SoapSecurityException.format(Constants.TRUST_FAULT_BAD_REQUEST, "security.wssecurity.WSEC6855E");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSTSRequestFromMessageContext(MessageContext messageContext)");
        }
        return sTSRequest;
    }

    private IRequestSecurityToken createRSTFromSoapEnvelope(SOAPEnvelope sOAPEnvelope, MessageContext messageContext, IAddressingInformation iAddressingInformation) throws SoapSecurityException {
        RequestSecurityToken requestSecurityToken;
        block68: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createRSTFromSoapEnvelope(SOAPEnvelope omEnvelope)");
            }
            requestSecurityToken = new RequestSecurityToken();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            OMElement oMElement = sOAPBody.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestSecurityToken"));
            if (oMElement == null) {
                Tr.error(tc, SoapSecurityException.getMessage("security.wssecurity.WSEC6852E"));
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestSecurityToken OMElement found");
            }
            try {
                Object object;
                Object object2;
                OMAttribute oMAttribute = oMElement.getAttribute(new QName("Context"));
                if (null != oMAttribute) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RST's contextURI:  " + oMAttribute.getAttributeValue());
                    }
                    requestSecurityToken.setContext(oMAttribute.getAttributeValue());
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RST's contextURI:  null");
                }
                Object object3 = oMElement.getChildElements();
                while (object3.hasNext()) {
                    Object object4;
                    Object object5;
                    Object object6;
                    String string;
                    Object object7;
                    Object object8;
                    object2 = (OMElement)object3.next();
                    object = object2.getLocalName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "strLocalName:  " + (String)object + ": " + object2.getText());
                    }
                    if (((String)object).equals("TokenType")) {
                        requestSecurityToken.setTokenType(new URI(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("RequestType")) {
                        requestSecurityToken.setRequestType(new URI(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("AppliesTo")) {
                        object8 = object2.getFirstChildWithName(new QName("EndpointReference"));
                        if (object8 == null) {
                            STSMessageReceiver.trDebug("No child with name 'EndpointReference' was found under the AppliesTo element.");
                            continue;
                        }
                        object7 = object8.getFirstChildWithName(new QName("Address"));
                        if (object7 == null) {
                            STSMessageReceiver.trDebug("No child with name 'Address' was found undere the EndpointReference element.");
                            continue;
                        }
                        string = object7.getText();
                        object6 = new EndpointReference();
                        object6.setAddress(new URI(string));
                        object5 = new AppliesTo();
                        object5.setEndpointReference((IEndpointReference)object6);
                        requestSecurityToken.setAppliesTo((IAppliesTo)object5);
                        continue;
                    }
                    if (((String)object).equals("Claims")) {
                        requestSecurityToken.setClaims(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("Entropy")) {
                        requestSecurityToken.setEntropy(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("Lifetime")) {
                        object8 = object2.getFirstChildWithName(new QName("Created"));
                        object7 = object2.getFirstChildWithName(new QName("Expires"));
                        if (object8 == null && object7 == null) {
                            STSMessageReceiver.trDebug("Both 'Created' and 'Expires' elements were not found under the Lifetime element");
                            continue;
                        }
                        string = null;
                        object6 = null;
                        object5 = null;
                        object4 = null;
                        if (object8 == null) {
                            STSMessageReceiver.trDebug("Created element not found under Lifetime.");
                        } else {
                            string = object8.getText();
                            if (string == null || string.equals("")) {
                                STSMessageReceiver.trDebug("Created element contains no time string.");
                            } else {
                                try {
                                    object5 = UTC.parse(string);
                                }
                                catch (ParseException parseException) {
                                    STSMessageReceiver.trDebug("Unable to parse Created time: " + string + ". " + parseException.getLocalizedMessage());
                                }
                            }
                        }
                        if (object7 == null) {
                            STSMessageReceiver.trDebug("Expires element not found under Lifetime.");
                        } else {
                            object6 = object7.getText();
                            if (object6 == null || ((String)object6).equals("")) {
                                STSMessageReceiver.trDebug("Expires element contains no time string.");
                            } else {
                                try {
                                    object4 = UTC.parse((String)object6);
                                }
                                catch (ParseException parseException) {
                                    STSMessageReceiver.trDebug("Unable to parse Expires time: " + (String)object6 + ". " + parseException.getLocalizedMessage());
                                }
                            }
                        }
                        if (object5 == null && object4 == null) {
                            STSMessageReceiver.trDebug("Both Created and Expires elements missing from Lifetime.");
                            continue;
                        }
                        Lifetime lifetime = new Lifetime();
                        if (object5 != null) {
                            lifetime.setCreated((Date)object5);
                        }
                        if (object4 != null) {
                            lifetime.setExpires((Date)object4);
                        }
                        requestSecurityToken.setLifetime(lifetime);
                        continue;
                    }
                    if (((String)object).equals("AllowPostdating")) {
                        requestSecurityToken.setAllowPostdating(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("Renewing")) {
                        requestSecurityToken.setRenewing(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("OnBehalfOf")) {
                        requestSecurityToken.setOnBehalfOf(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("Issuer")) {
                        object8 = object2.getText();
                        object7 = new EndpointReference();
                        object7.setAddress(new URI((String)object8));
                        requestSecurityToken.setIssuer((IEndpointReference)object7);
                        continue;
                    }
                    if (((String)object).equals("AuthenticationType")) {
                        requestSecurityToken.setAuthenticationType(new URI(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("KeyType")) {
                        requestSecurityToken.setKeyType(new URI(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("KeySize")) {
                        requestSecurityToken.setKeySize(new Integer(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("SignatureAlgorithm")) {
                        requestSecurityToken.setSignatureAlgorithm(new URI(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("Encryption")) {
                        requestSecurityToken.setEncryption(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("EncryptionAlgorithm")) {
                        requestSecurityToken.setEncryptionAlgorithm(new URI(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("CanonicalizationAlgorithm")) {
                        requestSecurityToken.setCanonicalizationAlgorithm(new URI(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("ProofEncryption")) {
                        requestSecurityToken.setProofEncryption(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("UseKey")) {
                        requestSecurityToken.setUseKey(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("SignWith")) {
                        requestSecurityToken.setSignWith(new URI(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("EncryptWith")) {
                        requestSecurityToken.setEncryptWith(new URI(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("DelegateTo")) {
                        requestSecurityToken.setDelegateTo(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("Forwardable")) {
                        requestSecurityToken.setForwardable(new Boolean(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("Delegatable")) {
                        requestSecurityToken.setDelegatable(new Boolean(object2.getText()));
                        continue;
                    }
                    if (((String)object).equals("Policy")) {
                        requestSecurityToken.setPolicy(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("PolicyReference")) {
                        requestSecurityToken.setPolicyReference(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("CancelTarget")) {
                        object8 = object2.getFirstChildWithName(new QName("SecurityTokenReference"));
                        if (object8 != null && (string = (object7 = object8.getAttribute(new QName("URI"))).getAttributeValue()).startsWith("#")) {
                            object6 = sOAPHeader.getChildElements();
                            while (object6.hasNext()) {
                                object5 = (OMElement)object6.next();
                                object4 = object5.getAttribute(new QName("URI"));
                                if (object4 == null || object4 != object7) continue;
                                object2.addChild((OMNode)object5);
                                break;
                            }
                        }
                        requestSecurityToken.setCancelTarget(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("ValidateTarget")) {
                        object8 = object2.getFirstChildWithName(new QName("SecurityTokenReference"));
                        if (object8 != null && (string = (object7 = object8.getAttribute(new QName("URI"))).getAttributeValue()).startsWith("#")) {
                            object6 = sOAPHeader.getChildElements();
                            while (object6.hasNext()) {
                                object5 = (OMElement)object6.next();
                                object4 = object5.getAttribute(new QName("URI"));
                                if (object4 == null || object4 != object7) continue;
                                object2.addChild((OMNode)object5);
                                break;
                            }
                        }
                        requestSecurityToken.setValidateTarget(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    if (((String)object).equals("RenewTarget")) {
                        object8 = object2.getFirstChildWithName(new QName("SecurityTokenReference"));
                        if (object8 != null && (string = (object7 = object8.getAttribute(new QName("URI"))).getAttributeValue()).startsWith("#")) {
                            object6 = sOAPHeader.getChildElements();
                            while (object6.hasNext()) {
                                object5 = (OMElement)object6.next();
                                object4 = object5.getAttribute(new QName("URI"));
                                if (object4 == null || object4 != object7) continue;
                                object2.addChild((OMNode)object5);
                                break;
                            }
                        }
                        requestSecurityToken.setRenewTarget(XMLHelper.toElement((OMElement)object2));
                        continue;
                    }
                    object8 = requestSecurityToken.getAnyOtherElements();
                    object8.add(XMLHelper.toElement((OMElement)object2));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, " ->anyOther");
                }
                if (requestSecurityToken.getRequestType() == null) {
                    Tr.error(tc, SoapSecurityException.getMessage("security.wssecurity.WSEC6853E"));
                    throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
                }
                if (requestSecurityToken.getAppliesTo() != null) break block68;
                STSMessageReceiver.trDebug("AppliesTo element was not found; substituting with To address.");
                object3 = iAddressingInformation.getTo();
                if (null != object3) {
                    iAddressingInformation.setTo((URI)object3);
                    STSMessageReceiver.trDebug("AppliesTo element substituted with To address: " + ((URI)object3).toString());
                    object2 = new EndpointReference();
                    object2.setAddress((URI)object3);
                    object = new AppliesTo();
                    object.setEndpointReference((IEndpointReference)object2);
                    requestSecurityToken.setAppliesTo((IAppliesTo)object);
                    break block68;
                }
                STSMessageReceiver.trDebug("Both AppliesTo and To are null.");
                Tr.error(tc, SoapSecurityException.getMessage("security.wssecurity.WSEC6853E"));
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in createRequestSecurityTokenFromMessageContext" + exception);
                }
                Tr.processException(exception, this.getClass().getName() + "createRSTFromSoapEnvelope", FFDC_ID_4);
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRSTFromSoapEnvelope(SOAPEnvelope omEnvelope)");
        }
        return requestSecurityToken;
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

