/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.token;

import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.registry.UserMapping;
import com.ibm.ws.wssecurity.platform.registry.UserRegistry;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.Permission;
import java.security.SecurityPermission;
import java.security.cert.X509Certificate;
import javax.security.auth.login.LoginException;

public class WSSUserRegistryProcessor {
    private static final TraceComponent tc = Tr.register(WSSUserRegistryProcessor.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSUserRegistryProcessor.class.getName();
    private static WSSContextManager manager = WSSContextManagerFactory.getInstance();
    private static final Permission PERM = new SecurityPermission("wssecurity.WSUserRegistry.mapCertificate");

    public static boolean checkRegistry(String string, char[] cArray) throws LoginException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRegistry()");
        }
        String string2 = null;
        try {
            if (manager != null) {
                if (tc.isDebugEnabled()) {
                    String string3 = cArray == null ? "null" : "not mull";
                    Tr.debug(tc, "Username [" + string + "], password [" + string3 + "]");
                }
                string = WSSUserRegistryProcessor.removeRealm(manager.getDefaultRealm(), string);
                string2 = manager.getRegistry(manager.getDefaultRealm()).checkPassword(string, new String(cArray));
            }
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".checkRegistry", "%C");
            Tr.error(tc, "security.wssecurity.WSSUserRegistryProcessor.s01", new Object[]{string, exception});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s01", new String[]{string, exception.toString()}));
        }
        boolean bl2 = bl = string2 != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRegistry() returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean checkUsername(String string) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkUsername(String username[" + string + "])");
        }
        String string2 = null;
        try {
            UserRegistry userRegistry = manager.getRegistry(manager.getDefaultRealm());
            string = WSSUserRegistryProcessor.removeRealm(manager.getDefaultRealm(), string);
            string2 = userRegistry.getUniqueUserId(string);
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".checkUsername", "%C");
            Tr.error(tc, "security.wssecurity.WSSUserRegistryProcessor.s02", new Object[]{string, exception});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s02", new String[]{string, exception.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkUsername(String username) returns [" + string2 + "]");
        }
        return true;
    }

    public static String mapCertificate(X509Certificate x509Certificate) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate(X509Certificate [" + x509Certificate + "])");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(PERM);
        }
        String string = null;
        UserMapping userMapping = manager.getUserMapping();
        try {
            string = userMapping.mapCertificateToName(new X509Certificate[]{x509Certificate});
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".mapCertificate", "84");
            Tr.warning(tc, "security.wssecurity.WSEC5185W", new Object[]{x509Certificate.getSubjectDN().getName(), exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate(X509Certificate) returns " + string);
        }
        return string;
    }

    public static String removeRealm(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return string2;
        }
        if (!string2.startsWith(string + "/")) {
            return string2;
        }
        int n = string.length();
        return string2.substring(n + 1);
    }
}

