/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.token;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.platform.auth.SubjectCache;
import com.ibm.ws.wssecurity.platform.auth.SubjectCacheFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.CommonCallbackHandler;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginProcessor
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(LoginProcessor.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LoginProcessor.class.getName();
    private boolean _initialized = false;
    private static SubjectCache authCcahe = SubjectCacheFactory.getInstance();

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        SecurityToken securityToken;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("invoke(");
            ((StringBuffer)object).append("OMNode target[").append(DOMUtils.getDisplayName(oMNode)).append("], ");
            ((StringBuffer)object).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if ((securityToken = LoginProcessor.invokeLoginModule((object = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey")).getCallers(), map)) == null) {
            throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s01");
        }
        SecurityTokenManagerImpl securityTokenManagerImpl = (SecurityTokenManagerImpl)map.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        securityTokenManagerImpl.integrateSubject();
        this.cacheInformation(securityToken, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Element, Map)");
        }
    }

    private static SecurityToken invokeLoginModule(Collection<CallerConfig> collection, Map<Object, Object> map) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("invokeLoginModule(");
            ((StringBuffer)object).append("Set cconfigs[").append(collection).append("], ");
            ((StringBuffer)object).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        if (collection != null && collection.size() > 0) {
            boolean bl = false;
            Exception[] exceptionArray = new Exception[collection.size()];
            int n = 0;
            for (CallerConfig callerConfig : collection) {
                try {
                    LoginProcessor.invokeLoginModule(callerConfig, map);
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    exceptionArray[n++] = exception;
                }
            }
            if (!bl) {
                Object object2;
                if (collection.size() == 1) {
                    if (exceptionArray[0] instanceof SoapSecurityException) {
                        if (((SoapSecurityException)exceptionArray[0]).getFaultCode() == null) {
                            object2 = Axis2Util.setFailedAuthFaultCodeIfNone(map);
                        }
                        throw (SoapSecurityException)exceptionArray[0];
                    }
                    object2 = Axis2Util.setFailedAuthFaultCodeIfNone(map);
                    throw SoapSecurityException.format((QName)object2, "security.wssecurity.WSEC6837E", (Throwable)exceptionArray[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n + " exceptions were catched.");
                    for (int i = 0; i < n; ++i) {
                        Tr.debug(tc, "No." + i + "'s exception: " + exceptionArray[i]);
                    }
                }
                object2 = Axis2Util.setFailedAuthFaultCodeIfNone(map);
                throw SoapSecurityException.format((QName)object2, "security.wssecurity.WSEC6838E", (Throwable)exceptionArray[n - 1]);
            }
            object = (SecurityToken)map.get(Constants.WSSECURITY_TOKEN_LOGININFO);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("invokeLoginModule(Set, Map)");
            stringBuffer.append(" returns SecurityToken [").append(object).append("]");
            Tr.entry(tc, stringBuffer.toString());
        }
        return object;
    }

    private static void invokeLoginModule(CallerConfig callerConfig, Map<Object, Object> map) throws SoapSecurityException {
        Object object;
        Serializable serializable;
        Class<?> clazz;
        Object object2;
        Object object3;
        Subject subject;
        Object object4;
        if (tc.isEntryEnabled()) {
            object4 = new StringBuffer("invokeLoginModule(");
            ((StringBuffer)object4).append("CallerConfig config[").append(callerConfig).append("], ");
            ((StringBuffer)object4).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object4).toString());
        }
        if ((object4 = map.get("com.ibm.wsspi.wssecurity.core.subject")) == null || !(object4 instanceof Subject)) {
            subject = new Subject();
            map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        } else {
            subject = (Subject)object4;
        }
        SecurityTokenManagerImpl securityTokenManagerImpl = (SecurityTokenManagerImpl)map.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String string = authCcahe.createUniqueCachekey(subject);
        Subject subject2 = null;
        if (string != null && string.length() > 0 && (subject2 = authCcahe.getSubjectFromAuthCacheByUniqueID(string)) != null) {
            securityTokenManagerImpl.addToSubject(subject2);
            return;
        }
        final String string2 = callerConfig.getJAASConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JAAS config name is " + string2 + ".");
        }
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.WSEC6834E", callerConfig.toString());
        }
        map.put("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey", callerConfig);
        map.putAll(callerConfig.getJAASConfigProperties());
        CallbackHandlerConfig callbackHandlerConfig = callerConfig.getCallbackHandler();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + callbackHandlerConfig + "].");
        }
        CallbackHandler callbackHandler = null;
        if (callbackHandlerConfig != null) {
            callbackHandler = callbackHandlerConfig.getInstance();
            if (callbackHandler == null) {
                block30: {
                    object3 = callbackHandlerConfig.getClassName();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Instantiating the callback handler [" + (String)object3 + "]...");
                        }
                        object2 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        clazz = null;
                        if (object2 != null) {
                            try {
                                clazz = ((ClassLoader)object2).loadClass((String)object3);
                            }
                            catch (Exception exception) {
                                clazz = Class.forName((String)object3);
                            }
                        } else {
                            clazz = Class.forName((String)object3);
                        }
                        if (CallbackHandler.class.isAssignableFrom(clazz)) {
                            serializable = new HashMap<String, CallbackHandlerConfig>();
                            serializable.put("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey", callbackHandlerConfig);
                            object = clazz.getConstructor(Map.class);
                            callbackHandler = (CallbackHandler)((Constructor)object).newInstance(serializable);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + (String)object3 + "].");
                            }
                            break block30;
                        }
                        throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", (String)object3, CallbackHandler.class.getName());
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        Tr.processException(soapSecurityException, clsName + ".invoke", "326");
                        throw soapSecurityException;
                    }
                    catch (Exception exception) {
                        Tr.processException(exception, clsName + ".invoke", "329");
                        Tr.error(tc, "security.wssecurity.X509TokenGenerator.s01", new Object[]{object3});
                        throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", (String)object3, (Throwable)exception);
                    }
                }
                callbackHandlerConfig.setInstance(callbackHandler);
            }
            map.putAll(callbackHandlerConfig.getProperties());
        }
        object3 = new CommonCallbackHandler(callbackHandler, map);
        object2 = subject;
        clazz = null;
        try {
            clazz = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>((Subject)object2, (CommonCallbackHandler)object3){
                final /* synthetic */ Subject val$subject;
                final /* synthetic */ CommonCallbackHandler val$commonCBH;
                {
                    this.val$subject = subject;
                    this.val$commonCBH = commonCallbackHandler;
                }

                @Override
                public Object run() throws LoginException {
                    LoginContext loginContext = new LoginContext(string2, this.val$subject, this.val$commonCBH);
                    return loginContext;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeed to construct the login context.");
            }
            ((LoginContext)((Object)clazz)).login();
            subject2 = ((LoginContext)((Object)clazz)).getSubject();
            try {
                if (authCcahe.validateSubject(subject2) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is no valid WebSphere security subject returned from Caller login.");
                    }
                    throw new LoginException("Valid WebSphere security subject from caller login Not Found.");
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no valid WebSphere security subject returned from Caller login.");
                }
                Tr.error(tc, "There is no valid WebSphere security subject returned from Caller login.");
                throw new LoginException("Valid WebSphere security subject from caller login Not Found.");
            }
            securityTokenManagerImpl.addToSubject(subject2);
            authCcahe.addSubjectToAuthCache(subject2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeed to login.");
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = (LoginException)privilegedActionException.getCause();
            Tr.processException((Throwable)object, clsName + ".invokeLoginModule", "391");
            Tr.error(tc, "security.wssecurity.X509TokenConsumer.s01", new Object[]{object});
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s01", (Throwable)object);
        }
        catch (LoginException loginException) {
            Tr.processException(loginException, clsName + ".invokeLoginModule", "397");
            Tr.error(tc, "security.wssecurity.X509TokenConsumer.s02", new Object[]{loginException});
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s02", (Throwable)loginException);
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("invokeLoginModule(");
            ((StringBuffer)serializable).append("CallerConfig, Map)");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
    }

    private void cacheInformation(SecurityToken securityToken, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheInformation(Token token[" + securityToken + "]," + "Map context)");
        }
        Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
        } else {
            contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderId", subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initial Sender is set.");
            }
            if (securityToken instanceof X509Token) {
                X509Certificate x509Certificate = ((X509Token)securityToken).getCertificate();
                contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", x509Certificate);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Cert is set.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheInformation(Token token,Map context)");
        }
    }
}

