/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.time;

import com.ibm.ws.wssecurity.common.Request;
import com.ibm.ws.wssecurity.common.RequestPool;
import com.ibm.ws.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.time.TimestampRequest;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(TimestampGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map) throws SoapSecurityException {
        OMNode oMNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
        Object object = map.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int n = 0;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[2][n];
        object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object;
        }
        String string2 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n2];
        if (oMElement == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s13", "wsu:Timestamp");
        }
        OMElement oMElement2 = NonceUtil.getTimestamp(oMElement, string2);
        if (oMElement2 != null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s01");
        }
        oMElement2 = NonceUtil.createTimestamp(oMFactory, oMElement, string2, null);
        TimestampGeneratorConfig timestampGeneratorConfig = (TimestampGeneratorConfig)map.remove("com.ibm.ws.wssecurity.impl.config.timestampGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TimestampGeneratorConfig [" + timestampGeneratorConfig + "].");
        }
        if (timestampGeneratorConfig.getSOAPHeaderAttribute()) {
            TimestampGenerator.setAttributeForSOAPHeader(oMElement2, n, string, timestampGeneratorConfig.getTargetActor(), map);
        }
        if ((oMNode = oMElement.getFirstOMChild()) == null) {
            oMElement.addChild(oMElement2);
        } else if (oMNode != oMElement2) {
            oMNode.insertSiblingBefore(oMElement2);
        }
        NonceUtil.addCreated(oMFactory, oMElement2, string2);
        if (timestampGeneratorConfig.getDuration() != null) {
            NonceUtil.addExpires(oMFactory, oMElement2, timestampGeneratorConfig.getDuration(), string2);
        }
        boolean bl = timestampGeneratorConfig.toBeSigned();
        TimestampRequest timestampRequest = new TimestampRequest(bl);
        timestampRequest.setElement(oMElement2);
        RequestPool.add(map, timestampRequest);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument, OMElement, Map)");
        }
    }

    private static void setAttributeForSOAPHeader(OMElement oMElement, int n, String string, String string2, Map<Object, Object> map) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributeForSOAPHeader(OMElement timestamp[" + DOMUtils.getDisplayName(oMElement) + "]," + "int soapVersion[" + n + "]," + "String nsSoap[" + string + "]," + "String actor[" + string2 + "]," + "Map context)");
        }
        String string3 = DOMUtils.getNamespacePrefix(oMElement, string);
        if (string2 != null) {
            String string4;
            String string5 = string4 = n == 0 ? "actor" : "role";
            if (string3 == null || string3.length() <= 0) {
                string3 = "env";
                oMElement.declareNamespace(string, string3);
            }
            oMElement.addAttribute(string4, string2, oMElement.getOMFactory().createOMNamespace(string, string3));
        }
        if (bl = Axis2Util.getMustUnderstand(map)) {
            if (string3 == null || string3.length() <= 0) {
                string3 = "env";
                oMElement.declareNamespace(string, string3);
            }
            oMElement.addAttribute("mustUnderstand", "1", oMElement.getOMFactory().createOMNamespace(string, string3));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributeForSOAPHeader(OMElement, int, String, String)");
        }
    }

    public static void moveTimestamp(OMDocument oMDocument, TimestampGeneratorConfig timestampGeneratorConfig, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        ArrayList<OMNode> arrayList;
        Request[] requestArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "moveTimestamp(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "TimestampGeneratorConfig config," + "Map selectors," + "Map context)");
        }
        if ((requestArray = RequestPool.get(map2, TimestampRequest.class)) == null || requestArray.length == 0) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s13");
        }
        if (requestArray.length > 1) {
            throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s02");
        }
        TimestampRequest timestampRequest = (TimestampRequest)requestArray[0];
        OMElement oMElement = timestampRequest.getElement();
        RequestMessagePool.EncryptedObject encryptedObject = RequestMessagePool.convertElement(map2, oMElement, -1);
        if (encryptedObject != null) {
            oMElement = encryptedObject.getEncryptedData();
        }
        Map<Object, Object> map3 = timestampGeneratorConfig.getProperties();
        String string = (String)map3.get(Constants.WSSECURITY_TIMESTAMP_DIALECT);
        String string2 = (String)map3.get(Constants.WSSECURITY_TIMESTAMP_KEYWORD);
        boolean bl = true;
        WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)map2.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        String string3 = (String)wSSGeneratorConfig.getProperties().get("com.ibm.ws.wssecurity.EnforceStrictLayout");
        if (string3 != null) {
            bl = !string3.equals("false");
        }
        if (string == null) {
            string = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
            string2 = timestampGeneratorConfig.isSOAPHeaderElement() ? TimestampDialectElementSelector.WASDIALECTS[3] : (bl ? TimestampDialectElementSelector.WASDIALECTS[0] : TimestampDialectElementSelector.WASDIALECTS[1]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Moving the Timestamp element to Dialect[" + string + "], " + "Keyword[" + string2 + "]...");
        }
        if ((arrayList = TimestampGenerator.getTimestamp(oMDocument, string, string2, "move", timestampRequest, encryptedObject, oMElement, map, map2)) != null && arrayList.size() > 0) {
            if (arrayList.size() > 1) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s14");
            }
            oMElement.detach();
            OMElement oMElement2 = (OMElement)arrayList.get(0);
            oMElement2.addChild(oMElement);
            if (encryptedObject != null) {
                encryptedObject.setEncryptedData(oMElement);
            } else {
                timestampRequest.setElement(oMElement);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Succeed to move the Timestamp element to Dialect[" + string + "], " + "Keyword[" + string2 + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "moveTimestamp(OMDocument, TimestampGeneratorConfig, Map, Map)");
        }
    }

    public static ArrayList<OMNode> getTimestamp(OMDocument oMDocument, String string, String string2, String string3, TimestampRequest timestampRequest, RequestMessagePool.EncryptedObject encryptedObject, OMElement oMElement, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestamp(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "String dialect[" + string + "]," + "String keyword[" + string2 + "]," + "String mode[" + string3 + "]," + "TimestampRequest trequest[" + timestampRequest + "]," + "EncryptedObject eobject[" + encryptedObject + "]," + "OMElement element[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map selectors," + "Map context)");
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(map2);
        hashMap.put("com.ibm.ws.wssecurity.util.selector.dialect", string);
        hashMap.put("com.ibm.ws.wssecurity.util.selector.keyword", string2);
        hashMap.put("com.ibm.ws.wssecurity.util.selector.operation", string3);
        hashMap.put("com.ibm.ws.wssecurity.util.selector.element", new Object[]{oMElement});
        ElementSelector elementSelector = null;
        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(string)) {
            elementSelector = (ElementSelector)map.get(TimestampDialectElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_FUNCTION.equals(string)) {
            elementSelector = (ElementSelector)map.get(WSPFunctionElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(string)) {
            elementSelector = (ElementSelector)map.get(XPathElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(string)) {
            elementSelector = (ElementSelector)map.get(QNameHeaderSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string);
        }
        ArrayList<OMNode> arrayList = elementSelector.getElements(oMDocument.getOMDocumentElement(), hashMap);
        if (encryptedObject != null) {
            Object[] objectArray = (Object[])hashMap.get("com.ibm.ws.wssecurity.util.selector.element");
            encryptedObject.setEncryptedData((OMElement)objectArray[0]);
        } else if (timestampRequest != null) {
            Object[] objectArray = (Object[])hashMap.get("com.ibm.ws.wssecurity.util.selector.element");
            timestampRequest.setElement((OMElement)objectArray[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestamp(OMDocument, String, String, String,TimestampRequest, EncryptedObject, Element, Map, Map)");
        }
        return arrayList;
    }
}

