/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.time;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.time.TimestampResult;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(TimestampConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMNode target[" + DOMUtils.getDisplayName(oMNode) + "]," + "Map context)");
        }
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11", "wsu:Timestamp");
        }
        Object object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n = 0;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string = Constants.NAMESPACES[1][n];
        TimestampConsumerConfig timestampConsumerConfig = (TimestampConsumerConfig)map.remove("com.ibm.ws.wssecurity.impl.config.timestampConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TimestampConsumerConfig [" + timestampConsumerConfig + "].");
        }
        SoapSecurityException soapSecurityException = null;
        try {
            NonceUtil.checkTimestamp(oMNode, string, timestampConsumerConfig.getTimestampMaxAge(), timestampConsumerConfig.getTimestampClockSkew(), true);
        }
        catch (SoapSecurityException soapSecurityException2) {
            soapSecurityException = soapSecurityException2;
        }
        ResultPool.add(map, new TimestampResult((OMElement)oMNode, soapSecurityException));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Element target, Map context)");
        }
    }
}

