/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.time;

import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.time.TimestampGenerator;
import com.ibm.ws.wssecurity.time.TimestampResult;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(TimestampChecker.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMNode target[" + DOMUtils.getDisplayName(oMNode) + "]," + "Map context)");
        }
        Object object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n = 0;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
        OMDocument oMDocument = null;
        oMDocument = DOMUtil.getOwnerDocument(oMNode);
        TimestampConsumerConfig timestampConsumerConfig = (TimestampConsumerConfig)map.remove("com.ibm.ws.wssecurity.impl.config.timestampConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TimestampConsumerConfig [" + timestampConsumerConfig + "].");
        }
        Set<RequiredPart> set = TimestampChecker.preprocess(oMDocument, timestampConsumerConfig, this._selectors, string, map);
        Result[] resultArray = ResultPool.get(map, TimestampResult.class);
        if (resultArray != null && resultArray.length > 0) {
            ResultPool.remove(map, resultArray);
            for (int i = 0; i < resultArray.length; ++i) {
                TimestampResult object2 = (TimestampResult)resultArray[i];
                RequiredPart requiredPart = TimestampChecker.getRelatedPart(object2._element, set);
                if (requiredPart == null) continue;
                if (object2._ex != null) {
                    throw object2._ex;
                }
                requiredPart._processed = true;
            }
        }
        for (RequiredPart requiredPart : set) {
            if (requiredPart._processed) continue;
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s01");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMNode, Map)");
        }
    }

    private static Set<RequiredPart> preprocess(OMDocument oMDocument, TimestampConsumerConfig timestampConsumerConfig, Map<Object, Object> map, String string, Map<Object, Object> map2) throws SoapSecurityException {
        ArrayList<OMNode> arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preprocess(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "TimestampConsumerConfig tconfig," + "Set selectors[" + map + "]," + "String nsWsu[" + string + "]," + "Map context)");
        }
        HashSet<RequiredPart> hashSet = new HashSet<RequiredPart>();
        Map<Object, Object> map3 = timestampConsumerConfig.getProperties();
        String string2 = (String)map3.get(Constants.WSSECURITY_TIMESTAMP_SOAPHEADER);
        boolean bl = ConfigUtil.isTrue(string2);
        String string3 = (String)map3.get(Constants.WSSECURITY_TIMESTAMP_DIALECT);
        String string4 = (String)map3.get(Constants.WSSECURITY_TIMESTAMP_KEYWORD);
        if (string3 == null) {
            string3 = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
            string4 = bl ? TimestampDialectElementSelector.WASDIALECTS[5] : TimestampDialectElementSelector.WASDIALECTS[4];
        }
        if ((arrayList = TimestampGenerator.getTimestamp(oMDocument, string3, string4, "check", null, null, null, map, map2)) != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                OMElement oMElement = (OMElement)arrayList.get(i);
                String string5 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
                String string6 = oMElement.getLocalName();
                if (!string.equals(string5) || !"Timestamp".equals(string6)) {
                    throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s02", string4);
                }
                RequiredPart requiredPart = new RequiredPart(oMElement);
                hashSet.add(requiredPart);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preprocess(OMDocument doc,TimestampConsumerConfig tconfig,Set selectors,String nsWsu,Map context)");
        }
        return hashSet;
    }

    private static RequiredPart getRelatedPart(OMElement oMElement, Set<RequiredPart> set) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelatedPart(OMElement element[" + DOMUtils.getDisplayName(oMElement) + "]," + "Set requiredParts[" + set + "])");
        }
        RequiredPart requiredPart = null;
        for (RequiredPart requiredPart2 : set) {
            if (DOMUtils.equals(requiredPart2._element, oMElement)) {
                requiredPart = requiredPart2;
                break;
            }
            if (requiredPart == null) continue;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelatedPart(Element, Set)");
        }
        return requiredPart;
    }

    private static class RequiredPart {
        private OMElement _element;
        private boolean _processed;

        RequiredPart(OMElement oMElement) {
            this._element = oMElement;
            this._processed = false;
        }
    }
}

