/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.sc;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.impl.auth.callback.SCTCallback;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.sc.util.SecureConversation;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSTokenUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;

public class SecureConversationImpl
implements Serializable,
SecureConversation {
    private static final long serialVersionUID = 1242813010528764538L;
    private static final TraceComponent tc = Tr.register(SecureConversationImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SecureConversationImpl.class.getName();

    public boolean isUsedForSigningAndEncryption(String string, MessageContext messageContext) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsedForSigningAndEncryption(): uuid = " + string + ", MessageContext");
        }
        SCT sCT = null;
        String string2 = null;
        boolean bl = false;
        try {
            bl = Axis2Util.isServiceProvider(messageContext);
        }
        catch (Exception exception) {
            throw new SoapSecurityException(exception.getMessage());
        }
        if (bl) {
            HashMap hashMap = null;
            hashMap = (HashMap)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
            if (hashMap != null) {
                string2 = (String)hashMap.get(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server side. Found the wss-ramp property map in the message context, sct uuid = " + string2);
                }
            } else {
                string2 = TokenHolder.getTokenFromContext("INBOUND_SCTOKEN", messageContext);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server side. Getting SCToken uuid from message context and the key  is INBOUND_SCTOKEN, uuid = " + string2);
                }
                if (string2 == null) {
                    string2 = (String)messageContext.getProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server side. Getting SCToken uuid from message context and the key is sessionID, uuid = " + string2);
                    }
                }
            }
            if (string2 != null && string2.equals(string)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isUsedForSigningAndEncryption() returnstrue");
                }
                return true;
            }
        } else {
            sCT = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(messageContext);
            if (sCT != null && sCT.getUUID().equals(string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client side. Found SCT in the cache. ");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isUsedForSigningAndEncryption() returnstrue");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsedForSigningAndEncryption() returnsfalse");
        }
        return false;
    }

    public List getSignedParts(String string, MessageContext messageContext) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignedParts(): uuid = " + string + ", MessageContext");
        }
        HashMap hashMap = (HashMap)messageContext.getProperty("SIGNED_ELEMENTS_MAP");
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        if (tc.isEntryEnabled()) {
            if (arrayList != null) {
                Tr.exit(tc, "getSignedParts() returns parts of " + arrayList.size());
            } else {
                Tr.exit(tc, "getSignedParts() returns null");
            }
        }
        return arrayList;
    }

    public List getEncryptedParts(String string, MessageContext messageContext) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncryptionParts(): uuid = " + string + ", MessageContext");
        }
        HashMap hashMap = (HashMap)messageContext.getProperty("DECRYPTED_ELEMENTS_MAP");
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        if (tc.isEntryEnabled()) {
            if (arrayList != null) {
                Tr.exit(tc, "getEncryptionParts()) returns parts of " + arrayList.size());
            } else {
                Tr.exit(tc, "getEncryptionParts() returns null");
            }
        }
        return arrayList;
    }

    public SecurityContextToken getSCToken(MessageContext messageContext) throws SoapSecurityException {
        PrivateGeneratorConfig privateGeneratorConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTToken(): MessageContext");
        }
        if ((privateGeneratorConfig = SecureConversationImpl.parseMessageContext(messageContext)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot get Policy/Binding information");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSCTToken(): MessageContext returns NULL");
            }
            return null;
        }
        if (!privateGeneratorConfig.isSCEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Secure Conversation is not enabled!");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSCTToken(): MessageContext returns NULL");
            }
            return null;
        }
        boolean bl = false;
        try {
            bl = Axis2Util.isServiceProvider(messageContext);
        }
        catch (Exception exception) {
            throw new SoapSecurityException(exception.getMessage());
        }
        SecurityContextToken securityContextToken = null;
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "client side. Getting SCToken from global cache");
            }
            if ((securityContextToken = (SecurityContextToken)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(messageContext)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No SCT in the cache. Invoke callback handler");
                }
                if (privateGeneratorConfig != null && privateGeneratorConfig.isSCEnabled()) {
                    Object object;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SC is in use");
                    }
                    Set<TokenGeneratorConfig> set = privateGeneratorConfig.getTokenGenerators();
                    Iterator<TokenGeneratorConfig> iterator = set.iterator();
                    String string = null;
                    boolean bl2 = false;
                    CallbackHandlerConfig callbackHandlerConfig = null;
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        string = object.getCallbackHandler().getClassName();
                        if (string == null || !string.equals("com.ibm.ws.wssecurity.impl.auth.callback.WSTrustCallbackHandler")) continue;
                        bl2 = true;
                        callbackHandlerConfig = object.getCallbackHandler();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "CallbackHandlerConfig [" + callbackHandlerConfig + "].");
                        break;
                    }
                    if (bl2) {
                        Callback[] callbackArray;
                        Object object2;
                        Object object3;
                        HashMap<Object, Object> hashMap;
                        block47: {
                            object = null;
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "About to Instantiate the callback handler [" + string + "]...");
                                }
                                hashMap = new HashMap<Object, Object>();
                                object3 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        return Thread.currentThread().getContextClassLoader();
                                    }
                                });
                                object2 = null;
                                if (object3 != null) {
                                    try {
                                        object2 = ((ClassLoader)object3).loadClass(string);
                                    }
                                    catch (Exception exception) {
                                        object2 = Class.forName(string);
                                    }
                                } else {
                                    object2 = Class.forName(string);
                                }
                                if (CallbackHandler.class.isAssignableFrom((Class<?>)object2)) {
                                    hashMap.put("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey", callbackHandlerConfig);
                                    callbackArray = ((Class)object2).getConstructor(Map.class);
                                    object = (CallbackHandler)callbackArray.newInstance(hashMap);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + string + "].");
                                    }
                                    break block47;
                                }
                                throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", string, CallbackHandler.class.getName());
                            }
                            catch (Exception exception) {
                                Tr.processException(exception, clsName + ".invoke", "311");
                                Tr.error(tc, "security.wssecurity.X509TokenGenerator.s01", new Object[]{string});
                                throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", string, (Throwable)exception);
                            }
                        }
                        hashMap = new HashMap();
                        hashMap.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
                        hashMap.put("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey", privateGeneratorConfig);
                        object3 = new SCTCallback();
                        object2 = new PropertyCallback(hashMap);
                        callbackArray = new Callback[]{object3, object2};
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Invoking the callback handler [" + string + "].");
                            }
                            object.handle(callbackArray);
                        }
                        catch (UnsupportedCallbackException unsupportedCallbackException) {
                            Tr.processException(unsupportedCallbackException, clsName + ".invoke", "379");
                            Tr.error(tc, "security.wssecurity.X509TokenGenerator.s02", new Object[]{string});
                            SoapSecurityException soapSecurityException = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", string, (Throwable)unsupportedCallbackException);
                            soapSecurityException.initCause(unsupportedCallbackException);
                            throw soapSecurityException;
                        }
                        catch (IOException iOException) {
                            Throwable throwable = iOException;
                            if (iOException.getCause() != null) {
                                throwable = iOException.getCause();
                            }
                            Tr.processException(iOException, clsName + ".invoke", "388");
                            Tr.error(tc, "security.wssecurity.XTokenGenerator.s02", new Object[]{string});
                            SoapSecurityException soapSecurityException = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", string, throwable);
                            soapSecurityException.initCause(iOException);
                            throw soapSecurityException;
                        }
                        securityContextToken = ((SCTCallback)object3).getToken();
                        callbackHandlerConfig.setInstance((CallbackHandler)object);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SC is not used");
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Service side. Getting SCToken from message context");
            }
            String string = null;
            HashMap hashMap = null;
            hashMap = (HashMap)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
            if (hashMap != null) {
                string = (String)hashMap.get(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server side. Found the wss-ramp property map in the message context, sct uuid = " + string);
                }
            } else {
                string = TokenHolder.getTokenFromContext("INBOUND_SCTOKEN", messageContext);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server side. Getting SCToken uuid from message context and the key is INBOUND_SCTOKEN, uuid = " + string);
                }
                if (string == null) {
                    string = (String)messageContext.getProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server side. Getting SCToken uuid from message context and the key is sessionID, uuid = " + string);
                    }
                }
            }
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting the SecurityContextToken from the service side cache and the  uuid = " + string);
                }
                try {
                    securityContextToken = (SecurityContextToken)((Object)STSTokenUtil.getToken(string, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct"));
                    if (securityContextToken != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the SCToken from the service side cache sucessfully!");
                    }
                }
                catch (AxisFault axisFault) {
                    Tr.processException(axisFault.getCause(), clsName, "getSCToken(MessageContext)");
                    throw new SoapSecurityException(axisFault.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSCTToken() returns " + securityContextToken);
        }
        return securityContextToken;
    }

    public SecurityContextToken getSCToken(String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTToken(uuid = " + string + ")");
        }
        SecurityContextToken securityContextToken = null;
        securityContextToken = (SecurityContextToken)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(string);
        if (securityContextToken == null) {
            block10: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not find the token in the client side cache. Try trust service cache..");
                }
                if (SCTHelper.getCache() != null) {
                    securityContextToken = (SCT)SCTHelper.getCache().getToken(string);
                }
                if (securityContextToken == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not find the token in the cache helper. Try trust service cache..");
                    }
                    try {
                        securityContextToken = (SCT)STSTokenUtil.getToken(string, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Exception while getting SCT from trust service:" + exception.getMessage());
                    }
                }
            }
            if (securityContextToken == null) {
                Tr.error(tc, "security.wssecurity.SecureConversationImpl.s01", new Object[]{string});
                throw SoapSecurityException.format("security.wssecurity.SecureConversationImpl.s01", string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSCTToken() returns");
        }
        return securityContextToken;
    }

    public byte[] getSCTokenBytes(String string) throws SoapSecurityException {
        SecurityContextToken securityContextToken;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTTokenBytes(uuid = " + string + ")");
        }
        if ((securityContextToken = this.getSCToken(string)) == null) {
            Tr.error(tc, "security.wssecurity.SecureConversationImpl.s01", new Object[]{string});
            throw SoapSecurityException.format("security.wssecurity.SecureConversationImpl.s01", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSCTTokenBytes(String uuid) returns");
        }
        return ((SCT)securityContextToken).getSerializationBytes();
    }

    public SecurityContextToken getSCTokenFromBytes(byte[] byArray) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTTokenFromBytes(byte[] token)");
            Tr.exit(tc, "getSCTTokenFromBytes() returns");
        }
        SCT sCT = new SCT();
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            sCT.readExternal(objectInputStream);
        }
        catch (Exception exception) {
            Tr.error(tc, "Error deserializing SCT, encountered " + exception.toString());
            sCT = null;
            throw new SoapSecurityException(exception.toString());
        }
        return sCT;
    }

    /*
     * Unable to fully structure code
     */
    public SecurityContextToken getSCTokenBySecurityTokenReference(OMElement var1_1, MessageContext var2_2) throws SoapSecurityException {
        if (SecureConversationImpl.tc.isEntryEnabled()) {
            Tr.entry(SecureConversationImpl.tc, "getSCTTokenBySecurityTokenReference(OMElement, MessageContext)");
        }
        var3_3 = false;
        try {
            var3_3 = Axis2Util.isServiceProvider(var2_2);
        }
        catch (Exception var4_4) {
            throw new SoapSecurityException(var4_4.getMessage());
        }
        var4_5 = null;
        var5_6 = null;
        var6_7 = null;
        var7_8 = null;
        var8_9 = null;
        if (var1_1 != null) {
            var4_5 = DOMUtils.getChildElement(var1_1, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "Reference");
            var5_6 = var4_5.getAttributeValue(new QName("", "URI"));
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "wsse:Reference URI in the RM supplied SecurityTokenReference element: " + var5_6);
            }
        } else if (SecureConversationImpl.tc.isDebugEnabled()) {
            Tr.debug(SecureConversationImpl.tc, "No Reference element found");
        }
        if (var5_6 != null && var5_6.startsWith("#")) {
            var5_6 = var5_6.substring(1);
            var9_10 = var2_2.getEnvelope();
            var10_12 = var9_10.getHeader();
            var11_13 = DOMUtil.getOwnerDocument(var10_12);
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "The original RM message to be processed : " + DOMUtils.toString(var11_13.getOMDocumentElement()));
            }
            if ((var13_15 = (var12_14 = IdUtils.getInstance()).resolveID(var11_13, var5_6)) != null && new QName(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "SecurityContextToken").equals(var14_16 = var13_15.getQName()) && (var15_17 = DOMUtils.getChildElement(var13_15, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier")) != null) {
                var7_8 = DOMUtils.getStringValue(var15_17);
                if (SecureConversationImpl.tc.isDebugEnabled()) {
                    Tr.debug(SecureConversationImpl.tc, "Found the matching SCT (Attached reference)for wsu:Id = " + var5_6 + ", the uuid Identifier = " + var7_8);
                }
            }
            if (var7_8 == null && SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "No SecurityContextToken element with the wsu:Id = " + var5_6 + " Found.");
            }
        } else if (var5_6 != null && var5_6.startsWith("uuid")) {
            var7_8 = var5_6;
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "Found the matching SCT (Unattached reference)for wsu:Id = " + var5_6 + ", the uuid Identifier = " + var7_8);
            }
        } else if (SecureConversationImpl.tc.isDebugEnabled()) {
            Tr.debug(SecureConversationImpl.tc, "No URI attribute found");
        }
        if (var7_8 != null) {
            if (!var3_3) {
                var8_9 = (SecurityContextToken)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(var7_8);
            } else {
                try {
                    var8_9 = (SecurityContextToken)STSTokenUtil.getToken(var7_8, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
                    if (var8_9 == null || !SecureConversationImpl.tc.isDebugEnabled()) ** GOTO lbl57
                    Tr.debug(SecureConversationImpl.tc, "Got the SecurityContextToken from the service side cache sucessfully!");
                }
                catch (AxisFault var9_11) {
                    Tr.processException(var9_11.getCause(), SecureConversationImpl.clsName, "getSCTokenBySecurityTokenReference(OMElement STRElem, MessageContext msgCtx)");
                    throw new SoapSecurityException(var9_11.getMessage());
                }
            }
        } else if (SecureConversationImpl.tc.isDebugEnabled()) {
            Tr.debug(SecureConversationImpl.tc, "SCT referenced in the STR element(either direct reference by Identifier or indirect reference by wsu:Id) is NOT found in the message");
        }
lbl57:
        // 6 sources

        if (var8_9 == null) {
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "SCT referenced by uuid = " + var7_8 + " not found");
            }
            Tr.error(SecureConversationImpl.tc, "security.wssecuritySCTConsumeLoginModule.invalidSCT03");
            throw SoapSecurityException.format("security.wssecuritySCTConsumeLoginModule.invalidSCT03");
        }
        if (SecureConversationImpl.tc.isEntryEnabled()) {
            Tr.exit(SecureConversationImpl.tc, "getSCTTokenBySecurityTokenReference(OMElement, MessageContext) returns " + var8_9);
        }
        return var8_9;
    }

    public static PrivateGeneratorConfig parseMessageContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseMessageContext(MessageContext)");
        }
        PrivateGeneratorConfig privateGeneratorConfig = null;
        AxisOperation axisOperation = messageContext.getAxisOperation();
        Parameter parameter = null;
        Object object = null;
        if (axisOperation != null) {
            parameter = axisOperation.getParameter("WASAxis2PolicySet");
        }
        if (parameter != null) {
            object = parameter.getValue();
        }
        PolicySetConfiguration policySetConfiguration = null;
        if (object != null && object instanceof PolicySetConfiguration) {
            policySetConfiguration = (PolicySetConfiguration)object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PolicySet from the operation context");
            }
        } else {
            AxisService axisService = messageContext.getAxisService();
            if (axisService != null) {
                parameter = axisService.getParameter("WASAxis2PolicySet");
            }
            if (parameter != null) {
                object = parameter.getValue();
            }
            if (object != null && object instanceof PolicySetConfiguration) {
                policySetConfiguration = (PolicySetConfiguration)object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicySet from the service context");
                }
            }
        }
        if (policySetConfiguration != null) {
            object = policySetConfiguration.getPolicyTypeBinding(PrivateGeneratorConfig.class);
            if (object != null && object instanceof PrivateGeneratorConfig) {
                privateGeneratorConfig = (PrivateGeneratorConfig)object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "app policy = " + privateGeneratorConfig);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No PolicyType Binding");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No PolicySet configuration");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseMessageContext(MessageContext) returns " + privateGeneratorConfig);
        }
        return privateGeneratorConfig;
    }

    public static boolean cancelSCT(AxisService axisService) throws WSSException {
        Object object;
        SCT sCT = null;
        Parameter parameter = axisService.getParameter(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
        if (parameter != null) {
            object = (String)parameter.getValue();
            sCT = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID((String)object);
        }
        if ((object = SecureConversationImpl.getGeneratorConfigFromService(axisService)) != null && ((PrivateGeneratorConfig)object).isSCEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "client side with security policy enabled. cancel SCT");
            }
            if (sCT == null || sCT.isCancelled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no SCT to cancel.");
                }
                return true;
            }
            Set<TokenGeneratorConfig> set = ((PrivateGeneratorConfig)object).getTokenGenerators();
            Iterator<TokenGeneratorConfig> iterator = set.iterator();
            String string = null;
            while (iterator.hasNext() && ((string = iterator.next().getCallbackHandler().getClassName()) == null || !string.equals("com.ibm.ws.wssecurity.impl.auth.callback.WSTrustCallbackHandler"))) {
            }
            if (string != null) {
                Object object2;
                Callback[] callbackArray;
                Object object3;
                HashMap<Object, Object> hashMap;
                CallbackHandler callbackHandler;
                block24: {
                    callbackHandler = null;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SCT is not found. Instantiating the callback handler [" + string + "]...");
                        }
                        hashMap = new HashMap<Object, Object>();
                        object3 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        callbackArray = null;
                        if (object3 != null) {
                            try {
                                callbackArray = ((ClassLoader)object3).loadClass(string);
                            }
                            catch (Exception exception) {
                                callbackArray = Class.forName(string);
                            }
                        } else {
                            callbackArray = Class.forName(string);
                        }
                        if (CallbackHandler.class.isAssignableFrom((Class<?>)callbackArray)) {
                            object2 = callbackArray.getConstructor(Map.class);
                            callbackHandler = (CallbackHandler)((Constructor)object2).newInstance(hashMap);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + string + "].");
                            }
                            break block24;
                        }
                        throw SoapSecurityException.format("", string, CallbackHandler.class.getName());
                    }
                    catch (Exception exception) {
                        Tr.error(tc, "", new Object[]{string, exception});
                        return false;
                    }
                }
                hashMap = new HashMap();
                hashMap.put("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_AXIS_SERVICE", axisService);
                hashMap.put("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey", object);
                hashMap.put("com.ibm.ws.wssecurity.sc.SCT.Cancel", "true");
                hashMap.put("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_SCT", sCT);
                object3 = new PropertyCallback(null);
                ((PropertyCallback)object3).setProperties(hashMap);
                callbackArray = new Callback[]{new SCTCallback(), object3};
                object2 = null;
                try {
                    callbackHandler.handle(callbackArray);
                }
                catch (UnsupportedCallbackException unsupportedCallbackException) {
                    Tr.error(tc, "", new Object[]{string, unsupportedCallbackException});
                    SoapSecurityException soapSecurityException = SoapSecurityException.format("", string, (Throwable)unsupportedCallbackException);
                    soapSecurityException.initCause(unsupportedCallbackException);
                    return false;
                }
                catch (IOException iOException) {
                    Throwable throwable = iOException;
                    if (iOException.getCause() != null) {
                        throwable = iOException.getCause();
                    }
                    Tr.error(tc, "", new Object[]{string, throwable});
                    SoapSecurityException soapSecurityException = SoapSecurityException.format("", string, throwable);
                    soapSecurityException.initCause(iOException);
                    return false;
                }
                object2 = (SCTCallback)callbackArray[0];
                sCT = ((SCTCallback)object2).getToken();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cancel SCT using WSSAPI");
            }
            sCT.cancel();
        }
        return true;
    }

    public static PrivateConsumerConfig getConsumerConfigFromService(AxisService axisService) {
        PrivateConsumerConfig privateConsumerConfig = null;
        Object object = null;
        PolicySetConfiguration policySetConfiguration = null;
        object = axisService.getParameter("WASAxis2PolicySet").getValue();
        if (object != null && object instanceof PolicySetConfiguration) {
            policySetConfiguration = (PolicySetConfiguration)object;
        }
        if (policySetConfiguration != null && (object = policySetConfiguration.getPolicyTypeBinding(PrivateConsumerConfig.class)) != null && object instanceof PrivateConsumerConfig) {
            privateConsumerConfig = (PrivateConsumerConfig)object;
        }
        return privateConsumerConfig;
    }

    public static PrivateGeneratorConfig getGeneratorConfigFromService(AxisService axisService) {
        PrivateGeneratorConfig privateGeneratorConfig = null;
        Object object = null;
        PolicySetConfiguration policySetConfiguration = null;
        object = axisService.getParameter("WASAxis2PolicySet").getValue();
        if (object != null && object instanceof PolicySetConfiguration) {
            policySetConfiguration = (PolicySetConfiguration)object;
        }
        if (policySetConfiguration != null && (object = policySetConfiguration.getPolicyTypeBinding(PrivateGeneratorConfig.class)) != null && object instanceof PrivateGeneratorConfig) {
            privateGeneratorConfig = (PrivateGeneratorConfig)object;
        }
        return privateGeneratorConfig;
    }

    public byte[] getWSSPropertyMapByteArray(MessageContext messageContext) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSPropertyMapByteArray(MessageContext msgCtx)");
        }
        byte[] byArray = new byte[]{};
        HashMap hashMap = null;
        if (messageContext != null) {
            hashMap = (HashMap)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
            if (hashMap == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not find property map in the current message context.");
                    Tr.debug(tc, "Look for it in the prev inbound message context.");
                }
                hashMap = TokenHolder.getPropertyMapFromInboundMessageContext(messageContext);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MessageContext is null!");
        }
        if (hashMap != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found property map in the message context.");
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(hashMap);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                Throwable throwable = iOException;
                if (iOException.getCause() != null) {
                    throwable = iOException.getCause();
                }
                Tr.error(tc, "", new Object[]{throwable});
                SoapSecurityException soapSecurityException = SoapSecurityException.format("", throwable);
                soapSecurityException.initCause(iOException);
                throw soapSecurityException;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find property map in the message context.");
            }
            String string = (String)messageContext.getProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage");
            String string2 = (String)messageContext.getProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found instance in the message context: " + string);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find instance in the message context.");
            }
            if (string2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found SCT uuid in the message context: " + string2);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find SCT uuid in the message context.");
            }
        }
        if (tc.isDebugEnabled() && byArray.length > 1) {
            Tr.debug(tc, "The WSS RAMP property map bytes = " + Base64.encode(byArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSPropertyMapByteArray(MessageContext msgCtx) returns byte array");
        }
        return byArray;
    }

    public HashMap getWSSPropertyMapFromByteArray(byte[] byArray, MessageContext messageContext) throws SoapSecurityException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSPropertyMapFromByteArray(byte[] wssmap, MessageContext msgCtx)");
        }
        HashMap hashMap = null;
        if (byArray != null && byArray.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "valid wss propertymap bytes.");
            }
            try {
                object2 = new ByteArrayInputStream(byArray);
                object = new ObjectInputStream((InputStream)object2);
                hashMap = (HashMap)((ObjectInputStream)object).readObject();
            }
            catch (IOException iOException) {
                Throwable throwable = iOException;
                if (iOException.getCause() != null) {
                    throwable = iOException.getCause();
                }
                Tr.error(tc, "", new Object[]{throwable});
                SoapSecurityException soapSecurityException = SoapSecurityException.format("", throwable);
                soapSecurityException.initCause(iOException);
                throw soapSecurityException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Throwable throwable = classNotFoundException;
                if (classNotFoundException.getCause() != null) {
                    throwable = classNotFoundException.getCause();
                }
                Tr.error(tc, "", new Object[]{throwable});
                SoapSecurityException soapSecurityException = SoapSecurityException.format("", throwable);
                soapSecurityException.initCause(classNotFoundException);
                throw soapSecurityException;
            }
        }
        if (hashMap != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "valid wss propertymap");
                Tr.debug(tc, "Save the wss property map using com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP key");
            }
            messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", hashMap);
            object2 = (String)hashMap.get(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
            if (object2 != null) {
                try {
                    if (messageContext.getAxisService() != null && (object = messageContext.getAxisService().getParameter(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER)) == null) {
                        object = new Parameter(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, object2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Add Client sessionId to AxisService = " + (String)object2);
                        }
                        messageContext.getAxisService().addParameter((Parameter)object);
                    }
                }
                catch (Exception exception) {
                    Tr.debug(tc, "Unable to add client sessionId to AxisService. " + exception.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSPropertyMapFromByteArray(byte[] wssmap, MessageContext msgCtx) returns = " + hashMap);
        }
        return hashMap;
    }

    /*
     * Unable to fully structure code
     */
    public void restoreSCToken(byte[] var1_1) throws SoapSecurityException {
        if (SecureConversationImpl.tc.isEntryEnabled()) {
            Tr.entry(SecureConversationImpl.tc, "restoreSCT(byte[] token)");
        }
        if (var1_1 == null) {
            if (SecureConversationImpl.tc.isEntryEnabled()) {
                Tr.exit(SecureConversationImpl.tc, "restoreSCT(byte[] token) returns, null token");
            }
            return;
        }
        if (SecureConversationImpl.tc.isDebugEnabled()) {
            Tr.debug(SecureConversationImpl.tc, "token bytes = " + Base64.encode(var1_1));
        }
        var2_2 = new SCT();
        try {
            var3_3 = new ObjectInputStream(new ByteArrayInputStream(var1_1));
            var2_2.readExternal(var3_3);
        }
        catch (Exception var3_4) {
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "Error when deserializing SCT. " + var3_4.toString());
            }
            var2_2 = null;
            throw new SoapSecurityException(var3_4.toString());
        }
        if (!PlatformContextUtil.isWebSphereThinClient() && var2_2 != null) {
            if (SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(var2_2.getUUID()) == null) {
                if (SecureConversationImpl.tc.isDebugEnabled()) {
                    Tr.debug(SecureConversationImpl.tc, "client cache does not have the SCT that is persisted. Update the cache");
                }
                SecureConversationCacheHelper.setSecurityContextTokenToCache(var2_2.getUUID(), null, var2_2, null);
            }
            if (SCTHelper.getCache() == null) {
                try {
                    if (STSTokenUtil.getToken(var2_2.getUUID(), "http://schemas.xmlsoap.org/ws/2005/02/sc/sct") != null) ** GOTO lbl58
                    if (SecureConversationImpl.tc.isDebugEnabled()) {
                        Tr.debug(SecureConversationImpl.tc, "service cache does not have the SCT that is persisted. Update the cache");
                    }
                    STSTokenUtil.putToken(var2_2, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
                }
                catch (Exception var3_5) {
                    Tr.error(SecureConversationImpl.tc, "error updating Service token cache");
                    throw new SoapSecurityException(var3_5.toString());
                }
            } else if (SCTHelper.getCache().getToken(var2_2.getUUID()) == null) {
                if (SecureConversationImpl.tc.isDebugEnabled()) {
                    Tr.debug(SecureConversationImpl.tc, "Did not find the token in the service cache. But the STS config is completed. Update thru SCTHelper");
                }
                var3_6 = 0x6DDD00L;
                if (SCTHelper.getSCTConfigProperties() != null) {
                    var5_7 = SCTHelper.getSCTConfigProperties();
                    var6_9 = var5_7.getProperty("renewalWindowMinutes", "120");
                    var7_10 = Integer.valueOf(var6_9) * 60000;
                    var8_11 = var2_2.getInstances();
                    var10_13 = var9_12 = new Date(0L);
                    if (var8_11 != null) {
                        for (var11_14 = 0; var11_14 < var8_11.length; ++var11_14) {
                            var12_16 = var8_11[var11_14];
                            var13_17 = var2_2.getExpiration(var12_16);
                            if (var13_17 == null || !var13_17.after(var10_13)) continue;
                            var10_13 = var13_17;
                        }
                        var11_15 = new Date();
                        if (!var10_13.equals(var9_12)) {
                            var3_6 = var10_13.getTime() - var11_15.getTime() + (long)var7_10;
                        }
                    }
                }
                var5_8 = SCTHelper.getCache().cacheToken(var2_2.getUUID(), var2_2, var3_6);
                if (SecureConversationImpl.tc.isDebugEnabled()) {
                    Tr.debug(SecureConversationImpl.tc, "Update the token in the service cache. result = " + var5_8);
                }
            }
        }
lbl58:
        // 9 sources

        if (SecureConversationImpl.tc.isEntryEnabled()) {
            Tr.exit(SecureConversationImpl.tc, "restoreSCToken(byte[] token)");
        }
    }
}

