/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.WasUsernameTokenImpl;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.WasX509TokenImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPATokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.token.TokenHolder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class wssTokenPropagationInboundLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(wssTokenPropagationInboundLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String UNT = "security.wssecurity_http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
    private static final String X509T = "security.wssecurity_http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    private static final String LTPAT = "security.wssecurity_http://www.ibm.com/websphere/appserver/tokentype/5.0.2#LTPA";
    private Vector allTokens = null;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map _sharedState;
    private Map options;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this._sharedState = map;
        this.options = map2;
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login");
        }
        Callback[] callbackArray = new Callback[]{new WSTokenHolderCallback("Authentication Token List: ")};
        try {
            this.callbackHandler.handle(callbackArray);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to handle callbackhandler.", exception.getStackTrace());
            }
            return false;
        }
        this.allTokens = new Vector();
        List list = ((WSTokenHolderCallback)callbackArray[0]).getTokenHolderList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                SecurityTokenImpl securityTokenImpl;
                TokenHolder tokenHolder = (TokenHolder)list.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restore authentication token: " + tokenHolder.getName());
                }
                if (tokenHolder.getName().equals(UNT) && tokenHolder.getVersion() == 1) {
                    securityTokenImpl = new WasUsernameTokenImpl();
                    ((WasUsernameTokenImpl)securityTokenImpl).initialize(tokenHolder.getBytes());
                    this.allTokens.addElement(securityTokenImpl);
                    continue;
                }
                if (tokenHolder.getName().equals(X509T) && tokenHolder.getVersion() == 1) {
                    securityTokenImpl = new WasX509TokenImpl();
                    ((WasX509TokenImpl)securityTokenImpl).initialize(tokenHolder.getBytes());
                    this.allTokens.addElement(securityTokenImpl);
                    continue;
                }
                if (!tokenHolder.getName().equals(LTPAT) || tokenHolder.getVersion() != 1) continue;
                securityTokenImpl = new LTPATokenImpl();
                ((LTPATokenImpl)securityTokenImpl).initialize(tokenHolder.getBytes());
                this.allTokens.addElement(securityTokenImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        while (this.allTokens != null && !this.allTokens.isEmpty()) {
            Object e = this.allTokens.lastElement();
            this.allTokens.remove(e);
            if (e == null || !(e instanceof SecurityToken)) continue;
            final SecurityToken securityToken = (SecurityToken)e;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws LoginException {
                        try {
                            if (!wssTokenPropagationInboundLoginModule.this.subject.getPrivateCredentials().contains(securityToken)) {
                                wssTokenPropagationInboundLoginModule.this.subject.getPrivateCredentials().add(securityToken);
                            }
                        }
                        catch (Exception exception) {
                            throw new LoginException(exception.getMessage());
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                throw new LoginException(exception.getMessage());
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        this.allTokens = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }
}

