/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509TokenImpl;
import com.ibm.wsspi.security.token.AuthenticationToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public class WasX509TokenImpl
extends X509TokenImpl
implements AuthenticationToken {
    private static final TraceComponent tc = Tr.register(WasX509TokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = -8134549655249745958L;
    private boolean isForwardable = true;
    private byte[] serializationBytes = null;
    public static final String authenticationTokenName = "security.wssecurity_http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";

    public void initialize(byte[] byArray) {
        block2: {
            this.serializationBytes = byArray;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.readExternal(objectInputStream);
                objectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to deserialize Token. ", exception.getStackTrace());
            }
        }
    }

    public boolean isForwardable() {
        return this.isForwardable;
    }

    public void setIsForwardable(boolean bl) {
        if (!this.readOnly) {
            this.isForwardable = bl;
        }
    }

    public String getUniqueID() {
        String string = null;
        string = this.getCertificate().getSerialNumber().toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getUniqueID() = " + string);
        }
        return string;
    }

    public byte[] getBytes() {
        block2: {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                this.writeExternal(objectOutputStream);
                objectOutputStream.close();
                byteArrayOutputStream.close();
                this.serializationBytes = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to serialize Token. ", exception.getStackTrace());
            }
        }
        return this.serializationBytes;
    }

    public void setBytes(byte[] byArray) {
        if (!this.readOnly) {
            this.serializationBytes = byArray;
        }
    }

    public String getName() {
        return authenticationTokenName;
    }

    public short getVersion() {
        return 1;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String[] getAttributes(String string) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String[] addAttribute(String string, String string2) {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public long getExpiration() {
        return -1L;
    }

    public Object clone() {
        return null;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.isForwardable = objectInput.readBoolean();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.isForwardable);
    }
}

