/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl;

import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSIdentityCallback;
import com.ibm.wsspi.security.auth.callback.WSProtocolPolicyCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TokenPropagationCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(TokenPropagationCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map _context = null;
    private String userName = null;
    private String password = null;
    private String realm = null;
    private byte[] credToken = null;
    private Map _appContext = null;
    private HttpServletRequest _req = null;
    private HttpServletResponse _resp = null;
    private String _identity = null;
    private List _tokenHolderList = null;
    private Object _protocolPolicy = null;
    private X509Certificate[] certChain;

    public TokenPropagationCallbackHandler(Map map, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(Map context, Object policy)");
        }
        this._context = map;
        this._protocolPolicy = object;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(Map context, Object policy)");
        }
    }

    public TokenPropagationCallbackHandler(Map map, List list, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
        this._context = map;
        this._tokenHolderList = list;
        this.credToken = CredentialsHelper.copyCredToken(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
    }

    public TokenPropagationCallbackHandler(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
        this._tokenHolderList = list;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        int n = 0;
        if (callbackArray == null || (n = callbackArray.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(callbackArray[i].getClass().getName());
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            Tr.entry(tc, "handle(callbacks = \"" + stringBuffer.toString() + "\")");
        }
        for (int i = 0; i < n; ++i) {
            Callback callback = callbackArray[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.userName);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password == null ? null : this.password.toCharArray());
                continue;
            }
            if (callback instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)callback).setCredToken(this.credToken);
                continue;
            }
            if (callback instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)callback).setRealmName(this.realm);
                continue;
            }
            if (callback instanceof WSAppContextCallback) {
                ((WSAppContextCallback)callback).setContext(this._appContext);
                continue;
            }
            if (callback instanceof WSIdentityCallback) {
                ((WSIdentityCallback)callback).setClientIdentity(this._identity);
                continue;
            }
            if (callback instanceof WSServletRequestCallback) {
                ((WSServletRequestCallback)callback).setHttpServletRequest(this._req);
                continue;
            }
            if (callback instanceof WSServletResponseCallback) {
                ((WSServletResponseCallback)callback).setHttpServletResponse(this._resp);
                continue;
            }
            if (callback instanceof WSTokenHolderCallback) {
                ((WSTokenHolderCallback)callback).setTokenHolderList(this._tokenHolderList);
                continue;
            }
            if (callback instanceof WSProtocolPolicyCallback) {
                ((WSProtocolPolicyCallback)callback).setProtocolPolicy(this._protocolPolicy);
                continue;
            }
            if (callback instanceof WSX509CertificateChainCallback) {
                ((WSX509CertificateChainCallback)callback).setX509CertificateChain(this.certChain);
                continue;
            }
            if (callback instanceof PropertyCallback) continue;
            throw new UnsupportedCallbackException(callback, "Unsupported callback");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

