/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.wssecurity.platform.util.KeyStoreUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.KeyStore;
import java.security.Provider;

public class WasKeyStoreUtilImpl
implements KeyStoreUtil {
    private static final TraceComponent tc = Tr.register(WasKeyStoreUtilImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WasKeyStoreUtilImpl.class.getName();

    public KeyStore getKeyStore(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStore(String keyStoreRef[" + string + "])");
        }
        KeyStore keyStore = null;
        try {
            if (KeyStoreManager.getInstance() != null) {
                WSKeyStore wSKeyStore = KeyStoreManager.getInstance().getKeyStore(string);
                if (wSKeyStore != null) {
                    keyStore = wSKeyStore.getKeyStore(false, false);
                } else if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "WSKeyStore is null. Cannot retrieve keystore with keyStoreRef[" + string + "]");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.entry(tc, "KeyStoreManager is null. Cannot retrieve keystore with keyStoreRef[" + string + "]");
            }
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".createKeyStore", "281");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{string, exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore(String)");
        }
        return keyStore;
    }

    public boolean isValidWSKeyStore(String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidWSKeyStore(String keyStoreName[" + string + "])");
        }
        boolean bl2 = bl = KeyStoreManager.getInstance().getKeyStore(string) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidWSKeyStore(String) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public boolean isHWKeyStore(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHWKeyStore(String keyStoreName[" + string + "])");
        }
        boolean bl = KeyStoreManager.getInstance().isHWKeyStore(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isHWKeyStore(String) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public Provider getHWCryptoProviderInstance(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHWCryptoProviderInstance(String keyStoreName[" + string + "])");
        }
        Provider provider = KeyStoreManager.getInstance().getHWCryptoProviderInstance(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHWCryptoProviderInstance(Provider)");
        }
        return provider;
    }

    public void returnHWCryptoProviderInstance(String string, Provider provider) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnHWCryptoProviderInstance(String keyStoreName[" + string + "], Provider)");
        }
        KeyStoreManager.getInstance().returnHWCryptoProviderInstance(string, provider);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnHWCryptoProviderInstance(String,Provider)");
        }
    }
}

