/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wssecurity.core.CertManagerFactory;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultGeneratorConfig;
import com.ibm.ws.wssecurity.handler.Constants;
import com.ibm.ws.wssecurity.platform.util.ConfigHelper;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class WasConfigHelperImpl
implements ConfigHelper {
    private static final TraceComponent tc = Tr.register(WasConfigHelperImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WasConfigHelperImpl.class.getName();

    public boolean loadConfig(boolean bl, VariableExpander variableExpander, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration, SecurityBindings securityBindings, DefaultBinding defaultBinding) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig(boolean ndEnvironment, VariableExpander vm, WSSecurityDefaultConfiguration securityDefaultConfig, SecurityBindings securityDefaultBindings, DefaultBinding defaultBinding): ", new Object[]{bl, variableExpander, wSSecurityDefaultConfiguration, securityBindings, defaultBinding});
        }
        boolean bl2 = false;
        WSSecurity wSSecurity = this.getWSSecurityObject(bl);
        if (wSSecurity != null && securityBindings != null) {
            bl2 = true;
            try {
                Object object;
                Object object2;
                boolean bl3 = wSSecurity.isUseHardwareAcceleration();
                if (bl3) {
                    if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{new Boolean(bl3)});
                        bl3 = false;
                    } else if (PlatformHelperFactory.getPlatformHelper().isOS400()) {
                        Tr.error(tc, "security.wssecurityHardware Crypto is not supported on this platform, continues to use software crypto provider");
                    }
                }
                if (bl3) {
                    wSSecurityDefaultConfiguration.setUseHardwareAcceleration(bl3);
                    Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{new Boolean(bl3)});
                    object2 = wSSecurity.getHardwareConfigRef();
                    if (object2 != null && ((String)object2).length() != 0) {
                        wSSecurityDefaultConfiguration.setHardwareConfigName((String)object2);
                        Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{object2});
                    }
                }
                if ((object2 = wSSecurity.getProperties()) != null) {
                    String string;
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    String string6;
                    block75: {
                        int n;
                        object = WasConfigHelperImpl.getProperties((EList)object2, variableExpander);
                        string6 = (String)object.get("com.ibm.ws.wssecurity.handler.useConfigCache");
                        if (string6 != null) {
                            wSSecurityDefaultConfiguration.setUseConfigCache(ConfigUtil.isTrue(string6));
                        } else {
                            wSSecurityDefaultConfiguration.setUseConfigCache(true);
                        }
                        string5 = (String)object.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout");
                        if (string5 != null && (string5 = string5.trim()).length() != 0) {
                            try {
                                n = Integer.parseInt(string5);
                                wSSecurityDefaultConfiguration.setNonceCacheTimeout(ConfigConstants.validNonceCacheTimeout(n));
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.setNonceCacheTimeout(600);
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "%C", this);
                                Tr.warning(tc, "security.wssecurity.WSEC0115W", new Object[]{string5, new Integer(600)});
                            }
                        }
                        if ((string5 = (String)object.get("com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout")) != null && (string5 = string5.trim()).length() != 0) {
                            try {
                                n = Integer.parseInt(string5);
                                wSSecurityDefaultConfiguration.setCertCacheTimeOut(ConfigConstants.validCertCacheTimeout(n));
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.setCertCacheTimeOut(900);
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "%C", this);
                                if (!tc.isDebugEnabled()) break block75;
                                Tr.debug(tc, "WARNING: Exception occurred during parsing the certificate cache timeout " + string5 + "seconds, default " + 900 + " seconds is used instead.");
                            }
                        }
                    }
                    if ((string5 = (String)object.get("com.ibm.ws.wssecurity.handler.configCacheTimeToLive")) != null) {
                        if ((string5 = string5.trim()).length() != 0) {
                            try {
                                int n = Integer.parseInt(string5);
                                wSSecurityDefaultConfiguration.setConfigCacheTimeToLive(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.setConfigCacheTimeToLive(900);
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "%C", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the config cache timeToLive " + string5 + "seconds, default " + 900 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        wSSecurityDefaultConfiguration.setConfigCacheTimeToLive(900);
                    }
                    if ((string5 = (String)object.get("com.ibm.ws.wssecurity.handler.token.cacheTimeout")) != null) {
                        if ((string5 = string5.trim()).length() != 0) {
                            try {
                                int n = Integer.parseInt(string5);
                                wSSecurityDefaultConfiguration.setTokenCacheTimeOut(ConfigConstants.validTokenCacheTimeout(n));
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.setTokenCacheTimeOut(900);
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "%C", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cache timeout " + string5 + "seconds, default " + 900 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        wSSecurityDefaultConfiguration.setTokenCacheTimeOut(900);
                    }
                    if ((string5 = (String)object.get("com.ibm.ws.wssecurity.handler.token.cushion")) != null) {
                        if ((string5 = string5.trim()).length() != 0) {
                            try {
                                int n = Integer.parseInt(string5);
                                wSSecurityDefaultConfiguration.setTokenCacheCushion(ConfigConstants.validTokenCushion(n * 1000));
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.setTokenCacheCushion(600000L);
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "%C", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cushion " + string5 + "seconds, default " + 600 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        wSSecurityDefaultConfiguration.setTokenCacheCushion(600000L);
                    }
                    if ((string4 = (String)object.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography")) != null) {
                        wSSecurityDefaultConfiguration.setUseOffloadAllCrypto(string4);
                    }
                    if ((string3 = (String)object.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography")) != null) {
                        wSSecurityDefaultConfiguration.setOffloadRSAPublicKeyCrypto(ConfigUtil.isTrue(string3));
                    } else {
                        wSSecurityDefaultConfiguration.setOffloadRSAPublicKeyCrypto(true);
                    }
                    String string7 = (String)object.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                    if (string7 != null) {
                        wSSecurityDefaultConfiguration.setHardwareCacheSize(ConfigConstants.processHardwareCacheSize(string7));
                    } else {
                        wSSecurityDefaultConfiguration.setHardwareCacheSize(1000);
                    }
                    String string8 = (String)object.get("com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours");
                    long l = 8L;
                    if (string8 != null) {
                        l = ConfigConstants.processHardwareCacheEntryRefresh(string8);
                    }
                    HWKeyCache hWKeyCache = HWKeyCache.getInstance();
                    hWKeyCache.setScanParameters(l);
                    string6 = (String)object.get("com.ibm.ws.wssecurity.config.token.certificate.useCache");
                    if (string6 != null) {
                        wSSecurityDefaultConfiguration.setUseCertCache(ConfigUtil.isTrue(string6));
                    }
                    if ((string6 = (String)object.get("com.ibm.ws.wssecurity.handler.useConfigCache")) != null) {
                        wSSecurityDefaultConfiguration.setUseConfigCache(ConfigUtil.isTrue(string6));
                    } else {
                        wSSecurityDefaultConfiguration.setUseConfigCache(true);
                    }
                    string6 = (String)object.get("com.ibm.ws.wssecurity.handler.token.useCache");
                    if (string6 != null) {
                        wSSecurityDefaultConfiguration.setUseTokenCache(ConfigUtil.isTrue(string6));
                    } else {
                        wSSecurityDefaultConfiguration.setUseTokenCache(true);
                    }
                    String string9 = (String)object.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName");
                    if (string9 != null) {
                        wSSecurityDefaultConfiguration.setNonceCacheName(string9);
                    }
                    if ((string9 = (String)object.get("com.ibm.ws.wssecurity.config.token.certificate.cacheName")) != null) {
                        wSSecurityDefaultConfiguration.setCertCacheName(string9);
                    }
                    if ((string9 = (String)object.get("com.ibm.ws.wssecurity.handler.configCacheName")) != null) {
                        wSSecurityDefaultConfiguration.setConfigCacheName(string9);
                    } else {
                        wSSecurityDefaultConfiguration.setConfigCacheName("WSSReqGeneratorConfigMap");
                    }
                    string9 = (String)object.get("com.ibm.ws.wssecurity.handler.token.cacheName");
                    if (string9 != null) {
                        wSSecurityDefaultConfiguration.setTokenCacheName(string9);
                    } else {
                        wSSecurityDefaultConfiguration.setTokenCacheName("WSSTokenCache");
                    }
                    String string10 = (String)object.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize");
                    if (string10 != null) {
                        wSSecurityDefaultConfiguration.setNonceCacheSize(ConfigConstants.processNonceCacheSize(string10));
                    }
                    if ((string10 = (String)object.get("com.ibm.ws.wssecurity.config.token.certificate.cacheSize")) != null) {
                        wSSecurityDefaultConfiguration.setCertCacheSize(ConfigConstants.processCertCacheSize(string10));
                    }
                    if ((string10 = (String)object.get("com.ibm.ws.wssecurity.handler.configCacheSize")) != null) {
                        try {
                            int n = Integer.parseInt(string10);
                            wSSecurityDefaultConfiguration.setConfigCacheSize(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            wSSecurityDefaultConfiguration.setConfigCacheSize(128);
                            FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "%C", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WARNING: Exception occurred during parsing the config cache size " + string10 + "default size" + 128 + " is used instead.");
                            }
                        }
                    } else {
                        wSSecurityDefaultConfiguration.setConfigCacheSize(128);
                    }
                    string10 = (String)object.get("com.ibm.ws.wssecurity.handler.token.cacheSize");
                    if (string10 != null) {
                        wSSecurityDefaultConfiguration.setTokenCacheSize(ConfigConstants.processTokenCacheSize(string10));
                    }
                    if ((string2 = (String)object.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge")) != null) {
                        wSSecurityDefaultConfiguration.setNonceMaxAge(ConfigConstants.processNonceMaxAge(string2, wSSecurityDefaultConfiguration.getNonceCacheTimeout()));
                    }
                    if ((string = (String)object.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew")) != null) {
                        wSSecurityDefaultConfiguration.setNonceClockSkew(ConfigConstants.processNonceClockSkew(string, wSSecurityDefaultConfiguration.getNonceMaxAge()));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Nonce cache timeout = " + wSSecurityDefaultConfiguration.getNonceCacheTimeout() + ", Nonce max age = " + wSSecurityDefaultConfiguration.getNonceMaxAge() + ", Nonce clock skew = " + wSSecurityDefaultConfiguration.getNonceClockSkew());
                    }
                }
                if ((object = wSSecurity.getNonceCaching()) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No NonceCaching found.");
                    }
                } else {
                    wSSecurityDefaultConfiguration.setNonceCacheDistributed(object.isDistributed());
                }
                if (securityBindings == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No default bindings found.");
                    }
                } else {
                    wSSecurityDefaultConfiguration.setDefaultConsumerBinding(new WSSecurityDefaultConsumerConfig(securityBindings));
                    wSSecurityDefaultConfiguration.setDefaultGeneratorBinding(new WSSecurityDefaultGeneratorConfig(securityBindings));
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "Caught exception e=" + exception);
            }
            if (!NonceManagerFactory.isInitialized()) {
                NonceManagerFactory.init(wSSecurityDefaultConfiguration.getUseNonceCache(), wSSecurityDefaultConfiguration.getNonceCacheName(), wSSecurityDefaultConfiguration.getNonceCacheSize(), wSSecurityDefaultConfiguration.getNonceCacheTimeout(), wSSecurityDefaultConfiguration.getNonceLength(), wSSecurityDefaultConfiguration.getNonceCacheDistributed());
            }
            if (!CertManagerFactory.isInitialized()) {
                CertManagerFactory.init(wSSecurityDefaultConfiguration.getUseCertCache(), wSSecurityDefaultConfiguration.getCertCacheName(), wSSecurityDefaultConfiguration.getCertCacheSize(), wSSecurityDefaultConfiguration.getCertCacheTimeOut());
            }
        } else {
            Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s04");
            throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s04");
        }
        defaultBinding.setDefaultBinding(Constants.WS_SECURITY_DEFAULT_BINDING_KEY, wSSecurityDefaultConfiguration);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig returns boolean[" + bl2 + "]", new Object[]{wSSecurity, wSSecurityDefaultConfiguration});
        }
        return bl2;
    }

    private WSSecurity getWSSecurityObject(boolean bl) {
        WSSecurity wSSecurity;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWSSecurityObject(boolean ndEnvironment [" + bl + "])");
            }
            wSSecurity = null;
            Repository repository = null;
            ConfigRoot configRoot = null;
            try {
                Resource resource;
                block14: {
                    String string;
                    repository = (Repository)WsServiceRegistry.getService(this, Repository.class);
                    configRoot = repository.getConfigRoot();
                    if (bl) {
                        resource = null;
                        try {
                            resource = configRoot.getResource(0, "ws-security.xml");
                        }
                        catch (Exception exception) {
                            string = configRoot.getAbsolutePath(0, "ws-security.xml");
                            Tr.processException((Throwable)exception, clsName + ".getWSSecurityObject", "%C", this);
                            Tr.warning(tc, "ws.wssecurity.load.cell.wssecurity.xml", new Object[]{string});
                        }
                        if (resource != null) {
                            wSSecurity = (WSSecurity)resource.getContents().get(0);
                        }
                    }
                    resource = null;
                    try {
                        resource = configRoot.getResource(4, "ws-security.xml");
                    }
                    catch (Exception exception) {
                        if (bl) break block14;
                        string = configRoot.getAbsolutePath(4, "ws-security.xml");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Can not load server level configuration file: " + string, new Object[]{exception});
                        }
                        Tr.warning(tc, "ws.wssecurity.load.server.wssecurity.xml", new Object[]{string});
                    }
                }
                if (resource != null) {
                    wSSecurity = (WSSecurity)resource.getContents().get(0);
                }
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".getWSSecurityObject", "%C", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in getWSSecurityObject().  Error while loading ws-security.xml.");
                }
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".getWSSecurityObject", "%C", this);
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Exception caught in getWSSecurityObject().  Error while loading ws-security.xml.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSecurityObject");
        }
        return wSSecurity;
    }

    public static Map getProperties(EList eList, VariableExpander variableExpander) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(EList, VariableExpander):", new Object[]{eList, variableExpander});
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (eList != null && !eList.isEmpty()) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                String string;
                EObject eObject;
                Object e = eList.get(i);
                if (e instanceof Property) {
                    eObject = (Property)e;
                    string = variableExpander == null ? eObject.getValue() : variableExpander.expand(eObject.getValue());
                    hashMap.put(eObject.getName(), string);
                    continue;
                }
                eObject = (com.ibm.etools.webservice.wscommonext.Property)e;
                string = variableExpander == null ? eObject.getValue() : variableExpander.expand(eObject.getValue());
                hashMap.put(eObject.getName(), string);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(EList, VariableExpander)");
        }
        return hashMap;
    }
}

