/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.TokenPropagationCallbackHandler;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class WSSTokenPropagationLoginHelper {
    private static final TraceComponent tc = Tr.register(WSSTokenPropagationLoginHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String WSS_DESERIALIZE_CONTEXT = "system.WSS_DESERIALIZE_CONTEXT";

    protected Subject jaas_login(ArrayList arrayList) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(ArrayList tokenHolderList)");
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        Subject subject = null;
        LoginContext loginContext = null;
        String string = WSS_DESERIALIZE_CONTEXT;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing attribute propagation login.");
            }
            TokenPropagationCallbackHandler tokenPropagationCallbackHandler = new TokenPropagationCallbackHandler(arrayList);
            loginContext = new LoginContext(string, tokenPropagationCallbackHandler);
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "353", this);
            throw loginException;
        }
        try {
            loginContext.login();
            subject = loginContext.getSubject();
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject returned from login module is null.");
                }
                throw new LoginException("Subject returned from login module is null.");
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "388", this);
            throw loginException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(ArrayList tokenHolderList)");
        }
        return subject;
    }
}

